/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PCMappingTable;
import com.iplanet.ums.PeopleContainer;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.User;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;

public class Organization
extends PersistentObject {
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private static final Class _class = class$com$iplanet$ums$Organization == null ? (class$com$iplanet$ums$Organization = Organization.class$("com.iplanet.ums.Organization")) : class$com$iplanet$ums$Organization;
    static /* synthetic */ Class class$com$iplanet$ums$Organization;

    protected Organization() throws UMSException {
    }

    Organization(Principal principal, Guid guid) throws UMSException {
        super(principal, guid);
        this.verifyClass();
    }

    Organization(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public Organization(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        super(creationTemplate, attrSet);
    }

    public void addChild(PersistentObject persistentObject) throws AccessRightsException, EntryAlreadyExistsException, UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            String string = i18n.getString("ums-bad-principal-hdl");
            throw new IllegalArgumentException(string);
        }
        if (persistentObject == null) {
            String string = i18n.getString("ums-badobjtoadd");
            throw new IllegalArgumentException(string);
        }
        if (persistentObject instanceof User) {
            String string = this.getPeopleContainer((User)persistentObject);
            if (string != null) {
                PeopleContainer peopleContainer = new PeopleContainer(this.getPrincipal(), new Guid(string));
                peopleContainer.addUser((User)persistentObject);
            } else {
                super.addChild(persistentObject);
            }
        } else {
            super.addChild(persistentObject);
        }
    }

    public void removeChild(PersistentObject persistentObject) throws AccessRightsException, EntryNotFoundException, UMSException {
        if (persistentObject != null && this.getPrincipal() != null) {
            super.removeChild(persistentObject);
        }
    }

    public String getName() throws UMSException {
        return this.getAttribute(this.getNamingAttribute()).getValue();
    }

    public Collection getPeopleContainerGuids() throws UMSException {
        ArrayList<Guid> arrayList = new ArrayList<Guid>();
        SearchTemplate searchTemplate = TemplateManager.getTemplateManager().getSearchTemplate("BasicPeopleContainerSearch", this.getGuid());
        SearchResults searchResults = this.search(searchTemplate, null);
        while (searchResults.hasMoreElements()) {
            arrayList.add(searchResults.next().getGuid());
        }
        return arrayList;
    }

    private String getPeopleContainer(User user) throws UMSException {
        PCMappingTable pCMappingTable = PCMappingTable.getPCMappingTable(this);
        return pCMappingTable.getPeopleContainer(user);
    }

    public void addPeopleContainerRule(Guid guid, String string) throws UMSException {
        PCMappingTable pCMappingTable = PCMappingTable.getPCMappingTable(this);
        pCMappingTable.addRule(guid, string);
    }

    public void removePeopleContainerRule(Guid guid, String string) throws UMSException {
        PCMappingTable pCMappingTable = PCMappingTable.getPCMappingTable(this);
        pCMappingTable.removeRule(guid, string);
    }

    public void setDefaultPeopleContainer(Guid guid) throws UMSException {
        PCMappingTable pCMappingTable = PCMappingTable.getPCMappingTable(this);
        pCMappingTable.setDefault(guid);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

