/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IDynamicMembership;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import java.net.MalformedURLException;
import java.security.Principal;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPUrl;

public class DynamicGroup
extends PersistentObject
implements IDynamicMembership {
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static final String MEMBER_URL_NAME = "memberurl";
    private static final Class _class = class$com$iplanet$ums$DynamicGroup == null ? (class$com$iplanet$ums$DynamicGroup = DynamicGroup.class$("com.iplanet.ums.DynamicGroup")) : class$com$iplanet$ums$DynamicGroup;
    static /* synthetic */ Class class$com$iplanet$ums$DynamicGroup;

    protected DynamicGroup() {
    }

    DynamicGroup(Principal principal, Guid guid) throws UMSException {
        super(principal, guid);
        this.verifyClass();
    }

    DynamicGroup(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public DynamicGroup(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        super(creationTemplate, attrSet);
    }

    DynamicGroup(AttrSet attrSet, Guid guid, String string, int n) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet, guid, string, n);
    }

    public DynamicGroup(CreationTemplate creationTemplate, AttrSet attrSet, Guid guid, String string, int n) throws UMSException {
        super(creationTemplate, attrSet);
        try {
            this.setUrl(guid, string, n);
        }
        catch (Exception exception) {
            debug.error("DynamicGroup : Exception : " + exception.getMessage());
        }
    }

    public void setSearchFilter(String string) {
        LDAPUrl lDAPUrl = this.getUrl();
        int n = lDAPUrl.getScope();
        Guid guid = new Guid(lDAPUrl.getDN());
        try {
            this.setUrl(guid, string, n);
        }
        catch (Exception exception) {
            debug.error("DynamicGroup.setSearchFilter : Exception : " + exception.getMessage());
        }
    }

    public String getSearchFilter() {
        return this.getUrl().getFilter();
    }

    public void setSearchBase(Guid guid) {
        LDAPUrl lDAPUrl = this.getUrl();
        int n = lDAPUrl.getScope();
        String string = lDAPUrl.getFilter();
        try {
            this.setUrl(guid, string, n);
        }
        catch (Exception exception) {
            debug.error("DynamicGroup.setSearchFilter : Exception : " + exception.getMessage());
        }
    }

    public Guid getSearchBase() {
        return new Guid(this.getUrl().getDN());
    }

    public void setSearchScope(int n) {
        LDAPUrl lDAPUrl = this.getUrl();
        Guid guid = new Guid(lDAPUrl.getDN());
        String string = lDAPUrl.getFilter();
        try {
            this.setUrl(guid, string, n);
        }
        catch (Exception exception) {
            debug.error("DynamicGroup.setSearchFilter : Exception : " + exception.getMessage());
        }
    }

    public int getSearchScope() {
        return this.getUrl().getScope();
    }

    protected String toUrlStr(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ldap:///" + string + "?");
        switch (n) {
            case 0: {
                stringBuffer.append("?base");
                break;
            }
            case 1: {
                stringBuffer.append("?one");
                break;
            }
            default: {
                stringBuffer.append("?sub");
            }
        }
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append("?" + string2);
        } else {
            stringBuffer.append("?");
        }
        return stringBuffer.toString();
    }

    protected void setUrl(Guid guid, String string, int n) {
        if (n != 1 && n != 2) {
            String string2 = i18n.getString("ums-illegalgroupscope");
            throw new IllegalArgumentException(string2);
        }
        String string3 = this.toUrlStr(guid.getDn(), string, n);
        try {
            LDAPUrl lDAPUrl = new LDAPUrl(string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.getMessage());
        }
        this.modify(new Attr(MEMBER_URL_NAME, string3), 2);
    }

    protected LDAPUrl getUrl() {
        Attr attr = this.getAttribute(MEMBER_URL_NAME);
        LDAPUrl lDAPUrl = null;
        try {
            if (attr != null && attr.getStringValues().length > 0) {
                lDAPUrl = new LDAPUrl(attr.getStringValues()[0]);
            }
            if (lDAPUrl == null) {
                lDAPUrl = new LDAPUrl(null, 0, "", (String[])null, 1, "");
            }
        }
        catch (MalformedURLException malformedURLException) {
            debug.error("DynamicGroup.getUrl : Exception : " + malformedURLException.getMessage());
            throw new IllegalArgumentException(malformedURLException.getMessage());
        }
        return lDAPUrl;
    }

    protected void setUrl(LDAPUrl lDAPUrl) {
        String string = lDAPUrl.toString();
        try {
            string = LDAPUrl.decode(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (lDAPUrl.getScope() != 1 && lDAPUrl.getScope() != 2) {
            String string2 = i18n.getString("ums-illegalgroupscope");
            throw new IllegalArgumentException(string2);
        }
        this.modify(new Attr(MEMBER_URL_NAME, string), 2);
    }

    protected SearchResults getMemberIDs(String[] stringArray) throws UMSException {
        return DataLayer.getInstance().search(this.getPrincipal(), this.getSearchBase(), this.getSearchScope(), this.getSearchFilter(), stringArray, false, null);
    }

    public SearchResults getMemberIDs() throws UMSException {
        String[] stringArray = new String[]{"objectclass"};
        return this.getMemberIDs(stringArray);
    }

    public int getMemberCount() throws UMSException {
        int n = 0;
        String[] stringArray = new String[]{"dn"};
        SearchResults searchResults = this.getMemberIDs(stringArray);
        while (searchResults.hasMoreElements()) {
            searchResults.next().getDN();
            ++n;
        }
        return n;
    }

    public Guid getMemberIDAt(int n) throws UMSException {
        if (n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        String string = this.getSearchFilter();
        if (string == null) {
            return null;
        }
        String[] stringArray = new String[]{"dn"};
        SearchResults searchResults = this.getMemberIDs(stringArray);
        while (searchResults.hasMoreElements()) {
            String string2 = searchResults.next().getDN();
            if (n == 0) {
                searchResults.abandon();
                return new Guid(string2);
            }
            --n;
        }
        throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
    }

    public boolean hasMember(Guid guid) throws UMSException {
        String string = this.getSearchFilter();
        if (string == null) {
            return false;
        }
        String string2 = guid.getDn();
        String string3 = LDAPDN.explodeDN(string2, false)[0];
        string = "(&" + string + "(" + string3 + "))";
        String[] stringArray = new String[]{"dn"};
        SearchResults searchResults = DataLayer.getInstance().search(this.getPrincipal(), this.getSearchBase(), this.getSearchScope(), string, stringArray, false, null);
        while (searchResults.hasMoreElements()) {
            String string4 = searchResults.next().getDN();
            if (!Guid.equals(string4, string2)) continue;
            searchResults.abandon();
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

