/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.CMListener;
import com.iplanet.ums.ConfigManagerException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.util.GuidUtils;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.ServerInstanceAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

public class ConfigManagerUMS
implements Serializable {
    static final String ERROR_CM_INITIATE = "error-cminitiate";
    static final String ERROR_CM = "error-cm";
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    protected static final String UMS_SRVC = "DAI";
    private static final String UMS_VERSION = "1.0";
    private static final String TEMPLATEPATH = "/templates";
    static final String ENTITYPATH = "/templates/StructureTemplates";
    static final String SEARCHPATH = "/templates/SearchTemplates";
    static final String CREATIONPATH = "/templates/CreationTemplates";
    private static final String OBJECTRESOLVERPATH = "/templates/ObjectResolver";
    private static final String OBJECTRESOLVER = "ObjectResolver";
    private static final String ENTITY = "StructureTemplates";
    private static final String SEARCH = "SearchTemplates";
    private static final String CREATION = "CreationTemplates";
    private static final String LID = "ListenerID";
    private static final String CLASS = "class";
    private static final String JAVACLASS = "javaclass";
    private static final String ATTRNAME = "name";
    private static final String OC_JC_MAP = "oc_jc_map";
    private static ConfigManagerUMS _instance = null;
    static Hashtable _cch = null;
    private static Cache _checkListCache = null;
    private static AuthPrincipal _principal;
    private static ServiceConfigManager _smapi;
    private static String _rootDN;
    private static DN _root;
    private static CMListener _listener;
    private static String _lid;
    private static Debug _debug;
    private static String[][] _oc_jc_map;

    public static synchronized ConfigManagerUMS getConfigManager() throws ConfigManagerException {
        if (_instance == null) {
            try {
                _instance = new ConfigManagerUMS();
            }
            catch (Exception exception) {
                _debug.error(exception.toString());
                Object[] objectArray = new String[]{exception.toString()};
                throw new ConfigManagerException(i18n.getString("ums-cminitiate", objectArray));
            }
        }
        return _instance;
    }

    private void loadCache(String string, Set set, String string2) {
        Iterator iterator = set.iterator();
        String string3 = "";
        AttrSet attrSet = null;
        while (iterator.hasNext()) {
            String string4;
            Object object;
            Object object2;
            Object object3;
            string3 = iterator.next().toString();
            Map map = new HashMap();
            attrSet = new AttrSet();
            try {
                map = this.getServiceAttributes(string, string3);
            }
            catch (SMSException sMSException) {
                _debug.error("ConfigManager->loadCache: SMSException: " + sMSException.toString());
            }
            catch (SSOException sSOException) {
                _debug.error("ConfigManager->loadCache: SSOException: " + sSOException.toString());
            }
            if (map.size() == 0) continue;
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                object3 = iterator2.next();
                object2 = (Set)object3.getValue();
                object = object2.iterator();
                object = object2.iterator();
                while (object.hasNext()) {
                    attrSet.add(new Attr((String)object3.getKey(), (String)object.next()));
                }
            }
            object3 = string + "/" + string2 + "/";
            object2 = null;
            if (string2.equals(ENTITY)) {
                object2 = attrSet.getAttribute(CLASS);
                if (object2 != null) {
                    object = new HashSet();
                    if (_cch.containsKey((String)object3 + ((Attr)object2).getValue())) {
                        object = (Set)_cch.get((String)object3 + ((Attr)object2).getValue());
                        object.add(attrSet);
                    } else {
                        object.add(attrSet);
                    }
                    _cch.put((String)object3 + ((Attr)object2).getValue(), object);
                    if (_debug.messageEnabled()) {
                        _debug.message("ConfigManager->loadCache KEY:" + (String)object3 + ((Attr)object2).getValue() + " VALUE:" + object);
                    }
                }
                int n = string3.lastIndexOf("/");
                String string5 = string3.substring(n + 1);
                HashSet<AttrSet> hashSet = new HashSet<AttrSet>();
                hashSet.add(attrSet);
                _cch.put((String)object3 + string5, hashSet);
                if (_debug.messageEnabled()) {
                    _debug.message("ConfigManager->loadCache KEY:" + (String)object3 + string5 + " VALUE:" + hashSet);
                }
            }
            if (string2.equals(SEARCH) || string2.equals(CREATION)) {
                object2 = attrSet.getAttribute(JAVACLASS);
                if (object2 != null) {
                    _cch.put((String)object3 + ((Attr)object2).getValue(), attrSet);
                    if (_debug.messageEnabled()) {
                        _debug.message("ConfigManager->loadCache KEY:" + (String)object3 + ((Attr)object2).getValue() + " VALUE:" + attrSet);
                    }
                }
                if ((object2 = attrSet.getAttribute(ATTRNAME)) != null) {
                    _cch.put((String)object3 + ((Attr)object2).getValue(), attrSet);
                    _debug.message("ConfigManager->loadCache KEY:" + (String)object3 + ((Attr)object2).getValue() + " VALUE:" + attrSet);
                }
            }
            if (!string2.equals(OBJECTRESOLVER) || (string4 = attrSet.getValue(OC_JC_MAP)) == null) continue;
            _cch.put(OBJECTRESOLVERPATH, this.getOC_JC_MAP(string4));
            _debug.message("ConfigManager->loadCache KEY:/templates/ObjectResolver VALUE:" + attrSet);
        }
    }

    void updateCache(String string) throws ConfigManagerException {
        int n;
        String string2;
        String string3;
        HashSet<String> hashSet;
        Iterator iterator;
        Set set;
        Set set2;
        Set set3;
        block22: {
            block21: {
                block20: {
                    HashSet hashSet2 = new HashSet();
                    set3 = new HashSet();
                    set2 = new HashSet();
                    set = new HashSet();
                    if (string.equals(_rootDN)) {
                        iterator = new HashSet<String>();
                        iterator.add(OBJECTRESOLVERPATH);
                        this.loadCache(string, (Set)((Object)iterator), OBJECTRESOLVER);
                    }
                    try {
                        set3 = this.getServiceComponents(string, ENTITYPATH, true);
                    }
                    catch (SMSException sMSException) {
                        if (_debug.warningEnabled()) {
                            _debug.warning("ConfigManager->updateCache: SMSException: " + sMSException.toString());
                        }
                    }
                    catch (SSOException sSOException) {
                        if (!_debug.warningEnabled()) break block20;
                        _debug.warning("ConfigManager->updateCache: SSOException: " + sSOException.toString());
                    }
                }
                try {
                    set2 = this.getServiceComponents(string, SEARCHPATH, true);
                }
                catch (SMSException sMSException) {
                    if (_debug.warningEnabled()) {
                        _debug.warning("ConfigManager->updateCache: SMSException: " + sMSException.toString());
                    }
                }
                catch (SSOException sSOException) {
                    if (!_debug.warningEnabled()) break block21;
                    _debug.warning("ConfigManager->updateCache: SSOException: " + sSOException.toString());
                }
            }
            try {
                set = this.getServiceComponents(string, CREATIONPATH, true);
            }
            catch (SMSException sMSException) {
                if (_debug.warningEnabled()) {
                    _debug.warning("ConfigManager->updateCache: SMSException: " + sMSException.toString());
                }
            }
            catch (SSOException sSOException) {
                if (!_debug.warningEnabled()) break block22;
                _debug.warning("ConfigManager->updateCache: SSOException: " + sSOException.toString());
            }
        }
        if (set.isEmpty() && set3.isEmpty() && set2.isEmpty()) {
            _checkListCache.put((Object)string.toLowerCase(), (Object)"dummy");
            return;
        }
        if (!set2.isEmpty()) {
            iterator = set2.iterator();
            hashSet = new HashSet<String>();
            while (iterator.hasNext()) {
                string3 = new String();
                string2 = (String)iterator.next();
                n = string2.lastIndexOf("/");
                string3 = string2.substring(n + 1);
                hashSet.add(string3);
            }
            _cch.put(string + "/" + SEARCH + "Names", hashSet);
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->updateCache: " + string + "/" + SEARCH + "Names :" + hashSet);
            }
        }
        if (!set.isEmpty()) {
            iterator = set.iterator();
            hashSet = new HashSet();
            while (iterator.hasNext()) {
                string3 = new String();
                string2 = (String)iterator.next();
                n = string2.lastIndexOf("/");
                string3 = string2.substring(n + 1);
                hashSet.add(string3);
            }
            _cch.put(string + "/" + CREATION + "Names", hashSet);
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->updateCache: " + string + "/" + CREATION + "Names :" + hashSet);
            }
        }
        this.loadCache(string, set3, ENTITY);
        this.loadCache(string, set, CREATION);
        this.loadCache(string, set2, SEARCH);
        _checkListCache.put((Object)string.toLowerCase(), (Object)"dummy");
    }

    private Set getServiceComponents(String string, String string2, boolean bl) throws SMSException, SSOException {
        Object object;
        ServiceConfig serviceConfig;
        ServiceConfig serviceConfig2 = serviceConfig = string.equals(_rootDN) ? _smapi.getGlobalConfig(null) : _smapi.getOrganizationConfig(string, null);
        if (serviceConfig == null) {
            return new HashSet();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).length() == 0 || ((String)object).equals("")) continue;
            serviceConfig = serviceConfig.getSubConfig((String)object);
        }
        object = new HashSet();
        Iterator iterator = serviceConfig.getSubConfigNames().iterator();
        while (iterator.hasNext()) {
            object.add(string2 + "/" + iterator.next());
        }
        return object;
    }

    private Map getServiceAttributes(String string, String string2) throws SMSException, SSOException {
        ServiceConfig serviceConfig = string.equals(_rootDN) ? _smapi.getGlobalConfig(null) : _smapi.getOrganizationConfig(string, null);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 0 || string3.equals("")) continue;
            if (serviceConfig != null) {
                serviceConfig = serviceConfig.getSubConfig(string3);
                continue;
            }
            return Collections.EMPTY_MAP;
        }
        if (serviceConfig != null) {
            return serviceConfig.getAttributes();
        }
        return Collections.EMPTY_MAP;
    }

    private void replaceServiceAttributes(String string, String string2, Map map) throws SMSException, SSOException {
        ServiceConfig serviceConfig = _smapi.getGlobalConfig(null);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 0 || string3.equals("")) continue;
            serviceConfig = serviceConfig.getSubConfig(string3);
        }
        serviceConfig.setAttributes(map);
    }

    void deleteOrgFromCache(String string) throws ConfigManagerException {
        String string2 = string == null || string.length() == 0 ? _rootDN : new DN(string).toRFCString().toLowerCase();
        String string3 = string2 + "/" + ENTITY;
        String string4 = string2 + "/" + CREATION;
        String string5 = string2 + "/" + SEARCH;
        if (_debug.messageEnabled()) {
            _debug.message("ConfigManager->deleteOrgFromCache: Deleting " + string + " from cache");
        }
        _checkListCache.remove((Object)string.toLowerCase());
        Enumeration enumeration = _cch.keys();
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            if (string6.indexOf(string3) != 0 && string6.indexOf(string4) != 0 && string6.indexOf(string5) != 0) continue;
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->deleteOrgFromCache:  Deleting..." + string6);
            }
            _cch.remove(string6);
        }
        if (string.equals("") && _cch.containsKey(OBJECTRESOLVERPATH)) {
            _cch.remove(OBJECTRESOLVERPATH);
            _oc_jc_map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getConfigData(Guid guid, String string, String string2, int n) throws ConfigManagerException {
        if (guid == null) {
            guid = new Guid(_rootDN);
        }
        DN dN = new DN(guid.getDn());
        DN dN2 = new DN(_rootDN);
        while (true) {
            String string3 = _rootDN;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string4 = null;
            String[] stringArray = dN.explodeDN(true);
            String[] stringArray2 = dN2.explodeDN(true);
            string3 = dN.toRFCString().toLowerCase();
            string4 = string2.equals(OBJECTRESOLVER) ? OBJECTRESOLVERPATH : string3 + "/" + string2 + "/" + string;
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->getConfigData: fdn=" + string3 + "   cacheKey=" + string4);
            }
            if (bl = _cch.containsKey(string4)) {
                if (_debug.messageEnabled()) {
                    _debug.message("ConfigManager->getConfigData: get from cache for " + dN);
                }
                return _cch.get(string4);
            }
            bl2 = _checkListCache.containsKey((Object)string3.toLowerCase());
            if (!bl2) {
                if (_debug.messageEnabled()) {
                    _debug.message("ConfigManager->getConfigData: updating cache for " + dN);
                }
                Hashtable hashtable = _cch;
                synchronized (hashtable) {
                    this.updateCache(string3);
                }
                if (_cch.containsKey(string4)) {
                    return _cch.get(string4);
                }
            }
            switch (n) {
                case 0: {
                    return null;
                }
                case 2: {
                    dN = new DN(_rootDN);
                    break;
                }
                case 1: {
                    dN = dN.getParent();
                    if (dN.isDescendantOf(_root) || dN.equals(_root)) break;
                    return null;
                }
            }
            if (!_debug.messageEnabled()) continue;
            _debug.message("ConfigManager->getConfigData: Traversing parent: " + dN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getConfigTemplateNames(Guid guid, String string, int n) throws ConfigManagerException {
        if (guid == null) {
            guid = new Guid(_rootDN);
        }
        if (!guid.getDn().startsWith("o=")) {
            guid = GuidUtils.getOrgGuid(guid);
        }
        DN dN = new DN(guid.getDn());
        DN dN2 = new DN(_rootDN);
        while (true) {
            String string2 = "";
            boolean bl = false;
            boolean bl2 = false;
            String string3 = null;
            boolean bl3 = false;
            string2 = dN.toRFCString().toLowerCase();
            string3 = string2 + "/" + string + "Names";
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->getConfigTemplateNames: Looking for: " + string3);
            }
            if (bl = _cch.containsKey(string3)) {
                return (Set)_cch.get(string3);
            }
            bl2 = _checkListCache.containsKey((Object)string2.toLowerCase());
            if (!bl2) {
                if (_debug.messageEnabled()) {
                    _debug.message("ConfigManager->getConfigTemplateNames: updating " + dN);
                }
                Hashtable hashtable = _cch;
                synchronized (hashtable) {
                    this.updateCache(string2);
                }
                if (_cch.containsKey(string3)) {
                    return (Set)_cch.get(string3);
                }
            }
            switch (n) {
                case 0: {
                    return Collections.EMPTY_SET;
                }
                case 2: {
                    dN = new DN(_rootDN);
                    break;
                }
                case 1: {
                    dN = dN.getParent();
                    if (dN.isDescendantOf(_root) || dN.equals(_root)) break;
                    return Collections.EMPTY_SET;
                }
            }
            _debug.message("ConfigManager->getConfigTemplateNames: Traversing parent: " + dN);
        }
    }

    public Set getEntity(Guid guid, String string) throws ConfigManagerException {
        Set set = (Set)this.getConfigData(guid, string, ENTITY, 1);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public AttrSet getSearchTemplate(Guid guid, String string, int n) throws ConfigManagerException {
        AttrSet attrSet = (AttrSet)this.getConfigData(guid, string, SEARCH, n);
        if (attrSet == null) {
            return AttrSet.EMPTY_ATTR_SET;
        }
        return attrSet;
    }

    public AttrSet getCreationTemplate(Guid guid, String string, int n) throws ConfigManagerException {
        AttrSet attrSet = (AttrSet)this.getConfigData(guid, string, CREATION, n);
        if (attrSet == null) {
            return AttrSet.EMPTY_ATTR_SET;
        }
        return attrSet;
    }

    public AttrSet getCreationTemplateForClass(Guid guid, String string, int n) throws ConfigManagerException {
        AttrSet attrSet = (AttrSet)this.getConfigData(guid, string, CREATION, n);
        if (attrSet == null) {
            return AttrSet.EMPTY_ATTR_SET;
        }
        return attrSet;
    }

    public Set getCreationTemplateNames(Guid guid) throws ConfigManagerException {
        return this.getConfigTemplateNames(guid, CREATION, 0);
    }

    public Set getSearchTemplateNames(Guid guid) throws ConfigManagerException {
        return this.getConfigTemplateNames(guid, SEARCH, 0);
    }

    public String[][] getClassResolver() throws ConfigManagerException {
        if (_oc_jc_map == null) {
            _oc_jc_map = (String[][])this.getConfigData(null, OBJECTRESOLVER, OBJECTRESOLVER, 0);
        }
        return _oc_jc_map;
    }

    public void replaceCreationTemplate(Guid guid, String string, AttrSet attrSet) throws ConfigManagerException {
        if (guid == null) {
            guid = new Guid(_rootDN);
        }
        DN dN = new DN(guid.getDn());
        String string2 = null;
        String[] stringArray = dN.explodeDN(true);
        int n = 0;
        while (n < stringArray.length - 1) {
            string2 = string2 + "/" + stringArray[n];
            ++n;
        }
        String string3 = "/templates/CreationTemplates/" + string;
        Map map = this.convertToMap(attrSet);
        try {
            this.replaceServiceAttributes(string2, string3, map);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new String[]{sMSException.toString()};
            throw new ConfigManagerException(i18n.getString("ums-cm", objectArray));
        }
        catch (SSOException sSOException) {
            Object[] objectArray = new String[]{sSOException.toString()};
            throw new ConfigManagerException(i18n.getString("ums-cm", objectArray));
        }
    }

    private Map convertToMap(AttrSet attrSet) {
        HashMap hashMap = new HashMap();
        String[] stringArray = attrSet.getAttributeNames();
        int n = 0;
        while (n < stringArray.length) {
            Attr attr = attrSet.getAttribute(stringArray[n]);
            String[] stringArray2 = attr.getStringValues();
            HashSet<String> hashSet = new HashSet<String>();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                hashSet.add(stringArray2[n2]);
                ++n2;
            }
            hashMap.put(stringArray[n], hashSet);
            ++n;
        }
        return hashMap;
    }

    private String[][] getOC_JC_MAP(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        String[][] stringArray = new String[n][2];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = string2.indexOf(61);
            if (n3 < 0) continue;
            String string3 = string2.substring(0, n3);
            String string4 = string2.substring(n3 + 1, string2.length());
            stringArray[n2][0] = string3;
            stringArray[n2][1] = string4;
            ++n2;
        }
        return stringArray;
    }

    private ConfigManagerUMS() throws ConfigManagerException {
        _cch = new Hashtable();
        _checkListCache = new Cache(10000);
        Object[] objectArray = new String[1];
        try {
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            ServerInstance serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            _rootDN = serverInstance.getBaseDN();
            _root = new DN(_rootDN);
            _rootDN = _root.toRFCString().toLowerCase();
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->Constructor: root DN " + _rootDN);
            }
            String string = serverInstance.getAuthID();
            _principal = new AuthPrincipal(string);
            String string2 = (String)AccessController.doPrivileged(new ServerInstanceAction(serverInstance));
            AuthContext authContext = new AuthContext(_principal, string2.toCharArray());
            SSOToken sSOToken = authContext.getSSOToken();
            try {
                SSOTokenManager.getInstance().validateToken(sSOToken);
            }
            catch (SSOException sSOException) {
                objectArray[0] = sSOException.toString();
                throw new ConfigManagerException(i18n.getString("ums-invalidssotoken", objectArray));
            }
            _smapi = new ServiceConfigManager(sSOToken, UMS_SRVC, UMS_VERSION);
            _listener = new CMListener();
            _lid = _smapi.addListener(_listener);
        }
        catch (Exception exception) {
            _debug.error("ConfigManager->Constructor: Caught exception " + exception);
            exception.printStackTrace();
            objectArray[0] = exception.toString();
            throw new ConfigManagerException(i18n.getString("ums-cm", objectArray));
        }
    }

    static {
        _debug = Debug.getInstance((String)"amSDK");
    }
}

