/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.naming.service;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.services.naming.share.NamingRequest;
import com.iplanet.services.naming.share.NamingResponse;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NamingService
implements RequestHandler,
ServiceListener {
    private static final String sccsID = "$Id: NamingService.java,v 1.37 2004/02/05 17:56:14 vs125812 Exp $ $Date: 2004/02/05 17:56:14 $  Sun Microsystems, Inc.";
    private static Debug namingDebug = null;
    public static final String NAMING_SERVICE = "com.iplanet.am.naming";
    private static Hashtable namingTable = null;
    private static Properties platformProperties = null;
    private static String server_proto = null;
    private static String server_host = null;
    private static String server_port = null;
    private static SSOTokenManager ssom = null;
    private static AuthPrincipal ap = null;
    private static SSOToken sso = null;
    private static ServiceSchemaManager scmNaming = null;
    private static ServiceSchemaManager scmPlatform = null;
    private static String delimiter = "|";

    public static Hashtable getNamingTable() throws SMSException {
        try {
            if (namingTable != null) {
                return namingTable;
            }
            NamingService.updateNamingTable();
        }
        catch (Exception exception) {
            throw new SMSException(exception.getMessage());
        }
        return namingTable;
    }

    private static void updateNamingTable() throws SMSException {
        try {
            ServiceSchema serviceSchema = scmNaming.getGlobalSchema();
            Map map = serviceSchema.getAttributeDefaults();
            serviceSchema = scmPlatform.getGlobalSchema();
            Map map2 = serviceSchema.getAttributeDefaults();
            Set set = (Set)map2.get("iplanet-am-platform-server-list");
            NamingService.storeServerList(set, map);
            namingTable = NamingService.convertToHash(map);
            if (namingDebug.messageEnabled()) {
                namingDebug.message("Naming table -> " + namingTable.toString());
            }
        }
        catch (Exception exception) {
            namingDebug.error("Can't get naming mable", (Throwable)exception);
            throw new SMSException(exception.getMessage());
        }
    }

    static Hashtable convertToHash(Map map) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set2 = (Set)map.get(string);
            hashtable.put(string, NamingService.setToString(set2));
        }
        return hashtable;
    }

    static void storeServerList(Set set, Map map) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(delimiter);
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                HashSet<String> hashSet2 = new HashSet<String>();
                hashSet2.add(string2);
                hashSet.add(string2);
                map.put(string3, hashSet2);
                continue;
            }
            namingDebug.error("Platform Server List entry is invalid:" + string);
        }
        map.put("iplanet-am-platform-server-list", hashSet);
    }

    static String setToString(Set set) {
        StringBuffer stringBuffer = new StringBuffer(100);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public ResponseSet process(Vector vector, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResponseSet responseSet = new ResponseSet(NAMING_SERVICE);
        int n = 0;
        while (n < vector.size()) {
            Request request = (Request)vector.elementAt(n);
            Response response = this.processRequest(request);
            responseSet.addResponse(response);
            ++n;
        }
        return responseSet;
    }

    private Response processRequest(Request request) {
        String string = request.getContent();
        NamingRequest namingRequest = NamingRequest.parseXML((String)string);
        NamingResponse namingResponse = new NamingResponse(namingRequest.getRequestID());
        String string2 = namingRequest.getSessionId();
        try {
            if (string2 == null) {
                namingResponse.setNamingTable(NamingService.getNamingTable());
            } else {
                Hashtable hashtable = new Hashtable();
                hashtable = this.transferTable(NamingService.getNamingTable());
                Hashtable hashtable2 = this.replaceTable(hashtable, string2);
                if (hashtable2 == null) {
                    namingResponse.setException("SessionID ---" + string2 + "---is Invalid");
                } else {
                    namingResponse.setNamingTable(hashtable2);
                }
            }
        }
        catch (Exception exception) {
            namingResponse.setException(exception.getMessage());
        }
        return new Response(namingResponse.toXMLString());
    }

    private Hashtable replaceTable(Hashtable hashtable, String string) {
        Object object;
        Object object2;
        SessionID sessionID = new SessionID(string);
        namingDebug.message("SessionId received is --" + string);
        String string2 = sessionID.getSessionServerProtocol();
        String string3 = sessionID.getSessionServer();
        String string4 = sessionID.getSessionServerPort();
        if (string2.equalsIgnoreCase("") || string3.equalsIgnoreCase("") || string4.equalsIgnoreCase("")) {
            return null;
        }
        if (!(string2.equals(server_proto) && string3.equals(server_host) && string4.equals(server_port))) {
            object2 = string2 + "://" + string3 + ":" + string4;
            object = (String)hashtable.get("iplanet-am-platform-server-list");
            if (((String)object).indexOf((String)object2) == -1) {
                return null;
            }
        }
        object2 = hashtable;
        object = ((Hashtable)object2).keys();
        while (object.hasMoreElements()) {
            Object k = object.nextElement();
            String string5 = k.toString();
            String string6 = ((Hashtable)object2).get(k).toString();
            int n = string6.indexOf("%protocol");
            if (n != -1) {
                string6 = string6.substring(0, n) + string2 + string6.substring(n + "%protocol".length(), string6.length());
            }
            if ((n = string6.indexOf("%host")) != -1) {
                string6 = string6.substring(0, n) + string3 + string6.substring(n + "%host".length(), string6.length());
            }
            if ((n = string6.indexOf("%port")) != -1) {
                string6 = string6.substring(0, n) + string4 + string6.substring(n + "%port".length(), string6.length());
            }
            ((Hashtable)object2).put(string5, string6);
        }
        return object2;
    }

    private Hashtable transferTable(Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string = k.toString();
            String string2 = hashtable.get(k).toString();
            hashtable2.put(string, string2);
        }
        return hashtable2;
    }

    public void schemaChanged(String string, String string2) {
        if (string == null || !string.equals("iPlanetAMPlatformService")) {
            return;
        }
        try {
            NamingService.updateNamingTable();
        }
        catch (SMSException sMSException) {
            namingDebug.error("Error occured in updating naming table", (Throwable)sMSException);
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
    }

    static {
        namingDebug = Debug.getInstance((String)"amNaming");
        platformProperties = SystemProperties.getPlatform();
        server_proto = platformProperties.getProperty("com.iplanet.am.server.protocol", "");
        server_host = platformProperties.getProperty("com.iplanet.am.server.host", "");
        server_port = platformProperties.getProperty("com.iplanet.am.server.port", "");
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            sso = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
            scmNaming = new ServiceSchemaManager("iPlanetAMNamingService", sso);
            scmPlatform = new ServiceSchemaManager("iPlanetAMPlatformService", sso);
            String string3 = scmPlatform.addListener(new NamingService());
        }
        catch (Exception exception) {
            namingDebug.error("Naming Initialization failed.", (Throwable)exception);
        }
    }
}

