/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.event;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.event.EventService;
import com.iplanet.services.ldap.event.EventServicePolling;

class TimeOut
implements Runnable {
    private Thread _serviceThread;
    private long _timeOut;
    private Object _monitor;
    private boolean _exitStatus = false;
    private Debug debug = EventService.debugger;
    private EventServicePolling _serviceInstance;

    TimeOut(EventServicePolling eventServicePolling, long l, Object object) {
        this.setServiceInstance(eventServicePolling);
        this.setServiceThread(this.getServiceInstance().getServiceThread());
        this.setTimeOutValue(l);
        this.setMonitor(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.debug.message("TimeOut.run() - thread started.");
        while (!this.shouldExit()) {
            try {
                long l = this.getTimeOutValue();
                if (this.debug.messageEnabled()) {
                    this.debug.message("TimeOut.run() - Sleeping for " + l + " milliseconds.");
                }
                Thread.sleep(l);
                Object object = this._monitor;
                synchronized (object) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("TimeOut.run() - Notifying EventServicePolling thread about timeout");
                    }
                    this.getServiceThread().interrupt();
                    if (this.debug.messageEnabled()) {
                        this.debug.message("TimeOut.run() - Waiting for EventServicePolling thread to notify");
                    }
                    this._monitor.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                if (!this.debug.messageEnabled()) continue;
                this.debug.message("TimeOut.run() - Received interrupt ", (Throwable)interruptedException);
            }
        }
        this.debug.error("TimeOut.run() - thread stopped as notified by EventServicePolling thread.");
    }

    private void setServiceInstance(EventServicePolling eventServicePolling) {
        this._serviceInstance = eventServicePolling;
    }

    private EventServicePolling getServiceInstance() {
        return this._serviceInstance;
    }

    protected synchronized void setTimeOutValue(long l) {
        this._timeOut = l;
    }

    private synchronized long getTimeOutValue() {
        return this._timeOut;
    }

    private void setServiceThread(Thread thread) {
        this._serviceThread = thread;
    }

    private Thread getServiceThread() {
        return this._serviceThread;
    }

    protected synchronized void setExitStatus(boolean bl) {
        this._exitStatus = bl;
    }

    private synchronized boolean shouldExit() {
        return this._exitStatus || !this.getServiceThread().isAlive();
    }

    private void setMonitor(Object object) {
        this._monitor = object;
    }
}

