/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.event;

import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.event.EventException;
import com.iplanet.services.ldap.event.EventService;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.services.ldap.event.Request;
import com.iplanet.services.ldap.event.TimeOut;
import com.iplanet.sso.SSOToken;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPMessage;

public class EventServicePolling
extends EventService {
    private TimeOut _timeOut = null;
    private Thread _timeOutThread = null;
    private Object _monitor;
    private final int IS_MESSAGE_PROCESSED = 0;

    public synchronized String addListener(SSOToken sSOToken, IDSEventListener iDSEventListener, String string, int n, String string2, int n2) throws LDAPException, EventException {
        String string3 = super.addListener(sSOToken, iDSEventListener, string, n, string2, n2);
        this.startTimeOutThread();
        return string3;
    }

    public void run() {
        if (EventService.debugger.messageEnabled()) {
            EventService.debugger.message("EventServicePolling.run(): Event Thread is running! Idle timeout = " + EventService._idleTimeOut + " minutes.");
        }
        boolean bl = true;
        LDAPMessage lDAPMessage = null;
        boolean[] blArray = new boolean[1];
        while (bl) {
            try {
                try {
                    if (EventService.debugger.messageEnabled()) {
                        EventService.debugger.message("EventServicePolling.run(): Waiting for response");
                    }
                    lDAPMessage = null;
                    blArray[0] = false;
                    lDAPMessage = EventService._msgQueue.getResponse();
                    bl = this.processResponse(lDAPMessage, blArray);
                }
                catch (LDAPInterruptedException lDAPInterruptedException) {
                    bl = this.processLDAPInterruptedException(lDAPInterruptedException, lDAPMessage, blArray);
                }
                catch (LDAPException lDAPException) {
                    bl = this.processLDAPException(lDAPException);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    bl = this.processInterruptedException(lDAPMessage, blArray, bl);
                    continue;
                }
                if (EventService.debugger.warningEnabled()) {
                    EventService.debugger.warning("EventServicePolling.run(): Unknown exception caught. Ignoring..", throwable);
                }
                this.sleepRetryInterval();
            }
        }
        EventService.debugger.error("EventServicePolling.run() - Monitor thread is terminating! Persistent Searches will no longer be operational.");
    }

    protected EventServicePolling() throws EventException {
    }

    protected String getName() {
        return "EventServicePolling";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processResponse(LDAPMessage lDAPMessage, boolean[] blArray) {
        Object object = this._monitor;
        synchronized (object) {
            boolean bl = true;
            bl = super.processResponse(lDAPMessage);
            blArray[0] = true;
            lDAPMessage = null;
            return bl;
        }
    }

    protected boolean resetAllSearches(boolean bl) {
        boolean bl2 = super.resetAllSearches(bl);
        this.interruptTimeOutThread(!bl2, EventService._idleTimeOutMills);
        return bl2;
    }

    private synchronized boolean resetTimedOutConnections() {
        HashSet<Request> hashSet = new HashSet<Request>();
        long l = EventService._idleTimeOutMills;
        long l2 = System.currentTimeMillis();
        if (EventService.debugger.messageEnabled()) {
            EventService.debugger.message("EventServicePolling.resetTimedOutConnections(): determining timed out connections.");
        }
        Collection collection = this._requestList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            long l3 = request.getLastUpdatedTime();
            if (this.checkIfTimedOut(l2, l3)) {
                if (EventService.debugger.messageEnabled()) {
                    EventService.debugger.message("EventServicePolling.resetTimedOutConnections(): the following request: " + request.getListener() + " has timed" + " out. Current Time: " + l2 + " Last " + "updated time: " + request.getLastUpdatedTime());
                }
                hashSet.add(request);
                continue;
            }
            long l4 = l3 + EventService._idleTimeOutMills - l2;
            long l5 = l = l4 < l ? l4 : l;
        }
        boolean bl = true;
        bl = l == EventService._idleTimeOutMills ? this.resetAllSearches(false) : this.resetTimedOutSearches(hashSet, l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean resetTimedOutSearches(Set set, long l) {
        boolean bl;
        block9: {
            if (EventService.debugger.messageEnabled()) {
                EventService.debugger.message("EventServicePolling.resetAllSearches(): " + set.size() + " connections (searches) timed out!");
            }
            bl = true;
            long l2 = EventService._idleTimeOutMills;
            try {
                try {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Request request = (Request)iterator.next();
                        this.removeListener(request);
                        this.addListener(request.getRequester(), request.getListener(), request.getBaseDn(), request.getScope(), request.getFilter(), request.getOperations());
                        this._requestList.remove(request.getRequestID());
                    }
                    l2 = l;
                }
                catch (LDAPServiceException lDAPServiceException) {
                    if (EventService.debugger.messageEnabled()) {
                        EventService.debugger.message("EventServicePolling.resetAllSearches():  LDAPServiceException occurred while re-establishinglisteners. ", (Throwable)lDAPServiceException);
                    }
                    int n = lDAPServiceException.getLDAPExceptionErrorCode();
                    bl = this.processExceptionErrorCodes(lDAPServiceException, n, false);
                    Object var11_11 = null;
                    this.interruptTimeOutThread(!bl, l2);
                    break block9;
                }
                catch (LDAPException lDAPException) {
                    if (EventService.debugger.messageEnabled()) {
                        EventService.debugger.message("EventServicePolling.resetAllSearches(): LDAPException occurred, while trying to re-establish persistent searches.", (Throwable)lDAPException);
                    }
                    int n = lDAPException.getLDAPResultCode();
                    bl = this.processExceptionErrorCodes(lDAPException, n, false);
                    Object var11_12 = null;
                    this.interruptTimeOutThread(!bl, l2);
                }
                Object var11_10 = null;
                this.interruptTimeOutThread(!bl, l2);
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.interruptTimeOutThread(!bl, l2);
                throw throwable;
            }
        }
        return bl;
    }

    private boolean checkIfTimedOut(long l, long l2) {
        boolean bl = false;
        long l3 = l - l2;
        long l4 = l3 / 60000L;
        long l5 = (long)EventService._idleTimeOut - l4;
        if (l5 <= 1L) {
            bl = true;
        }
        return bl;
    }

    private boolean processExceptionErrorCodes(Exception exception, int n, boolean bl) {
        boolean bl2 = true;
        if (EventService._retryErrorCodes.contains(Integer.toString(n))) {
            bl2 = super.resetAllSearches(true);
            if (bl) {
                this.interruptTimeOutThread(!bl2, EventService._idleTimeOutMills);
            }
        } else {
            this.processNetworkError(exception);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processLDAPException(LDAPException lDAPException) {
        Object object = this._monitor;
        synchronized (object) {
            if (EventService.debugger.warningEnabled()) {
                EventService.debugger.warning("EventServicePolling.processLDAPException() - LDAPException received:", (Throwable)lDAPException);
            }
            boolean bl = true;
            int n = lDAPException.getLDAPResultCode();
            bl = this.processExceptionErrorCodes(lDAPException, n, true);
            return bl;
        }
    }

    private boolean processInterruptedException(LDAPMessage lDAPMessage, boolean[] blArray, boolean bl) {
        if (EventService.debugger.messageEnabled()) {
            EventService.debugger.message("EventServicePolling.processInterruptedException() - Message present: " + (lDAPMessage != null) + " Processed earlier: " + blArray[0]);
        }
        boolean bl2 = bl;
        if (!blArray[0]) {
            bl2 = this.processResponse(lDAPMessage, blArray);
        }
        if (bl2) {
            bl2 = this.resetTimedOutConnections();
        }
        return bl2;
    }

    private boolean processLDAPInterruptedException(LDAPInterruptedException lDAPInterruptedException, LDAPMessage lDAPMessage, boolean[] blArray) {
        if (EventService.debugger.messageEnabled()) {
            EventService.debugger.message("EventServicePolling.processLDAPInterruptedException(): Received an interrupted Exception - resetting searches. Message present: " + (lDAPMessage != null) + "message proccessed: " + blArray[0], (Throwable)lDAPInterruptedException);
        }
        boolean bl = true;
        if (lDAPMessage != null && !blArray[0]) {
            bl = this.processResponse(lDAPMessage, blArray);
        }
        if (bl) {
            bl = this.resetTimedOutConnections();
        }
        return bl;
    }

    private void initialize(LDAPMessage lDAPMessage, boolean[] blArray) {
        lDAPMessage = null;
        blArray[0] = false;
    }

    private void startTimeOutThread() {
        if (this._timeOutThread == null || !this._timeOutThread.isAlive()) {
            this._monitor = new Object();
            this._timeOut = new TimeOut(this, EventService._idleTimeOutMills, this._monitor);
            this._timeOutThread = new Thread((Runnable)this._timeOut, "TimeOut");
            this._timeOutThread.setDaemon(true);
            this._timeOutThread.start();
        }
    }

    private void interruptTimeOutThread(boolean bl, long l) {
        if (EventService.debugger.messageEnabled()) {
            EventService.debugger.message("EventServicePolling.interruptTimeOutThread():  Interrupting TimeOut thread with exit status: " + bl + " time out: " + l);
        }
        this._timeOut.setTimeOutValue(l);
        this._timeOut.setExitStatus(bl);
        this._timeOutThread.interrupt();
    }

    protected Thread getServiceThread() {
        return EventService._monitorThread;
    }
}

