/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.IterEnumeration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import netscape.ldap.LDAPAttributeSet;

public class AttrSet
implements Serializable,
Cloneable {
    private ArrayList _attrs = new ArrayList();
    public static final AttrSet EMPTY_ATTR_SET = new AttrSet();

    public AttrSet() {
    }

    public AttrSet(Attr[] attrArray) {
        int n = attrArray.length;
        this._attrs = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this._attrs.add(attrArray[n2]);
            ++n2;
        }
    }

    public AttrSet(Attr attr) {
        this.add(attr);
    }

    public AttrSet(LDAPAttributeSet lDAPAttributeSet) {
        int n = lDAPAttributeSet.size();
        this._attrs = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this._attrs.add(new Attr(lDAPAttributeSet.elementAt(n2)));
            ++n2;
        }
    }

    public void add(Attr attr) {
        if (attr == null) {
            return;
        }
        Attr attr2 = this.findAttribute(attr.getName());
        if (attr2 == null) {
            this._attrs.add(attr);
        } else {
            attr2.addValues(attr.getStringValues());
        }
    }

    public void addBinaryAttr(Attr attr) {
        Attr attr2 = this.findAttribute(attr.getName());
        if (attr2 == null) {
            this._attrs.add(attr);
        } else {
            attr2.addValues(attr.getByteValues());
        }
    }

    public void remove(String string) {
        int n = this.indexOf(string);
        if (n != -1) {
            this._attrs.remove(n);
        }
    }

    public void remove(String string, String string2) {
        int n = this.indexOf(string);
        if (n != -1) {
            Attr attr = (Attr)this._attrs.get(n);
            attr.removeValue(string2);
            if (attr.size() == 0) {
                this._attrs.remove(n);
            }
        }
    }

    public void replace(Attr attr) {
        int n = this.indexOf(attr.getName());
        if (n != -1) {
            this._attrs.set(n, attr);
        } else {
            this._attrs.add(attr);
        }
    }

    public String[] getAttributeNames() {
        int n = this.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((Attr)this._attrs.get(n2)).getName();
            ++n2;
        }
        return stringArray;
    }

    public Attr getAttribute(String string) {
        return this.findAttribute(string);
    }

    public Enumeration getAttributes() {
        return new IterEnumeration(this._attrs.iterator());
    }

    public String getValue(String string) {
        String string2 = null;
        Attr attr = this.findAttribute(string);
        if (attr != null) {
            string2 = attr.getValue();
        }
        return string2;
    }

    public boolean contains(String string) {
        boolean bl = false;
        int n = this.indexOf(string);
        if (n != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(String string, String string2) {
        boolean bl = false;
        Attr attr = this.findAttribute(string);
        if (attr != null) {
            bl = attr.contains(string2);
        }
        return bl;
    }

    public int size() {
        return this._attrs.size();
    }

    public Attr elementAt(int n) {
        return (Attr)this._attrs.get(n);
    }

    public int indexOf(String string) {
        string = string.toLowerCase();
        int n = -1;
        int n2 = this._attrs.size();
        int n3 = 0;
        while (n3 < n2) {
            if (string.equals(((Attr)this._attrs.get(n3)).getName())) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    private Attr findAttribute(String string) {
        string = string.toLowerCase();
        Attr attr = null;
        if (this._attrs != null) {
            int n = this._attrs.size();
            int n2 = 0;
            while (n2 < n) {
                Attr attr2 = (Attr)this._attrs.get(n2);
                if (attr2.getName().equals(string)) {
                    attr = attr2;
                    break;
                }
                ++n2;
            }
        }
        return attr;
    }

    public Object clone() {
        AttrSet attrSet = new AttrSet();
        int n = this._attrs.size();
        int n2 = 0;
        while (n2 < n) {
            attrSet.add((Attr)((Attr)this._attrs.get(n2)).clone());
            ++n2;
        }
        return attrSet;
    }

    public LDAPAttributeSet toLDAPAttributeSet() {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)this._attrs.get(n2);
            if (attr.size() > 0) {
                lDAPAttributeSet.add(attr.toLDAPAttribute());
            }
            ++n2;
        }
        return lDAPAttributeSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AttrSet: ");
        int n = this._attrs.size();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this._attrs.get(n2).toString() + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

