/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.server;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.server.SendNotificationException;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.services.comm.share.PLLBundle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class NotificationSender {
    private static final String sccsID = "@(#)NotificationSender.java\t1.2  00/03/27 03/27/00  Sun Microsystems, Inc.";
    private URL url;
    private NotificationSet set;

    NotificationSender(URL uRL, NotificationSet notificationSet) {
        this.url = uRL;
        this.set = notificationSet;
    }

    public void run() throws SendNotificationException {
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            String string;
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            if (SystemProperties.iasGXId != null) {
                httpURLConnection.setRequestProperty("Cookie", "GX_jst=" + SystemProperties.iasGXId);
            }
            httpURLConnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            String string2 = this.set.toXMLString();
            int n = string2.getBytes("UTF-8").length;
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n));
            if (PLLServer.pllDebug.messageEnabled()) {
                PLLServer.pllDebug.message("Sent NotificationSet XML :" + string2);
            }
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(string2.getBytes("UTF-8"));
            outputStream.flush();
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            string = stringBuffer.toString();
            if (!string.equals("OK")) {
                throw new SendNotificationException(PLLBundle.getString((String)"sendNotificationFailed"));
            }
        }
        catch (Exception exception) {
            PLLServer.pllDebug.error("Cannot send notification to " + this.url, (Throwable)exception);
            throw new SendNotificationException(exception);
        }
        finally {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

