/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.QCharset;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ICDMConstants;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.services.cdm.clientschema.AMClientDataListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public class G11NSettings
implements ServiceListener,
ICDMConstants,
AMClientDataListener {
    private Map rawServiceData = null;
    private static G11NSettings currInstance = null;
    private static Debug debug = null;
    private static SSOToken internalToken = null;
    private ServiceSchemaManager serviceSchemaManager = null;
    private Map localeCharset = new TreeMap();
    private Map charsetAlias = new TreeMap();
    private Map charsetCache = new HashMap();
    private static AMClientCapData intCapInstance = null;
    private static AMClientCapData extCapInstance = null;

    public static G11NSettings getInstance() {
        return currInstance;
    }

    public String getDefaultCharsetForLocale(Locale locale) {
        List list = this.getCharsetForLocale(locale.toString());
        Object var3_3 = null;
        if (list != null && !list.isEmpty()) {
            return list.iterator().next().toString();
        }
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (string2 != null && string2.length() > 0 && (list = this.getCharsetForLocale(string + "_" + string2)) != null && !list.isEmpty()) {
            return list.iterator().next().toString();
        }
        if (string != null && string.length() > 0 && (list = this.getCharsetForLocale(string)) != null && !list.isEmpty()) {
            return list.iterator().next().toString();
        }
        return "UTF-8";
    }

    public List getCharsetForLocale(String string) {
        if (debug.messageEnabled()) {
            debug.message("G11NSettings::Getcharsetforlocale" + string);
            debug.message("returns " + this.localeCharset.get(string));
        }
        return (List)this.localeCharset.get(string);
    }

    public Map getCharsetAliasTable(String string) {
        return (Map)this.charsetAlias.get(string);
    }

    public String getJavaCharset(String string) {
        Map map = (Map)this.charsetAlias.get(string);
        if (map == null) {
            return string;
        }
        String string2 = (String)map.get("javaname");
        if (string2 == null || string2.length() == 0) {
            if (debug.messageEnabled()) {
                debug.message("Unable to find java charset for " + string);
            }
            return string;
        }
        if (debug.messageEnabled()) {
            debug.message("javacharset(" + string + ")=" + string2);
        }
        return string2;
    }

    public void schemaChanged(String string, String string2) {
        if (debug.messageEnabled()) {
            debug.message("Schema change serviceName = " + string + "\tversion = " + string2 + "\tinitializing ...");
        }
        if (string.equals("iPlanetG11NSettings")) {
            this.localeCharset.clear();
            this.charsetAlias.clear();
            this.charsetCache.clear();
            this.initializeService();
        }
        if (debug.messageEnabled()) {
            debug.message("G11NSettings init  complete");
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
    }

    public String getCharset(String string, Locale locale) throws ClientException {
        Client client = Client.getInstance(string);
        String string2 = this.fetchCharsetFromCache(client, locale);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        string2 = this.fetchCharset(client, locale);
        HashMap<Locale, String> hashMap = (HashMap<Locale, String>)this.charsetCache.get(client.getClientType());
        if (hashMap == null) {
            hashMap = new HashMap<Locale, String>(3);
            this.charsetCache.put(string, hashMap);
        }
        if (debug.messageEnabled()) {
            debug.message("getCharset() for clientType = " + string + "\tlocale=" + locale + "\tcharset = " + string2);
        }
        hashMap.put(locale, string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientChanged(String string, int n, int n2) {
        if (debug.messageEnabled()) {
            debug.message("G11nSettings::clientChanged() NOTIFICATION: clientType = " + string + " :DB = " + n + " : Op = " + n2);
        }
        if (string == null || string.length() == 0) {
            return;
        }
        Map map = this.charsetCache;
        synchronized (map) {
            switch (n2) {
                case 2: {
                    Iterator iterator = this.charsetCache.keySet().iterator();
                    int n3 = string.length();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (!string2.equalsIgnoreCase(string)) continue;
                        iterator.remove();
                        break;
                    }
                    return;
                }
                case 1: {
                    return;
                }
                case 4: {
                    this.charsetCache.remove(string);
                    return;
                }
            }
            debug.error("ClientSchema modification unknown opType" + n2);
        }
    }

    private G11NSettings() {
        this.initializeService();
        if (this.serviceSchemaManager != null) {
            this.serviceSchemaManager.addListener(this);
        }
        try {
            intCapInstance = AMClientCapData.getInternalInstance();
            intCapInstance.addListener(this);
            extCapInstance = AMClientCapData.getExternalInstance();
            extCapInstance.addListener(this);
        }
        catch (AMClientCapException aMClientCapException) {
            debug.error("Unable to get an instance Of ClientData in G11Nsettings", (Throwable)aMClientCapException);
        }
    }

    private void initializeService() {
        try {
            this.readServiceConfig();
            Object[] objectArray = ((Set)this.rawServiceData.get("sun-identity-g11n-settings-locale-charset-mapping")).toArray();
            int n = 0;
            while (n < objectArray.length) {
                this.createLocaleEntry((String)objectArray[n]);
                ++n;
            }
            objectArray = ((Set)this.rawServiceData.get("sun-identity-g11n-settings-charset-alias-mapping")).toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.createCharsetAliasEntry((String)objectArray[n2]);
                ++n2;
            }
        }
        catch (SSOException sSOException) {
            debug.error("Unable to get internal SSOToken for locale attribute ", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            debug.error("Unable to get  locale attribute value", (Throwable)sMSException);
        }
    }

    private void readServiceConfig() throws SSOException, SMSException {
        if (debug.messageEnabled()) {
            debug.message("G11Settings::ReadServiceConfig");
        }
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        String string = (String)AccessController.doPrivileged(new AdminDNAction());
        String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
        internalToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        this.serviceSchemaManager = new ServiceSchemaManager("iPlanetG11NSettings", internalToken);
        ServiceSchema serviceSchema = this.serviceSchemaManager.getGlobalSchema();
        this.rawServiceData = serviceSchema.getAttributeDefaults();
    }

    private void createCharsetAliasEntry(String string) {
        String string2;
        Object object;
        Object object2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string3 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (stringTokenizer.hasMoreElements()) {
            object2 = stringTokenizer.nextToken();
            object = new StringTokenizer((String)object2, "=");
            if (((StringTokenizer)object).countTokens() != 2) continue;
            string2 = ((StringTokenizer)object).nextToken();
            string2 = string2.trim();
            String string4 = ((StringTokenizer)object).nextToken().trim();
            if (string2.equalsIgnoreCase("mimeName")) {
                string3 = string4.toUpperCase();
                continue;
            }
            hashMap.put(string2.toLowerCase(), string4.toUpperCase());
        }
        if (string3 != null) {
            this.charsetAlias.put(string3, hashMap);
            if (debug.messageEnabled()) {
                debug.message("Building alias name for " + string3);
                object2 = hashMap.keySet();
                object = object2.iterator();
                while (object.hasNext()) {
                    string2 = (String)object.next();
                    debug.message("name = " + string2 + " value = " + hashMap.get(string2));
                }
            }
        }
    }

    private void createLocaleEntry(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = null;
        LinkedList<String> linkedList = null;
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=");
            if (stringTokenizer2.countTokens() != 2) continue;
            String string4 = stringTokenizer2.nextToken();
            string4 = string4.trim();
            String string5 = stringTokenizer2.nextToken();
            if (string4.equalsIgnoreCase("locale")) {
                string2 = string5.toLowerCase();
            }
            int n = 0;
            if (!string4.equalsIgnoreCase("charset")) continue;
            linkedList = new LinkedList<String>();
            StringTokenizer stringTokenizer3 = new StringTokenizer(string5, ";");
            while (stringTokenizer3.hasMoreElements()) {
                String string6 = stringTokenizer3.nextToken();
                linkedList.add(string6);
                ++n;
            }
        }
        if (linkedList != null && string2 != null) {
            this.localeCharset.put(string2, linkedList);
            if (debug.messageEnabled()) {
                debug.message("G11NSettings Locale = " + string2 + "\tAllowed charset are " + linkedList);
            }
        }
    }

    private static void getInternalToken() {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            internalToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (SSOException sSOException) {
            debug.error("getInternalToken", (Throwable)sSOException);
            internalToken = null;
        }
    }

    private String fetchCharsetFromCache(Client client, Locale locale) {
        Map map = (Map)this.charsetCache.get(client.getClientType());
        String string = null;
        if (map != null) {
            string = (String)map.get(locale);
        }
        return string;
    }

    private synchronized String fetchCharset(Client client, Locale locale) {
        String string;
        Object object;
        Object object2;
        Object object3;
        String string2 = null;
        string2 = this.fetchCharsetFromCache(client, locale);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        Set set = client.getProperties("CcppAccept-Charset");
        if (set == null && (string2 = this.getCharsetLegacy(client, locale)) != null && string2.length() > 0) {
            return string2;
        }
        TreeSet<QCharset> treeSet = new TreeSet<QCharset>();
        if (set != null) {
            object3 = set.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (((String)object2).indexOf(";") >= 0) {
                    object = new StringTokenizer((String)object2, ";");
                    if (((StringTokenizer)object).countTokens() != 2) {
                        debug.error("G11NSettings::fetchcharSet () Unable toparse charset entry " + (String)object2);
                        break;
                    }
                    string = ((StringTokenizer)object).nextToken();
                    String string3 = ((StringTokenizer)object).nextToken();
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
                    if (stringTokenizer.countTokens() != 2) {
                        debug.error("G11NSettings::fetchcharSet ()Unable to parse qvalue of charset entry " + string3);
                        break;
                    }
                    String string4 = stringTokenizer.nextToken();
                    if (string4.length() > 1 || !string4.equalsIgnoreCase("q")) {
                        debug.error("G11NSettings::Fetchcharset() Unable toparse  charset entry invalid Q " + string4);
                        break;
                    }
                    String string5 = stringTokenizer.nextToken();
                    try {
                        float f = Float.parseFloat(string5);
                        treeSet.add(new QCharset(string, f));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        debug.error("G11NSettings::fetchcharSet () unableto parse q factor", (Throwable)numberFormatException);
                        break;
                    }
                }
                treeSet.add(new QCharset((String)object2));
            }
            if (debug.messageEnabled()) {
                object2 = treeSet.iterator();
                while (object2.hasNext()) {
                    debug.message("G11NSettings.fetchCharset()ccpp-accept-charset order = " + object2.next().toString());
                }
            }
        }
        object2 = locale.getLanguage();
        object = locale.getCountry();
        string = locale.getVariant();
        object3 = ((String)object2).toLowerCase();
        if (object != null && ((String)object).length() != 0) {
            object3 = (String)object3 + "_" + ((String)object).toLowerCase();
        }
        if (string != null && string.length() != 0) {
            object3 = (String)object3 + "_" + string.toLowerCase();
        }
        if ((string2 = this.locateCharset((String)object3, treeSet)) != null && string2.length() > 0) {
            return string2;
        }
        if (object != null && ((String)object).length() != 0 && (string2 = this.locateCharset((String)object2 + "_" + (String)object, treeSet)) != null) {
            if (debug.messageEnabled()) {
                debug.message("charset located for " + (String)object2 + "_" + (String)object);
            }
            return string2;
        }
        if (object2 != null && ((String)object2).length() != 0 && (string2 = this.locateCharset((String)object2, treeSet)) != null) {
            if (debug.messageEnabled()) {
                debug.message("charset located for " + (String)object2);
            }
            return string2;
        }
        if (debug.messageEnabled()) {
            debug.message("unable to locate charset for " + locale);
        }
        return "ISO-8859-1";
    }

    private String locateCharset(String string, Set set) {
        if (set == null) {
            return null;
        }
        String string2 = null;
        List list = this.getCharsetForLocale(string);
        if (list == null) {
            return null;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            QCharset qCharset = (QCharset)iterator.next();
            String string3 = qCharset.getName();
            if (string3.equals("*")) {
                string2 = (String)list.get(0);
                break;
            }
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                if (!string4.equalsIgnoreCase(string3)) continue;
                string2 = string3;
                break;
            }
            if (string2 != null) break;
        }
        return string2;
    }

    private String getCharsetLegacy(Client client, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer("charset_");
        int n = stringBuffer.length();
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (string2 == null || string2.length() == 0) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string).append('_').append(string2);
        }
        String string3 = client.getProperty(stringBuffer.toString());
        if (string3 != null) {
            return string3;
        }
        stringBuffer.setLength(n);
        stringBuffer.append(string);
        string3 = client.getProperty(stringBuffer.toString());
        if (string3 != null) {
            return string3;
        }
        stringBuffer.setLength(n - 1);
        string3 = client.getProperty(stringBuffer.toString());
        return string3;
    }

    static {
        debug = Debug.getInstance((String)"amClientDetection");
        currInstance = new G11NSettings();
    }
}

