/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdc;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.dpro.session.DNOrIPAddressListTokenRestriction;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.services.cdc.CDCServlet;
import com.iplanet.services.cdc.SPValidator;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LdapSPValidator
implements SPValidator {
    private AMOrganizationalUnit orgUnit;
    private Exception exception;
    private static final String LDAP_ATTR_NAME = "sunIdentityServerDeviceKeyValue";
    private static final String LDAP_STATUS_ATTR_NAME = "sunIdentityServerDeviceStatus";
    private static final String PROVIDER_ID_ATTR_NAME = "agentRootURL";
    private static final int PROVIDER_ID_ATTR_LEN = 13;
    private static final String HOSTNAME_ATTR_NAME = "hostname";
    private static final int HOSTNAME_ATTR_LEN = 9;

    public LdapSPValidator() {
        SSOToken sSOToken = null;
        String string = (String)AccessController.doPrivileged(new AdminDNAction());
        String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
        try {
            sSOToken = SSOTokenManager.getInstance().createSSOToken((Principal)new AuthPrincipal(string), string2);
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            this.orgUnit = aMStoreConnection.getOrganizationalUnit(AMStoreConnection.getNamingAttribute(3) + "=" + AdminInterfaceUtils.defaultAgentContainerName() + "," + aMStoreConnection.getOrganizationDN("/", null));
            if (!this.orgUnit.isExists()) {
                this.exception = new AMException(AMSDKBundle.getString("32"), "32");
            }
        }
        catch (SSOException sSOException) {
            this.exception = sSOException;
            CDCServlet.debug.error("CDC:LdapSPValidator unable to get SSO Token: ", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            this.exception = aMException;
            CDCServlet.debug.error("CDC::dapSPValidator unable to get Agent container: ", (Throwable)aMException);
        }
    }

    public TokenRestriction validateAndGetRestriction(FSAuthnRequest fSAuthnRequest, String string) throws Exception {
        if (this.exception != null) {
            throw this.exception;
        }
        URL uRL = new URL(fSAuthnRequest.getProviderId());
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(uRL.getProtocol()).append("://").append(uRL.getHost()).append(":").append(uRL.getPort()).append("/");
        Map map = this.searchAgents(stringBuffer);
        if (map.size() == 0) {
            if (CDCServlet.debug.warningEnabled()) {
                CDCServlet.debug.warning("CDC Component: Invalid agent ID: " + stringBuffer);
            }
            throw new Exception("Invalid Agent: Not configured in directory");
        }
        String string2 = null;
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        boolean bl2 = false;
        URL uRL2 = new URL(string);
        String string3 = uRL2.getHost().toLowerCase();
        String string4 = uRL2.getProtocol().toLowerCase();
        int n = uRL2.getPort();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            Map map2 = (Map)map.get(string2);
            bl = this.isAgentActive(map2);
            if (!bl || !this.validateGotoUrlAndUpdateHostList(map2, arrayList, bl2, string3, string4, n)) continue;
            bl2 = true;
        }
        if (!bl) {
            if (CDCServlet.debug.warningEnabled()) {
                CDCServlet.debug.warning("Invalid request for Agent ID: " + stringBuffer);
            }
            throw new Exception("Agent is not active");
        }
        if (!bl2) {
            if (CDCServlet.debug.warningEnabled()) {
                CDCServlet.debug.warning("Invalid GoTo URL: " + string + " for Agent ID: " + stringBuffer);
            }
            throw new Exception("Goto URL not valid for the agent Provider ID");
        }
        if (CDCServlet.debug.messageEnabled()) {
            CDCServlet.debug.message("CDC Servlet: Restriction string for: " + stringBuffer + " is: " + string2 + " " + arrayList);
        }
        return new DNOrIPAddressListTokenRestriction(string2, arrayList);
    }

    private Map searchAgents(StringBuffer stringBuffer) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("agentRootURL=" + stringBuffer.toString());
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        hashMap.put(LDAP_ATTR_NAME, hashSet);
        AMSearchControl aMSearchControl = new AMSearchControl();
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add(LDAP_ATTR_NAME);
        hashSet2.add(LDAP_STATUS_ATTR_NAME);
        aMSearchControl.setReturnAttributes(hashSet2);
        AMSearchResults aMSearchResults = this.orgUnit.searchEntities("*", hashMap, null, aMSearchControl);
        Map map = aMSearchResults.getResultAttributes();
        if (CDCServlet.debug.messageEnabled()) {
            CDCServlet.debug.message("CDC Servlet: Directory matches for " + stringBuffer + " is:" + map);
        }
        return map;
    }

    private boolean isAgentActive(Map map) {
        String string;
        Set set;
        boolean bl = false;
        if (map != null && (set = (Set)map.get(LDAP_STATUS_ATTR_NAME)) != null && !set.isEmpty() && (string = (String)set.iterator().next()).equalsIgnoreCase("Active")) {
            bl = true;
        }
        return bl;
    }

    private boolean validateGotoUrlAndUpdateHostList(Map map, ArrayList arrayList, boolean bl, String string, String string2, int n) throws MalformedURLException {
        Set set;
        boolean bl2 = false;
        if (map != null && (set = (Set)map.get(LDAP_ATTR_NAME)) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (string3.startsWith(PROVIDER_ID_ATTR_NAME)) {
                    URL uRL = new URL(string3.substring(13));
                    arrayList.add(uRL.getHost());
                    if (bl || !uRL.getHost().toLowerCase().equals(string) || !uRL.getProtocol().toLowerCase().equals(string2) || uRL.getPort() != n) continue;
                    bl2 = true;
                    continue;
                }
                if (!string3.startsWith(HOSTNAME_ATTR_NAME)) continue;
                arrayList.add(string3.substring(9));
            }
        }
        return bl2;
    }
}

