/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdc;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.cdc.LdapSPValidator;
import com.iplanet.services.cdc.SPValidator;
import com.iplanet.services.util.Base64;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContextStmt;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CDCServlet
extends HttpServlet {
    private static final ArrayList adviceParams = new ArrayList();
    static Debug debug;
    private static SSOTokenManager tokenManager;
    private static SessionService sessionService;
    private static SPValidator spValidator;
    private static String DNSAddress;
    private static String IPAddress;
    private static String authURLCookieName;
    private static String authURLCookieDomain;
    private static String deployDescriptor;
    private static boolean uniqueCookieEnabled;
    private String responseID;
    private static final char QUESTION_MARK = '?';
    private static final char AMPERSAND = '&';
    private static final char EQUAL_TO = '=';
    private static final String GOTO_PARAMETER = "goto";
    private static final String TARGET_PARAMETER = "TARGET";
    private static final String DEBUG_FILE_NAME = "amCDC";
    private static final String CDCURI = "/cdcservlet";
    private static final String AUTHURI = "/UI/Login";
    private static final String PROVIDER_ID = "ProviderID";
    private static final String REQUEST_ID = "RequestID";
    private static final String RELAY_STATE = "RelayState";
    private static final String SELF_PROVIDER_ID;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        debug = Debug.getInstance((String)DEBUG_FILE_NAME);
        debug.message("CDCServlet Initializing...");
        try {
            tokenManager = SSOTokenManager.getInstance();
        }
        catch (SSOException sSOException) {
            debug.error("Unable to get SSOTokenManager", (Throwable)sSOException);
        }
        sessionService = SessionService.getSessionService();
        spValidator = new LdapSPValidator();
        try {
            DNSAddress = SystemProperties.get((String)"com.iplanet.am.server.host");
            IPAddress = InetAddress.getByName(DNSAddress).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            debug.error("CDCServlet:init: Unknown Host Exception", (Throwable)unknownHostException);
        }
        authURLCookieName = SystemProperties.get((String)"com.sun.identity.authentication.uniqueCookieName", (String)"sunIdentityServerAuthNServer");
        authURLCookieDomain = SystemProperties.get((String)"com.sun.identity.authentication.uniqueCookieDomain", (String)"");
        deployDescriptor = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor", (String)"/amserver");
        uniqueCookieEnabled = Boolean.valueOf(SystemProperties.get((String)"com.sun.identity.enableUniqueSSOTokenCookie", (String)"false"));
        if (debug.messageEnabled()) {
            debug.message("CDCServlet init params. Restricted Token Enabled: " + uniqueCookieEnabled + " Auth URL Cookie Name: " + authURLCookieName + " Auth URL Cookie Domain: " + authURLCookieDomain + " Deployment Descriptor: " + deployDescriptor);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        SSOToken sSOToken;
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.doGetPost: Query String received: " + httpServletRequest.getQueryString());
        }
        if ((sSOToken = this.getSSOToken(httpServletRequest, httpServletResponse)) == null || this.checkForPolicyAdvice(httpServletRequest, httpServletResponse) != null) {
            this.redirectForAuthentication(httpServletRequest, httpServletResponse);
        } else {
            this.redirectWithAuthNResponse(httpServletRequest, httpServletResponse, sSOToken);
        }
    }

    private void redirectWithAuthNResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SSOToken sSOToken) throws ServletException, IOException {
        String string = httpServletRequest.getParameter(GOTO_PARAMETER);
        String string2 = httpServletRequest.getParameter(TARGET_PARAMETER);
        if (string == null || string.length() < 1) {
            if (string2 == null || string2.length() < 1) {
                debug.error("No GOTO or TARGET URL present in the Query !!");
                this.showError(httpServletResponse);
                return;
            }
            string = string2;
            if (debug.messageEnabled()) {
                debug.message("CDCServlet.doGetPost: targetURL = " + string2);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.doGetPost: gotoURL = " + string);
        }
        try {
            String string3 = httpServletRequest.getParameter(REQUEST_ID);
            String string4 = httpServletRequest.getParameter(PROVIDER_ID);
            String string5 = null;
            string5 = uniqueCookieEnabled ? sessionService.getRestrictedTokenId(sSOToken.getTokenID().toString(), spValidator.validateAndGetRestriction(FSAuthnRequest.parseURLEncodedRequest(httpServletRequest), string)) : sSOToken.getTokenID().toString();
            FSAssertion fSAssertion = this.createAssertion(string4, SELF_PROVIDER_ID, string5, sSOToken.getAuthType(), sSOToken.getProperty("authInstant"), sSOToken.getPrincipal().getName(), string3);
            String string6 = httpServletRequest.getParameter(RELAY_STATE);
            StatusCode statusCode = new StatusCode("samlp:Success");
            Status status = new Status(statusCode);
            FSAuthnResponse fSAuthnResponse = this.createAuthnResponse(SELF_PROVIDER_ID, this.responseID, string3, status, fSAssertion, string6);
            this.sendAuthnResponse(httpServletRequest, httpServletResponse, fSAuthnResponse, string);
        }
        catch (SAMLException sAMLException) {
            debug.error("CDCServlet.doGetPost:SAMLException occured", (Throwable)sAMLException);
            this.showError(httpServletResponse);
        }
        catch (FSMsgException fSMsgException) {
            debug.error("CDCServlet.doGetPost:FSMsgException occured", (Throwable)((Object)fSMsgException));
            this.showError(httpServletResponse);
        }
        catch (FSException fSException) {
            debug.error("CDCServlet.doGetPost:FSException occured", (Throwable)((Object)fSException));
            this.showError(httpServletResponse);
        }
        catch (SessionException sessionException) {
            debug.error("CDCServlet.doGetPost:SessionException occured", (Throwable)sessionException);
        }
        catch (SSOException sSOException) {
            debug.error("CDCServlet.doGetPost:SSOException occured", (Throwable)sSOException);
        }
        catch (Exception exception) {
            debug.error("CDCServlet.doGetPost:Exception occured", (Throwable)exception);
        }
    }

    private String getParameterString(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer(100);
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals(GOTO_PARAMETER) || adviceParams.contains(string)) continue;
            String[] stringArray = httpServletRequest.getParameterValues(string);
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                stringBuffer.append('&').append(string).append('=').append(URLEncoder.encode(stringArray[n]));
                ++n;
            }
        }
        return stringBuffer.deleteCharAt(0).toString();
    }

    private String checkForPolicyAdvice(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        StringBuffer stringBuffer = null;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!adviceParams.contains(string)) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append('&');
            }
            String[] stringArray = httpServletRequest.getParameterValues(string);
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                stringBuffer.append(string).append('=').append(stringArray[n]);
                ++n;
            }
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    private void redirectForAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        String string2 = null;
        Cookie cookie = CookieUtils.getCookieFromReq((HttpServletRequest)httpServletRequest, (String)authURLCookieName);
        if (cookie != null) {
            string2 = CookieUtils.getCookieValue((Cookie)cookie);
            if (debug.messageEnabled()) {
                debug.message("CDCServlet::redirectForAuthentiation got an authenticated URL: " + string2);
            }
        }
        if (string2 == null || string2.length() == 0 || !string2.toLowerCase().startsWith("http")) {
            string = httpServletRequest.getParameter(GOTO_PARAMETER);
            if (string == null || string.equals("")) {
                string = httpServletRequest.getParameter(TARGET_PARAMETER);
            }
            if (string == null || string.equals("")) {
                this.showError(httpServletResponse);
                return;
            }
            stringBuffer2.append(deployDescriptor).append(CDCURI).append('?').append(TARGET_PARAMETER).append('=').append(URLEncoder.encode(string)).append('&').append(this.getParameterString(httpServletRequest));
            stringBuffer.append(AUTHURI).append('?').append(GOTO_PARAMETER).append('=').append(URLEncoder.encode(stringBuffer2.toString()));
            String string3 = this.checkForPolicyAdvice(httpServletRequest, httpServletResponse);
            if (string3 != null) {
                stringBuffer.append('&').append(string3);
            }
        } else {
            stringBuffer.append(string2).append(deployDescriptor).append(CDCURI).append('?').append(httpServletRequest.getQueryString());
            if (cookie != null) {
                cookie.setValue("");
                httpServletResponse.addCookie(cookie);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Forwarding for authentication to: " + stringBuffer);
        }
        try {
            string = httpServletRequest.getRequestDispatcher(stringBuffer.toString());
            string.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception exception) {
            debug.error("CDCServlet.redirectForAuthentication : Failed in forwarding to Authentication service", (Throwable)exception);
            this.showError(httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void showError(HttpServletResponse httpServletResponse) {
        block8: {
            ServletOutputStream servletOutputStream = null;
            servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.println("ERROR: An application error has occured.");
            servletOutputStream.flush();
            Object var5_3 = null;
            try {
                servletOutputStream.close();
            }
            catch (IOException iOException) {}
            break block8;
            {
                catch (IOException iOException) {
                    debug.error("Could not show error message to the user " + iOException);
                    Object var5_4 = null;
                    try {
                        servletOutputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    servletOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private SSOToken getSSOToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        SSOToken sSOToken = null;
        try {
            sSOToken = tokenManager.createSSOToken(httpServletRequest);
            if (sSOToken == null || !tokenManager.isValidToken(sSOToken)) {
                if (debug.messageEnabled()) {
                    debug.message("SSOToken is either null or not valid: " + sSOToken + "\nRedirecting for authentication");
                }
                sSOToken = null;
            }
        }
        catch (SSOException sSOException) {
            if (debug.messageEnabled()) {
                debug.message("SSOException caught: " + (Object)((Object)sSOException));
            }
            sSOToken = null;
        }
        return sSOToken;
    }

    private FSAuthnResponse createAuthnResponse(String string, String string2, String string3, Status status, FSAssertion fSAssertion, String string4) throws SAMLException, FSMsgException {
        ArrayList<FSAssertion> arrayList = new ArrayList<FSAssertion>();
        arrayList.add(fSAssertion);
        FSAuthnResponse fSAuthnResponse = new FSAuthnResponse(null, string3, status, arrayList, string4);
        fSAuthnResponse.setProviderId(string);
        return fSAuthnResponse;
    }

    private FSAssertion createAssertion(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws FSException, SAMLException {
        Object object;
        Object object2;
        Object object3;
        debug.message("CDCServlet: createAssertion(...): Called");
        if (string == null || string2 == null || string3 == null || string4 == null || string6 == null || string7 == null) {
            if (debug.messageEnabled()) {
                debug.message("CDCServlet::createAssertion: null input for method createAssertion.");
            }
            throw new FSException(FSUtils.bundle.getString("nullInput"));
        }
        String string8 = null;
        String string9 = null;
        String string10 = null;
        Date date = null;
        String string11 = string2;
        NameIdentifier nameIdentifier = null;
        NameIdentifier nameIdentifier2 = null;
        try {
            object3 = URLEncoder.encode(string3);
            object2 = string2;
            nameIdentifier2 = nameIdentifier = new NameIdentifier((String)object3, (String)object2);
            string8 = string4;
            if (string5 != null) {
                try {
                    date = FSUtils.stringToDate(string5);
                }
                catch (Exception exception) {
                    if (debug.messageEnabled()) {
                        debug.message("CDCServlet: unable to convert authInst: " + string5);
                    }
                    date = new Date();
                }
            } else {
                date = new Date();
            }
        }
        catch (Exception exception) {
            debug.error("CDCServlet:createAssertion(...): exception preparing assertion info: ", (Throwable)exception);
            throw new FSException("Alliance manager could not find local descriptor");
        }
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion(id):  Creating Authentication Assertion for user with opaqueHandle =" + nameIdentifier2.getName() + " and SecurityDomain = " + string11);
        }
        object3 = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        object2 = new IDPProvidedNameIdentifier(nameIdentifier.getNameQualifier(), nameIdentifier.getName());
        FSSubject fSSubject = new FSSubject(nameIdentifier2, (SubjectConfirmation)object3, (IDPProvidedNameIdentifier)object2);
        SubjectLocality subjectLocality = null;
        subjectLocality = new SubjectLocality(IPAddress, DNSAddress);
        AuthnContextStmt authnContextStmt = new AuthnContextStmt(string10, string9);
        FSAuthenticationStatement fSAuthenticationStatement = new FSAuthenticationStatement(string8, date, fSSubject, subjectLocality, null, authnContextStmt);
        Date date2 = new Date();
        Integer n = new Integer(60);
        long l = n * 1000;
        if (l < 60000L) {
            l = 60000L;
        }
        Date date3 = new Date(date2.getTime() + l);
        fSAuthenticationStatement.setReauthenticateOnOrAfter(date3);
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion(...):Authentication Statement: " + fSAuthenticationStatement.toXMLString());
        }
        Conditions conditions = new Conditions(date2, date3);
        if (string != null && !string.equals("")) {
            object = new ArrayList();
            object.add(string);
            conditions.addAudienceRestrictionCondition(new AudienceRestrictionCondition((List)object));
        }
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion(...): Condition: " + conditions.toString());
        }
        object = new AssertionIDReference();
        HashSet<FSAuthenticationStatement> hashSet = new HashSet<FSAuthenticationStatement>();
        hashSet.add(fSAuthenticationStatement);
        FSAssertion fSAssertion = new FSAssertion(((AssertionIDReference)object).getAssertionIDReference(), string2, date2, conditions, hashSet, string7);
        fSAssertion.setID(((AssertionIDReference)object).getAssertionIDReference());
        FSUtils.access("FSAssertionManager", FSUtils.bundle.getString("assertionCreated") + ":" + fSAssertion.toString());
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion(id): Returning Assertion: " + fSAssertion.toXMLString());
        }
        return fSAssertion;
    }

    private void sendAuthnResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnResponse fSAuthnResponse, String string) {
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.sendAuthnResponse: Called");
        }
        try {
            Appendable appendable;
            String string2 = fSAuthnResponse.toXMLString(true, true);
            if (debug.messageEnabled()) {
                debug.message("CDCServlet::sendAuthnResponse: AuthnResponse: " + string2);
            }
            String string3 = Base64.encode((byte[])string2.getBytes());
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setHeader("Pragma", "no-cache");
            Cookie cookie = null;
            Cookie[] cookieArray = httpServletRequest.getCookies();
            int n = 0;
            if (cookieArray == null || n >= cookieArray.length || !(cookie = cookieArray[n]).getName().equals(authURLCookieName)) {
                // empty if block
            }
            if (cookie != null && !cookie.getValue().toLowerCase().startsWith("http")) {
                appendable = new StringBuffer(50);
                ((StringBuffer)appendable).append(httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort());
                if (cookie == null) {
                    cookie = new Cookie(authURLCookieName, ((StringBuffer)appendable).toString());
                    cookie.setDomain(authURLCookieDomain);
                } else {
                    cookie.setValue(((StringBuffer)appendable).toString());
                }
                httpServletResponse.addCookie(cookie);
            }
            appendable = httpServletResponse.getWriter();
            ((PrintWriter)appendable).println("<HTML>");
            ((PrintWriter)appendable).println("<BODY Onload=\"document.Response.submit()\">");
            ((PrintWriter)appendable).println("<FORM NAME=\"Response\" METHOD=\"POST\" ACTION=\"" + string + "\">");
            ((PrintWriter)appendable).println("<INPUT TYPE=\"HIDDEN\" NAME=\"LARES\" VALUE=\"" + string3 + "\"/>");
            ((PrintWriter)appendable).println("</FORM>");
            ((PrintWriter)appendable).println("</BODY></HTML>");
            ((PrintWriter)appendable).close();
            if (debug.messageEnabled()) {
                debug.message("CDCServlet:sendAuthnResponse: AuthnResponse sent successfully to: " + string);
            }
            return;
        }
        catch (FSMsgException fSMsgException) {
            debug.error("CDCServlet:sendAuthnResponse:" + fSMsgException.getMessage());
        }
        catch (IOException iOException) {
            debug.error("CDCServlet:sendAuthnResponse:" + iOException.getMessage());
        }
    }

    static {
        adviceParams.add("module");
        adviceParams.add("authlevel");
        adviceParams.add("role");
        adviceParams.add("service");
        adviceParams.add("user");
        adviceParams.add("org");
        DNSAddress = "localhost";
        IPAddress = "127.0.0.1";
        SELF_PROVIDER_ID = FSServiceUtils.getBaseURL() + CDCURI;
    }
}

