/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerValue;
import com.iplanet.security.x509.GeneralNamesException;
import com.iplanet.security.x509.RDN;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.x509.GeneralNames;

public class CRLDistributionPoint
implements ASN1Value {
    private GeneralNames fullName;
    private RDN relativeName;
    private ANY fullNameEncoding;
    private BitArray reasons;
    private GeneralNames CRLIssuer;
    private ANY CRLIssuerEncoding;
    private static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    public GeneralNames getFullName() {
        return this.fullName;
    }

    public RDN getRelativeName() {
        return this.relativeName;
    }

    public void setFullName(GeneralNames generalNames) throws GeneralNamesException, IOException {
        this.fullName = generalNames;
        if (generalNames != null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            generalNames.encode(derOutputStream);
            try {
                ANY aNY = new ANY(derOutputStream.toByteArray());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                aNY.encodeWithAlternateTag(Tag.get((long)0L), (OutputStream)byteArrayOutputStream);
                this.fullNameEncoding = new ANY(byteArrayOutputStream.toByteArray());
            }
            catch (InvalidBERException invalidBERException) {
                throw new GeneralNamesException(invalidBERException.toString());
            }
            this.relativeName = null;
        }
    }

    public void setRelativeName(RDN rDN) {
        this.relativeName = rDN;
        if (rDN != null) {
            this.fullName = null;
        }
    }

    public BitArray getReasons() {
        return this.reasons;
    }

    public void setReasons(BitArray bitArray) {
        this.reasons = bitArray;
    }

    public GeneralNames getCRLIssuer() {
        return this.CRLIssuer;
    }

    public void setCRLIssuer(GeneralNames generalNames) throws GeneralNamesException, IOException {
        this.CRLIssuer = generalNames;
        if (generalNames != null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            generalNames.encode(derOutputStream);
            try {
                ANY aNY = new ANY(derOutputStream.toByteArray());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                aNY.encodeWithAlternateTag(Tag.get((long)2L), (OutputStream)byteArrayOutputStream);
                this.CRLIssuerEncoding = new ANY(byteArrayOutputStream.toByteArray());
            }
            catch (InvalidBERException invalidBERException) {
                throw new GeneralNamesException(invalidBERException.toString());
            }
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            ANY aNY;
            ByteArrayOutputStream byteArrayOutputStream;
            com.iplanet.security.util.DerOutputStream derOutputStream;
            EXPLICIT eXPLICIT;
            if (this.fullName != null) {
                eXPLICIT = new EXPLICIT(Tag.get((long)0L), (ASN1Value)this.fullNameEncoding);
                sEQUENCE.addElement((ASN1Value)eXPLICIT);
            } else if (this.relativeName != null) {
                derOutputStream = new com.iplanet.security.util.DerOutputStream();
                this.relativeName.encode(derOutputStream);
                eXPLICIT = new ANY(derOutputStream.toByteArray());
                byteArrayOutputStream = new ByteArrayOutputStream();
                eXPLICIT.encodeWithAlternateTag(Tag.get((long)1L), (OutputStream)byteArrayOutputStream);
                aNY = new ANY(byteArrayOutputStream.toByteArray());
                EXPLICIT eXPLICIT2 = new EXPLICIT(Tag.get((long)0L), (ASN1Value)aNY);
                sEQUENCE.addElement((ASN1Value)eXPLICIT2);
            }
            if (this.reasons != null) {
                derOutputStream = new com.iplanet.security.util.DerOutputStream();
                derOutputStream.putUnalignedBitString(this.reasons);
                eXPLICIT = new ANY(derOutputStream.toByteArray());
                byteArrayOutputStream = new ByteArrayOutputStream();
                eXPLICIT.encodeWithAlternateTag(Tag.get((long)1L), (OutputStream)byteArrayOutputStream);
                aNY = new ANY(byteArrayOutputStream.toByteArray());
                sEQUENCE.addElement(Tag.get((long)1L), (ASN1Value)aNY);
            }
            if (this.CRLIssuer != null) {
                sEQUENCE.addElement(Tag.get((long)2L), (ASN1Value)this.CRLIssuerEncoding);
            }
            sEQUENCE.encode(tag, outputStream);
        }
        catch (InvalidBERException invalidBERException) {
            throw new IOException(invalidBERException.toString());
        }
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    private static void toFile(String string, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            Object object;
            EXPLICIT eXPLICIT;
            CRLDistributionPoint cRLDistributionPoint = new CRLDistributionPoint();
            SEQUENCE.Template template = SEQUENCE.getTemplate();
            template.addOptionalElement((ASN1Template)new EXPLICIT.Template(Tag.get((long)0L), (ASN1Template)ANY.getTemplate()));
            template.addOptionalElement(Tag.get((long)1L), (ASN1Template)BIT_STRING.getTemplate());
            template.addOptionalElement((ASN1Template)ANY.getTemplate());
            SEQUENCE sEQUENCE = (SEQUENCE)template.decode(tag, inputStream);
            if (sEQUENCE.elementAt(0) != null) {
                eXPLICIT = (EXPLICIT)sEQUENCE.elementAt(0);
                object = (ANY)eXPLICIT.getContent();
                if (object.getTag().equals((Object)Tag.get((long)0L))) {
                    try {
                        sun.security.util.DerValue derValue = new sun.security.util.DerValue(object.getEncoded());
                        derValue.resetTag((byte)48);
                        cRLDistributionPoint.setFullName(new GeneralNames(derValue));
                    }
                    catch (GeneralNamesException generalNamesException) {
                        throw new InvalidBERException("fullName: " + generalNamesException.toString());
                    }
                    catch (IOException iOException) {
                        throw new InvalidBERException("fullName: " + iOException.toString());
                    }
                } else if (object.getTag().equals((Object)Tag.get((long)1L))) {
                    try {
                        DerValue derValue = new DerValue(object.getEncoded());
                        derValue.resetTag((byte)49);
                        cRLDistributionPoint.setRelativeName(new RDN(derValue));
                    }
                    catch (IOException iOException) {
                        throw new InvalidBERException("relativeName " + iOException.toString());
                    }
                } else {
                    throw new InvalidBERException("Unknown tag " + object.getTag() + " in distributionPoint");
                }
            }
            if (sEQUENCE.elementAt(1) != null) {
                eXPLICIT = (BIT_STRING)sEQUENCE.elementAt(1);
                object = eXPLICIT.getBits();
                cRLDistributionPoint.setReasons(new BitArray(((ANY)object).length * 8 - eXPLICIT.getPadCount(), (byte[])object));
            }
            if (sEQUENCE.elementAt(2) != null) {
                eXPLICIT = (ANY)sEQUENCE.elementAt(2);
                if (!eXPLICIT.getTag().equals((Object)Tag.get((long)2L))) {
                    throw new InvalidBERException("Invalid tag " + eXPLICIT.getTag());
                }
                try {
                    object = new sun.security.util.DerValue(eXPLICIT.getEncoded());
                    ((sun.security.util.DerValue)object).resetTag((byte)48);
                    cRLDistributionPoint.setCRLIssuer(new GeneralNames((sun.security.util.DerValue)object));
                }
                catch (GeneralNamesException generalNamesException) {
                    throw new InvalidBERException("cRLIssuer " + generalNamesException.toString());
                }
                catch (IOException iOException) {
                    throw new InvalidBERException("cRLIssuer " + iOException.toString());
                }
            }
            return cRLDistributionPoint;
        }
    }
}

