/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCacheManager;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Stats;
import com.iplanet.am.util.StatsListener;

class CacheStats
implements StatsListener {
    int intervalCount = 0;
    long totalGetRequests = 0L;
    long totalCacheHits = 0L;
    long totalIntervalHits = 0L;
    static Stats stats = null;
    static CacheStats instance = null;
    static final String CACHE_STATS_FILE_NAME = "amSDKStats";
    static Debug debug = AMCommonUtils.debug;

    protected static CacheStats getInstance() {
        return instance;
    }

    protected CacheStats() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHitCount() {
        if (stats.isEnabled()) {
            CacheStats cacheStats = this;
            synchronized (cacheStats) {
                ++this.totalCacheHits;
                ++this.totalIntervalHits;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementRequestCount() {
        if (stats.isEnabled()) {
            CacheStats cacheStats = this;
            synchronized (cacheStats) {
                ++this.totalGetRequests;
                ++this.intervalCount;
            }
        }
    }

    protected synchronized int getIntervalCount() {
        return this.intervalCount;
    }

    public synchronized void printStats() {
        AMCacheManager aMCacheManager = (AMCacheManager)AMDirectoryWrapper.getInstance();
        stats.record("SDK Cache Statistics\n--------------------\nNumber of requests during this interval: " + this.intervalCount + "\nNumber of Cache Hits during this interval: " + this.totalIntervalHits + "\nHit ratio for this interval: " + (double)this.totalIntervalHits / (double)this.intervalCount + "\nTotal number of requests since server start: " + this.totalGetRequests + "\nTotal number of Cache Hits since server start: " + this.totalCacheHits + "\nOverall Hit ratio: " + (double)this.totalCacheHits / (double)this.totalGetRequests + "\nTotal Cache Size: " + aMCacheManager.getCachesize() + "\n");
        this.intervalCount = 0;
        this.totalIntervalHits = 0L;
    }

    static {
        stats = Stats.getInstance((String)CACHE_STATS_FILE_NAME);
        instance = new CacheStats();
        if (stats.isEnabled()) {
            stats.addStatsListener((StatsListener)instance);
            if (debug.messageEnabled()) {
                debug.message("CacheStats.static{} Stats : " + stats.isEnabled() + " SDK cache stats listener added.");
            }
        }
    }
}

