/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.util.Debug;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class CacheBlock {
    private AMHashMap cacheEntries;
    private String entryDN;
    private int objectType = -9999;
    private AMHashMap stringAttributes;
    private AMHashMap byteAttributes;
    private String organizationDN = null;
    private boolean isValidEntry = true;
    private Debug debug = AMCommonUtils.debug;

    protected CacheBlock(String string, boolean bl) {
        if (bl) {
            this.cacheEntries = new AMHashMap();
            this.stringAttributes = new AMHashMap(false);
            this.byteAttributes = new AMHashMap(true);
        } else {
            this.isValidEntry = false;
        }
        this.entryDN = string;
    }

    protected CacheBlock(String string, String string2, boolean bl) {
        this(string, bl);
        this.organizationDN = string2;
    }

    protected synchronized void setExists(boolean bl) {
        if (bl) {
            this.cacheEntries = new AMHashMap();
            this.stringAttributes = new AMHashMap(false);
            this.byteAttributes = new AMHashMap(true);
        }
        this.isValidEntry = bl;
    }

    protected synchronized void setObjectType(int n) {
        this.objectType = n;
    }

    protected synchronized void setOrganizationDN(String string) {
        this.organizationDN = string;
    }

    protected String getOrganizationDN() {
        return this.organizationDN;
    }

    protected int getObjectType() {
        return this.objectType;
    }

    protected String getEntryDN() {
        return this.entryDN;
    }

    protected synchronized boolean isExists() {
        return this.isValidEntry;
    }

    protected synchronized boolean hasCompleteSet(String string) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        boolean bl = false;
        if (cacheEntry != null) {
            bl = cacheEntry.isCompleteSet();
        }
        return bl;
    }

    protected synchronized Map getAttributes(String string, boolean bl) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        Map map = new AMHashMap(bl);
        if (cacheEntry != null) {
            Set set = cacheEntry.getAttributeNames();
            map = !bl ? this.stringAttributes.getCopy(set) : this.byteAttributes.getCopy(set);
        }
        return map;
    }

    protected synchronized Map getAttributes(String string, Set set, boolean bl) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        Map map = new AMHashMap(bl);
        if (cacheEntry != null) {
            Set set2 = cacheEntry.getAttributeNames(set);
            map = !bl ? this.stringAttributes.getCopy(set2) : this.byteAttributes.getCopy(set2);
        }
        return map;
    }

    protected synchronized void putAttributes(String string, Map map, boolean bl, boolean bl2) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            this.cacheEntries.put(string, cacheEntry);
        }
        cacheEntry.putAttributes(map.keySet(), bl);
        if (!bl2) {
            this.stringAttributes.copy(map);
        } else {
            this.byteAttributes.copy(map);
        }
    }

    protected synchronized void removeAttributes(String string) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.remove(string);
        if (cacheEntry != null) {
            cacheEntry.clear();
        }
    }

    protected synchronized void removeAttributes(Set set) {
        if (set != null && !set.isEmpty()) {
            this.stringAttributes.removeKeys(set);
            this.byteAttributes.removeKeys(set);
            Iterator iterator = this.cacheEntries.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.removeAttributes(string, set);
            }
        }
    }

    private synchronized void removeAttributes(String string, Set set) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
        if (cacheEntry != null) {
            cacheEntry.removeAttributeNames(set);
        }
    }

    protected synchronized void replaceAttributes(Map map, Map map2) {
        this.stringAttributes.copy(map);
        this.byteAttributes.copy(map2);
    }

    protected synchronized void clear() {
        if (this.isValidEntry) {
            this.stringAttributes.clear();
            this.byteAttributes.clear();
            this.cacheEntries.clear();
        }
        this.objectType = -9999;
        this.organizationDN = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n----------- START CACHE BLOCK -----------");
        stringBuffer.append("\nEntry DN: ").append(this.entryDN);
        stringBuffer.append(" Valid Entry: ").append(this.isValidEntry);
        stringBuffer.append("\nOrganization: ").append(this.organizationDN);
        stringBuffer.append("\nString Attributes: ");
        stringBuffer.append(AMCommonUtils.mapSetToString(this.stringAttributes));
        stringBuffer.append("\nByte Attributes: ");
        stringBuffer.append(AMCommonUtils.mapSetToString(this.byteAttributes));
        stringBuffer.append("\nByte Negative Attributes: ");
        stringBuffer.append(this.byteAttributes.getNegativeByteAttrClone().toString());
        stringBuffer.append("\nCache Entries: ");
        if (this.cacheEntries != null && !this.cacheEntries.isEmpty()) {
            Iterator iterator = this.cacheEntries.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CacheEntry cacheEntry = (CacheEntry)this.cacheEntries.get(string);
                stringBuffer.append("\nPrincipal: ").append(string);
                stringBuffer.append(cacheEntry.toString());
            }
        } else {
            stringBuffer.append("<empty>");
        }
        stringBuffer.append("\n----------- END CACHE BLOCK -----------");
        return stringBuffer.toString();
    }

    class CacheEntry {
        private boolean completeSet = false;
        private Set attributeNames = new HashSet();

        CacheEntry() {
        }

        protected Set getAttributeNames() {
            return this.attributeNames;
        }

        protected Set getAttributeNames(Set set) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = ((String)iterator.next()).toLowerCase();
                if (!this.attributeNames.contains(string)) continue;
                hashSet.add(string);
            }
            return hashSet;
        }

        protected void putAttributes(Set set, boolean bl) {
            this.completeSet = bl;
            this.attributeNames.addAll(set);
        }

        protected void removeAttributeNames(Set set) {
            this.completeSet = false;
            this.attributeNames.removeAll(set);
        }

        protected boolean isCompleteSet() {
            return this.completeSet;
        }

        protected void clear() {
            this.completeSet = false;
            this.attributeNames.clear();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" Complete Set: ").append(this.completeSet);
            stringBuffer.append(" Attributes: ").append(this.attributeNames);
            return stringBuffer.toString();
        }
    }
}

