/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.ums.Guid;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import java.util.HashMap;
import java.util.Map;
import netscape.ldap.util.DN;

class AMSearchFilterManager {
    private static final String USER_SEARCH_TEMPLATE = "BasicUserSearch";
    private static final String ROLE_SEARCH_TEMPLATE = "BasicManagedRoleSearch";
    private static final String FILTERED_ROLE_SEARCH_TEMPLATE = "BasicFilteredRoleSearch";
    private static final String GROUP_SEARCH_TEMPLATE = "BasicGroupSearch";
    private static final String DYNAMIC_GROUP_SEARCH_TEMPLATE = "BasicDynamicGroupSearch";
    private static final String ORGANIZATION_SEARCH_TEMPLATE = "BasicOrganizationSearch";
    private static final String PEOPLE_CONTAINER_SEARCH_TEMPLATE = "BasicPeopleContainerSearch";
    private static final String ORGANIZATIONAL_UNIT_SEARCH_TEMPLATE = "BasicOrganizationalUnitSearch";
    private static final String ASSIGNABLE_DYNAMIC_GROUP_SEARCH_TEMPLATE = "BasicAssignableDynamicGroupSearch";
    private static final String GROUP_CONTAINER_SEARCH_TEMPLATE = "BasicGroupContainerSearch";
    private static final String RESOURCE_SEARCH_TEMPLATE = "BasicResourceSearch";
    private static final String DEFAULT_USER_SEARCH_FILTER = "(objectclass=inetorgperson)";
    private static final String DEFAULT_ROLE_SEARCH_FILTER = "(objectclass=nsmanagedroledefinition)";
    private static final String DEFAULT_FILTERED_ROLE_SEARCH_FILTER = "(&(objectclass=nsfilteredroledefinition)(!(cn=ContainerDefaultTemplateRole)))";
    private static final String DEFAULT_GROUP_SEARCH_FILTER = "(objectclass=groupofuniquenames)";
    private static final String DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_SEARCH_FILTER = "(objectclass=iplanet-am-managed-assignable-group)";
    private static final String DEFAULT_DYNAMIC_GROUP_SEARCH_FILTER = "(objectclass=groupofurls)";
    private static final String DEFAULT_ORGANIZATION_SEARCH_FILTER = "(objectclass=organization)";
    private static final String DEFAULT_PEOPLE_CONTAINER_SEARCH_FILTER = "(objectclass=nsManagedPeopleContainer)";
    private static final String DEFAULT_ORGANIZATIONAL_UNIT_SEARCH_FILTER = "(objectclass=organizationalunit)";
    private static final String DEFAULT_GROUP_CONTAINER_SEARCH_FILTER = "(objectclass=iplanet-am-managed-group-container)";
    private static Debug debug = AMCommonUtils.debug;
    protected static Map searchtemplateMap = new HashMap();

    AMSearchFilterManager() {
    }

    private static String getSearchFilterFromTemplate(int n, String string, String string2) throws UMSException {
        Guid guid;
        String string3;
        String string4 = string3 = string2 == null ? AMSearchFilterManager.getSearchTemplateName(n) : string2;
        if (string3 == null) {
            debug.warning("AMSearchFilterManager.getSearchFilterFromTemplate(): Search template name is nullUnable to retrieve search filter. Returning <empty> value.");
            return "";
        }
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        SearchTemplate searchTemplate = templateManager.getSearchTemplate(string3, guid = string == null ? null : new Guid(string), 1);
        String string5 = searchTemplate.getSearchFilter();
        if (!string5.startsWith("(") || !string5.endsWith(")")) {
            string5 = "(" + string5 + ")";
        }
        string5 = AMSearchFilterManager.modifyFilter(string5, n);
        if (debug.messageEnabled()) {
            debug.message("AMSearchFilterManager.getSearchFilterFromTemplate() SearchTemplate Name = " + searchTemplate.getName() + ", objectType = " + n + ", orgDN = " + string + ", Obtained Filter = " + searchTemplate.getSearchFilter() + ", Modified Filter = " + string5);
        }
        return string5;
    }

    private static String modifyFilter(String string, int n) {
        switch (n) {
            case 6: 
            case 8: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("(&").append(string);
                stringBuffer.append("(objectClass=ldapsubentry)").append("(!(cn=");
                stringBuffer.append("ContainerDefaultTemplateRole");
                stringBuffer.append(")))");
                return stringBuffer.toString();
            }
        }
        return string;
    }

    protected static String getSearchFilter(int n, String string, String string2, boolean bl) {
        String string3;
        String string4 = new DN(string).toRFCString();
        String string5 = AMStoreConnection.rootSuffix;
        if (string != null && string4.equals(string5)) {
            string = null;
        }
        try {
            string3 = AMSearchFilterManager.getSearchFilterFromTemplate(n, string, string2);
        }
        catch (UMSException uMSException) {
            string3 = AMSearchFilterManager.getDefaultSearchFilter(n);
            debug.warning("AMSearchFilter.getSearchFilter() - Unable to get Search Filter for: " + n + ", orgDN = " + string + ", Search Template Name = " + string2 + ". Using " + "default filter = " + string3);
        }
        string3 = AMSearchFilterManager.addAdminGroupFilters(string3, string, n);
        string3 = AMSearchFilterManager.addComplianceModeFilters(string3, n, bl);
        return string3;
    }

    private static String addAdminGroupFilters(String string, String string2, int n) {
        block7: {
            try {
                if (!AMCompliance.isAdminGroupsEnabled(string2)) {
                    String string3 = string;
                    switch (n) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("(&").append(string).append("(!(");
                            stringBuffer.append(AMNamingAttrManager.getNamingAttr(12));
                            stringBuffer.append("=serviceadministrators))").append("(!(");
                            stringBuffer.append(AMNamingAttrManager.getNamingAttr(12));
                            stringBuffer.append("=servicehelpdeskadministrators)))");
                            string3 = stringBuffer.toString();
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMSearchFilterManager.addAdminGroupFilters() - objectType = " + n + ", orgDN = " + string2 + ", Original filter: " + string + ", Modified filter = " + string3);
                    }
                    return string3;
                }
            }
            catch (AMException aMException) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("AMSearchFilterManager.addAdminGroupFilters() Unable to determine if \"Admin Groups\" option is enabled or disabled. Exception : ", (Throwable)aMException);
            }
        }
        return string;
    }

    private static String addComplianceModeFilters(String string, int n, boolean bl) {
        block9: {
            try {
                String string2 = string;
                if (!bl && AMCompliance.isComplianceUserDeletionEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    switch (n) {
                        case 1: {
                            stringBuffer.append("(&").append(string);
                            stringBuffer.append("(!(inetuserstatus=deleted)))");
                            string2 = stringBuffer.toString();
                            break;
                        }
                        case 2: {
                            stringBuffer.append("(&").append(string);
                            stringBuffer.append("(!(inetdomainstatus=deleted)))");
                            string2 = stringBuffer.toString();
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            stringBuffer.append("(&").append(string);
                            stringBuffer.append("(!(inetgroupstatus=deleted)))");
                            string2 = stringBuffer.toString();
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMSearchFilterManager.addComplainceModeFilters() - objectType = " + n + ", Original Filter = " + string + ", Modified Filter = " + string2);
                    }
                    return string2;
                }
            }
            catch (AMException aMException) {
                if (!debug.warningEnabled()) break block9;
                debug.warning("AMSearchFilterManager.addComplianceModeFilters() Unable to determine if \"User Compliance deletion mode\" is enabled or disabled. Exception : ", (Throwable)aMException);
            }
        }
        return string;
    }

    protected static String getSearchFilter(int n, String string) {
        return AMSearchFilterManager.getSearchFilter(n, string, null, true);
    }

    protected static String getGlobalSearchFilter(int n) {
        return AMSearchFilterManager.getGlobalSearchFilter(n, null);
    }

    protected static String getGlobalSearchFilter(int n, String string) {
        return AMSearchFilterManager.getSearchFilter(n, null, string, true);
    }

    private static String getSearchTemplateName(int n) {
        String string = (String)searchtemplateMap.get(Integer.toString(n));
        if (string != null) {
            return string;
        }
        switch (n) {
            case 1: {
                return USER_SEARCH_TEMPLATE;
            }
            case 6: {
                return ROLE_SEARCH_TEMPLATE;
            }
            case 8: {
                return FILTERED_ROLE_SEARCH_TEMPLATE;
            }
            case 9: {
                return GROUP_SEARCH_TEMPLATE;
            }
            case 11: {
                return DYNAMIC_GROUP_SEARCH_TEMPLATE;
            }
            case 2: {
                return ORGANIZATION_SEARCH_TEMPLATE;
            }
            case 5: {
                return PEOPLE_CONTAINER_SEARCH_TEMPLATE;
            }
            case 3: {
                return ORGANIZATIONAL_UNIT_SEARCH_TEMPLATE;
            }
            case 12: {
                return ASSIGNABLE_DYNAMIC_GROUP_SEARCH_TEMPLATE;
            }
            case 4: {
                return GROUP_CONTAINER_SEARCH_TEMPLATE;
            }
            case 21: {
                return RESOURCE_SEARCH_TEMPLATE;
            }
        }
        debug.warning("AMSearchFilterManager.getSearchTemplateName(): Unknown object type is passed. Returning null value");
        return null;
    }

    private static String getDefaultSearchFilter(int n) {
        switch (n) {
            case 1: {
                return DEFAULT_USER_SEARCH_FILTER;
            }
            case 6: {
                return DEFAULT_ROLE_SEARCH_FILTER;
            }
            case 8: {
                return DEFAULT_FILTERED_ROLE_SEARCH_FILTER;
            }
            case 9: {
                return DEFAULT_GROUP_SEARCH_FILTER;
            }
            case 12: {
                return DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_SEARCH_FILTER;
            }
            case 11: {
                return DEFAULT_DYNAMIC_GROUP_SEARCH_FILTER;
            }
            case 2: {
                return DEFAULT_ORGANIZATION_SEARCH_FILTER;
            }
            case 5: {
                return DEFAULT_PEOPLE_CONTAINER_SEARCH_FILTER;
            }
            case 3: {
                return DEFAULT_ORGANIZATIONAL_UNIT_SEARCH_FILTER;
            }
            case 4: {
                return DEFAULT_GROUP_CONTAINER_SEARCH_FILTER;
            }
        }
        debug.warning("AMSearchFilterManager.getDefaultSearchFilter(): Unknown object type is passed. Returning <empty> value");
        return "";
    }
}

