/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMAttributeSchema;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSDKUtil;
import com.iplanet.am.sdk.AMServiceListener;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AMSchema {
    private ServiceSchema serviceSchema;
    private static HashMap serviceListeners = new HashMap();

    protected AMSchema(ServiceSchema serviceSchema) {
        this.serviceSchema = serviceSchema;
    }

    public String getServiceName() {
        return this.serviceSchema.getServiceName();
    }

    public Type getSchemaType() {
        SchemaType schemaType = this.serviceSchema.getServiceType();
        return new Type(schemaType);
    }

    public String getI18NKey() {
        return this.serviceSchema.getI18NKey();
    }

    public String getStatusAttribute() {
        return this.serviceSchema.getStatusAttribute();
    }

    public String[] getStatusAttributeChoiceValues() {
        String string = this.getStatusAttribute();
        if (string != null) {
            AMAttributeSchema aMAttributeSchema = this.getAttributeSchema(string);
            if (aMAttributeSchema != null) {
                return aMAttributeSchema.getChoiceValues();
            }
            return null;
        }
        return null;
    }

    public Set getAttributeNames() {
        return this.serviceSchema.getAttributeSchemaNames();
    }

    public AMAttributeSchema getAttributeSchema(String string) {
        AttributeSchema attributeSchema = this.serviceSchema.getAttributeSchema(string);
        if (attributeSchema == null) {
            AMSDKUtil.debug.message("AMSchema.getAttributeSchema(): No schema found for: " + string);
            return null;
        }
        return new AMAttributeSchema(attributeSchema);
    }

    public Set getAttributeSchemas() {
        Set set = this.serviceSchema.getAttributeSchemas();
        HashSet<AMAttributeSchema> hashSet = new HashSet<AMAttributeSchema>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            hashSet.add(new AMAttributeSchema(attributeSchema));
        }
        return hashSet;
    }

    public Map getAttributeDefaults() {
        return this.serviceSchema.getAttributeDefaults();
    }

    public Map getReadOnlyAttributeDefaults() {
        return this.serviceSchema.getReadOnlyAttributeDefaults();
    }

    public Set getSubSchemaNames() {
        return this.serviceSchema.getSubSchemaNames();
    }

    public AMSchema getSubSchema(String string) throws AMException {
        try {
            ServiceSchema serviceSchema = this.serviceSchema.getSubSchema(string);
            if (serviceSchema == null) {
                return null;
            }
            return new AMSchema(serviceSchema);
        }
        catch (SMSException sMSException) {
            AMSDKUtil.debug.message("AMSchema.getSubSchema(): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("901"), "901");
        }
    }

    public void setAttributeDefaults(Map map) throws AMException {
        try {
            this.serviceSchema.setAttributeDefaults(map);
        }
        catch (SMSException sMSException) {
            AMSDKUtil.debug.message("AMSchema.setAttributeDefaults(Map): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("900"), "900");
        }
        catch (SSOException sSOException) {
            AMSDKUtil.debug.message("AMSchema.setAttributeDefaults(Map): ", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("900"), "900");
        }
    }

    public void setAttributeDefaults(String string, Set set) throws AMException {
        try {
            this.serviceSchema.setAttributeDefaults(string, set);
        }
        catch (SMSException sMSException) {
            AMSDKUtil.debug.message("AMSchema.setAttributeDefaults(attrName,values): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("900"), "900");
        }
        catch (SSOException sSOException) {
            AMSDKUtil.debug.message("AMSchema.setAttributeDefaults(Map): ", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("900"), "900");
        }
    }

    public void removeAttributeDefaults(Set set) throws AMException {
        try {
            this.serviceSchema.removeAttributeDefaults(set);
        }
        catch (SMSException sMSException) {
            AMSDKUtil.debug.message("AMSchema.removeAttributeDefaults(Set): ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("912"), "912");
        }
        catch (SSOException sSOException) {
            AMSDKUtil.debug.message("AMSchema.removeAttributeDefaults(Set): ", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("912"), "912");
        }
    }

    public String getPropertiesViewBeanURL() {
        return this.serviceSchema.getPropertiesViewBeanURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(String string, AMServiceListener aMServiceListener) throws AMException {
        HashMap hashMap = serviceListeners;
        synchronized (hashMap) {
            Listener listener = (Listener)serviceListeners.get(string);
            if (listener == null) {
                listener = new Listener(string);
                serviceListeners.put(string, listener);
            }
            listener.addListener(aMServiceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(String string, AMServiceListener aMServiceListener) throws AMException {
        HashMap hashMap = serviceListeners;
        synchronized (hashMap) {
            Listener listener = (Listener)serviceListeners.get(string);
            if (listener != null) {
                listener.removeListener(aMServiceListener);
            }
        }
    }

    public static class Type {
        private SchemaType schemaType;
        public static final Type GLOBAL = new Type(SchemaType.GLOBAL);
        public static final Type ORGANIZATION = new Type(SchemaType.ORGANIZATION);
        public static final Type USER = new Type(SchemaType.USER);
        public static final Type POLICY = new Type(SchemaType.POLICY);
        public static final Type DYNAMIC = new Type(SchemaType.DYNAMIC);

        private Type() {
        }

        protected Type(SchemaType schemaType) {
            this.schemaType = schemaType;
        }

        public String toString() {
            return this.schemaType.toString();
        }

        public boolean equals(Object object) {
            if (object instanceof Type) {
                Type type = (Type)object;
                SchemaType schemaType = type.getInternalSchemaType();
                return this.schemaType.equals(schemaType);
            }
            return false;
        }

        protected SchemaType getInternalSchemaType() {
            return this.schemaType;
        }

        public int hashCode() {
            return this.schemaType.hashCode();
        }
    }

    static class Listener
    implements ServiceListener {
        HashSet amlisteners = new HashSet();

        public Listener(String string) {
            try {
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, AMSDKUtil.pUserToken);
                serviceSchemaManager.addListener(this);
            }
            catch (SSOException sSOException) {
                AMSDKUtil.debug.error("AMStoreConnection.Listener(): ", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMSDKUtil.debug.error("AMStoreConnection.Listener(): ", (Throwable)sMSException);
            }
        }

        synchronized void addListener(AMServiceListener aMServiceListener) {
            this.amlisteners.add(aMServiceListener);
        }

        synchronized void removeListener(AMServiceListener aMServiceListener) {
            this.amlisteners.remove(aMServiceListener);
        }

        public void schemaChanged(String string, String string2) {
            Iterator iterator = this.amlisteners.iterator();
            while (iterator.hasNext()) {
                AMServiceListener aMServiceListener = (AMServiceListener)iterator.next();
                aMServiceListener.schemaChanged(string, string2);
            }
        }

        public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        }

        public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        }
    }
}

