/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCallBackImpl;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMOrganizationImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchFilterManager;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUserEntryProcessed;
import com.iplanet.am.sdk.CacheEntry;
import com.iplanet.am.sdk.CacheStats;
import com.iplanet.am.util.AMSendMail;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.am.util.Stats;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.AssignableDynamicGroup;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DynamicGroup;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.FilteredRole;
import com.iplanet.ums.Guid;
import com.iplanet.ums.ManagedRole;
import com.iplanet.ums.Organization;
import com.iplanet.ums.OrganizationalUnit;
import com.iplanet.ums.PeopleContainer;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.Resource;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SizeLimitExceededException;
import com.iplanet.ums.SortKey;
import com.iplanet.ums.StaticGroup;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.TimeLimitExceededException;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.User;
import com.iplanet.ums.cos.COSManager;
import com.iplanet.ums.cos.COSNotFoundException;
import com.iplanet.ums.cos.COSTemplate;
import com.iplanet.ums.cos.DirectCOSDefinition;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class AMSDKUtil
implements AMConstants {
    protected static final int ADD_MEMBER = 1;
    protected static final int REMOVE_MEMBER = 2;
    protected static final int CREATE = 3;
    protected static final int DELETE = 4;
    protected static final int MODIFY = 5;
    protected static final String CONTAINER_DEFAULT_TEMPLATE_ROLE = "ContainerDefaultTemplateRole";
    protected static final String NAMED_POLICY_DN_ATTRIBUTE = "iplanet-am-named-policy-dn";
    protected static final String NAMED_POLICY_OBJECT_CLASS = "iplanet-am-managed-policy";
    protected static final String CACHE_ENABLED_DISABLED_KEY = "com.iplanet.am.sdk.caching.enabled";
    protected static final String CACHE_MAX_SIZE_KEY = "com.iplanet.am.sdk.cache.maxSize";
    public static final String CACHE_KEY_SEPARATOR = ":";
    private static final String USER_ENTRY_PROCESSING_IMPL = "com.iplanet.am.sdk.userEntryProcessingImpl";
    protected static final String POLICY_SUFFIX = "Policy";
    private static final String POLICY_COSATTR_TYPE = " override";
    private static final String OTHER_COSATTR_TYPE = " default";
    protected static final String SERVICE_STATUS_ATTRIBUTE = "sunRegisteredServiceName";
    protected static String SUBSCRIBABLE_ATTRIBUTE = "iplanet-am-group-subscribable";
    protected static final String UNIQUE_MEMBER_ATTRIBUTE = "uniquemember";
    protected static final String USER_PASSWORD_ATTRIBUTE = "userpassword";
    protected static final String USER_ENCRYPTED_PASSWORD_ATTRIBUTE = "encrypteduserpassword";
    protected static final String EMAIL_ATTRIBUTE = "mail";
    protected static final String CONSOLE_SERVICE = "iPlanetAMAdminConsoleService";
    protected static final String REQUIRED_SERVICES_ATTR = "iplanet-am-required-services";
    protected static final String USER_SEARCH_RETURN_ATTR = "iplanet-am-admin-console-user-return-attribute";
    protected static final String UNIQUE_ATTRIBUTE_LIST_ATTR = "sunnamespaceuniqueattrs";
    protected static final String DCT_ENABLED_ATTR = "iplanet-am-admin-console-dctree";
    protected static final String DCT_ATTRIBUTE_LIST_ATTR = "iplanet-am-admin-console-dctree-attr-list";
    protected static final String ADMIN_GROUPS_ENABLED_ATTR = "iplanet-am-admin-console-compliance-admin-groups";
    protected static final String COMPLIANCE_USER_DELETION_ATTR = "iplanet-am-admin-console-compliance-user-deletion";
    protected static final String COMPLIANCE_SPECIAL_FILTER_ATTR = "iplanet-am-admin-console-special-search-filters";
    protected static final String ROLE_MANAGED_CONTAINER_DN_ATTR = "iplanet-am-role-managed-container-dn";
    protected static final String PRE_POST_PROCESSING_MODULES_ATTR = "iplanet-am-admin-console-pre-post-processing-modules";
    protected static final String USER_CREATE_NOTIFICATION_LIST = "iplanet-am-user-create-notification-list";
    protected static final String USER_DELETE_NOTIFICATION_LIST = "iplanet-am-user-delete-notification-list";
    protected static final String USER_MODIFY_NOTIFICATION_LIST = "iplanet-am-user-modify-notification-list";
    protected static final String INET_DOMAIN_STATUS_ATTR = "inetdomainstatus";
    protected static final String DOMAIN_ADMINISTRATORS = "DomainAdministrators";
    protected static final String DOMAIN_HELP_DESK_ADMINISTRATORS = "DomainHelpDeskAdministrators";
    protected static final String INET_ADMIN_OBJECT_CLASS = "inetadmin";
    protected static final String ADMIN_ROLE_ATTR = "adminrole";
    protected static Debug debug;
    protected static Cache sdkCache;
    protected static HashSet sdkNegativeCache;
    protected static Cache orgCache;
    protected static Cache searchFilterCache;
    protected static CacheStats cacheStatsObj;
    protected static Stats stats;
    protected static boolean cachingEnabled;
    protected static SSOToken pUserToken;
    protected static boolean isUserPluginInitialized;
    private static AMUserEntryProcessed userEntry;

    AMSDKUtil() {
    }

    protected static AMUserEntryProcessed getUserPostPlugin() {
        if (!isUserPluginInitialized) {
            String string = SystemProperties.get((String)USER_ENTRY_PROCESSING_IMPL);
            if (string != null && string.length() == 0) {
                try {
                    userEntry = (AMUserEntryProcessed)Class.forName(string).newInstance();
                    if (debug.messageEnabled()) {
                        debug.message("AMSDKUtil.getUserPostPlugin : Class " + string + " instantiated.");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    debug.error("AMSDKUtil.getUserPostPlugin() : Class not found: " + string, (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    debug.error("AMSDKUtil.getUserPostPlugin() : Unable to instantiate: " + string, (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    debug.error("AMSDKUtil.getUserPostPlugin() : IllegalAccessException: " + string, (Throwable)illegalAccessException);
                }
            }
            isUserPluginInitialized = true;
        }
        return userEntry;
    }

    private static void enableOrDisableCache() {
        String string = System.getProperty(CACHE_ENABLED_DISABLED_KEY);
        if (string == null || string.length() == 0) {
            string = SystemProperties.get((String)CACHE_ENABLED_DISABLED_KEY);
        }
        if (string == null || string.equalsIgnoreCase("true")) {
            cachingEnabled = true;
            String string2 = SystemProperties.get((String)CACHE_MAX_SIZE_KEY);
            if (string2 != null) {
                try {
                    int n = Integer.parseInt(string2);
                    if (n < 1) {
                        n = 10000;
                    }
                    sdkCache = new Cache(n);
                    sdkNegativeCache = new HashSet(n);
                    orgCache = new Cache(n);
                    searchFilterCache = new Cache(n);
                    if (debug.messageEnabled()) {
                        debug.message("Caching size set to: " + n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    sdkCache = new Cache();
                    sdkNegativeCache = new HashSet();
                    orgCache = new Cache();
                    searchFilterCache = new Cache();
                    debug.warning("Invalid value for cache size. Setting to default");
                }
            } else {
                sdkCache = new Cache();
                sdkNegativeCache = new HashSet();
                orgCache = new Cache();
                searchFilterCache = new Cache();
            }
        } else {
            cachingEnabled = false;
        }
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.enableOrDisableCache()-Caching Mode: " + cachingEnabled);
        }
    }

    protected static String getUserLocale(SSOToken sSOToken) {
        try {
            String string = sSOToken.getProperty("Locale");
            if (debug.messageEnabled()) {
                debug.message("AMSDKUtil.getUserLocale locale string = " + string);
            }
            return string;
        }
        catch (SSOException sSOException) {
            debug.error("AMSDKUtil.getUserLocale, missing locale, setting to null");
            return null;
        }
    }

    protected static boolean doesProfileExist(SSOToken sSOToken, String string) {
        Object object;
        if (cachingEnabled) {
            object = null;
            try {
                object = AMSDKUtil.constructCacheKey(sSOToken.getPrincipal().getName(), string);
            }
            catch (SSOException sSOException) {
                if (debug.messageEnabled()) {
                    debug.message("AMSDKUtil.doesProfileExist()-SSOException: " + (Object)((Object)sSOException));
                }
                return false;
            }
            if (sdkCache.get(object) != null) {
                return true;
            }
            if (sdkNegativeCache.contains(new DN(string).toRFCString().toLowerCase())) {
                if (debug.messageEnabled()) {
                    debug.message("AMSDKUtil: negative cache contains dn: " + string + " : returning False");
                }
                return false;
            }
        }
        try {
            object = UMSObject.getObject(pUserToken, new Guid(string));
        }
        catch (UMSException uMSException) {
            if (debug.messageEnabled()) {
                debug.message("AMSDKUtil.doesProfileExist()-UMSException: " + uMSException.toString());
                debug.message("AMSDKUTil: adding to negative cache: " + string);
            }
            if (cachingEnabled) {
                sdkNegativeCache.add(new DN(string).toRFCString().toLowerCase());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dirtyCache(DSEvent dSEvent, String string, boolean bl, boolean bl2, String string2, Set set) {
        if (!cachingEnabled || sdkCache.isEmpty() && orgCache.isEmpty() && searchFilterCache.isEmpty() && sdkNegativeCache.isEmpty()) {
            return;
        }
        Cache cache = searchFilterCache;
        synchronized (cache) {
            searchFilterCache.remove((Object)string2.toLowerCase());
        }
        int n = dSEvent.getEventType();
        switch (n) {
            case 1: {
                if (bl) {
                    Cache cache2 = sdkCache;
                    synchronized (cache2) {
                        Enumeration enumeration = sdkCache.keys();
                        while (enumeration.hasMoreElements()) {
                            int n2;
                            int n3;
                            String string3 = (String)enumeration.nextElement();
                            if (!string3.regionMatches(true, (n3 = string3.length()) - (n2 = string.length()), string, 0, n2)) continue;
                            String string4 = CACHE_KEY_SEPARATOR + string2;
                            int n4 = string4.length();
                            if (string3.regionMatches(true, n3 - n4, string4, 0, n4)) {
                                sdkCache.remove((Object)string3);
                                continue;
                            }
                            CacheEntry cacheEntry = (CacheEntry)sdkCache.get((Object)string3);
                            if (cacheEntry == null) continue;
                            CacheEntry cacheEntry2 = cacheEntry;
                            synchronized (cacheEntry2) {
                                AttrSet attrSet = cacheEntry.getStoredAttrSet();
                                Iterator iterator = set.iterator();
                                while (iterator.hasNext()) {
                                    String string5 = (String)iterator.next();
                                    if (!attrSet.contains(string5)) continue;
                                    attrSet.remove(string5);
                                    cacheEntry.setComplete(false);
                                }
                            }
                        }
                    }
                }
                if (debug.messageEnabled()) {
                    debug.message("AMSDKUtil: removing from negative cache (ADD OP): " + string2);
                }
                sdkNegativeCache.remove(string2.toLowerCase());
                break;
            }
            case 2: 
            case 8: {
                if (debug.messageEnabled()) {
                    debug.message("AMSDKUtil: removing from negative cache (REMOVE or RENAME OP): " + string2);
                }
                sdkNegativeCache.remove(string2.toLowerCase());
                orgCache.remove((Object)string2.toLowerCase());
            }
            case 4: {
                if (bl || bl2) {
                    Cache cache3 = sdkCache;
                    synchronized (cache3) {
                        Enumeration enumeration = sdkCache.keys();
                        while (enumeration.hasMoreElements()) {
                            int n5;
                            int n6;
                            String string6 = (String)enumeration.nextElement();
                            if (!string6.regionMatches(true, (n6 = string6.length()) - (n5 = string.length()), string, 0, n5)) continue;
                            String string7 = CACHE_KEY_SEPARATOR + string2;
                            int n7 = string7.length();
                            if (string6.regionMatches(true, n6 - n7, string7, 0, n7)) {
                                sdkCache.remove((Object)string6);
                                continue;
                            }
                            CacheEntry cacheEntry = (CacheEntry)sdkCache.get((Object)string6);
                            if (cacheEntry == null) continue;
                            CacheEntry cacheEntry3 = cacheEntry;
                            synchronized (cacheEntry3) {
                                AttrSet attrSet = cacheEntry.getStoredAttrSet();
                                Iterator iterator = set.iterator();
                                while (iterator.hasNext()) {
                                    String string8 = (String)iterator.next();
                                    if (!attrSet.contains(string8)) continue;
                                    attrSet.remove(string8);
                                    cacheEntry.setComplete(false);
                                }
                            }
                        }
                        break;
                    }
                }
                Cache cache4 = sdkCache;
                synchronized (cache4) {
                    Enumeration enumeration = sdkCache.keys();
                    while (enumeration.hasMoreElements()) {
                        String string9 = (String)enumeration.nextElement();
                        String string10 = string9.substring(string9.indexOf(CACHE_KEY_SEPARATOR) + 1);
                        if (!string.equalsIgnoreCase(string10)) continue;
                        sdkCache.remove((Object)string9);
                    }
                    break;
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.dirtyCache(): Cache dirtied because of Event Notification.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dirtyCache(String string, Set set) {
        if (!cachingEnabled || sdkCache.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        Cache cache = sdkCache;
        synchronized (cache) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = AMSDKUtil.constructCacheKey(string, string2);
                sdkCache.remove((Object)string3);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.dirtyCache(): Cache dirtied because of invalid SSOTokens.");
        }
    }

    protected static void dirtyCache(SSOToken sSOToken, String string) {
        if (!cachingEnabled || sdkCache.isEmpty()) {
            return;
        }
        try {
            String string2 = AMSDKUtil.constructCacheKey(sSOToken.getPrincipal().getName(), string);
            sdkCache.remove((Object)string2);
            if (debug.messageEnabled()) {
                debug.message("AMSDKUtil.dirtyCache() Updated cache for: " + string2 + " because of setting/modification of " + "attributes values");
            }
        }
        catch (SSOException sSOException) {
            debug.message("AMSDKUtil.updateUserAttribute(): Unable to get Principal: " + sSOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateCache(SSOToken sSOToken, String string, AttrSet attrSet) {
        String string2;
        block8: {
            if (!cachingEnabled || sdkCache.isEmpty()) {
                return;
            }
            string2 = null;
            try {
                string2 = AMSDKUtil.constructCacheKey(sSOToken.getPrincipal().getName(), string);
            }
            catch (SSOException sSOException) {
                if (!debug.messageEnabled()) break block8;
                debug.message("AMSDKUtil.updateCache(): SSOException ", (Throwable)sSOException);
            }
        }
        CacheEntry cacheEntry = (CacheEntry)sdkCache.get((Object)string2);
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                AttrSet attrSet2 = cacheEntry.getStoredAttrSet();
                int n = attrSet.size();
                int n2 = 0;
                while (n2 < n) {
                    Attr attr = attrSet.elementAt(n2);
                    String string3 = attr.getName();
                    Attr attr2 = attrSet2.getAttribute(string3);
                    attrSet2.remove(string3);
                    attrSet2.add(attr);
                    ++n2;
                }
            }
        }
    }

    private static AttrSet getAttrSet(COSTemplate cOSTemplate, String[] stringArray) {
        debug.message("AMSDKUtil.getAttrSet() method");
        if (stringArray == null || stringArray.length == 0) {
            stringArray = cOSTemplate.getAttributeNames();
        }
        AttrSet attrSet = new AttrSet();
        int n = 0;
        while (n < stringArray.length) {
            attrSet.add(cOSTemplate.getAttribute(stringArray[n]));
            ++n;
        }
        return attrSet;
    }

    protected static Set getServiceNames(SSOToken sSOToken) throws SMSException, SSOException {
        ServiceManager serviceManager = new ServiceManager(sSOToken);
        return serviceManager.getServiceNames();
    }

    protected static Set getServiceAttributeNames(SSOToken sSOToken, String string, SchemaType schemaType) throws SMSException, PolicyException, SSOException {
        ServiceSchema serviceSchema;
        block3: {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            serviceSchema = null;
            try {
                serviceSchema = serviceSchemaManager.getSchema(schemaType);
            }
            catch (SMSException sMSException) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("AMSDKUtil.getServiceNames(): No schema defined for " + schemaType.toString());
            }
        }
        if (serviceSchema == null || schemaType == SchemaType.POLICY) {
            return Collections.EMPTY_SET;
        }
        return serviceSchema.getAttributeSchemaNames();
    }

    private static Set getServiceAttributesWithQualifier(SSOToken sSOToken, String string) throws SMSException, SSOException {
        ServiceSchema serviceSchema;
        block4: {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            serviceSchema = null;
            try {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
            }
            catch (SMSException sMSException) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMSDKUtil.getServiceNames(): No schema defined for SchemaType.DYNAMIC type");
            }
        }
        if (serviceSchema == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set set = serviceSchema.getAttributeSchemaNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string2);
            String string3 = string2 + " " + attributeSchema.getCosQualifier();
            hashSet.add(string3);
        }
        return hashSet;
    }

    protected static boolean serviceHasSubSchema(SSOToken sSOToken, String string, SchemaType schemaType) throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
        Set set = serviceSchemaManager.getSchemaTypes();
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.serviceHasSubSchema() types for " + string + " = " + set);
        }
        return set.contains(schemaType);
    }

    protected static Map getServiceConfig(SSOToken sSOToken, String string, SchemaType schemaType) throws SMSException, AMException, SSOException {
        try {
            HashMap<String, Set> hashMap = null;
            if (schemaType != SchemaType.POLICY) {
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
                hashMap = serviceSchema.getAttributeDefaults();
            } else {
                ServiceTypeManager serviceTypeManager = new ServiceTypeManager(sSOToken);
                ServiceType serviceType = serviceTypeManager.getServiceType(string);
                Map map = serviceType.getActionSchemas();
                Iterator iterator = map.entrySet().iterator();
                hashMap = new HashMap<String, Set>();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string2 = (String)entry.getKey();
                    ActionSchema actionSchema = (ActionSchema)entry.getValue();
                    Set set = actionSchema.getActionValues();
                    if (actionSchema.requiresResourceName()) {
                        Iterator iterator2 = set.iterator();
                        while (iterator2.hasNext()) {
                            String string3 = (String)iterator2.next();
                            Set set2 = actionSchema.getResourceNames(string3);
                            hashMap.put(string3, set2);
                        }
                        continue;
                    }
                    hashMap.put(string2, set);
                }
            }
            return hashMap;
        }
        catch (PolicyException policyException) {
            debug.error("AMSDKUtil.getServiceConf(): ", (Throwable)policyException);
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("499", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "499", objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttrSet getAllAttributes(SSOToken sSOToken, String string, String string2, CacheEntry cacheEntry, boolean bl) throws AMException, UMSException {
        PersistentObject persistentObject = UMSObject.getObject(sSOToken, new Guid(string));
        AttrSet attrSet = persistentObject.getAttributes(persistentObject.getAttributeNames());
        if (attrSet != null && attrSet.size() > 0) {
            debug.message("AMSDKUtil.getAllAttributes()-Key: " + string2 + " fetched complete AttrSet from LDAP ");
        }
        AttrSet attrSet2 = null;
        if (AMDCTree.isRequired() && persistentObject instanceof Organization && !string.equalsIgnoreCase(AMStoreConnection.rootSuffix) && (attrSet2 = AMDCTree.getDomainAttributes(pUserToken, string, null)) != null) {
            debug.message("AMSDKUtil.getAllAttributes(): obtained DCTree domain attributes");
            int n = attrSet2.size();
            int n2 = 0;
            while (n2 < n) {
                attrSet.add(attrSet2.elementAt(n2));
                ++n2;
            }
        }
        if (bl && AMCompliance.isComplianceUserDeletionEnabled()) {
            AMCompliance.verifyAttributes(attrSet);
        }
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(attrSet, true);
            sdkCache.put((Object)string2, (Object)cacheEntry);
        } else {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                cacheEntry.storeAttrSet(attrSet, true);
            }
        }
        String string3 = AMSDKUtil.getOrgDN(pUserToken, string);
        Map map = AMCallBackImpl.getAttributes(sSOToken, string, null, string3);
        if (map != null) {
            AttrSet attrSet3 = AMSDKUtil.mapToAttrSet(map);
            return AMSDKUtil.combineAttrSets(attrSet3, attrSet);
        }
        return attrSet;
    }

    private static AttrSet getRequestedAttributes(SSOToken sSOToken, String string, String[] stringArray, String string2) throws AMException, UMSException {
        Object object;
        PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
        AttrSet attrSet = persistentObject.getAttributes(stringArray);
        int n = stringArray.length;
        HashSet<String> hashSet = new HashSet<String>();
        if (attrSet.size() < n) {
            int n2 = 0;
            while (n2 < n) {
                object = attrSet.getAttribute(stringArray[n2]);
                if (object == null) {
                    hashSet.add(stringArray[n2]);
                    object = new Attr(stringArray[n2]);
                    attrSet.add((Attr)object);
                }
                ++n2;
            }
        }
        String string3 = AMSDKUtil.getOrgDN(pUserToken, string);
        object = AMCallBackImpl.getAttributes(sSOToken, string, hashSet, string3);
        AttrSet attrSet2 = null;
        if (object != null) {
            attrSet2 = AMSDKUtil.mapToAttrSet((Map)object);
            int n3 = attrSet2.size();
            int n4 = 0;
            while (n4 < n3) {
                Attr attr = attrSet2.elementAt(n4);
                attrSet.remove(attr.getName());
                ++n4;
            }
        }
        CacheEntry cacheEntry = new CacheEntry(attrSet, false);
        sdkCache.put((Object)string2, (Object)cacheEntry);
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.getRequestedAttributes()-Key : " + string2 + " Retrieved requested AttrSet from LDAP.");
        }
        if (attrSet2 != null) {
            return AMSDKUtil.combineAttrSets(attrSet2, attrSet);
        }
        return attrSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttrSet getHitAndMissAttributes(SSOToken sSOToken, String string, String[] stringArray, String string2, CacheEntry cacheEntry) throws AMException, UMSException {
        Map map;
        Object object;
        AttrSet attrSet = new AttrSet();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = stringArray.length;
        AttrSet attrSet2 = cacheEntry.getStoredAttrSet();
        int n2 = 0;
        while (n2 < n) {
            object = attrSet2.getAttribute(stringArray[n2]);
            if (object == null) {
                arrayList.add(stringArray[n2]);
            } else {
                attrSet.add((Attr)object);
            }
            ++n2;
        }
        if (!arrayList.isEmpty()) {
            Object object2;
            Object object3;
            int n3 = arrayList.size();
            String[] stringArray2 = new String[n3];
            stringArray2 = arrayList.toArray(stringArray2);
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            AttrSet attrSet3 = persistentObject.getAttributes(stringArray2);
            HashSet<String> hashSet = new HashSet<String>();
            int n4 = 0;
            while (n4 < n3) {
                object3 = attrSet3.getAttribute(stringArray2[n4]);
                if (object3 == null) {
                    hashSet.add(stringArray2[n4]);
                    object3 = new Attr(stringArray2[n4]);
                }
                attrSet.add((Attr)object3);
                object2 = cacheEntry;
                synchronized (object2) {
                    cacheEntry.storeAttribute((Attr)object3);
                }
                ++n4;
            }
            object3 = AMSDKUtil.getOrgDN(pUserToken, string);
            object2 = AMCallBackImpl.getAttributes(sSOToken, string, hashSet, (String)object3);
            AttrSet attrSet4 = null;
            if (object2 != null) {
                attrSet4 = AMSDKUtil.mapToAttrSet((Map)object2);
                int n5 = attrSet4.size();
                int n6 = 0;
                while (n6 < n5) {
                    Attr attr = attrSet4.elementAt(n6);
                    attrSet.remove(attr.getName());
                    CacheEntry cacheEntry2 = cacheEntry;
                    synchronized (cacheEntry2) {
                        cacheEntry.removeAttribute(attr.getName());
                    }
                    ++n6;
                }
            }
            if (debug.messageEnabled()) {
                debug.message("AMSDKUtil.getProfileAttributes()-Key : " + string2 + " Obtained requested AttrSet from cache and LDAP");
                debug.message("Missing attribute List: " + arrayList.toString());
            }
            if (attrSet4 != null) {
                return AMSDKUtil.combineAttrSets(attrSet4, attrSet);
            }
            return attrSet;
        }
        cacheStatsObj.updateHitCount();
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.getProfileAttributes()-Key: " + string2 + " Retrived requested AttrSet from cache");
        }
        if ((map = AMCallBackImpl.getAttributes(sSOToken, string, null, (String)(object = AMSDKUtil.getOrgDN(pUserToken, string)))) != null) {
            AttrSet attrSet5 = AMSDKUtil.mapToAttrSet(map);
            return AMSDKUtil.combineAttrSets(attrSet5, attrSet);
        }
        return attrSet;
    }

    protected static AttrSet getProfileAttributes(SSOToken sSOToken, String string, String[] stringArray) throws AMException {
        return AMSDKUtil.getProfileAttributes(sSOToken, string, stringArray, true);
    }

    protected static AttrSet getProfileAttributes(SSOToken sSOToken, String string, String[] stringArray, boolean bl) throws AMException {
        cacheStatsObj.incrementRequestCount();
        try {
            if (!cachingEnabled) {
                if (stringArray == null || stringArray.length == 0) {
                    String string2;
                    PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
                    AttrSet attrSet = persistentObject.getAttributes(persistentObject.getAttributeNames());
                    if (persistentObject instanceof Organization && AMDCTree.isRequired() && (string2 = AMDCTree.getCanonicalDomain(pUserToken, string)) != null) {
                        AttrSet attrSet2 = AMDCTree.getDomainAttributes(pUserToken, string, null);
                        int n = attrSet2.size();
                        int n2 = 0;
                        while (n2 < n) {
                            attrSet.add(attrSet2.elementAt(n2));
                            ++n2;
                        }
                    }
                    if (bl && AMCompliance.isComplianceUserDeletionEnabled()) {
                        AMCompliance.verifyAttributes(attrSet);
                    }
                    return attrSet;
                }
                PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
                if (persistentObject instanceof Organization && AMDCTree.isRequired()) {
                    String string3;
                    AttrSet attrSet = persistentObject.getAttributes(stringArray);
                    if (persistentObject instanceof Organization && AMDCTree.isRequired() && (string3 = AMDCTree.getCanonicalDomain(pUserToken, string)) != null) {
                        AttrSet attrSet3 = AMDCTree.getDomainAttributes(pUserToken, string, stringArray);
                        int n = attrSet3.size();
                        int n3 = 0;
                        while (n3 < n) {
                            attrSet.add(attrSet3.elementAt(n3));
                            ++n3;
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMSDKUtil.getProfileAttribute-> returning attrset: " + attrSet.toString());
                    }
                    return attrSet;
                }
                if (bl && AMCompliance.isComplianceUserDeletionEnabled()) {
                    return AMCompliance.verifyAndGetAttributes(persistentObject, stringArray);
                }
                return persistentObject.getAttributes(stringArray);
            }
            String string4 = new DN(string).toRFCString();
            String string5 = AMSDKUtil.constructCacheKey(sSOToken.getPrincipal().getName(), string4);
            if (AMDCTree.isRequired()) {
                AMSDKUtil.getAllAttributes(sSOToken, string4, string5, null, bl);
            }
            CacheEntry cacheEntry = (CacheEntry)sdkCache.get((Object)string5);
            if (stringArray == null || stringArray.length == 0) {
                if (cacheEntry != null && cacheEntry.isCompleteAttrSet()) {
                    if (debug.messageEnabled()) {
                        debug.message("AMSDKUtil.getProfileAttributes()-Key:" + string5 + " Complete AttrSet retrieved from cache!");
                    }
                    cacheStatsObj.updateHitCount();
                    return cacheEntry.getStoredAttrSet();
                }
                return AMSDKUtil.getAllAttributes(sSOToken, string4, string5, cacheEntry, bl);
            }
            if (cacheEntry == null) {
                return AMSDKUtil.getRequestedAttributes(sSOToken, string4, stringArray, string5);
            }
            return AMSDKUtil.getHitAndMissAttributes(sSOToken, string4, stringArray, string5, cacheEntry);
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("AMSDKUtil.getProfileAttribute", (Throwable)exception);
            }
            throw new AMException(AMSDKBundle.getString("330", AMSDKUtil.getUserLocale(sSOToken)), "330");
        }
    }

    protected static void makeNamingFirst(AttrSet attrSet, String string, String string2) {
        int n = attrSet.indexOf(string);
        if (n == -1) {
            attrSet.add(new Attr(string, string2));
        } else {
            Attr attr = attrSet.elementAt(n);
            attr.removeValue(string2);
            String[] stringArray = attr.getStringValues();
            attr = new Attr(string, string2);
            attr.addValues(stringArray);
            attrSet.replace(attr);
        }
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.makeNamingFirst() attrSet: " + AMSDKUtil.attrSetToString(attrSet));
        }
    }

    protected static Set stringArrayToSet(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < stringArray.length) {
            hashSet.add(stringArray[n]);
            ++n;
        }
        return hashSet;
    }

    protected static AttrSet combineAttrSets(AttrSet attrSet, AttrSet attrSet2) {
        AttrSet attrSet3 = new AttrSet();
        int n = attrSet.size();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = attrSet.elementAt(n2);
            attrSet3.add(attr);
            ++n2;
        }
        n = attrSet2.size();
        int n3 = 0;
        while (n3 < n) {
            Attr attr = attrSet2.elementAt(n3);
            attrSet3.add(attr);
            ++n3;
        }
        return attrSet3;
    }

    protected static Map attrSetToMap(AttrSet attrSet) {
        AMHashMap aMHashMap = new AMHashMap();
        if (attrSet == null) {
            return aMHashMap;
        }
        int n = attrSet.size();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = attrSet.elementAt(n2);
            aMHashMap.put(attr.getName(), AMSDKUtil.stringArrayToSet(attr.getStringValues()));
            ++n2;
        }
        return aMHashMap;
    }

    protected static AttrSet mapToAttrSet(Map map) {
        AttrSet attrSet = new AttrSet();
        if (map == null) {
            return attrSet;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            String[] stringArray = set == null ? null : set.toArray(new String[set.size()]);
            attrSet.replace(new Attr(string, stringArray));
        }
        return attrSet;
    }

    private static void createUser(SSOToken sSOToken, PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException, AMEntryExistsException, AMException {
        Serializable serializable;
        String string2 = AMSDKUtil.getOrgDN(pUserToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(1) + "=" + string + "," + persistentObject.getDN();
        attrSet = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, attrSet, 3, 1, false);
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(1), string);
        Attr attr = attrSet.getAttribute("objectclass");
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicUser", null);
        if (attr != null) {
            serializable = creationTemplate.getAttribute("objectclass");
            attr.addValues(((Attr)serializable).getStringValues());
        }
        serializable = new User(creationTemplate, attrSet);
        try {
            persistentObject.addChild((PersistentObject)serializable);
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.createUser(): ", (Throwable)accessRightsException);
            }
            throw new AMException(AMSDKBundle.getString("460", AMSDKUtil.getUserLocale(sSOToken)), "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            if (AMCompliance.isComplianceUserDeletionEnabled()) {
                AMCompliance.checkIfDeletedUser(sSOToken, ((PersistentObject)serializable).getDN());
            }
            debug.warning("User already exists! " + entryAlreadyExistsException);
            throw new AMEntryExistsException(AMSDKBundle.getString("328", AMSDKUtil.getUserLocale(sSOToken)), "328", (UMSException)entryAlreadyExistsException);
        }
        catch (UMSException uMSException) {
            int n;
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.createUser(): ", (Throwable)uMSException);
            }
            try {
                LDAPException lDAPException = (LDAPException)uMSException.getRootCause();
                n = lDAPException.getLDAPResultCode();
            }
            catch (Exception exception) {
                throw new AMException(AMSDKBundle.getString("324", AMSDKUtil.getUserLocale(sSOToken)), "324");
            }
            if (n == 19) {
                throw new AMException(AMSDKBundle.getString("19", AMSDKUtil.getUserLocale(sSOToken)), "19");
            }
            throw new AMException(AMSDKBundle.getString("324", AMSDKUtil.getUserLocale(sSOToken)), "324");
        }
        AMCallBackImpl.postProcess(sSOToken, ((PersistentObject)serializable).getDN(), string2, null, attrSet, 3, 1, false);
        AMUserEntryProcessed aMUserEntryProcessed = AMSDKUtil.getUserPostPlugin();
        if (aMUserEntryProcessed != null) {
            aMUserEntryProcessed.processUserAdd(sSOToken, ((PersistentObject)serializable).getDN(), AMSDKUtil.attrSetToMap(attrSet));
        }
        AMSDKUtil.sendUserCreateNotification(((PersistentObject)serializable).getDN(), attrSet);
    }

    private static void createResource(PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException {
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(21), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicResource", null);
        Resource resource = new Resource(creationTemplate, attrSet);
        persistentObject.addChild(resource);
    }

    private static void createRole(SSOToken sSOToken, PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException, AMException {
        String string2 = AMSDKUtil.getOrgDN(pUserToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(6) + "=" + string + "," + persistentObject.getDN();
        attrSet = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, attrSet, 3, 6, false);
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(6), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicManagedRole", null);
        ManagedRole managedRole = new ManagedRole(creationTemplate, attrSet);
        persistentObject.addChild(managedRole);
        AMCallBackImpl.postProcess(sSOToken, managedRole.getDN(), string2, null, attrSet, 3, 6, false);
    }

    private static void createOrganization(SSOToken sSOToken, PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException, AMException {
        String string2 = AMSDKUtil.getOrgDN(pUserToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(2) + "=" + string + "," + persistentObject.getDN();
        attrSet = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, attrSet, 3, 2, false);
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(2), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicOrganization", null);
        Organization organization = new Organization(creationTemplate, attrSet);
        persistentObject.addChild(organization);
        if (AMDCTree.isRequired()) {
            AMDCTree.createDomain(sSOToken, organization.getGuid(), attrSet);
        }
        if (AMCompliance.isAdminGroupsEnabled(organization.getDN())) {
            AMCompliance.createAdminGroups(sSOToken, organization);
        }
        AMCallBackImpl.postProcess(sSOToken, organization.getDN(), string2, null, attrSet, 3, 2, false);
    }

    private static void createGroup(SSOToken sSOToken, PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException, AMException {
        String string2 = AMSDKUtil.getOrgDN(pUserToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + persistentObject.getDN();
        attrSet = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, attrSet, 3, 9, false);
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(9), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicGroup", null);
        StaticGroup staticGroup = new StaticGroup(creationTemplate, attrSet);
        persistentObject.addChild(staticGroup);
        Attr attr = attrSet.getAttribute(UNIQUE_MEMBER_ATTRIBUTE);
        if (attr != null) {
            String[] stringArray = attr.getStringValues();
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
            AMSDKUtil.updateUserAttribute(sSOToken, hashSet, staticGroup.getDN(), true);
        }
        AMCallBackImpl.postProcess(sSOToken, staticGroup.getDN(), string2, null, attrSet, 3, 9, false);
    }

    private static void createAssignDynamicGroup(SSOToken sSOToken, PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException, AMException {
        Serializable serializable;
        String string2 = AMSDKUtil.getOrgDN(pUserToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + persistentObject.getDN();
        attrSet = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, attrSet, 3, 12, false);
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(9), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicAssignableDynamicGroup", null);
        Attr attr = attrSet.getAttribute("objectclass");
        if (attr != null) {
            serializable = creationTemplate.getAttribute("objectclass");
            attr.addValues(((Attr)serializable).getStringValues());
        }
        serializable = new AssignableDynamicGroup(creationTemplate, attrSet);
        ((AssignableDynamicGroup)serializable).setSearchFilter("(memberof=" + string3 + ")");
        ((DynamicGroup)serializable).setSearchScope(2);
        ((DynamicGroup)serializable).setSearchBase(new Guid(AMSDKUtil.getOrgDN(sSOToken, persistentObject.getDN())));
        persistentObject.addChild((PersistentObject)serializable);
        AMCallBackImpl.postProcess(sSOToken, ((PersistentObject)serializable).getDN(), string2, null, attrSet, 3, 12, false);
    }

    private static void createDynamicGroup(SSOToken sSOToken, PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException, AMException {
        String string2 = AMSDKUtil.getOrgDN(pUserToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + persistentObject.getDN();
        attrSet = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, attrSet, 3, 11, false);
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(9), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicDynamicGroup", null);
        DynamicGroup dynamicGroup = new DynamicGroup(creationTemplate, attrSet);
        String string4 = persistentObject.getDN();
        String string5 = dynamicGroup.getSearchFilter();
        if (LDAPUrl.defaultFilter.equalsIgnoreCase(string5)) {
            dynamicGroup.setSearchFilter(AMSearchFilterManager.getSearchFilter(1, string2));
        }
        dynamicGroup.setSearchScope(2);
        dynamicGroup.setSearchBase(new Guid(AMSDKUtil.getOrgDN(sSOToken, string4)));
        persistentObject.addChild(dynamicGroup);
        AMCallBackImpl.postProcess(sSOToken, dynamicGroup.getDN(), string2, null, attrSet, 3, 11, false);
    }

    private static void createPeopleContainer(PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException {
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(5), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicPeopleContainer", null);
        PeopleContainer peopleContainer = new PeopleContainer(creationTemplate, attrSet);
        persistentObject.addChild(peopleContainer);
    }

    private static void createOrganizationalUnit(SSOToken sSOToken, PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException, AMException {
        String string2 = AMSDKUtil.getOrgDN(pUserToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(3) + "=" + string + "," + persistentObject.getDN();
        attrSet = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, attrSet, 3, 3, false);
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(3), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicOrganizationalUnit", null);
        OrganizationalUnit organizationalUnit = new OrganizationalUnit(creationTemplate, attrSet);
        persistentObject.addChild(organizationalUnit);
        AMCallBackImpl.postProcess(sSOToken, organizationalUnit.getDN(), string2, null, attrSet, 3, 3, false);
    }

    private static void createGroupContainer(PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException {
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(4), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicGroupContainer", null);
        OrganizationalUnit organizationalUnit = new OrganizationalUnit(creationTemplate, attrSet);
        persistentObject.addChild(organizationalUnit);
    }

    private static void createFilteredRole(SSOToken sSOToken, PersistentObject persistentObject, AttrSet attrSet, String string) throws UMSException, AMException {
        Serializable serializable;
        String string2 = AMSDKUtil.getOrgDN(pUserToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(8) + "=" + string + "," + persistentObject.getDN();
        attrSet = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, attrSet, 3, 8, false);
        AMSDKUtil.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(8), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicFilteredRole", null);
        if (!attrSet.contains("nsRoleFilter")) {
            serializable = new Attr("nsRoleFilter", AMSearchFilterManager.getSearchFilter(1, string2));
            attrSet.add((Attr)serializable);
        }
        serializable = new FilteredRole(creationTemplate, attrSet);
        persistentObject.addChild((PersistentObject)serializable);
        AMCallBackImpl.postProcess(sSOToken, ((PersistentObject)serializable).getDN(), string2, null, attrSet, 3, 8, false);
    }

    protected static void createProfile(SSOToken sSOToken, String string, int n, String string2, AttrSet attrSet) throws AMEntryExistsException, AMException {
        try {
            if (string == null || string.equals("")) {
                throw new AMException(AMSDKBundle.getString("320", AMSDKUtil.getUserLocale(sSOToken)), "320");
            }
            if (string2 == null) {
                throw new AMException(AMSDKBundle.getString("322", AMSDKUtil.getUserLocale(sSOToken)), "322");
            }
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string2));
            switch (n) {
                case 1: {
                    AMSDKUtil.createUser(sSOToken, persistentObject, attrSet, string);
                    break;
                }
                case 6: 
                case 7: {
                    AMSDKUtil.createRole(sSOToken, persistentObject, attrSet, string);
                    break;
                }
                case 2: {
                    AMSDKUtil.createOrganization(sSOToken, persistentObject, attrSet, string);
                    break;
                }
                case 9: 
                case 10: {
                    AMSDKUtil.createGroup(sSOToken, persistentObject, attrSet, string);
                    break;
                }
                case 12: {
                    AMSDKUtil.createAssignDynamicGroup(sSOToken, persistentObject, attrSet, string);
                    break;
                }
                case 11: {
                    AMSDKUtil.createDynamicGroup(sSOToken, persistentObject, attrSet, string);
                    break;
                }
                case 5: {
                    AMSDKUtil.createPeopleContainer(persistentObject, attrSet, string);
                    break;
                }
                case 3: {
                    AMSDKUtil.createOrganizationalUnit(sSOToken, persistentObject, attrSet, string);
                    break;
                }
                case 4: {
                    AMSDKUtil.createGroupContainer(persistentObject, attrSet, string);
                    break;
                }
                case 8: {
                    AMSDKUtil.createFilteredRole(sSOToken, persistentObject, attrSet, string);
                    break;
                }
                case 21: {
                    AMSDKUtil.createResource(persistentObject, attrSet, string);
                    break;
                }
                default: {
                    throw new AMException(AMSDKBundle.getString("326", AMSDKUtil.getUserLocale(sSOToken)), "326");
                }
            }
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.CreateProfile", (Throwable)accessRightsException);
            }
            throw new AMException(AMSDKBundle.getString("460", AMSDKUtil.getUserLocale(sSOToken)), "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.CreateProfile", (Throwable)entryAlreadyExistsException);
            }
            String string3 = AMSDKUtil.getEntryExistsMsgID(n);
            String string4 = AMSDKUtil.getExceptionEntryName(entryAlreadyExistsException);
            Object[] objectArray = new Object[]{string4};
            throw new AMException(AMSDKBundle.getString(string3, objectArray), string3, objectArray);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.CreateProfile", (Throwable)uMSException);
            }
            throw new AMException(AMSDKBundle.getString("324", AMSDKUtil.getUserLocale(sSOToken)), "324", uMSException);
        }
    }

    protected static void removeProfile(SSOToken sSOToken, String string, int n, boolean bl) throws AMException {
        Object object;
        Serializable serializable;
        Object object2;
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.removeProfile(): " + string + " recursive=" + bl);
        }
        AttrSet attrSet = null;
        Set set = null;
        String string2 = AMSDKUtil.getOrgDN(pUserToken, string, n);
        try {
            Object object3;
            block29: {
                if (n == 1) {
                    try {
                        AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(pUserToken, string2);
                        set = aMOrganizationImpl.getOrgTypeAttributes(CONSOLE_SERVICE, USER_DELETE_NOTIFICATION_LIST);
                    }
                    catch (Exception exception) {
                        if (!debug.warningEnabled()) break block29;
                        debug.warning("AMSDKUtil.removeProfile: unable to get notification list");
                    }
                }
            }
            boolean bl2 = false;
            if (AMSDKUtil.getUserPostPlugin() != null || set != null && !set.isEmpty()) {
                attrSet = AMSDKUtil.getProfileAttributes(sSOToken, string, null);
                bl2 = true;
            }
            if (n != 5 && n != 4) {
                object2 = string2;
                if (!(n != 2 && n != 3 || ((DN)(serializable = new DN(AMStoreConnection.rootSuffix))).equals((DN)(object = new DN(string2))))) {
                    object3 = new DN(string2).getParent().toString();
                    object2 = AMSDKUtil.getOrgDN(pUserToken, (String)object3);
                }
                if (!bl2) {
                    attrSet = AMSDKUtil.getProfileAttributes(sSOToken, string, null);
                }
                AMCallBackImpl.preProcess(sSOToken, string, (String)object2, attrSet, null, 4, n, true);
            }
            object2 = new Guid(string);
            if (bl) {
                int n2;
                int n3;
                serializable = UMSObject.getObjectHandle(pUserToken, (Guid)object2);
                object = new SearchControl();
                ((SearchControl)object).setSearchScope(2);
                object3 = ((PersistentObject)serializable).getChildren("(|(objectclass=*)(objectclass=ldapsubEntry))", (SearchControl)object);
                ArrayList<DN> arrayList = new ArrayList<DN>();
                int n4 = n3 = new DN(string).countRDNs();
                while (((SearchResults)object3).hasMoreElements()) {
                    PersistentObject persistentObject = ((SearchResults)object3).next();
                    DN dN = new DN(persistentObject.getDN());
                    if (debug.messageEnabled()) {
                        debug.message("AMSDKUtil.removeProfile: found child " + dN.toRFCString());
                    }
                    if ((n2 = dN.countRDNs()) > n4) {
                        n4 = n2;
                    }
                    arrayList.add(dN);
                }
                if (debug.messageEnabled()) {
                    debug.message("AMSDKUtil.removeProfile: max RDNs = " + n4);
                }
                int n5 = arrayList.size();
                int n6 = n4;
                while (n6 >= n3) {
                    n2 = 0;
                    while (n2 < n5) {
                        DN dN = (DN)arrayList.get(n2);
                        if (dN.countRDNs() == n6) {
                            if (debug.messageEnabled()) {
                                debug.message("AMSDKUtil.removeProfile: del " + dN.toRFCString());
                            }
                            if (AMDCTree.isRequired()) {
                                AMDCTree.removeDomain(pUserToken, dN.toRFCString());
                            }
                            UMSObject.removeObject(sSOToken, new Guid(dN.toRFCString()));
                            arrayList.remove(n2);
                            --n2;
                            --n5;
                        }
                        ++n2;
                    }
                    --n6;
                }
            } else {
                if (AMDCTree.isRequired()) {
                    AMDCTree.removeDomain(pUserToken, new DN(string).toRFCString());
                }
                UMSObject.removeObject(sSOToken, (Guid)object2);
            }
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("AMSDKUtil.removeProfile", (Throwable)accessRightsException);
            throw new AMException(AMSDKBundle.getString("460", AMSDKUtil.getUserLocale(sSOToken)), "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            debug.error("AMSDKUtil.removeProfile", (Throwable)entryNotFoundException);
            String string3 = AMSDKUtil.getEntryNotFoundMsgID(n);
            String string4 = AMSDKUtil.getExceptionEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string4};
            throw new AMException(AMSDKBundle.getString(string3, objectArray, AMSDKUtil.getUserLocale(sSOToken)), string3, objectArray);
        }
        catch (UMSException uMSException) {
            debug.error("AMSDKUtil.removeProfile", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("325", AMSDKUtil.getUserLocale(sSOToken)), "325", uMSException);
        }
        if (n != 5 && n != 4) {
            String string5 = string2;
            if (!(n != 2 && n != 3 || ((DN)(object2 = new DN(AMStoreConnection.rootSuffix))).equals((DN)(serializable = new DN(string2))))) {
                object = new DN(string2).getParent().toString();
                string5 = AMSDKUtil.getOrgDN(pUserToken, (String)object);
            }
            AMCallBackImpl.postProcess(sSOToken, string, string5, attrSet, null, 4, n, true);
        }
        if (n == 1) {
            AMUserEntryProcessed aMUserEntryProcessed = AMSDKUtil.getUserPostPlugin();
            if (aMUserEntryProcessed != null) {
                aMUserEntryProcessed.processUserDelete(sSOToken, string, AMSDKUtil.attrSetToMap(attrSet));
            }
            if (set != null && !set.isEmpty()) {
                AMSDKUtil.sendUserDeleteNotification(string, set, attrSet);
            }
        }
    }

    protected static Set searchProfile(SSOToken sSOToken, String string, String string2, int n) throws AMException {
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(n);
            SearchResults searchResults = persistentObject.search(string2, searchControl);
            return AMSDKUtil.searchResultsToSet(searchResults);
        }
        catch (UMSException uMSException) {
            int n2;
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.searchProfile", (Throwable)uMSException);
            }
            try {
                LDAPException lDAPException = (LDAPException)uMSException.getRootCause();
                n2 = lDAPException.getLDAPResultCode();
                lDAPException.printStackTrace();
            }
            catch (Exception exception) {
                throw new AMException(AMSDKBundle.getString("341", AMSDKUtil.getUserLocale(sSOToken)), "341", uMSException);
            }
            if (n2 == 11) {
                throw new AMException(AMSDKBundle.getString("968", AMSDKUtil.getUserLocale(sSOToken)), "968", uMSException);
            }
            throw new AMException(AMSDKBundle.getString("341", AMSDKUtil.getUserLocale(sSOToken)), "341", uMSException);
        }
    }

    protected static AMSearchResults searchUsingSearchControl(SSOToken sSOToken, String string, String string2, SearchControl searchControl, String[] stringArray) throws AMException {
        try {
            SearchResults searchResults;
            SearchControl searchControl2;
            SortKey[] sortKeyArray = searchControl.getSortKeys();
            SortKey sortKey = null;
            if (sortKeyArray != null && sortKeyArray.length > 0 && sortKeyArray[0].attributeName != null) {
                sortKey = sortKeyArray[0];
            }
            String string3 = AMSDKUtil.getUserLocale(sSOToken);
            if (debug.messageEnabled()) {
                debug.message("searchcontrol locale = " + string3);
            }
            Collator collator = Collator.getInstance(Locale.getLocale((String)string3));
            if (sortKey != null) {
                searchControl2 = new SearchControl();
                searchControl2.setMaxResults(searchControl.getMaxResults());
                searchControl2.setSearchScope(searchControl.getSearchScope());
                searchControl2.setTimeOut(searchControl.getTimeOut());
            } else {
                searchControl2 = searchControl;
            }
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            if (stringArray == null) {
                if (sortKey == null) {
                    searchResults = persistentObject.search(string2, searchControl2);
                } else {
                    String[] stringArray2 = new String[]{sortKey.attributeName};
                    searchResults = persistentObject.search(string2, stringArray2, searchControl2);
                }
            } else if (sortKey == null) {
                searchResults = persistentObject.search(string2, stringArray, searchControl2);
            } else {
                String[] stringArray3 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                stringArray3[stringArray.length] = sortKey.attributeName;
                searchResults = persistentObject.search(string2, stringArray3, searchControl2);
            }
            return AMSDKUtil.getSearchResults(searchResults, sortKey, stringArray, collator);
        }
        catch (UMSException uMSException) {
            int n;
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.searchUsingSearchControl", (Throwable)uMSException);
            }
            try {
                LDAPException lDAPException = (LDAPException)uMSException.getRootCause();
                n = lDAPException.getLDAPResultCode();
            }
            catch (Exception exception) {
                throw new AMException(AMSDKBundle.getString("341", AMSDKUtil.getUserLocale(sSOToken)), "341", uMSException);
            }
            if (n == 11) {
                throw new AMException(AMSDKBundle.getString("968", AMSDKUtil.getUserLocale(sSOToken)), "968", uMSException);
            }
            throw new AMException(AMSDKBundle.getString("341", AMSDKUtil.getUserLocale(sSOToken)), "341", uMSException);
        }
    }

    protected static void removeService(SSOToken sSOToken, String string, int n, String string2, int n2) throws AMException {
        if (n2 != 301) {
            return;
        }
        try {
            DirectCOSDefinition directCOSDefinition;
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            COSManager cOSManager = null;
            if (n == 6 || n == 8) {
                cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getParentGuid());
            } else if (n == 2 || n == 3 || n == 5) {
                cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getGuid());
            } else {
                throw new AMException(AMSDKBundle.getString("450", AMSDKUtil.getUserLocale(sSOToken)), "450");
            }
            try {
                directCOSDefinition = (DirectCOSDefinition)cOSManager.getDefinition(string2);
            }
            catch (COSNotFoundException cOSNotFoundException) {
                if (debug.messageEnabled()) {
                    debug.message("AMSDKUtil.removeService: " + string2 + " not found");
                }
                Object[] objectArray = new Object[]{string2};
                throw new AMException(AMSDKBundle.getString("463", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "463", objectArray);
            }
            directCOSDefinition.removeCOSTemplates();
            cOSManager.removeDefinition(string2);
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("AMSDKUtil.removeService", (Throwable)accessRightsException);
            throw new AMException(AMSDKBundle.getString("460", AMSDKUtil.getUserLocale(sSOToken)), "460");
        }
        catch (UMSException uMSException) {
            debug.error("AMSDKUtil.removeService", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("855", AMSDKUtil.getUserLocale(sSOToken)), "855", uMSException);
        }
    }

    protected static String getAMTemplateDN(SSOToken sSOToken, String string, int n, String string2, int n2) throws AMException {
        Object var5_5 = null;
        Object var6_6 = null;
        String string3 = null;
        try {
            if (n == 6 || n == 8) {
                string3 = string;
                PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
                return "cn=\"" + string3 + "\",cn=" + string2 + "," + persistentObject.getParentGuid().toString();
            }
            if (n == 2 || n == 3 || n == 5) {
                string3 = "cn=ContainerDefaultTemplateRole," + string;
                return "cn=\"" + string3 + "\",cn=" + string2 + "," + string;
            }
            throw new AMException(AMSDKBundle.getString("450", AMSDKUtil.getUserLocale(sSOToken)), "450");
        }
        catch (UMSException uMSException) {
            debug.error("AMSDKUtil.getAMTemplateDN", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("349", AMSDKUtil.getUserLocale(sSOToken)), "349", uMSException);
        }
    }

    protected static void registerService(SSOToken sSOToken, String string, String string2) throws AMException {
        try {
            Set set = AMSDKUtil.getServiceAttributesWithQualifier(sSOToken, string2);
            if (set != null && !set.isEmpty()) {
                PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
                DirectCOSDefinition directCOSDefinition = AMSDKUtil.newCOSDefinition(string2, set);
                COSManager cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getGuid());
                cOSManager.addDefinition(directCOSDefinition);
            }
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("AMSDKUtil.registerService", (Throwable)accessRightsException);
            throw new AMException(AMSDKBundle.getString("460", AMSDKUtil.getUserLocale(sSOToken)), "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            debug.error("AMSDKUtil.registerService", (Throwable)entryAlreadyExistsException);
            Object[] objectArray = new Object[]{string2};
            throw new AMException(AMSDKBundle.getString("464", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "464", objectArray);
        }
        catch (UMSException uMSException) {
            debug.error("AMSDKUtil.registerService", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("914", AMSDKUtil.getUserLocale(sSOToken)), "914", uMSException);
        }
        catch (Exception exception) {
            debug.error("AMSDKUtil.registerService", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("917", AMSDKUtil.getUserLocale(sSOToken)), "917");
        }
    }

    protected static String createAMTemplate(SSOToken sSOToken, String string, int n, String string2, AttrSet attrSet, int n2, int n3, String[] stringArray) throws AMException {
        COSTemplate cOSTemplate;
        COSManager cOSManager = null;
        DirectCOSDefinition directCOSDefinition = null;
        String string3 = null;
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            if (n == 6 || n == 8) {
                string3 = string;
                cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getParentGuid());
                directCOSDefinition = (DirectCOSDefinition)cOSManager.getDefinition(string2);
            } else if (n == 2 || n == 3 || n == 5) {
                string3 = "cn=ContainerDefaultTemplateRole," + string;
                cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getGuid());
                directCOSDefinition = (DirectCOSDefinition)cOSManager.getDefinition(string2);
            } else {
                throw new AMException(AMSDKBundle.getString("450", AMSDKUtil.getUserLocale(sSOToken)), "450");
            }
            if (n2 != -1) {
                Attr attr = new Attr("cospriority");
                attr.addValue("" + n2);
                attrSet.add(attr);
            }
            cOSTemplate = AMSDKUtil.newCOSTemplate(string2, attrSet, string3, n3);
            directCOSDefinition.addCOSTemplate(cOSTemplate);
            sdkNegativeCache.remove(new DN(cOSTemplate.getDN()).toRFCString().toLowerCase());
        }
        catch (COSNotFoundException cOSNotFoundException) {
            debug.message("AMSDKUtil.createAMTemplate", (Throwable)cOSNotFoundException);
            Object[] objectArray = new Object[]{string2};
            throw new AMException(AMSDKBundle.getString("459", AMSDKUtil.getUserLocale(sSOToken)), "459", objectArray);
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            debug.message("AMSDKUtil.createAMTemplate: Template exists for " + string2);
            Object[] objectArray = new String[]{string2};
            throw new AMException(AMSDKBundle.getString("854", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "854", objectArray);
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.createAMTemplate", (Throwable)accessRightsException);
            }
            throw new AMException(AMSDKBundle.getString("460", AMSDKUtil.getUserLocale(sSOToken)), "460");
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.createAMTemplate", (Throwable)uMSException);
            }
            Object[] objectArray = new Object[]{string2};
            throw new AMException(AMSDKBundle.getString("459", AMSDKUtil.getUserLocale(sSOToken)), "459", objectArray, uMSException);
        }
        catch (Exception exception) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.createAMTemplate", (Throwable)exception);
            }
            throw new AMException(AMSDKBundle.getString("451", AMSDKUtil.getUserLocale(sSOToken)), "451");
        }
        return cOSTemplate.getGuid().toString();
    }

    static ServiceConfig createOrgConfig(SSOToken sSOToken, String string, String string2, Map map) throws SSOException, AMException {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string2, sSOToken);
            ServiceConfig serviceConfig = serviceConfigManager.createOrganizationConfig(string, map);
            return serviceConfig;
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            Object[] objectArray = new Object[]{string2};
            throw new AMException(AMSDKBundle.getString("481", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "481", objectArray);
        }
        catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
            Object[] objectArray = new Object[]{string2};
            throw new AMException(AMSDKBundle.getString("479", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "479", objectArray);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{string2};
            throw new AMException(AMSDKBundle.getString("482", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "482", objectArray);
        }
    }

    static ServiceConfig getOrgConfig(SSOToken sSOToken, String string, String string2) throws SSOException, AMException {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string2, sSOToken);
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
            DN dN = new DN(string);
            if (dN.equals(new DN(AMStoreConnection.rootSuffix)) && serviceConfig != null) {
                Map map = serviceConfig.getAttributes();
                Set set = serviceConfig.getSubConfigNames();
                if (map.isEmpty() && (set == null || set.isEmpty())) {
                    return null;
                }
            }
            return serviceConfig;
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            Object[] objectArray = new Object[]{string2};
            throw new AMException(AMSDKBundle.getString("481", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "481", objectArray);
        }
        catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
            Object[] objectArray = new Object[]{string2};
            throw new AMException(AMSDKBundle.getString("479", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "479", objectArray);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{string2};
            throw new AMException(AMSDKBundle.getString("482", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "482", objectArray);
        }
    }

    protected static Map getNamedPolicyAttributes(SSOToken sSOToken, String string, String string2, String string3, Map map) throws SSOException, AMException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.getNamedPolicyAttributes: orgDN=" + string + ", policyDN=" + string2);
        }
        try {
            DN dN = new DN(string2);
            String string4 = ((RDN)dN.getRDNs().firstElement()).getValues()[0];
            PolicyManager policyManager = new PolicyManager(sSOToken, string);
            Policy policy = policyManager.getPolicy(string4);
            Iterator iterator = policy.getRuleNames().iterator();
            HashMap<String, Set> hashMap = new HashMap<String, Set>();
            HashSet<String> hashSet = new HashSet<String>();
            ServiceTypeManager serviceTypeManager = new ServiceTypeManager(sSOToken);
            ServiceType serviceType = serviceTypeManager.getServiceType(string3);
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                Rule rule = policy.getRule(string5);
                String string6 = rule.getResourceName();
                Map map2 = rule.getActionValues();
                Iterator iterator2 = map2.keySet().iterator();
                while (iterator2.hasNext()) {
                    Object object;
                    String string7 = (String)iterator2.next();
                    ActionSchema actionSchema = serviceType.getActionSchema(string7);
                    if (actionSchema == null) {
                        debug.error("Unable to get action schema:" + string2);
                        throw new AMException(AMSDKBundle.getString("449", AMSDKUtil.getUserLocale(sSOToken)), "449");
                    }
                    String string8 = actionSchema.getCosQualifier();
                    if (debug.messageEnabled()) {
                        debug.message("cos Qualifier = " + string8);
                    }
                    boolean bl = !string8.equals("merge-schemes");
                    Set set = rule.getActionValues(string7);
                    if (string6 == null) {
                        if (bl) {
                            hashSet.add(string7);
                        }
                        if ((object = (Set)hashMap.get(string7)) == null) {
                            hashMap.put(string7, set);
                            continue;
                        }
                        object.addAll(set);
                        continue;
                    }
                    object = set.iterator();
                    while (object.hasNext()) {
                        HashSet<String> hashSet2;
                        String string9 = (String)object.next();
                        if (bl) {
                            hashSet.add(string9);
                        }
                        if ((hashSet2 = (HashSet<String>)hashMap.get(string9)) == null) {
                            hashSet2 = new HashSet<String>();
                            hashMap.put(string9, hashSet2);
                        }
                        hashSet2.add(string6);
                    }
                }
            }
            map.put(new Integer(policy.getPriority()), hashSet);
            return hashMap;
        }
        catch (PolicyException policyException) {
            debug.error("AMSDKUtil.getNamedPolicyAttributes(): ", (Throwable)policyException);
            throw new AMException(AMSDKBundle.getString("489", AMSDKUtil.getUserLocale(sSOToken)), "489");
        }
    }

    protected static Map getNamedPoliciesAttributes(SSOToken sSOToken, String string, Set set, String string2, Set set2) throws AMException, SSOException {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        if (set == null || set.size() == 0) {
            return hashMap;
        }
        Iterator iterator = set.iterator();
        int n = 1000;
        int n2 = 1000;
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            HashMap hashMap2 = new HashMap();
            Map map = AMSDKUtil.getNamedPolicyAttributes(sSOToken, string, string3, string2, hashMap2);
            Integer n3 = (Integer)hashMap2.keySet().iterator().next();
            Set set3 = (Set)hashMap2.get(n3);
            int n4 = n3;
            if (n4 < n2) {
                n2 = n4;
            }
            boolean bl = n4 < n;
            n = n4;
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                boolean bl2 = set3.contains(string4);
                Set set4 = (Set)map.get(string4);
                Set set5 = (Set)hashMap.get(string4);
                if (set5 == null) {
                    hashMap.put(string4, set4);
                    continue;
                }
                if (bl2) {
                    if (!bl) continue;
                    hashMap.remove(string4);
                    hashMap.put(string4, set4);
                    continue;
                }
                set5.addAll(set4);
            }
        }
        set2.add(new Integer(n2));
        return hashMap;
    }

    protected static Set getAllPolicyTemplates(SSOToken sSOToken, String string, String string2) throws AMException {
        String string3 = "(&(objectclass=iplanet-am-managed-policy)(iplanet-am-named-policy-dn=" + string2 + "))";
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.getAllPolicyTemplates(): OrgDN=" + string + " policyDN=" + string2 + " SearchFilter: " + string3);
        }
        return AMSDKUtil.searchProfile(sSOToken, string, string3, 2);
    }

    protected static boolean checkIfTemplateExists(SSOToken sSOToken, String string, String string2, String string3) throws AMException {
        String string4 = "cn=" + string3 + POLICY_SUFFIX + "," + string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&(objectclass=").append(NAMED_POLICY_OBJECT_CLASS);
        stringBuffer.append(")(").append(NAMED_POLICY_DN_ATTRIBUTE).append("=");
        stringBuffer.append(string2).append("))");
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.checkIfTemplateExists(): Filter: " + stringBuffer.toString() + "BaseDN: " + string4);
        }
        try {
            PersistentObject persistentObject = UMSObject.getObject(sSOToken, new Guid(string4));
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(2);
            SearchResults searchResults = persistentObject.search(stringBuffer.toString(), searchControl);
            if (searchResults != null && searchResults.hasMoreElements()) {
                searchResults.abandon();
                return true;
            }
            return false;
        }
        catch (UMSException uMSException) {
            if (debug.messageEnabled()) {
                debug.message("AMSDKUtil.checkIfTemplateExists()", (Throwable)uMSException);
            }
            throw new AMException(AMSDKBundle.getString("345", AMSDKUtil.getUserLocale(sSOToken)), "345", uMSException);
        }
    }

    protected static boolean deleteAllPolicyTemplates(SSOToken sSOToken, String string, String string2) throws AMException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&(objectclass=").append(NAMED_POLICY_OBJECT_CLASS);
        stringBuffer.append(")(").append(NAMED_POLICY_DN_ATTRIBUTE).append("=");
        stringBuffer.append(string2).append("))");
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(2);
            SearchResults searchResults = persistentObject.search(stringBuffer.toString(), searchControl);
            if (searchResults != null) {
                while (searchResults.hasMoreElements()) {
                    PersistentObject persistentObject2 = searchResults.next();
                    if (debug.messageEnabled()) {
                        debug.message("Removing template: " + persistentObject2.getGuid().getDn());
                    }
                    persistentObject2.remove();
                }
                return true;
            }
            return false;
        }
        catch (UMSException uMSException) {
            if (debug.messageEnabled()) {
                debug.message("AMSDKUtil.deleteAllPolicyTemplates()", (Throwable)uMSException);
            }
            throw new AMException(AMSDKBundle.getString("346", AMSDKUtil.getUserLocale(sSOToken)), "346", uMSException);
        }
    }

    protected static boolean updateAllPolicyTemplates(SSOToken sSOToken, String string, String string2, int n, AttrSet attrSet) throws AMException, SSOException {
        String string3 = "(&(objectclass=iplanet-am-managed-policy)(iplanet-am-named-policy-dn=" + string2 + "))";
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(2);
            SearchResults searchResults = persistentObject.search(string3, searchControl);
            if (searchResults != null) {
                while (searchResults.hasMoreElements()) {
                    PersistentObject persistentObject2 = searchResults.next();
                    String string4 = persistentObject2.getGuid().getDn();
                    if (debug.messageEnabled()) {
                        debug.message("Updating template: " + string4);
                    }
                    AMSDKUtil.setProfileAttributes(sSOToken, string4, n, attrSet, false);
                }
                return true;
            }
            return false;
        }
        catch (UMSException uMSException) {
            if (debug.messageEnabled()) {
                debug.message("AMSDKUtil.updateAllPolicyTemplates()", (Throwable)uMSException);
            }
            throw new AMException(AMSDKBundle.getString("347", AMSDKUtil.getUserLocale(sSOToken)), "347", uMSException);
        }
    }

    private static COSTemplate newCOSTemplate(String string, AttrSet attrSet, String string2, int n) throws UMSException {
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicCOSTemplate", null);
        COSTemplate cOSTemplate = new COSTemplate(creationTemplate, "\"" + string2 + "\"");
        cOSTemplate.addTemplateAttribute("objectclass", "extensibleObject");
        if (n == 300) {
            cOSTemplate.addTemplateAttribute("objectclass", NAMED_POLICY_OBJECT_CLASS);
        }
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.newCOSTemplate : cn = " + string2 + " COSTemplate = " + cOSTemplate);
        }
        int n2 = attrSet.size();
        int n3 = 0;
        while (n3 < n2) {
            Attr attr = attrSet.elementAt(n3);
            cOSTemplate.modify(attr, 0);
            ++n3;
        }
        debug.message("AMSDKUtil.newCOSTemplate : before return");
        return cOSTemplate;
    }

    private static DirectCOSDefinition newCOSDefinition(String string, Set set) throws UMSException {
        AttrSet attrSet = new AttrSet();
        Attr attr = new Attr("cn", string);
        attrSet.add(attr);
        attr = new Attr("cosSpecifier", "nsrole");
        attrSet.add(attr);
        attr = new Attr("cosAttribute");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            attr.addValue(string2);
        }
        attrSet.add(attr);
        return new DirectCOSDefinition(attrSet);
    }

    protected static String renameEntry(SSOToken sSOToken, int n, String string, String string2, boolean bl) throws AMException {
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            String string3 = AMNamingAttrManager.getNamingAttr(1) + "=" + string2;
            persistentObject.rename(string3, bl);
            AMSDKUtil.dirtyCache(sSOToken, string);
            return persistentObject.getDN();
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.renameEntry(): User does not have sufficient access rights ", (Throwable)accessRightsException);
            }
            throw new AMException(AMSDKBundle.getString("460", AMSDKUtil.getUserLocale(sSOToken)), "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.renameEntry(): Entry not found: ", (Throwable)entryNotFoundException);
            }
            String string4 = AMSDKUtil.getEntryNotFoundMsgID(n);
            String string5 = AMSDKUtil.getExceptionEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string5};
            throw new AMException(AMSDKBundle.getString(string4, objectArray), string4, objectArray);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.renameEntry(): Unable to rename entry: ", (Throwable)uMSException);
            }
            throw new AMException(AMSDKBundle.getString("360", AMSDKUtil.getUserLocale(sSOToken)), "360");
        }
    }

    protected static void setProfileAttributes(SSOToken sSOToken, String string, int n, AttrSet attrSet, boolean bl) throws AMException, SSOException {
        Object object;
        AttrSet attrSet2 = null;
        Set set = null;
        String string2 = AMSDKUtil.getOrgDN(pUserToken, string, n);
        try {
            Object object2;
            Serializable serializable;
            if (debug.messageEnabled()) {
                debug.message("AMSDKUtil.setProfileAttributes() DN = " + string + " AttrSet: " + AMSDKUtil.attrSetToString(attrSet));
            }
            if (n == 1) {
                try {
                    AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(pUserToken, string2);
                    set = aMOrganizationImpl.getOrgTypeAttributes(CONSOLE_SERVICE, USER_MODIFY_NOTIFICATION_LIST);
                }
                catch (SSOException sSOException) {
                    if (debug.warningEnabled()) {
                        debug.warning("AMSDKUtil.setProfileAttributes: unable to get notification list ", (Throwable)sSOException);
                    }
                    throw sSOException;
                }
            }
            boolean bl2 = false;
            if (AMSDKUtil.getUserPostPlugin() != null || set != null && !set.isEmpty()) {
                attrSet2 = AMSDKUtil.getProfileAttributes(sSOToken, string, attrSet.getAttributeNames());
                bl2 = true;
            }
            if (n != 5 && n != 4) {
                DN dN;
                object = string2;
                if (!(n != 2 && n != 3 || (serializable = new DN(AMStoreConnection.rootSuffix)).equals(dN = new DN(string2)))) {
                    object2 = new DN(string2).getParent().toString();
                    object = AMSDKUtil.getOrgDN(pUserToken, (String)object2);
                }
                if (!bl2) {
                    attrSet2 = AMSDKUtil.getProfileAttributes(sSOToken, string, attrSet.getAttributeNames());
                }
                attrSet = AMCallBackImpl.preProcess(sSOToken, string, (String)object, attrSet2, attrSet, 5, n, false);
            }
            if (n == 2 && AMDCTree.isRequired() && !string.equals(AMStoreConnection.rootSuffix)) {
                object = AMDCTree.splitAttrSet(string, attrSet);
                attrSet = object[0];
                serializable = object[1];
                AMDCTree.setDomainAttributes(sSOToken, string, (AttrSet)serializable);
            }
            object = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            int n2 = attrSet.size();
            int n3 = 0;
            while (n3 < n2) {
                object2 = attrSet.elementAt(n3);
                if (((Attr)object2).size() == 0) {
                    ((PersistentObject)object).modify((Attr)object2, 1);
                } else if (!bl) {
                    ((PersistentObject)object).modify((Attr)object2, 2);
                } else {
                    ((PersistentObject)object).modify((Attr)object2, 0);
                }
                ++n3;
            }
            ((PersistentObject)object).save();
            if (n != 1) {
                AMSDKUtil.dirtyCache(sSOToken, string);
            }
            if (n == 2 && AMDCTree.isRequired() && (object2 = attrSet.getValue(INET_DOMAIN_STATUS_ATTR)) != null) {
                AMDCTree.updateDomainStatus(sSOToken, string, (String)object2);
            }
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.setProfileAttributes: User does not have sufficient access rights: ", (Throwable)accessRightsException);
            }
            throw new AMException(AMSDKBundle.getString("460", AMSDKUtil.getUserLocale(sSOToken)), "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.setProfileAttributes() Entry not found: ", (Throwable)entryNotFoundException);
            }
            String string3 = AMSDKUtil.getEntryNotFoundMsgID(n);
            String string4 = AMSDKUtil.getExceptionEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string4};
            throw new AMException(AMSDKBundle.getString(string3, objectArray), string3, objectArray);
        }
        catch (UMSException uMSException) {
            int n4;
            if (debug.warningEnabled()) {
                debug.warning("AMSDKUtil.setProfileAttributes", (Throwable)uMSException);
            }
            try {
                LDAPException lDAPException = (LDAPException)uMSException.getRootCause();
                n4 = lDAPException.getLDAPResultCode();
            }
            catch (Exception exception) {
                throw new AMException(AMSDKBundle.getString("452", AMSDKUtil.getUserLocale(sSOToken)), "452");
            }
            if (n4 == 19) {
                throw new AMException(AMSDKBundle.getString("19", AMSDKUtil.getUserLocale(sSOToken)), "19");
            }
            if (n4 == 67) {
                throw new AMException(AMSDKBundle.getString("967", AMSDKUtil.getUserLocale(sSOToken)), "967");
            }
            throw new AMException(AMSDKBundle.getString("452", AMSDKUtil.getUserLocale(sSOToken)), "452");
        }
        if (n != 5 && n != 4) {
            DN dN;
            String string5 = string2;
            if (!(n != 2 && n != 3 || ((DN)(object = new DN(AMStoreConnection.rootSuffix))).equals(dN = new DN(string2)))) {
                String string6 = new DN(string2).getParent().toString();
                string5 = AMSDKUtil.getOrgDN(pUserToken, string6);
            }
            AMCallBackImpl.postProcess(sSOToken, string, string5, attrSet2, attrSet, 5, n, false);
        }
        if (n == 1) {
            AMSDKUtil.updateCache(sSOToken, string, attrSet);
            AMUserEntryProcessed aMUserEntryProcessed = AMSDKUtil.getUserPostPlugin();
            if (aMUserEntryProcessed != null) {
                aMUserEntryProcessed.processUserModify(sSOToken, string, AMSDKUtil.attrSetToMap(attrSet2), AMSDKUtil.attrSetToMap(attrSet));
            }
            if (set != null && !set.isEmpty()) {
                AMSDKUtil.sendUserModifyNotification(sSOToken, string, set, attrSet, attrSet2);
            }
        }
    }

    private static void modifyRoleMembership(SSOToken sSOToken, String string, Set set, int n, int n2) throws UMSException, AMException {
        ManagedRole managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid(string));
        String string2 = managedRole.getParentGuid().getDn();
        String string3 = AMSDKUtil.getOrgDN(sSOToken, string2);
        if (AMCallBackImpl.isExistsPrePostPlugins(string3) && ((set = AMCallBackImpl.preProcessModifyMemberShip(sSOToken, string, string3, set, n, n2)) == null || set.isEmpty())) {
            return;
        }
        switch (n) {
            case 1: {
                Guid[] guidArray = AMSDKUtil.toGuidArray(set);
                managedRole.addMembers(guidArray);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    AMSDKUtil.dirtyCache(sSOToken, string4);
                }
                if (!AMCompliance.isAdminGroupsEnabled(string2)) break;
                AMCompliance.verifyAndLinkRoleToGroup(sSOToken, guidArray, string);
                break;
            }
            case 2: {
                Object[] objectArray = set.toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    managedRole.removeMember(new Guid((String)objectArray[n3]));
                    AMSDKUtil.dirtyCache(sSOToken, (String)objectArray[n3]);
                    ++n3;
                }
                if (!AMCompliance.isAdminGroupsEnabled(string2)) break;
                AMCompliance.verifyAndUnLinkRoleToGroup(sSOToken, set, string);
                break;
            }
            default: {
                throw new AMException(AMSDKBundle.getString("114", AMSDKUtil.getUserLocale(sSOToken)), "114");
            }
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string3)) {
            AMCallBackImpl.postProcessModifyMemberShip(sSOToken, string, string3, set, n, n2);
        }
    }

    private static void modifyGroupMembership(SSOToken sSOToken, String string, Set set, int n, int n2) throws UMSException, AMException {
        StaticGroup staticGroup = (StaticGroup)UMSObject.getObject(sSOToken, new Guid(string));
        String string2 = staticGroup.getParentGuid().getDn();
        String string3 = AMSDKUtil.getOrgDN(sSOToken, string2);
        if (AMCallBackImpl.isExistsPrePostPlugins(string3) && ((set = AMCallBackImpl.preProcessModifyMemberShip(sSOToken, string, string3, set, n, n2)) == null || set.isEmpty())) {
            return;
        }
        switch (n) {
            case 1: {
                staticGroup.addMembers(AMSDKUtil.toGuidArray(set));
                AMSDKUtil.updateUserAttribute(sSOToken, set, string, true);
                break;
            }
            case 2: {
                Object[] objectArray = set.toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    staticGroup.removeMember(new Guid((String)objectArray[n3]));
                    ++n3;
                }
                AMSDKUtil.updateUserAttribute(sSOToken, set, string, false);
                break;
            }
            default: {
                throw new AMException(AMSDKBundle.getString("114", AMSDKUtil.getUserLocale(sSOToken)), "114");
            }
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string3)) {
            AMCallBackImpl.postProcessModifyMemberShip(sSOToken, string, string3, set, n, n2);
        }
    }

    private static void modifyAssignDynamicGroupMembership(SSOToken sSOToken, String string, Set set, int n, int n2) throws UMSException, AMException {
        AssignableDynamicGroup assignableDynamicGroup = new AssignableDynamicGroup();
        AssignableDynamicGroup assignableDynamicGroup2 = (AssignableDynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
        String string2 = assignableDynamicGroup2.getParentGuid().getDn();
        String string3 = AMSDKUtil.getOrgDN(sSOToken, string2);
        if (AMCallBackImpl.isExistsPrePostPlugins(string3) && ((set = AMCallBackImpl.preProcessModifyMemberShip(sSOToken, string, string3, set, n, n2)) == null || set.isEmpty())) {
            return;
        }
        switch (n) {
            case 1: {
                Guid[] guidArray = AMSDKUtil.toGuidArray(set);
                assignableDynamicGroup2.addMembers(AMSDKUtil.toGuidArray(set));
                if (!AMCompliance.isAdminGroupsEnabled(AMStoreConnection.rootSuffix)) break;
                AMCompliance.verifyAndLinkGroupToRole(sSOToken, guidArray, string);
                break;
            }
            case 2: {
                Object[] objectArray = set.toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    assignableDynamicGroup2.removeMember(new Guid((String)objectArray[n3]));
                    ++n3;
                }
                if (!AMCompliance.isAdminGroupsEnabled(AMStoreConnection.rootSuffix)) break;
                AMCompliance.verifyAndUnLinkGroupToRole(sSOToken, set, string);
                break;
            }
            default: {
                throw new AMException(AMSDKBundle.getString("114", AMSDKUtil.getUserLocale(sSOToken)), "114");
            }
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string3)) {
            AMCallBackImpl.postProcessModifyMemberShip(sSOToken, string, string3, set, n, n2);
        }
    }

    protected static void modMemberShip(SSOToken sSOToken, Set set, String string, int n, int n2) throws AMException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.modMemberShip: targetDN = <" + string + ">, Members: " + set + ", object Type = " + n + "Operation = " + n2);
        }
        try {
            switch (n) {
                case 6: 
                case 7: {
                    AMSDKUtil.modifyRoleMembership(sSOToken, string, set, n2, n);
                    break;
                }
                case 9: 
                case 10: {
                    AMSDKUtil.modifyGroupMembership(sSOToken, string, set, n2, n);
                    break;
                }
                case 12: {
                    AMSDKUtil.modifyAssignDynamicGroupMembership(sSOToken, string, set, n2, n);
                    break;
                }
                default: {
                    throw new AMException(AMSDKBundle.getString("114", AMSDKUtil.getUserLocale(sSOToken)), "114");
                }
            }
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("AMSDKUtil.modMemberShip() - Insufficient access rights: ", (Throwable)accessRightsException);
            throw new AMException(AMSDKBundle.getString("460", AMSDKUtil.getUserLocale(sSOToken)), "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            DN dN = AMSDKUtil.getExceptionDN(entryNotFoundException);
            DN dN2 = new DN(string);
            if (dN == null) {
                debug.error("AMSDKUtil.modMemberShip", (Throwable)entryNotFoundException);
                Object[] objectArray = new Object[]{dN2};
                throw new AMException(AMSDKBundle.getString("461", objectArray, AMSDKUtil.getUserLocale(sSOToken)), "461", objectArray);
            }
            String string2 = ((RDN)dN.getRDNs().firstElement()).getValues()[0];
            String string3 = null;
            if (dN.equals(dN2)) {
                switch (n) {
                    case 6: 
                    case 7: {
                        string3 = "465";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 12: {
                        string3 = "466";
                    }
                }
            } else {
                string3 = "468";
            }
            debug.error("AMSDKUtil.modMemberShip() - Entry not found " + string, (Throwable)entryNotFoundException);
            Object[] objectArray = new Object[]{string2};
            throw new AMException(AMSDKBundle.getString(string3, objectArray), string3, objectArray);
        }
        catch (UMSException uMSException) {
            debug.message("AMSDKUtil.modMemberShip() - Unable to modify membership", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("350", AMSDKUtil.getUserLocale(sSOToken)), "350", uMSException);
        }
    }

    protected static void updateUserAttribute(SSOToken sSOToken, Set set, String string, boolean bl) throws AMException {
        try {
            if (debug.messageEnabled()) {
                debug.message("AMSDKUtil.updateUserAttribute: groupDN: " + string + ", toAdd=" + bl);
            }
            Attr attr = new Attr("iplanet-am-static-group-dn", string);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (debug.messageEnabled()) {
                    debug.message("AMSDKUtil.updateUserAttribute: userDN: " + string2);
                }
                PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string2));
                if (bl) {
                    persistentObject.modify(attr, 0);
                } else {
                    persistentObject.modify(attr, 1);
                }
                AMSDKUtil.dirtyCache(sSOToken, string2);
                persistentObject.save();
            }
        }
        catch (UMSException uMSException) {
            debug.error("AMSDKUtil.updateUserAttribute", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("351", AMSDKUtil.getUserLocale(sSOToken)), "351", uMSException);
        }
    }

    protected static Set getMembers(SSOToken sSOToken, String string, int n) throws AMException {
        try {
            if (n == 6 || n == 7) {
                ManagedRole managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid(string));
                SearchResults searchResults = managedRole.getMemberIDs();
                return AMSDKUtil.searchResultsToSet(searchResults);
            }
            if (n == 8) {
                FilteredRole filteredRole = (FilteredRole)UMSObject.getObject(sSOToken, new Guid(string));
                SearchResults searchResults = filteredRole.getMemberIDs();
                return AMSDKUtil.searchResultsToSet(searchResults);
            }
            if (n == 9 || n == 10) {
                StaticGroup staticGroup = (StaticGroup)UMSObject.getObject(sSOToken, new Guid(string));
                SearchResults searchResults = staticGroup.getMemberIDs();
                return AMSDKUtil.searchResultsToSet(searchResults);
            }
            if (n == 11) {
                DynamicGroup dynamicGroup = (DynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
                SearchResults searchResults = dynamicGroup.getMemberIDs();
                return AMSDKUtil.searchResultsToSet(searchResults);
            }
            if (n == 12) {
                AssignableDynamicGroup assignableDynamicGroup = new AssignableDynamicGroup();
                AssignableDynamicGroup assignableDynamicGroup2 = (AssignableDynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
                SearchResults searchResults = assignableDynamicGroup2.getMemberIDs();
                return AMSDKUtil.searchResultsToSet(searchResults);
            }
            throw new AMException(AMSDKBundle.getString("114", AMSDKUtil.getUserLocale(sSOToken)), "114");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            debug.error("AMSDKUtil.getMembers", (Throwable)entryNotFoundException);
            String string2 = AMSDKUtil.getEntryNotFoundMsgID(n);
            String string3 = AMSDKUtil.getExceptionEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string3};
            throw new AMException(AMSDKBundle.getString(string2, objectArray), string2, objectArray);
        }
        catch (UMSException uMSException) {
            debug.message("AMSDKUtil.getMembers", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("454", AMSDKUtil.getUserLocale(sSOToken)), "454", uMSException);
        }
    }

    protected static Set getRegisteredServiceNames(SSOToken sSOToken, String string) throws AMException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.getRegisteredServiceNames: profileDN = " + string);
        }
        try {
            Set set = new HashSet();
            String[] stringArray = new String[]{SERVICE_STATUS_ATTRIBUTE};
            AttrSet attrSet = AMSDKUtil.getProfileAttributes(pUserToken, string, stringArray);
            if (attrSet.size() == 1) {
                if (debug.messageEnabled()) {
                    debug.message("AMSDKUtil.getRegisteredServiceNames: " + attrSet.toString());
                }
                String[] stringArray2 = attrSet.elementAt(0).getStringValues();
                set = AMSDKUtil.stringArrayToSet(stringArray2);
            }
            return set;
        }
        catch (Exception exception) {
            debug.error("AMSDKUtil.getRegisteredService", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("455", AMSDKUtil.getUserLocale(sSOToken)), "455");
        }
    }

    protected static Set searchResultsToSet(SearchResults searchResults) throws UMSException {
        OrderedSet orderedSet = new OrderedSet();
        if (searchResults != null) {
            while (searchResults.hasMoreElements()) {
                PersistentObject persistentObject = searchResults.next();
                orderedSet.add(persistentObject.getGuid().toString());
            }
        }
        return orderedSet;
    }

    protected static AMSearchResults getSearchResults(SearchResults searchResults, SortKey sortKey, String[] stringArray, Collator collator) throws UMSException {
        TreeSet<Object> treeSet;
        Object object;
        Serializable serializable;
        OrderedSet orderedSet = null;
        TreeMap<Object, Object> treeMap = null;
        TreeSet<String> treeSet2 = null;
        if (sortKey != null) {
            treeMap = new TreeMap<Object, Object>(collator);
            treeSet2 = new TreeSet<String>();
        }
        orderedSet = new OrderedSet();
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        int n = 0;
        try {
            if (searchResults != null) {
                while (searchResults.hasMoreElements()) {
                    serializable = searchResults.next();
                    String string = ((PersistentObject)serializable).getGuid().toString();
                    if (treeMap != null) {
                        object = ((PersistentObject)serializable).getAttribute(sortKey.attributeName);
                        if (object != null) {
                            String string2 = object.getStringValues()[0];
                            Object v = treeMap.get(string2);
                            if (v == null) {
                                treeMap.put(string2, string);
                            } else if (v instanceof String) {
                                treeSet = new TreeSet<Object>();
                                treeSet.add(v);
                                treeSet.add(string);
                                treeMap.put(string2, treeSet);
                            } else {
                                ((TreeSet)v).add(string);
                            }
                        } else {
                            treeSet2.add(string);
                        }
                    } else {
                        orderedSet.add(string);
                    }
                    if (stringArray == null) continue;
                    object = ((PersistentObject)serializable).getAttributes(stringArray, true);
                    hashMap.put(string, AMSDKUtil.attrSetToMap((AttrSet)object));
                }
            }
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
            n = 1;
        }
        catch (TimeLimitExceededException timeLimitExceededException) {
            n = 2;
        }
        serializable = (Integer)searchResults.get("vlvContentCount");
        int n2 = serializable == null ? -1 : (Integer)serializable;
        if (treeMap != null) {
            int n3;
            object = treeMap.values().toArray();
            int n4 = ((Object[])object).length;
            if (sortKey.reverse) {
                n3 = n4 - 1;
                while (n3 >= 0) {
                    treeSet = object[n3];
                    if (treeSet instanceof String) {
                        orderedSet.add(treeSet);
                    } else {
                        orderedSet.addAll((Collection)treeSet);
                    }
                    --n3;
                }
            } else {
                n3 = 0;
                while (n3 < n4) {
                    treeSet = object[n3];
                    if (treeSet instanceof String) {
                        orderedSet.add(treeSet);
                    } else {
                        orderedSet.addAll((Collection)treeSet);
                    }
                    ++n3;
                }
            }
            Iterator iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                orderedSet.add(iterator.next());
            }
        }
        object = new AMSearchResults(n2, (Set)orderedSet, n, hashMap);
        return object;
    }

    protected static Guid[] toGuidArray(Set set) {
        Object[] objectArray = set.toArray();
        Guid[] guidArray = new Guid[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            guidArray[n] = new Guid((String)objectArray[n]);
            ++n;
        }
        return guidArray;
    }

    private static String[] stringToArray(String string) {
        if (string == null || string.trim().length() == 0) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    static Set getServiceObjectClasses(SSOToken sSOToken, Set set) throws SSOException, AMException {
        HashSet hashSet = new HashSet();
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map map;
                Set set2;
                String string = (String)iterator.next();
                if (!AMSDKUtil.serviceHasSubSchema(sSOToken, string, SchemaType.GLOBAL) || (set2 = (Set)(map = AMSDKUtil.getServiceConfig(sSOToken, string, SchemaType.GLOBAL)).get("serviceObjectClasses")) == null) continue;
                hashSet.addAll(set2);
            }
        }
        catch (SMSException sMSException) {
            debug.error("AMSDKUtil.getServiceObjectClasses ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("161", AMSDKUtil.getUserLocale(sSOToken)), "161");
        }
        return hashSet;
    }

    static String getOrgDN(SSOToken sSOToken, String string, int n) throws AMException {
        if (n == 1) {
            DN dN = new DN(string);
            return AMSDKUtil.getOrgDN(sSOToken, dN.getParent().toString());
        }
        return AMSDKUtil.getOrgDN(sSOToken, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getOrgDN(SSOToken sSOToken, String string) throws AMException {
        try {
            String[] stringArray;
            if (!DN.isDN(string)) {
                debug.error("AMSDKUtil.getOrgDN " + AMSDKBundle.getString("157"));
                throw new AMException(AMSDKBundle.getString("157", AMSDKUtil.getUserLocale(sSOToken)), "157");
            }
            DN dN = new DN(string);
            if (cachingEnabled && (stringArray = (String[])orgCache.get((Object)dN.toString().toLowerCase())) != null) {
                if (debug.messageEnabled()) {
                    debug.message("AMSDKUtil: getOrgDN: obtaining org DN for " + string + " from cache: " + (String)stringArray);
                }
                return stringArray;
            }
            stringArray = new String[]{"objectclass"};
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(0);
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = "";
            while (true) {
                PersistentObject persistentObject;
                Object object;
                String string3;
                string2 = dN.toString();
                if (debug.messageEnabled()) {
                    debug.message("AMSDKUtil.getOrgDN : dn=" + string2);
                }
                if (cachingEnabled) {
                    string3 = (String)orgCache.get((Object)string2.toLowerCase());
                    if (string3 != null) {
                        if (debug.messageEnabled()) {
                            debug.message("AMSDKUtil: getOrgDN: obtaining org DN for " + string + " from cache: " + string3);
                        }
                        object = orgCache;
                        synchronized (object) {
                            Iterator iterator = hashSet.iterator();
                            while (iterator.hasNext()) {
                                String string4 = (String)iterator.next();
                                orgCache.put((Object)string4, (Object)string3);
                            }
                        }
                        return string3;
                    }
                    hashSet.add(string2.toLowerCase());
                }
                if (((SearchResults)(object = (persistentObject = UMSObject.getObjectHandle(pUserToken, new Guid(string2))).search(string3 = "(|" + AMSearchFilterManager.getSearchFilter(2, string2, null, true) + AMSearchFilterManager.getSearchFilter(3, string2, null, true) + ")", stringArray, searchControl))).hasMoreElements()) {
                    ((SearchResults)object).abandon();
                    String string5 = persistentObject.getGuid().toString().toLowerCase();
                    if (cachingEnabled) {
                        if (debug.messageEnabled()) {
                            debug.message("AMSDKUtil: getOrgDN-> Adding orgDN to cache: " + hashSet + " orgDN is " + string5);
                        }
                        Cache cache = orgCache;
                        synchronized (cache) {
                            Iterator iterator = hashSet.iterator();
                            while (iterator.hasNext()) {
                                String string6 = (String)iterator.next();
                                orgCache.put((Object)string6, (Object)string5);
                            }
                        }
                    }
                    return string5;
                }
                if (dN.countRDNs() == 1) {
                    debug.error("AMSDKUtil.getparentOrg " + AMSDKBundle.getString("124"));
                    throw new AMException(AMSDKBundle.getString("124", AMSDKUtil.getUserLocale(sSOToken)), "124");
                }
                dN = dN.getParent();
            }
        }
        catch (Exception exception) {
            debug.error("AMSDKUtil.getparentOrg", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("124", AMSDKUtil.getUserLocale(sSOToken)), "124");
        }
    }

    static void removeAdminRole(SSOToken sSOToken, String string, boolean bl) throws SSOException, AMException {
        Set<String> set;
        Object object;
        SSOTokenManager.getInstance().validateToken(sSOToken);
        if (debug.messageEnabled()) {
            debug.message("AMSDKUtil.removeAdminRole : dn=" + string);
        }
        DN dN = new DN(string);
        String string2 = AMSDKUtil.getOrgDN(sSOToken, dN.getParent().toString());
        String string3 = string.replace(',', '_');
        String string4 = AMNamingAttrManager.getNamingAttr(6) + "=" + string3 + "," + string2;
        if (bl) {
            object = "(&" + AMSearchFilterManager.getSearchFilter(6, string2) + "(" + AMNamingAttrManager.getNamingAttr(6) + "=*" + string3 + "))";
            set = AMSDKUtil.searchProfile(sSOToken, string2, (String)object, 1);
        } else {
            set = new HashSet<String>();
            set.add(string4);
        }
        object = set.iterator();
        while (object.hasNext()) {
            String string5 = (String)object.next();
            try {
                ManagedRole managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid(string5));
                managedRole.removeAllMembers();
                AMSDKUtil.removeProfile(sSOToken, string5, 6, false);
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) continue;
                debug.message("AMSDKUtil.removeAdminRole", (Throwable)exception);
            }
        }
    }

    static DN getExceptionDN(UMSException uMSException) {
        String string = uMSException.getMessage();
        if (string == null) {
            return null;
        }
        int n = string.indexOf("::");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        if (!DN.isDN(string2)) {
            return null;
        }
        return new DN(string2);
    }

    static String getExceptionEntryName(UMSException uMSException) {
        DN dN = AMSDKUtil.getExceptionDN(uMSException);
        if (dN == null) {
            return "";
        }
        return ((RDN)dN.getRDNs().firstElement()).getValues()[0];
    }

    static String getEntryNotFoundMsgID(int n) {
        if (n == 6 || n == 7 || n == 8) {
            return "465";
        }
        if (n == 9 || n == 11 || n == 10 || n == 12) {
            return "466";
        }
        if (n == 2) {
            return "467";
        }
        if (n == 1) {
            return "468";
        }
        if (n == 3) {
            return "469";
        }
        if (n == 5) {
            return "470";
        }
        if (n == 4) {
            return "471";
        }
        return "461";
    }

    static String getEntryExistsMsgID(int n) {
        if (n == 6 || n == 7 || n == 8) {
            return "472";
        }
        if (n == 9 || n == 11 || n == 10 || n == 12) {
            return "473";
        }
        if (n == 2) {
            return "474";
        }
        if (n == 1) {
            return "475";
        }
        if (n == 3) {
            return "476";
        }
        if (n == 5) {
            return "477";
        }
        if (n == 4) {
            return "483";
        }
        return "462";
    }

    static void encryptPasswordAttributeValues(Map map, ServiceSchema serviceSchema) {
        if (serviceSchema == null || map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Set set;
            String string = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
            if (attributeSchema == null || !attributeSchema.getSyntax().equals(AttributeSchema.Syntax.PASSWORD) && !attributeSchema.getSyntax().equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD) || (set = (Set)map.get(string)) == null) continue;
            HashSet hashSet = new HashSet(set);
            set.clear();
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (string2 != null) {
                    string2 = (String)AccessController.doPrivileged(new EncodeAction(string2));
                }
                set.add(string2);
            }
        }
    }

    static void decryptPasswordAttributeValues(Map map, ServiceSchema serviceSchema) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Set set;
            String string = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
            if (attributeSchema == null || !attributeSchema.getSyntax().equals(AttributeSchema.Syntax.PASSWORD) && !attributeSchema.getSyntax().equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD) || (set = (Set)map.get(string)) == null) continue;
            HashSet hashSet = new HashSet(set);
            set.clear();
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (string2 != null) {
                    string2 = (String)AccessController.doPrivileged(new DecodeAction(string2));
                }
                set.add(string2);
            }
        }
    }

    static Set decryptPasswordAttributeValues(Set set, String string, ServiceSchema serviceSchema) {
        if (set == null || set.isEmpty()) {
            return set;
        }
        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
        if (attributeSchema == null || !attributeSchema.getSyntax().equals(AttributeSchema.Syntax.PASSWORD) && !attributeSchema.getSyntax().equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) {
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 != null) {
                string2 = (String)AccessController.doPrivileged(new DecodeAction(string2));
            }
            hashSet.add(string2);
        }
        return hashSet;
    }

    static String attrSetToString(AttrSet attrSet) {
        Attr attr = attrSet.getAttribute(USER_PASSWORD_ATTRIBUTE);
        if (attr == null) {
            return attrSet.toString();
        }
        attrSet.remove(USER_PASSWORD_ATTRIBUTE);
        String string = attrSet.toString();
        attrSet.add(attr);
        return string;
    }

    private static void sendUserCreateNotification(String string, AttrSet attrSet) {
        try {
            String string2 = AMSDKUtil.getOrgDN(pUserToken, string, 1);
            AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(pUserToken, string2);
            Set set = aMOrganizationImpl.getOrgTypeAttributes(CONSOLE_SERVICE, USER_CREATE_NOTIFICATION_LIST);
            if (set == null || set.isEmpty()) {
                return;
            }
            AMSendMail aMSendMail = new AMSendMail();
            Iterator iterator = set.iterator();
            String string3 = AMSDKBundle.getString("504");
            while (iterator.hasNext()) {
                Object object;
                String[] stringArray;
                Object object2;
                StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next(), "|");
                String string4 = stringTokenizer.nextToken();
                if (string4.equals(string3)) {
                    object2 = attrSet.getAttribute(EMAIL_ATTRIBUTE);
                    if (object2 == null || ((Attr)object2).size() == 0) continue;
                    stringArray = ((Attr)object2).getStringValues();
                } else if (string4.startsWith(string3 + CACHE_KEY_SEPARATOR)) {
                    object2 = string4.substring((string3 + CACHE_KEY_SEPARATOR).length());
                    if (object2 == null || ((String)object2).length() == 0 || (object = attrSet.getAttribute((String)object2)) == null || ((Attr)object).size() == 0) continue;
                    stringArray = ((Attr)object).getStringValues();
                } else {
                    stringArray = new String[]{string4};
                }
                object2 = null;
                object = null;
                if (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken();
                    }
                }
                String string5 = AMSDKBundle.getString("490", (String)object2);
                String string6 = AMSDKBundle.getString("493", (String)object2) + " " + string;
                String string7 = AMSDKBundle.getString("497", (String)object2);
                try {
                    aMSendMail.postMail(stringArray, string5, string6, string7, (String)object);
                }
                catch (Exception exception) {
                    if (!debug.warningEnabled()) continue;
                    debug.warning("AMSDKUtil.sendUserCreateNotification: userDN=" + string, (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            debug.error("AMSDKUtil.sendUserCreateNotification: userDN=" + string, (Throwable)exception);
        }
    }

    private static void sendUserDeleteNotification(String string, Set set, AttrSet attrSet) {
        try {
            AMSendMail aMSendMail = new AMSendMail();
            String string2 = AMSDKBundle.getString("504");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object;
                String[] stringArray;
                Object object2;
                StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next(), "|");
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(string2)) {
                    object2 = attrSet.getAttribute(EMAIL_ATTRIBUTE);
                    if (object2 == null || ((Attr)object2).size() == 0) continue;
                    stringArray = ((Attr)object2).getStringValues();
                } else if (string3.startsWith(string2 + CACHE_KEY_SEPARATOR)) {
                    object2 = string3.substring((string2 + CACHE_KEY_SEPARATOR).length());
                    if (object2 == null || ((String)object2).length() == 0 || (object = attrSet.getAttribute((String)object2)) == null || ((Attr)object).size() == 0) continue;
                    stringArray = ((Attr)object).getStringValues();
                } else {
                    stringArray = new String[]{string3};
                }
                object2 = null;
                object = null;
                if (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken();
                    }
                }
                String string4 = AMSDKBundle.getString("491", (String)object2);
                String string5 = AMSDKBundle.getString("494", (String)object2) + " " + string;
                String string6 = AMSDKBundle.getString("497", (String)object2);
                try {
                    aMSendMail.postMail(stringArray, string4, string5, string6, (String)object);
                }
                catch (Exception exception) {
                    if (!debug.warningEnabled()) continue;
                    debug.warning("AMSDKUtil.sendUserDeleteNotification: userDN=" + string, (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            debug.error("AMSDKUtil.sendUserDeleteNotification: userDN=" + string, (Throwable)exception);
        }
    }

    private static void sendUserModifyNotification(SSOToken sSOToken, String string, Set set, AttrSet attrSet, AttrSet attrSet2) {
        try {
            AMSendMail aMSendMail = new AMSendMail();
            String string2 = AMSDKBundle.getString("504");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3;
                String string4 = (String)iterator.next();
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                int n = stringTokenizer.countTokens();
                if (n <= 1 || !attrSet.contains(string3 = stringTokenizer.nextToken().toLowerCase())) continue;
                while (stringTokenizer.hasMoreTokens()) {
                    int n2;
                    Object object;
                    Attr attr;
                    String[] stringArray;
                    Object object2;
                    Object object3;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "|");
                    String string5 = stringTokenizer2.nextToken();
                    if (string5.equals(string2)) {
                        object3 = new String[]{EMAIL_ATTRIBUTE};
                        object2 = AMSDKUtil.getProfileAttributes(sSOToken, string, (String[])object3).getAttribute(EMAIL_ATTRIBUTE);
                        if (object2 == null || object2.size() == 0) continue;
                        stringArray = object2.getStringValues();
                    } else if (string5.startsWith(string2 + CACHE_KEY_SEPARATOR)) {
                        object3 = string5.substring((string2 + CACHE_KEY_SEPARATOR).length());
                        if (object3 == null || ((String)object3).length() == 0 || (attr = AMSDKUtil.getProfileAttributes(sSOToken, string, object2 = new String[]{object3}).getAttribute((String)object3)) == null || attr.size() == 0) continue;
                        stringArray = attr.getStringValues();
                    } else {
                        stringArray = new String[]{string5};
                    }
                    object3 = null;
                    object2 = null;
                    if (stringTokenizer2.hasMoreTokens()) {
                        object3 = stringTokenizer2.nextToken();
                        if (stringTokenizer2.hasMoreTokens()) {
                            object2 = stringTokenizer2.nextToken();
                        }
                    }
                    attr = attrSet2.getAttribute(string3);
                    Attr attr2 = attrSet.getAttribute(string3);
                    String string6 = AMSDKBundle.getString("492", (String)object3);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(AMSDKBundle.getString("495", (String)object3)).append(" ").append(string).append("\n").append(AMSDKBundle.getString("496", (String)object3)).append(" ").append(string3).append("\n").append(AMSDKBundle.getString("502", (String)object3)).append("\n");
                    if (attr != null) {
                        object = attr.getStringValues();
                        n2 = 0;
                        while (n2 < ((String[])object).length) {
                            stringBuffer.append("    ").append(object[n2]).append("\n");
                            ++n2;
                        }
                    }
                    stringBuffer.append(AMSDKBundle.getString("503", (String)object3)).append("\n");
                    if (attr2 != null) {
                        object = attr2.getStringValues();
                        n2 = 0;
                        while (n2 < ((String[])object).length) {
                            stringBuffer.append("    ").append(object[n2]).append("\n");
                            ++n2;
                        }
                    }
                    object = AMSDKBundle.getString("497", (String)object3);
                    try {
                        aMSendMail.postMail(stringArray, string6, stringBuffer.toString(), (String)object, (String)object2);
                    }
                    catch (Exception exception) {
                        if (!debug.warningEnabled()) continue;
                        debug.warning("AMSDKUtil.sendUserModifyNotification: userDN=" + string, (Throwable)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            debug.error("AMSDKUtil.sendUserModifyNotification: userDN=" + string, (Throwable)exception);
        }
    }

    private static String constructCacheKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = new DN(string).toRFCString();
        String string4 = new DN(string2).toRFCString().toLowerCase();
        stringBuffer.append(string3).append(CACHE_KEY_SEPARATOR).append(string4);
        return stringBuffer.toString();
    }

    static {
        pUserToken = null;
        isUserPluginInitialized = false;
        userEntry = null;
        debug = Debug.getInstance((String)"amProfile");
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            pUserToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (SSOException sSOException) {
            debug.error("AMSDKUtil: Unable to get puser token", (Throwable)sSOException);
        }
    }
}

