/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.InvalidAttributeValueException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AMOrgTemplateImpl
extends AMObjectImpl
implements AMTemplate {
    String serviceName;
    ServiceSchema serviceSchema = null;
    ServiceConfig serviceConfig = null;
    String orgDN;
    Map modAttributes = new HashMap();

    public AMOrgTemplateImpl(SSOToken sSOToken, String string, String string2, ServiceConfig serviceConfig, String string3) throws AMException, SSOException {
        super(sSOToken, string, 13);
        this.serviceName = string2;
        this.serviceConfig = serviceConfig;
        this.orgDN = string3;
        if (this.serviceConfig == null) {
            throw new AMException(AMSDKBundle.getString("485"), "485");
        }
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string2, sSOToken);
            this.serviceSchema = serviceSchemaManager.getSchema(SchemaType.ORGANIZATION);
            if (this.serviceSchema == null) {
                AMObjectImpl.debug.error("AMOrgTemplateImpl:AMOrgTemplateImpl: " + AMSDKBundle.getString("484"));
                throw new AMException(AMSDKBundle.getString("484"), "484");
            }
        }
        catch (SMSException sMSException) {
            AMObjectImpl.debug.error("AMTemplateImpl:AMTemplateImpl", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("484"), "484");
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Set getAttributeSchemas() throws AMException, SSOException {
        return this.serviceSchema.getAttributeSchemas();
    }

    public int getPriority() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setPriority(int n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getType() {
        return 302;
    }

    public Set getPolicyNames() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setAttributes(Map map) {
        this.modAttributes.putAll(map);
    }

    public void store() throws AMException, SSOException {
        Map map = this.modAttributes;
        this.modAttributes = new HashMap();
        try {
            this.serviceConfig.setAttributes(map);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            Object[] objectArray = new Object[]{this.serviceName};
            throw new AMException(AMSDKBundle.getString("481", objectArray), "481", objectArray);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            Object[] objectArray = invalidAttributeValueException.getMessageArgs();
            AMObjectImpl.debug.error("Store exception from SMS: " + invalidAttributeValueException, (Throwable)invalidAttributeValueException);
            throw new AMException(AMSDKBundle.getString("975", objectArray), "975", objectArray);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{this.serviceName};
            AMObjectImpl.debug.error("Store exception from SMS: " + sMSException, (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("486", objectArray), "486", objectArray);
        }
    }

    public Set getAttribute(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        Map map = this.serviceConfig.getAttributes();
        if (string != null && map != null) {
            return (Set)map.get(string);
        }
        return new HashSet();
    }

    public String getStringAttribute(String string) throws AMException, SSOException {
        Set set = this.getAttribute(string);
        if (set != null && set.size() == 1) {
            return (String)set.iterator().next();
        }
        if (set == null || set.isEmpty()) {
            return "";
        }
        throw new AMException(AMSDKBundle.getString("150"), "150");
    }

    public Map getAttributes(Set set) throws AMException, SSOException {
        Map map = this.serviceConfig.getAttributes();
        if (set != null && map != null) {
            HashMap hashMap = new HashMap();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = map.get(string);
                if (v == null) continue;
                hashMap.put(string, v);
            }
            return hashMap;
        }
        return map;
    }

    public void delete(boolean bl) throws AMException, SSOException {
        this.modAttributes = new HashMap();
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(this.serviceName, this.token);
            serviceConfigManager.deleteOrganizationConfig(this.orgDN);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            Object[] objectArray = new Object[]{this.serviceName};
            throw new AMException(AMSDKBundle.getString("481", objectArray), "481", objectArray);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{this.serviceName};
            throw new AMException(AMSDKBundle.getString("913", objectArray), "913", objectArray);
        }
    }

    public boolean isExists() throws SSOException {
        return true;
    }
}

