/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMCrypt;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMEvent;
import com.iplanet.am.sdk.AMEventListener;
import com.iplanet.am.sdk.AMEventManager;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrgTemplateImpl;
import com.iplanet.am.sdk.AMOrganizationImpl;
import com.iplanet.am.sdk.AMOrganizationalUnitImpl;
import com.iplanet.am.sdk.AMPeopleContainerImpl;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMRoleImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSDKUtil;
import com.iplanet.am.sdk.AMSSOTokenListener;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchFilterManager;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMTemplateImpl;
import com.iplanet.am.sdk.AMUserImpl;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.SchemaManager;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.UMSException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class AMObjectImpl
implements AMObject {
    private static final String POLICY_ADMIN_ROLE_NAME = "Organization Policy Admin Role";
    private static final String POLICY_ADMIN_ROLE_PERMISSION = "Organization Policy Admin";
    private static final String ATTR_CONSOLE_ROLE_DISPLAY_OPTION = "iplanet-am-admin-console-role-display-options";
    private static final String ROLE_DISPLAY_ATTR = "iplanet-am-role-display-options";
    private static Map objImplListeners = new HashMap();
    protected static Hashtable profileNameTable = new Hashtable();
    public static AMEventManager amEventMgr = null;
    protected static Debug debug = AMCommonUtils.debug;
    protected AMDirectoryManager dsManager;
    protected AMDirectoryManager amDirectoryManager;
    protected SSOToken internalToken;
    protected SSOToken token;
    protected String entryDN;
    protected int profileType;
    private AMHashMap byteValueModMap;
    private AMHashMap stringValueModMap;
    private AttrSet modAttrSet = new AttrSet();
    private Set listeners = new HashSet();
    private String organizationDN = null;
    private boolean isRegistered = false;

    AMObjectImpl(SSOToken sSOToken, String string, int n) {
        this.entryDN = string;
        this.token = sSOToken;
        this.profileType = n;
        this.dsManager = AMDirectoryWrapper.getInstance();
        this.amDirectoryManager = AMDirectoryManager.getInstance();
        this.stringValueModMap = new AMHashMap(false);
        this.byteValueModMap = new AMHashMap(true);
        this.internalToken = AMCommonUtils.getInternalToken();
    }

    public Set getAssignedServices() throws AMException, SSOException {
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        HashSet<String> hashSet = new HashSet<String>(1);
        Set set = this.getAttribute("objectclass");
        String string = this.getOrganizationDN();
        AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(this.internalToken, string);
        Set set2 = aMOrganizationImpl.getRegisteredServiceNames();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            HashSet<String> hashSet2 = new HashSet<String>(1);
            hashSet2.add(string2);
            Set set3 = AMServiceUtils.getServiceObjectClasses(this.token, hashSet2);
            if (set3.isEmpty()) continue;
            boolean bl = true;
            Iterator iterator2 = set3.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                if (AMCommonUtils.isObjectClassPresent(set, string3)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public void setAttribute(String string, Set set) throws AMException, SSOException {
        Set set2 = AMCommonUtils.getSetCopy(set);
        this.stringValueModMap.put(string, set2);
    }

    public Set getAttribute(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        Map map = this.dsManager.getAttributes(this.token, this.entryDN, hashSet, this.profileType);
        Set set = (Set)map.get(string);
        return set != null ? set : new HashSet();
    }

    public void setAttributeByteArray(String string, byte[][] byArray) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        this.byteValueModMap.put(string, byArray);
    }

    public byte[][] getAttributeByteArray(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        Map map = this.dsManager.getAttributesByteValues(this.token, this.entryDN, hashSet, this.profileType);
        byte[][] byArray = (byte[][])map.get(string);
        return byArray;
    }

    public void setAttributes(Map map) throws AMException, SSOException {
        this.stringValueModMap.copy(map);
    }

    public Map getAttributes() throws AMException, SSOException {
        return this.getAttributes(null);
    }

    public Map getAttributes(Set set) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        Map map = this.dsManager.getAttributes(this.token, this.entryDN, set, this.profileType);
        return map;
    }

    public Map getAttributesFromDataStore() throws AMException, SSOException {
        return this.getAttributesFromDataStore(null);
    }

    public Map getAttributesFromDataStore(Set set) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        Map map = this.amDirectoryManager.getAttributes(this.token, this.entryDN, set, this.profileType);
        return map;
    }

    public void setAttributesByteArray(Map map) throws SSOException, AMException {
        SSOTokenManager.getInstance().validateToken(this.token);
        this.byteValueModMap.copy(map);
    }

    public Map getAttributesByteArray() throws AMException, SSOException {
        return this.getAttributesByteArray(null);
    }

    public Map getAttributesByteArray(Set set) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        Map map = this.dsManager.getAttributesByteValues(this.token, this.entryDN, set, this.profileType);
        return map;
    }

    public void setBooleanAttribute(String string, boolean bl) throws AMException, SSOException {
        if (bl) {
            this.setStringAttribute(string, "true");
        } else {
            this.setStringAttribute(string, "false");
        }
    }

    public boolean getBooleanAttribute(String string) throws AMException, SSOException {
        Set set = this.getAttribute(string);
        if (set.size() == 1) {
            String string2 = (String)set.iterator().next();
            if (string2.equalsIgnoreCase("true")) {
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                return false;
            }
            throw new AMException(AMSDKBundle.getString("154"), "154");
        }
        if (set.size() == 0) {
            throw new AMException(AMSDKBundle.getString("155"), "155");
        }
        throw new AMException(AMSDKBundle.getString("154"), "154");
    }

    public String getDN() {
        return this.entryDN;
    }

    public boolean isExists() throws SSOException {
        if (!DN.isDN(this.entryDN)) {
            return false;
        }
        SSOTokenManager.getInstance().validateToken(this.token);
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.isExists(): DN=" + this.entryDN);
        }
        return this.dsManager.doesEntryExists(this.token, this.entryDN);
    }

    public void setIntegerAttribute(String string, int n) throws AMException, SSOException {
        this.setStringAttribute(string, "" + n);
    }

    public int getIntegerAttribute(String string) throws AMException, SSOException {
        Set set = this.getAttribute(string);
        if (set.size() == 1) {
            try {
                String string2 = (String)set.iterator().next();
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AMException(AMSDKBundle.getString("152"), "152");
            }
        }
        if (set.size() == 0) {
            throw new AMException(AMSDKBundle.getString("153"), "153");
        }
        throw new AMException(AMSDKBundle.getString("152"), "152");
    }

    public String getOrganizationDN() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        if (this.organizationDN == null) {
            this.organizationDN = this.dsManager.getOrganizationDN(this.token, this.entryDN);
        }
        return this.organizationDN;
    }

    public String getParentDN() {
        if (this.entryDN.equalsIgnoreCase(AMStoreConnection.rootSuffix)) {
            return null;
        }
        return new DN(this.entryDN).getParent().toString();
    }

    public Map getPolicy(String string) throws UnsupportedOperationException, AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.getPolicy(" + string + "): DN=" + this.entryDN);
        }
        try {
            Set set = AMServiceUtils.getServiceAttributeNames(this.token, string, SchemaType.POLICY);
            Map map = this.getAttributes(set);
            return map;
        }
        catch (SMSException sMSException) {
            if (debug.messageEnabled()) {
                debug.message("AMObjectImpl.getPolicy(" + string + ")", (Throwable)sMSException);
            }
            throw new AMException(AMSDKBundle.getString("498"), "498");
        }
    }

    public AMTemplate getPolicyTemplate(String string) throws UnsupportedOperationException, AMException, SSOException {
        return this.getTemplate(string, 300);
    }

    public Map getServiceAttributes(String string) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.getServiceAttributes(" + string + "): DN=" + this.entryDN);
        }
        try {
            Set set = AMServiceUtils.getServiceAttributeNames(this.token, string, SchemaType.DYNAMIC);
            Set set2 = AMServiceUtils.getServiceAttributeNames(this.token, string, SchemaType.GLOBAL);
            if (!set2.isEmpty()) {
                if (set.size() == 0) {
                    set = set2;
                } else {
                    set.addAll(set2);
                }
            }
            if (!(set2 = AMServiceUtils.getServiceAttributeNames(this.token, string, SchemaType.USER)).isEmpty()) {
                if (set.size() == 0) {
                    set = set2;
                } else {
                    set.addAll(set2);
                }
            }
            return this.getAttributes(set);
        }
        catch (SMSException sMSException) {
            if (debug.messageEnabled()) {
                debug.message("AMObjectImpl.getServiceAttributes(" + string + ")", (Throwable)sMSException);
            }
            throw new AMException(AMSDKBundle.getString("915"), "915");
        }
    }

    public void setServiceStatus(String string, String string2) throws AMException, SSOException {
        Object object;
        String string3 = null;
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        Set set = this.getAssignedServices();
        if (!set.contains(string)) {
            throw new AMException(AMSDKBundle.getString("126"), "126");
        }
        try {
            object = new ServiceSchemaManager(string, this.internalToken);
            ServiceSchema serviceSchema = null;
            if (this.profileType == 1) {
                serviceSchema = ((ServiceSchemaManager)object).getSchema(SchemaType.USER);
            } else if (this.profileType == 2 || this.profileType == 3) {
                serviceSchema = ((ServiceSchemaManager)object).getSchema(SchemaType.DOMAIN);
            } else if (this.profileType == 10 || this.profileType == 11 || this.profileType == 12 || this.profileType == 9) {
                serviceSchema = ((ServiceSchemaManager)object).getSchema(SchemaType.GROUP);
            }
            string3 = serviceSchema.getStatusAttribute();
        }
        catch (SMSException sMSException) {
            debug.error("AMObjectImpl.setServiceStatus: SMSException: ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("908"), "908");
        }
        object = new HashSet();
        object.add(string2);
        if (string3 == null) {
            throw new AMException(AMSDKBundle.getString("705"), "705");
        }
        this.setAttribute(string3, (Set)object);
        this.store();
    }

    public String getServiceStatus(String string) throws AMException, SSOException {
        Object object;
        Object object2;
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        String string2 = null;
        try {
            object2 = new ServiceSchemaManager(string, this.internalToken);
            object = null;
            if (this.profileType == 1) {
                object = ((ServiceSchemaManager)object2).getSchema(SchemaType.USER);
            } else if (this.profileType == 2 || this.profileType == 3) {
                object = ((ServiceSchemaManager)object2).getSchema(SchemaType.DOMAIN);
            } else if (this.profileType == 10 || this.profileType == 11 || this.profileType == 12 || this.profileType == 9) {
                object = ((ServiceSchemaManager)object2).getSchema(SchemaType.GROUP);
            }
            if (object != null) {
                string2 = ((ServiceSchema)object).getStatusAttribute();
            }
        }
        catch (SMSException sMSException) {
            debug.error("AMObjectImpl.getServiceStatus: SMSException: ", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("908"), "908");
        }
        if (string2 != null) {
            object2 = this.getAttribute(string2);
            if (object2 == null || object2.isEmpty()) {
                return null;
            }
            object = object2.iterator();
            return (String)object.next();
        }
        return null;
    }

    public void setStringAttribute(String string, String string2) throws AMException, SSOException {
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string2);
        this.stringValueModMap.put(string, hashSet);
    }

    public String getStringAttribute(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        Map map = this.dsManager.getAttributes(this.token, this.entryDN, hashSet, this.profileType);
        Set set = (Set)map.get(string);
        if (set != null && set.size() == 1) {
            return (String)set.iterator().next();
        }
        if (set == null || set.isEmpty()) {
            return "";
        }
        throw new AMException(AMSDKBundle.getString("150"), "150");
    }

    public AMTemplate getTemplate(String string, int n) throws UnsupportedOperationException, AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        if (this.profileType != 2 && this.profileType != 6 && this.profileType != 3 && this.profileType != 8) {
            throw new UnsupportedOperationException();
        }
        if (n == 302) {
            if (this.profileType != 3 && this.profileType != 2) {
                throw new UnsupportedOperationException();
            }
            ServiceConfig serviceConfig = AMServiceUtils.getOrgConfig(this.token, new DN(this.entryDN).toRFCString(), string);
            if (serviceConfig == null) {
                Object[] objectArray = new Object[]{string};
                throw new AMException(AMSDKBundle.getString("480", objectArray), "480", objectArray);
            }
            return new AMOrgTemplateImpl(this.token, serviceConfig.getDN(), string, serviceConfig, new DN(this.entryDN).toRFCString());
        }
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.getTemplate(" + string + ", " + n + "): DN=" + this.entryDN);
        }
        String string2 = this.dsManager.getAMTemplateDN(this.token, new DN(this.entryDN).toRFCString(), this.profileType, string, n);
        return new AMTemplateImpl(this.token, string2, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(AMEventListener aMEventListener) throws SSOException {
        Object object;
        SSOTokenManager.getInstance().validateToken(this.token);
        if (!this.isRegistered) {
            if (debug.messageEnabled()) {
                debug.message("AMObjectImpl.addEventListener(..): registering this instance to obj*Impl table");
            }
            try {
                AMObjectImpl.addToProfileNameTable(this.token, this.entryDN);
            }
            catch (SSOException sSOException) {
                debug.message("AMObjectImpl.addEventListener(): " + sSOException.toString());
                throw sSOException;
            }
            object = objImplListeners;
            synchronized (object) {
                HashSet<AMObjectImpl> hashSet = (HashSet<AMObjectImpl>)objImplListeners.get(this.entryDN);
                if (hashSet == null) {
                    hashSet = new HashSet<AMObjectImpl>();
                    objImplListeners.put(this.entryDN.toLowerCase(), hashSet);
                }
                hashSet.add(this);
                this.isRegistered = true;
            }
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.add(aMEventListener);
        }
    }

    public void assignPolicies(String string, Set set) throws AMException, SSOException {
        if (set == null || set.size() == 0) {
            return;
        }
        AMTemplate aMTemplate = this.getTemplate(string, 300);
        if (aMTemplate.isExists()) {
            HashSet hashSet = new HashSet();
            Set set2 = aMTemplate.getAttribute("iplanet-am-named-policy-dn");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!set2.contains(string2)) continue;
                throw new AMException(AMSDKBundle.getString("488"), "488");
            }
            set2.addAll(set);
            this.setPolicyTemplate(aMTemplate, set2);
        } else {
            this.createTemplate(300, string, null, -1, set);
        }
    }

    public void assignServices(Map map) throws AMException, SSOException {
        this.assignServices(map, true);
    }

    public void assignServices(Map map, boolean bl) throws AMException, SSOException {
        Object object;
        Map map2;
        Object object2;
        Object object3;
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        if (map == null || map.isEmpty()) {
            return;
        }
        Set set = new HashSet();
        Set<Object> set2 = new HashSet();
        if (bl) {
            object3 = this.getAssignedServices();
            object2 = map.keySet();
            map2 = object2.iterator();
            while (map2.hasNext()) {
                object = (String)map2.next();
                if (!object3.contains(object)) {
                    set2.add(object);
                    continue;
                }
                if (!debug.warningEnabled()) continue;
                debug.warning("AMObjectImpl.assignService()-> " + (String)object + " is already assigned to " + this.entryDN);
            }
            object = null;
            object = this.profileType == 2 ? this.dsManager.getRegisteredServiceNames(this.internalToken, this.entryDN) : this.dsManager.getRegisteredServiceNames(this.internalToken, this.getOrganizationDN());
            map2 = set2.iterator();
            while (map2.hasNext()) {
                if (object.contains((String)map2.next())) continue;
                throw new AMException(AMSDKBundle.getString("126"), "126");
            }
        } else {
            set2 = map.keySet();
        }
        set = AMServiceUtils.getServiceObjectClasses(this.token, set2);
        if (bl) {
            object3 = this.getAttribute("objectclass");
            set = AMCommonUtils.combineOCs(set, (Set)object3);
        }
        this.setAttribute("objectclass", set);
        object3 = set2.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            map2 = (Map)map.get(object2);
            if (map2 == null || map2.isEmpty()) {
                map2 = new HashMap();
            }
            try {
                object = new ServiceSchemaManager((String)object2, this.internalToken);
                ServiceSchema serviceSchema = null;
                Object[] objectArray = new Object[]{object2};
                if (this.profileType == 1) {
                    serviceSchema = ((ServiceSchemaManager)object).getSchema(SchemaType.USER);
                    if (serviceSchema == null) {
                        serviceSchema = ((ServiceSchemaManager)object).getSchema(SchemaType.DYNAMIC);
                    }
                } else if (this.profileType == 2 || this.profileType == 3) {
                    serviceSchema = ((ServiceSchemaManager)object).getSchema(SchemaType.DOMAIN);
                } else if (this.profileType == 10 || this.profileType == 11 || this.profileType == 12 || this.profileType == 9) {
                    serviceSchema = ((ServiceSchemaManager)object).getSchema(SchemaType.GROUP);
                }
                if (serviceSchema == null) {
                    debug.warning(AMSDKBundle.getString("1001"));
                    throw new AMException(AMSDKBundle.getString("1001", objectArray), "1001", objectArray);
                }
                if (serviceSchema.getServiceType() != SchemaType.DYNAMIC) {
                    map2 = serviceSchema.validateAndInheritDefaults(map2, true);
                }
                map2 = AMCommonUtils.removeEmptyValues(map2);
            }
            catch (SMSException sMSException) {
                debug.error("AMObjectImpl:assignService-> unable to validate attributes for " + (String)object2, (Throwable)sMSException);
                throw new AMException(AMSDKBundle.getString("908"), "908");
            }
            this.setAttributes(map2);
        }
        if (bl) {
            this.store();
        }
    }

    public void create() throws AMException, SSOException {
        block44: {
            block43: {
                Object object;
                Object object2;
                block37: {
                    SSOTokenManager.getInstance().validateToken(this.token);
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.create(): DN=" + this.entryDN);
                    }
                    DN dN = new DN(this.entryDN);
                    String string = dN.getParent().toString();
                    String string2 = ((RDN)dN.getRDNs().firstElement()).getValues()[0];
                    this.validateAttributeUniqueness(true);
                    if (this.profileType == 1) {
                        object2 = new AMUserImpl(this.token, this.token.getPrincipal().getName());
                        object = ((AMUserImpl)object2).getRoleDNs();
                        if (object.size() > 0) {
                            this.stringValueModMap.put("iplanet-am-modifiable-by", object);
                        }
                        this.stringValueModMap = this.integrateLocale();
                    }
                    this.dsManager.createEntry(this.token, string2, this.profileType, string, this.stringValueModMap);
                    if (this.profileType == 2 || this.profileType == 3) {
                        object2 = AMNamingAttrManager.getNamingAttr(5) + "=People," + this.entryDN;
                        try {
                            object = new AMPeopleContainerImpl(this.token, (String)object2);
                            ((AMObjectImpl)object).createAdminRole();
                        }
                        catch (Exception exception) {
                            if (!debug.messageEnabled()) break block37;
                            debug.message("AMObject.create: Unable to create admin role for " + (String)object2 + exception);
                        }
                    }
                }
                if (this.profileType == 2 || this.profileType == 3) {
                    String string;
                    AMRoleImpl aMRoleImpl;
                    block41: {
                        String string3;
                        AMRoleImpl aMRoleImpl2;
                        String string4;
                        block39: {
                            String string5;
                            if (this.profileType == 2) {
                                object2 = "Organization Admin Role";
                                object = "Organization Help Desk Admin Role";
                                string5 = "Organization Admin";
                                string4 = "Organization Help Desk Admin";
                            } else {
                                object2 = "Container Admin Role";
                                object = "Container Help Desk Admin Role";
                                string5 = "Container Admin";
                                string4 = "Container Help Desk Admin";
                            }
                            String string6 = AMNamingAttrManager.getNamingAttr(6) + "=" + (String)object2 + "," + this.entryDN;
                            AMRoleImpl aMRoleImpl3 = new AMRoleImpl(this.token, string6);
                            if (aMRoleImpl3.isExists()) {
                                block38: {
                                    try {
                                        this.setRoleAciDescAciList(aMRoleImpl3, string5);
                                        this.setAciForRole(aMRoleImpl3);
                                    }
                                    catch (Exception exception) {
                                        if (!debug.messageEnabled()) break block38;
                                        debug.message("AMObject.create: Unable to set aci or org admin role. ", (Throwable)exception);
                                    }
                                }
                                try {
                                    aMRoleImpl3.setStringAttribute("iplanet-am-role-managed-container-dn", this.entryDN);
                                    aMRoleImpl3.store();
                                }
                                catch (Exception exception) {
                                    if (!debug.warningEnabled()) break block39;
                                    debug.warning("AMObject.create: Unable to set managed dn for org admin role.", (Throwable)exception);
                                }
                            }
                        }
                        if ((aMRoleImpl2 = new AMRoleImpl(this.token, string3 = AMNamingAttrManager.getNamingAttr(6) + "=" + (String)object + "," + this.entryDN)).isExists()) {
                            block40: {
                                try {
                                    this.setRoleAciDescAciList(aMRoleImpl2, string4);
                                    this.setAciForRole(aMRoleImpl2);
                                }
                                catch (Exception exception) {
                                    if (!debug.messageEnabled()) break block40;
                                    debug.message("AMObject.create: Unable to set aci or org help desk admin role. ", (Throwable)exception);
                                }
                            }
                            try {
                                aMRoleImpl2.setStringAttribute("iplanet-am-role-managed-container-dn", this.entryDN);
                                aMRoleImpl2.store();
                            }
                            catch (Exception exception) {
                                if (!debug.warningEnabled()) break block41;
                                debug.warning("AMObject.create: Unable to set managed dn for org help role.", (Throwable)exception);
                            }
                        }
                    }
                    if ((aMRoleImpl = new AMRoleImpl(this.token, string = AMNamingAttrManager.getNamingAttr(6) + "=" + POLICY_ADMIN_ROLE_NAME + "," + this.entryDN)).isExists()) {
                        block42: {
                            try {
                                this.setRoleAciDescAciList(aMRoleImpl, POLICY_ADMIN_ROLE_PERMISSION);
                                this.setAciForRole(aMRoleImpl);
                            }
                            catch (Exception exception) {
                                if (!debug.messageEnabled()) break block42;
                                debug.message("AMObject.create: Unable to set aci or org policy admin role. ", (Throwable)exception);
                            }
                        }
                        try {
                            aMRoleImpl.setStringAttribute("iplanet-am-role-managed-container-dn", this.entryDN);
                            aMRoleImpl.store();
                        }
                        catch (Exception exception) {
                            if (debug.warningEnabled()) {
                                debug.warning("AMObject.create: Unable to set managed dn for org policy admin role.", (Throwable)exception);
                            }
                        }
                    }
                } else {
                    if (this.profileType == 9 || this.profileType == 11 || this.profileType == 12 || this.profileType == 5) {
                        try {
                            if (!AMDCTree.isRequired()) {
                                this.createAdminRole();
                            }
                            break block43;
                        }
                        catch (Exception exception) {
                            if (debug.messageEnabled()) {
                                debug.message("AMObject.create: Unable to create admin role for " + this.entryDN + exception);
                            }
                            break block43;
                        }
                    }
                    if (this.profileType == 6 || this.profileType == 8) {
                        this.setAciForRole((AMRole)((Object)this));
                    }
                }
            }
            if (this.profileType == 9 || this.profileType == 11 || this.profileType == 12) {
                try {
                    if (!AMDCTree.isRequired()) {
                        this.setAciBasedOnGroupPclist();
                    }
                }
                catch (Exception exception) {
                    if (!debug.messageEnabled()) break block44;
                    debug.message("AMObject.create: Unable to set aci based on group pclist for " + this.entryDN + exception);
                }
            }
        }
        this.stringValueModMap.clear();
        if (!this.byteValueModMap.isEmpty()) {
            this.byteValueModMap.clear();
        }
    }

    public AMTemplate createPolicyTemplate(String string, Map map) throws UnsupportedOperationException, AMException, SSOException {
        return this.createPolicyTemplate(string, map, -1);
    }

    public AMTemplate createPolicyTemplate(String string, Map map, int n) throws UnsupportedOperationException, AMException, SSOException {
        return this.createTemplate(300, string, map, n);
    }

    public AMTemplate createTemplate(int n, String string, Map map) throws UnsupportedOperationException, AMException, SSOException {
        return this.createTemplate(n, string, map, -1);
    }

    public AMTemplate createTemplate(int n, String string, Map map, int n2) throws UnsupportedOperationException, AMException, SSOException {
        return this.createTemplate(n, string, map, n2, null);
    }

    public AMTemplate createTemplate(int n, String string, Map map, int n2, Set set) throws UnsupportedOperationException, AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        if (this.profileType != 2 && this.profileType != 6 && this.profileType != 3 && this.profileType != 8) {
            throw new UnsupportedOperationException();
        }
        if (n == 302) {
            if (this.profileType != 3 && this.profileType != 2) {
                throw new UnsupportedOperationException();
            }
            ServiceConfig serviceConfig = AMServiceUtils.createOrgConfig(this.token, this.entryDN, string, map);
            return new AMOrgTemplateImpl(this.token, serviceConfig.getDN(), string, serviceConfig, this.entryDN);
        }
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.createTemplate(" + n + ", " + string + ", Map, " + n2 + "): DN=" + this.entryDN);
        }
        if (map == null) {
            try {
                map = AMServiceUtils.getServiceConfig(this.token, string, SchemaType.DYNAMIC);
            }
            catch (SMSException sMSException) {
                if (debug.messageEnabled()) {
                    debug.message("AMObjectImpl.createTemplate(" + n + ", " + string + ", Map, " + n2 + ")", (Throwable)sMSException);
                }
                throw new AMException(AMSDKBundle.getString("451"), "451");
            }
        }
        ServiceSchemaManager serviceSchemaManager = null;
        ServiceSchema serviceSchema = null;
        try {
            serviceSchemaManager = new ServiceSchemaManager(string, this.token);
            serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
        }
        catch (SMSException sMSException) {
            debug.error("AMObjectImpl.createTemplate()", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("484"), "484");
        }
        if (serviceSchema == null) {
            throw new AMException(AMSDKBundle.getString("484"), "484");
        }
        map = AMCrypt.encryptPasswords(map, serviceSchema);
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.createTemplate(): attributes encrypted: " + map);
        }
        map = this.integrateLocaleForTemplateCreation(map);
        String string2 = this.dsManager.createAMTemplate(this.token, new DN(this.entryDN).toRFCString(), this.profileType, string, map, n2);
        return new AMTemplateImpl(this.token, string2, string, n);
    }

    public void delete(boolean bl) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        if (AMCompliance.isComplianceUserDeletionEnabled()) {
            switch (this.profileType) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 21: {
                    AMCompliance.verifyAndDeleteObject(this.token, new DN(this.entryDN).toRFCString());
                    return;
                }
                case 6: 
                case 8: {
                    this.purge(bl, -1);
                    return;
                }
                case 5: {
                    String string = this.getSearchFilter(5);
                    String string2 = this.getSearchFilter(1);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("(|").append(string).append(string2);
                    stringBuffer.append(")");
                    String string3 = stringBuffer.toString();
                    Set set = new HashSet();
                    try {
                        set = this.search(1, string3);
                    }
                    catch (AMException aMException) {
                        String string4 = aMException.getLDAPErrorCode();
                        int n = Integer.parseInt(string4);
                        if (string4 != null && (n == 4 || n == 11)) {
                            throw new AMException(AMSDKBundle.getString("977"), "977");
                        }
                        if (debug.messageEnabled()) {
                            debug.message("AMObjectImpl.delete people container" + aMException);
                        }
                        throw aMException;
                    }
                    if (set != null && !set.isEmpty()) {
                        throw new AMException(AMSDKBundle.getString("977"), "977");
                    }
                    this.purge(bl, -1);
                    return;
                }
                case 4: {
                    String string = this.getSearchFilter(4);
                    String string5 = this.getSearchFilter(9);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("(|").append(string).append(string5);
                    stringBuffer.append(")");
                    String string6 = stringBuffer.toString();
                    Set set = new HashSet();
                    try {
                        set = this.search(1, string6);
                    }
                    catch (AMException aMException) {
                        String string7 = aMException.getLDAPErrorCode();
                        int n = Integer.parseInt(string7);
                        if (string7 != null && (n == 4 || n == 11)) {
                            throw new AMException(AMSDKBundle.getString("977"), "977");
                        }
                        if (debug.messageEnabled()) {
                            debug.message("AMObjectImpl.delete group container " + aMException);
                        }
                        throw aMException;
                    }
                    if (set != null && !set.isEmpty()) {
                        throw new AMException(AMSDKBundle.getString("977"), "977");
                    }
                    this.purge(bl, -1);
                    return;
                }
            }
            this.purge(bl, -1);
            return;
        }
        this.purge(bl, -1);
    }

    public void delete() throws AMException, SSOException {
        this.delete(false);
    }

    public void modifyService(String string, Map map) throws AMException, SSOException {
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        if (map == null || map.isEmpty() || string == null) {
            return;
        }
        Set set = this.getAssignedServices();
        HashSet hashSet = new HashSet();
        if (!set.contains(string)) {
            throw new AMException(AMSDKBundle.getString("126"), "126");
        }
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.internalToken);
            ServiceSchema serviceSchema = null;
            if (this.profileType == 1) {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
            } else if (this.profileType == 2 || this.profileType == 3) {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.DOMAIN);
            } else if (this.profileType == 10 || this.profileType == 11 || this.profileType == 12 || this.profileType == 9) {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.GROUP);
            }
            map = serviceSchema.validateAndInheritDefaults(map, false);
        }
        catch (SMSException sMSException) {
            debug.error("AMObjectImpl:modifyService-> unable to validate attributes for " + string, (Throwable)sMSException);
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("976", objectArray), "976", objectArray);
        }
        this.setAttributes(map);
        this.store();
    }

    public void purge(boolean bl, int n) throws AMException, SSOException {
        Object object;
        block15: {
            if (debug.messageEnabled()) {
                debug.message("AMObjectImpl.delete(): DN=" + this.entryDN + " recursive=" + bl + "graceperiod= " + n);
            }
            if (this.entryDN.equals(AMStoreConnection.defaultOrg)) {
                throw new AMException(AMSDKBundle.getString("160"), "160");
            }
            if (n > -1 && n < AMStoreConnection.daysSinceModified(this.entryDN)) {
                if (debug.messageEnabled()) {
                    debug.message("AMObjectImpl.purge-> " + this.entryDN + "will not be purged. Grace period= " + n + " has not expired");
                }
                throw new AMException(AMSDKBundle.getString("974"), "974");
            }
            if (this.profileType == 9 || this.profileType == 11 || this.profileType == 12 || this.profileType == 5) {
                block14: {
                    try {
                        this.removeAdminRoleAci(bl);
                    }
                    catch (Exception exception) {
                        if (!debug.messageEnabled()) break block14;
                        debug.message("AMObjectImpl.delete: Unable to remove admin role aci." + exception);
                    }
                }
                try {
                    this.dsManager.removeAdminRole(this.token, this.entryDN, bl);
                }
                catch (Exception exception) {
                    if (!debug.messageEnabled()) break block15;
                    debug.message("AMObjectImpl.delete: " + exception.getMessage());
                }
            }
        }
        Set set = null;
        Set set2 = null;
        if (this.profileType == 6 || this.profileType == 8) {
            set = this.findRemovableAciList(this.getAttribute("iplanet-am-role-aci-list"));
            object = "(&(objectclass=costemplate)(cn=\"" + this.entryDN + "\"))";
            set2 = this.dsManager.search(this.token, this.getOrganizationDN(), (String)object, 2);
        }
        this.dsManager.removeEntry(this.token, this.entryDN, this.profileType, bl, false);
        if (set != null) {
            this.removeAci(set);
        }
        if (set2 != null && !set2.isEmpty()) {
            object = set2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                this.dsManager.removeEntry(this.token, string, 13, bl, false);
            }
        }
        this.stringValueModMap.clear();
        if (!this.byteValueModMap.isEmpty()) {
            this.byteValueModMap.clear();
        }
    }

    public void removeAttributes(Set set) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.removeAttributes(Set): DN=" + this.entryDN + "\n" + set);
        }
        Iterator iterator = set.iterator();
        HashMap<String, Set> hashMap = new HashMap<String, Set>(set.size());
        HashMap<String, Set> hashMap2 = new HashMap<String, Set>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashMap.put(string, Collections.EMPTY_SET);
            if (AMCommonUtils.integrateLocale && string.equalsIgnoreCase("preferredLanguage")) {
                hashMap2.put("preferredLocale", Collections.EMPTY_SET);
            }
            if (!AMCommonUtils.integrateLocale || !string.equalsIgnoreCase("preferredLocale")) continue;
            hashMap2.put("preferredLanguage", Collections.EMPTY_SET);
        }
        this.dsManager.setAttributes(this.token, this.entryDN, this.profileType, hashMap, null, false);
        if (!hashMap2.isEmpty()) {
            try {
                this.dsManager.setAttributes(this.token, this.entryDN, this.profileType, hashMap2, null, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stringValueModMap.removeKeys(set);
        if (!this.byteValueModMap.isEmpty()) {
            this.byteValueModMap.removeKeys(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(AMEventListener aMEventListener) {
        boolean bl = false;
        Set set = this.listeners;
        synchronized (set) {
            bl = this.listeners.remove(aMEventListener);
        }
        if (bl && this.listeners.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("AMObjectImpl.removeEventListener(..): private listener table empty for this instance");
            }
            Map map = objImplListeners;
            synchronized (map) {
                Set set2 = (Set)objImplListeners.get(this.entryDN);
                if (set2 != null) {
                    set2.remove(this);
                    if (set2.isEmpty()) {
                        objImplListeners.remove(this.entryDN);
                    }
                }
                this.isRegistered = false;
            }
            AMObjectImpl.removeFromProfileNameTable(this.token, this.entryDN);
        }
    }

    public Set search(int n, String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.search(" + n + ", " + string + "): DN=" + this.entryDN);
        }
        return this.dsManager.search(this.token, this.entryDN, string, n);
    }

    public Set searchObjects(String string, String string2, String string3, Map map, int n) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.searchObjects(" + string + ", " + string2 + ", " + string3 + ", Map): DN=" + this.entryDN + ", level " + n + "\n" + this.mapToString(map));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&").append(AMObjectImpl.constructFilter(string, string2, string3));
        if (map != null && map.size() > 0) {
            stringBuffer.append(AMObjectImpl.constructFilter(map));
        }
        stringBuffer.append(")");
        if (debug.messageEnabled()) {
            debug.message("    filter: " + stringBuffer.toString());
        }
        return this.search(n, stringBuffer.toString());
    }

    public void store() throws AMException, SSOException {
        this.store(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(boolean bl) throws AMException, SSOException {
        try {
            Set set;
            block20: {
                Set set2;
                block18: {
                    block17: {
                        SSOTokenManager.getInstance().validateToken(this.token);
                        if (debug.messageEnabled()) {
                            debug.message("AMObjectImpl.store(): DN=" + this.entryDN + "\n" + AMCommonUtils.mapSetToString(this.stringValueModMap));
                        }
                        this.validateAttributeUniqueness(false);
                        if (this.profileType == 2 && this.stringValueModMap.containsKey("sunOrganizationAlias")) {
                            set2 = this.getAttribute("objectclass");
                            set = (Set)this.stringValueModMap.get("objectclass");
                            set = set == null || set == Collections.EMPTY_SET ? set2 : AMCommonUtils.combineOCs(set, set2);
                            set.add("sunISManagedOrganization");
                            this.stringValueModMap.put("objectclass", set);
                        }
                        this.stringValueModMap = this.integrateLocale();
                        set2 = null;
                        if (this.stringValueModMap.containsKey("iplanet-am-role-aci-list")) {
                            try {
                                set2 = this.findRemovableAciList(this.getAttribute("iplanet-am-role-aci-list"));
                            }
                            catch (Exception exception) {
                                if (!debug.messageEnabled()) break block17;
                                debug.message("AMObjectImpl.store: Failed to get old iplanet-am-role-aci-list");
                            }
                        }
                    }
                    set = null;
                    if (this.profileType == 9 && this.stringValueModMap.containsKey("uniquemember")) {
                        try {
                            set = this.getAttribute("uniquemember");
                        }
                        catch (Exception exception) {
                            if (!debug.messageEnabled()) break block18;
                            debug.message("AMObjectImpl.store: Failed to get old uniquemember");
                        }
                    }
                }
                this.dsManager.setAttributes(this.token, this.entryDN, this.profileType, this.stringValueModMap, this.byteValueModMap, bl);
                if (this.stringValueModMap.containsKey("iplanet-am-role-aci-list")) {
                    block19: {
                        try {
                            this.removeAci(set2);
                        }
                        catch (Exception exception) {
                            if (!debug.messageEnabled()) break block19;
                            debug.message("AMObjectImpl.store: Failed to remove old acis");
                        }
                    }
                    try {
                        this.setAciForRole(new AMRoleImpl(this.token, this.entryDN));
                    }
                    catch (Exception exception) {
                        if (!debug.messageEnabled()) break block20;
                        debug.message("AMObjectImpl.store: Failed to add new acis");
                    }
                }
            }
            if (this.profileType == 9 && this.stringValueModMap.containsKey("uniquemember")) {
                if (set != null) {
                    this.dsManager.updateUserAttribute(this.token, set, this.entryDN, false);
                }
                Set set3 = (Set)this.stringValueModMap.get("uniquemember");
                this.dsManager.updateUserAttribute(this.token, set3, this.entryDN, true);
            }
            Object var6_9 = null;
            this.stringValueModMap.clear();
            this.byteValueModMap.clear();
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.stringValueModMap.clear();
            this.byteValueModMap.clear();
            throw throwable;
        }
    }

    public void unassignPolicies(String string, Set set) throws AMException, SSOException {
        this.unassignPolicies(string, set, true);
    }

    public void unassignServices(Set set) throws AMException, SSOException {
        HashSet<String> hashSet;
        String string;
        Iterator<Object> iterator;
        Object object;
        Object object2;
        if (set == null || set.isEmpty()) {
            return;
        }
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        Set set2 = this.getAssignedServices();
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            object2 = (String)iterator2.next();
            if (set2.contains(object2)) continue;
            debug.error(AMSDKBundle.getString("126"));
            throw new AMException(AMSDKBundle.getString("126"), "126");
        }
        object2 = AMServiceUtils.getServiceObjectClasses(this.token, set);
        Set set3 = this.getAttribute("objectclass");
        object2 = AMCommonUtils.updateAndGetRemovableOCs(set3, (Set)object2);
        HashSet<String> hashSet2 = new HashSet<String>();
        try {
            object = SchemaManager.getSchemaManager(this.token);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                hashSet = new HashSet<String>(((SchemaManager)object).getAttributes(string));
                Iterator iterator3 = hashSet.iterator();
                while (iterator3.hasNext()) {
                    String string2 = (String)iterator3.next();
                    hashSet2.add(string2.toLowerCase());
                }
            }
        }
        catch (UMSException uMSException) {
            debug.error(AMSDKBundle.getString("127"), (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("127"), "127");
        }
        object = this.getAttributes();
        iterator = object.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!hashSet2.contains(string)) continue;
            try {
                hashSet = new HashSet();
                hashSet.add(string);
                this.removeAttributes(hashSet);
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) continue;
                debug.message("AMUserImpl.unassignServices()Error occured while removing attribute: " + string);
            }
        }
        this.setAttribute("objectclass", set3);
        this.store();
    }

    protected static String constructFilter(String string) {
        int n = string.indexOf("%U");
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n)).append("*");
        int n2 = string.indexOf("%V");
        if (n2 == -1) {
            stringBuffer.append(string.substring(n + 2));
        } else {
            stringBuffer.append(string.substring(n + 2, n2)).append("*").append(string.substring(n2 + 2));
        }
        return stringBuffer.toString();
    }

    protected static String constructFilter(String string, String string2, String string3) {
        String string4;
        String string5;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.indexOf("%U");
        int n2 = string2.indexOf("%V");
        if (n == -1 && n2 == -1) {
            stringBuffer.append("(&(").append(string).append("=").append(string3).append(")").append(string2).append(")");
            string2 = stringBuffer.toString();
            return string2;
        }
        int n3 = string3.indexOf("@");
        if (n3 == -1) {
            string5 = string3;
            string4 = "*";
        } else {
            string5 = string3.substring(0, n3);
            string4 = string3.substring(n3 + 1);
        }
        while (n != -1) {
            stringBuffer.append(string2.substring(0, n)).append(string3).append(string2.substring(n + 2));
            string2 = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            n = string2.indexOf("%U");
        }
        while (n2 != -1) {
            stringBuffer.append(string2.substring(0, n2)).append(string3).append(string2.substring(n2 + 2));
            string2 = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            n2 = string2.indexOf("%V");
        }
        return string2;
    }

    protected static String constructFilter(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = ((Set)map.get(string)).iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                stringBuffer.append("(").append(string).append("=").append(string2).append(")");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected String getSearchFilter(int n) {
        return this.getSearchFilter(n, null);
    }

    protected String getSearchFilter(int n, String string) {
        try {
            return AMSearchFilterManager.getSearchFilter(n, this.getOrganizationDN(), string, false);
        }
        catch (Exception exception) {
            return AMSearchFilterManager.getGlobalSearchFilter(n, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyACIChangeEvent(DSEvent dSEvent) {
        if (debug.messageEnabled()) {
            debug.message("In AMObjectImpl.notifyACIChangeEvent(..): ");
        }
        Map map = objImplListeners;
        synchronized (map) {
            if (objImplListeners.isEmpty()) {
                return;
            }
            int n = dSEvent.getEventType();
            AMEvent aMEvent = new AMEvent(dSEvent, n);
            switch (n) {
                case 4: 
                case 8: {
                    if (debug.messageEnabled()) {
                        debug.message("In AMObjectImpl.notifyACIChangeEvent(..): ACI Entry renamed/changed event");
                    }
                    AMObjectImpl.notifyAffectedDNs(dSEvent.getID().toLowerCase(), aMEvent);
                    break;
                }
                case 2: {
                    Set set;
                    if (debug.messageEnabled()) {
                        debug.message("In AMObjectImpl.notifyACIChangeEvent(..): ACI Entry removed event");
                    }
                    if ((set = (Set)objImplListeners.get(dSEvent.getID().toLowerCase())) == null) {
                        return;
                    }
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        AMObjectImpl aMObjectImpl = (AMObjectImpl)iterator.next();
                        aMObjectImpl.sendEvents(aMEvent);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyEntryEvent(DSEvent dSEvent, String string, boolean bl) {
        Map map = objImplListeners;
        synchronized (map) {
            if (objImplListeners.isEmpty()) {
                return;
            }
            int n = dSEvent.getEventType();
            string = string.toLowerCase();
            AMEvent aMEvent = new AMEvent(dSEvent, n);
            switch (n) {
                case 1: {
                    if (!bl) break;
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.notifyEntryEvent(..): change/remove cos event!" + string);
                    }
                    AMObjectImpl.notifyAffectedDNs(string, aMEvent);
                    break;
                }
                case 2: 
                case 4: {
                    Set set;
                    if (bl) {
                        if (debug.messageEnabled()) {
                            debug.message("AMObjectImpl.notifyEntryEvent(..): change/remove cos event!" + string);
                        }
                        AMObjectImpl.notifyAffectedDNs(string, aMEvent);
                        break;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.notifyEntryEvent(..): change/remove entry event!" + string);
                    }
                    if ((set = (Set)objImplListeners.get(string)) == null) {
                        return;
                    }
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        AMObjectImpl aMObjectImpl = (AMObjectImpl)iterator.next();
                        aMObjectImpl.sendEvents(aMEvent);
                    }
                    break;
                }
                case 8: {
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.notifyEntryEvent(..): rename entry event!" + string);
                    }
                    AMObjectImpl.notifyAffectedDNs(string, aMEvent);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Set removeFromProfileNameTable(SSOToken sSOToken) {
        Hashtable hashtable = profileNameTable;
        if (hashtable == null || hashtable.isEmpty()) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("In ProfileService.removeFromProfilefNameTable(SSOTokenID)..");
        }
        Set set = null;
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            String string;
            try {
                string = sSOToken.getPrincipal().getName();
            }
            catch (SSOException sSOException) {
                debug.error("AMObjectImpl.removeFromProfileNameTable(): Could not update PFN table");
                return null;
            }
            set = (Set)hashtable.remove(string);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeObjImplListeners(Set set, SSOTokenID sSOTokenID) {
        if (debug.messageEnabled()) {
            debug.message("In AMObjectImpl.removeObjImplListeners(..): ");
        }
        Map map = objImplListeners;
        synchronized (map) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set2 = (Set)objImplListeners.get(string);
                if (set2 == null) continue;
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    AMObjectImpl aMObjectImpl = (AMObjectImpl)iterator2.next();
                    SSOToken sSOToken = aMObjectImpl.getSSOToken();
                    if (!sSOTokenID.equals((Object)sSOToken.getTokenID())) continue;
                    set2.remove(aMObjectImpl);
                }
                if (!set2.isEmpty()) continue;
                objImplListeners.remove(string);
            }
        }
    }

    protected Set replaceAciListMacros(Set set, String string, String string2, String string3, String string4) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.add(this.replaceAciMacros((String)iterator.next(), string, string2, string3, string4));
        }
        return hashSet;
    }

    protected String replaceAciMacro(String string, String string2, String string3) {
        if (string3 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = string.indexOf(string2)) == -1) break;
            stringBuffer.append(string.substring(0, n)).append(string3);
            string = string.substring(n + string2.length());
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected String replaceAciMacros(String string, String string2, String string3, String string4, String string5) {
        String string6 = this.replaceAciMacro(string, "ROLENAME", string2);
        string6 = this.replaceAciMacro(string6, "ORGANIZATION", string3);
        string6 = this.replaceAciMacro(string6, "GROUPNAME", string4);
        string6 = this.replaceAciMacro(string6, "PCNAME", string5);
        String string7 = null;
        String string8 = "(memberof=*" + this.entryDN + ")";
        String string9 = "(iplanet-am-static-group-dn=*" + this.entryDN + ")";
        if (this.profileType == 11) {
            block8: {
                Set set = (Set)this.stringValueModMap.get("memberurl");
                if (set != null && set.iterator().hasNext()) {
                    String string10 = (String)set.iterator().next();
                    try {
                        LDAPUrl lDAPUrl = new LDAPUrl(string10);
                        string7 = "(|" + string8 + string9 + lDAPUrl.getFilter() + ")";
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (!debug.messageEnabled()) break block8;
                        debug.message("AMObject.create: Invalid member url " + string10);
                    }
                }
            }
            if (string7 == null) {
                string7 = "(|" + string8 + string9 + ")";
            }
        } else if (this.profileType == 12 || this.profileType == 9) {
            string7 = "(|" + string8 + string9 + ")";
        }
        if (string7 != null) {
            string6 = this.replaceAciMacro(string6, "FILTER", string7);
        }
        return string6;
    }

    protected AMSearchResults searchObjects(String string, String string2, String string3, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&").append(AMObjectImpl.constructFilter(string, string2, string3));
        if (map != null && !map.isEmpty()) {
            stringBuffer.append(AMObjectImpl.constructFilter(map));
        }
        stringBuffer.append(")");
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.searchObjects(" + string + ", " + string2 + ", " + string3 + ", Map): DN=" + this.entryDN + ", level " + aMSearchControl.getSearchScope() + "\n" + this.mapToString(map));
            debug.message("AMObjectImpl.searchObjects(): filter: " + stringBuffer.toString());
        }
        SearchControl searchControl = aMSearchControl.getSearchControl();
        String[] stringArray = aMSearchControl.getReturnAttributes();
        return this.dsManager.search(this.token, this.entryDN, stringBuffer.toString(), searchControl, stringArray);
    }

    protected AMSearchResults searchObjects(String string, String string2, String string3, AMSearchControl aMSearchControl, String string4) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&").append(AMObjectImpl.constructFilter(string, string2, string3));
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(")");
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.searchObjects(" + string + ", " + string2 + ", " + string3 + ", " + string4 + "): DN=" + this.entryDN + ", level " + aMSearchControl.getSearchScope());
            debug.message("AMObjectImpl.searchObjects(): filter: " + stringBuffer.toString());
        }
        SearchControl searchControl = aMSearchControl.getSearchControl();
        String[] stringArray = aMSearchControl.getReturnAttributes();
        return this.dsManager.search(this.token, this.entryDN, stringBuffer.toString(), searchControl, stringArray);
    }

    protected AMSearchResults searchObjects(String string, AMSearchControl aMSearchControl, String string2) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&").append(AMObjectImpl.constructFilter(string));
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(")");
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.searchObjects(" + string + ", " + string2 + "): DN=" + this.entryDN + ", level " + aMSearchControl.getSearchScope());
            debug.message("AMObjectImpl.searchObjects(): filter: " + stringBuffer.toString());
        }
        SearchControl searchControl = aMSearchControl.getSearchControl();
        String[] stringArray = aMSearchControl.getReturnAttributes();
        return this.dsManager.search(this.token, this.entryDN, stringBuffer.toString(), searchControl, stringArray);
    }

    protected Set searchObjects(int[] nArray, String string, Map map, int n) throws AMException, SSOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&");
        stringBuffer.append("(|");
        int n2 = 0;
        while (n2 < nArray.length) {
            String string2 = AMNamingAttrManager.getNamingAttr(nArray[n2]);
            String string3 = this.getSearchFilter(nArray[n2]);
            stringBuffer.append(AMObjectImpl.constructFilter(string2, string3, string));
            ++n2;
        }
        stringBuffer.append(")");
        if (map != null && !map.isEmpty()) {
            stringBuffer.append(AMObjectImpl.constructFilter(map));
        }
        stringBuffer.append(")");
        if (debug.messageEnabled()) {
            debug.message("    filter: " + stringBuffer.toString());
        }
        return this.search(n, stringBuffer.toString());
    }

    protected AMSearchResults searchObjects(int[] nArray, String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        String[] stringArray;
        Object object;
        SSOTokenManager.getInstance().validateToken(this.token);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&");
        stringBuffer.append("(|");
        int n = 0;
        while (n < nArray.length) {
            object = AMNamingAttrManager.getNamingAttr(nArray[n]);
            stringArray = this.getSearchFilter(nArray[n]);
            stringBuffer.append(AMObjectImpl.constructFilter((String)object, (String)stringArray, string));
            ++n;
        }
        stringBuffer.append(")");
        if (map != null && !map.isEmpty()) {
            stringBuffer.append(AMObjectImpl.constructFilter(map));
        }
        stringBuffer.append(")");
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.searchObjects(): filter: " + stringBuffer.toString());
        }
        object = aMSearchControl.getSearchControl();
        stringArray = aMSearchControl.getReturnAttributes();
        return this.dsManager.search(this.token, this.entryDN, stringBuffer.toString(), (SearchControl)object, stringArray);
    }

    void setAciBasedOnGroupPclist() throws AMException, SSOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        DN dN;
        HashSet<String> hashSet;
        AMOrganizationImpl aMOrganizationImpl;
        String string;
        block8: {
            string = this.getOrganizationDN();
            aMOrganizationImpl = new AMOrganizationImpl(this.token, string);
            hashSet = new HashSet<String>();
            dN = new DN(this.entryDN);
            try {
                object5 = aMOrganizationImpl.getTemplate("iPlanetAMAdminConsoleService", 302);
                object4 = object5.getAttribute("iplanet-am-admin-console-group-pclist");
                if (debug.messageEnabled()) {
                    debug.message("AMObject.setAciBasedOnGroupPclist: iplanet-am-admin-console-group-pclist " + this.setToString((Set)object4));
                }
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    int n = ((String)object2).indexOf("|");
                    if (n == -1 || !((DN)(object = new DN(((String)object2).substring(0, n)))).equals(dN)) continue;
                    hashSet.add(((String)object2).substring(n + 1));
                }
                if (hashSet.isEmpty() && (object2 = object5.getStringAttribute("iplanet-am-admin-console-group-default-pc")) != null && ((String)object2).length() > 0) {
                    hashSet.add((String)object2);
                }
            }
            catch (AMException aMException) {
                if (!debug.messageEnabled()) break block8;
                debug.message("AMObject.setAciBasedOnGroupPclist: Unable to get template for iPlanetAMAdminConsoleService");
            }
        }
        if (hashSet.isEmpty()) {
            hashSet.add(AMNamingAttrManager.getNamingAttr(5) + "=People," + string);
        }
        if (!((AMObjectImpl)(object4 = new AMRoleImpl(this.internalToken, (String)(object5 = AMNamingAttrManager.getNamingAttr(6) + "=" + dN.toString().replace(',', '_') + "," + string)))).isExists()) {
            return;
        }
        object3 = new HashSet();
        object2 = new HashSet();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string2 = "(target=\"ldap:///" + (String)object + "\")" + "(targetattr=\"nsroledn\")" + "(targattrfilters=\"add=nsroledn:(!(nsroledn=*))," + "del=nsroledn:(!(nsroledn=*))\")" + "(version 3.0; acl \"Group admin's right to add user " + "to people container\"; allow (add) roledn = \"" + "ldap:///" + (String)object5 + "\";)";
            object3.add(string2);
            object2.add(string + ":aci:" + string2);
        }
        aMOrganizationImpl.setAttribute("aci", (Set)object3);
        aMOrganizationImpl.store(true);
        ((AMObjectImpl)object4).setAttribute("iplanet-am-role-aci-list", (Set)object2);
        ((AMObjectImpl)object4).store(true);
    }

    void setAciForRole(AMRole aMRole) throws AMException, SSOException {
        TreeSet treeSet = new TreeSet(aMRole.getAttribute("iplanet-am-role-aci-list"));
        Iterator iterator = treeSet.iterator();
        DN dN = null;
        HashSet hashSet = new HashSet();
        Set set = new HashSet();
        HashSet<String> hashSet2 = new HashSet<String>();
        boolean bl = false;
        boolean bl2 = false;
        AMObjectImpl aMObjectImpl = null;
        while (iterator.hasNext()) {
            String string;
            DN dN2;
            block13: {
                String string2 = (String)iterator.next();
                int n = string2.indexOf(":aci:");
                if (n == -1) continue;
                dN2 = new DN(string2.substring(0, n));
                string = string2.substring(n + 5).trim();
                if (dN == null) {
                    dN = dN2;
                    try {
                        aMObjectImpl = new AMObjectImpl(this.token, dN.toString(), -1);
                        set = aMObjectImpl.getAttribute("aci");
                        if (set.contains(string)) continue;
                        bl = true;
                        hashSet2.add(string);
                    }
                    catch (Exception exception) {
                        if (debug.messageEnabled()) {
                            debug.message("AMObject.setAciForRole :" + dN.toString() + " read access denied." + exception);
                        }
                        bl2 = true;
                    }
                    continue;
                }
                if (dN2.equals(dN)) {
                    if (bl2 || set.contains(string)) continue;
                    bl = true;
                    hashSet2.add(string);
                    continue;
                }
                if (!bl2 && bl) {
                    try {
                        aMObjectImpl.setAttribute("aci", hashSet2);
                        aMObjectImpl.store(true);
                    }
                    catch (Exception exception) {
                        if (!debug.messageEnabled()) break block13;
                        debug.message("AMObject.setAciForRole :" + dN.toString() + " write access denied." + exception);
                    }
                }
            }
            bl = false;
            bl2 = false;
            dN = dN2;
            try {
                aMObjectImpl = new AMObjectImpl(this.token, dN.toString(), -1);
                set = aMObjectImpl.getAttribute("aci");
                if (set.contains(string)) continue;
                bl = true;
                hashSet2.add(string);
            }
            catch (Exception exception) {
                if (debug.messageEnabled()) {
                    debug.message("AMObject.setAciForRole :" + dN.toString() + " read access denied." + exception);
                }
                bl2 = true;
            }
        }
        if (bl) {
            aMObjectImpl.setAttribute("aci", hashSet2);
            aMObjectImpl.store(true);
        }
    }

    Set getDefaultAcis(String string, StringBuffer stringBuffer) throws AMException, SSOException {
        Object object;
        Map map;
        try {
            map = AMServiceUtils.getServiceConfig(this.token, "iPlanetAMAdminConsoleService", SchemaType.GLOBAL);
        }
        catch (SMSException sMSException) {
            debug.error(sMSException.toString());
            throw new AMException(AMSDKBundle.getString("158"), "158");
        }
        Set set = (Set)map.get("iplanet-am-admin-console-dynamic-aci-list");
        Iterator iterator = set.iterator();
        Object object2 = null;
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!((String)object).startsWith(string + "|")) continue;
            object2 = object;
            break;
        }
        if (object2 == null) {
            throw new AMException(AMSDKBundle.getString("158"), "158");
        }
        object = new StringTokenizer((String)object2, "|");
        if (((StringTokenizer)object).countTokens() < 3) {
            throw new AMException(AMSDKBundle.getString("159"), "159");
        }
        string = ((StringTokenizer)object).nextToken();
        stringBuffer.append(((StringTokenizer)object).nextToken());
        int n = ((String)object2).indexOf(124, string.length() + 1);
        String string2 = ((String)object2).substring(n + 1);
        object = new StringTokenizer(string2, "##");
        HashSet<String> hashSet = new HashSet<String>();
        while (((StringTokenizer)object).hasMoreTokens()) {
            hashSet.add(((StringTokenizer)object).nextToken());
        }
        return hashSet;
    }

    String getDefaultDisplayOption(String string) throws AMException, SSOException {
        Set set;
        String string2 = null;
        Map map = null;
        try {
            map = AMServiceUtils.getServiceConfig(this.token, "iPlanetAMAdminConsoleService", SchemaType.GLOBAL);
        }
        catch (SMSException sMSException) {
            debug.error("AMObjectImpl.getDefaultDisplayOption", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("158"), "158");
        }
        if (map != null && !map.isEmpty() && (set = (Set)map.get(ATTR_CONSOLE_ROLE_DISPLAY_OPTION)) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && string2 == null) {
                StringTokenizer stringTokenizer;
                String string3 = (String)iterator.next();
                if (!string3.startsWith(string + "|") || (stringTokenizer = new StringTokenizer(string3, "|")).countTokens() != 3) continue;
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
        }
        return string2;
    }

    void setPolicyTemplate(AMTemplate aMTemplate, Set set) throws AMException, SSOException {
        HashSet hashSet = new HashSet();
        Map map = AMSDKUtil.getNamedPoliciesAttributes(this.token, this.getOrganizationDN(), set, aMTemplate.getServiceName(), hashSet);
        int n = (Integer)hashSet.iterator().next();
        Set set2 = null;
        try {
            set2 = AMServiceUtils.getServiceAttributeNames(this.token, aMTemplate.getServiceName(), SchemaType.POLICY);
        }
        catch (SMSException sMSException) {
            debug.error("AMObjectImpl.unassignPolicies()", (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("489"), "489");
        }
        Map map2 = aMTemplate.getAttributes();
        if (map2 != null && !map2.isEmpty()) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map.containsKey(string) || !map2.containsKey(string)) continue;
                map.put(string, Collections.EMPTY_SET);
            }
        }
        map.put("iplanet-am-named-policy-dn", set);
        aMTemplate.setAttributes(map);
        aMTemplate.store();
        aMTemplate.setPriority(n);
    }

    void setRoleAciDescAciList(AMRole aMRole, String string) throws AMException, SSOException {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.getDefaultAcis(string, stringBuffer);
        String string2 = this.getDefaultDisplayOption(string);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(stringBuffer.toString());
        hashMap.put("iplanet-am-role-aci-description", hashSet);
        hashMap.put("iplanet-am-role-aci-list", this.replaceAciListMacros(set, aMRole.getDN(), this.entryDN, null, null));
        if (string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            HashSet<String> hashSet2 = new HashSet<String>();
            while (stringTokenizer.hasMoreElements()) {
                hashSet2.add((String)stringTokenizer.nextElement());
            }
            hashMap.put(ROLE_DISPLAY_ATTR, hashSet2);
        } else if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.setRoleAciDescAciList-> Display Options for permision = " + string + "  are not defined");
        }
        aMRole.setAttributes(hashMap);
        aMRole.store();
    }

    void createAdminRole() throws SSOException, AMException {
        if (debug.messageEnabled()) {
            debug.message("AMObject.createAdminRole : dn=" + this.entryDN);
        }
        DN dN = new DN(this.entryDN);
        String string = this.dsManager.getOrganizationDN(this.token, dN.getParent().toString());
        if (this.profileType == 5) {
            String string2 = "People Container Admin";
            String string3 = AMNamingAttrManager.getNamingAttr(6) + "=" + dN.toString().replace(',', '_') + "," + string;
            this.createAdminRole(string2, string, string3);
        } else {
            String string4 = "Group Admin";
            String string5 = AMNamingAttrManager.getNamingAttr(6) + "=" + dN.toString().replace(',', '_') + "," + string;
            this.createAdminRole(string4, string, string5);
        }
    }

    void createAdminRole(String string, String string2, String string3) throws SSOException, AMException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.getDefaultAcis(string, stringBuffer);
        String string4 = this.getDefaultDisplayOption(string);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("2");
        hashMap.put("iplanet-am-role-type", hashSet);
        hashSet = new HashSet();
        hashSet.add(string);
        hashMap.put("iplanet-am-role-description", hashSet);
        hashSet = new HashSet();
        hashSet.add(stringBuffer.toString());
        hashMap.put("iplanet-am-role-aci-description", hashSet);
        if (this.profileType == 5) {
            hashMap.put("iplanet-am-role-aci-list", this.replaceAciListMacros(set, string3, string2, null, this.entryDN));
        } else {
            hashMap.put("iplanet-am-role-aci-list", this.replaceAciListMacros(set, string3, string2, this.entryDN, null));
        }
        if (string4 != null && string4.length() > 0) {
            object = new StringTokenizer(string4, " ");
            HashSet<String> hashSet2 = new HashSet<String>();
            while (((StringTokenizer)object).hasMoreElements()) {
                hashSet2.add((String)((StringTokenizer)object).nextElement());
            }
            hashMap.put(ROLE_DISPLAY_ATTR, hashSet2);
        } else if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.createAdminRole-> Display Options for permision = " + string + "  are not defined");
        }
        hashSet = new HashSet();
        hashSet.add(this.entryDN);
        hashMap.put("iplanet-am-role-managed-container-dn", hashSet);
        object = new AMRoleImpl(this.token, string3);
        ((AMObjectImpl)object).setAttributes(hashMap);
        ((AMObjectImpl)object).create();
    }

    Set findRemovableAciList(Set set) throws AMException, SSOException {
        HashSet<String> hashSet = new HashSet<String>();
        if (set == null) {
            return hashSet;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set2 = this.dsManager.search(this.token, AMStoreConnection.rootSuffix, "(&" + AMSearchFilterManager.getGlobalSearchFilter(9) + "(iplanet-am-role-aci-list=" + string + "))", 2);
            if (set2.size() >= 2) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    void removeAci(Set set) throws AMException, SSOException {
        if (set == null) {
            return;
        }
        if (set.size() == 0) {
            return;
        }
        TreeSet treeSet = new TreeSet(set);
        Iterator iterator = treeSet.iterator();
        DN dN = null;
        HashSet hashSet = new HashSet();
        Set set2 = new HashSet();
        boolean bl = false;
        boolean bl2 = false;
        AMObjectImpl aMObjectImpl = null;
        while (iterator.hasNext()) {
            String string;
            DN dN2;
            block15: {
                String string2 = (String)iterator.next();
                int n = string2.indexOf(":aci:");
                if (n == -1) continue;
                dN2 = new DN(string2.substring(0, n));
                string = string2.substring(n + 5).trim();
                if (dN == null) {
                    dN = dN2;
                    try {
                        aMObjectImpl = new AMObjectImpl(this.token, dN.toString(), -1);
                        set2 = aMObjectImpl.getAttribute("aci");
                        if (!set2.remove(string)) continue;
                        bl = true;
                    }
                    catch (Exception exception) {
                        if (debug.messageEnabled()) {
                            debug.message("AMObject.removeAci :" + dN.toString() + " read access denied." + exception);
                        }
                        bl2 = true;
                    }
                    continue;
                }
                if (dN2.equals(dN)) {
                    if (bl2 || !set2.remove(string)) continue;
                    bl = true;
                    continue;
                }
                if (!bl2 && bl) {
                    try {
                        aMObjectImpl.setAttribute("aci", set2);
                        aMObjectImpl.store();
                    }
                    catch (Exception exception) {
                        if (!debug.messageEnabled()) break block15;
                        debug.message("AMObject.removeAci :" + dN.toString() + " write access denied." + exception);
                    }
                }
            }
            bl = false;
            bl2 = false;
            dN = dN2;
            try {
                aMObjectImpl = new AMObjectImpl(this.token, dN.toString(), -1);
                set2 = aMObjectImpl.getAttribute("aci");
                if (!set2.remove(string)) continue;
                bl = true;
            }
            catch (Exception exception) {
                if (debug.messageEnabled()) {
                    debug.message("AMObject.setAciForRole :" + dN.toString() + " read access denied." + exception);
                }
                bl2 = true;
            }
        }
        if (bl) {
            aMObjectImpl.setAttribute("aci", set2);
            aMObjectImpl.store();
        }
    }

    void removeAdminRoleAci(boolean bl) throws AMException, SSOException {
        String string = this.getOrganizationDN();
        AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(this.token, string);
        Set set = aMOrganizationImpl.getAttribute("aci");
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        DN dN = new DN(this.entryDN);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n = string2.indexOf("version 3.0;");
            if (n == -1) {
                hashSet.add(string2);
                continue;
            }
            if ((n = string2.indexOf("roledn", n)) == -1) {
                hashSet.add(string2);
                continue;
            }
            if ((n = string2.indexOf("ldap:///", n)) == -1) {
                hashSet.add(string2);
                continue;
            }
            int n2 = string2.lastIndexOf("\"");
            DN dN2 = new DN(string2.substring(n + 8, n2));
            String string3 = ((RDN)dN2.getRDNs().firstElement()).getValues()[0];
            String string4 = string3.replace('_', ',');
            if (DN.isDN(string4)) {
                DN dN3 = new DN(string4);
                if (dN3.equals(dN)) continue;
                if (dN3.isDescendantOf(dN)) {
                    if (bl) continue;
                    hashSet.add(string2);
                    continue;
                }
                hashSet.add(string2);
                continue;
            }
            hashSet.add(string2);
        }
        aMOrganizationImpl.setAttribute("aci", hashSet);
        aMOrganizationImpl.store();
    }

    void unassignPolicies(String string, Set set, boolean bl) throws AMException, SSOException {
        if (set == null || set.size() == 0) {
            return;
        }
        AMTemplate aMTemplate = this.getTemplate(string, 300);
        this.unassignPolicies(aMTemplate, set, bl);
    }

    void unassignPolicies(AMTemplate aMTemplate, Set set, boolean bl) throws AMException, SSOException {
        if (!aMTemplate.isExists()) {
            throw new AMException(AMSDKBundle.getString("489"), "489");
        }
        Set set2 = aMTemplate.getAttribute("iplanet-am-named-policy-dn");
        if (bl) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (set2.contains(string)) continue;
                throw new AMException(AMSDKBundle.getString("489"), "489");
            }
        }
        set2.removeAll(set);
        if (set2.isEmpty()) {
            aMTemplate.delete();
            return;
        }
        this.setPolicyTemplate(aMTemplate, set2);
    }

    private String[] getAttrList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringTokenizer.nextToken();
            stringArray[n2] = string2.trim();
            ++n2;
        }
        return stringArray;
    }

    private Set getAttrValues(String[] stringArray) {
        HashSet hashSet = new HashSet();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Set set = (Set)this.stringValueModMap.get(stringArray[n2]);
            if (set != null && !set.isEmpty()) {
                hashSet.addAll(set);
            }
            ++n2;
        }
        return hashSet;
    }

    void validateAttributeUniqueness(boolean bl) throws AMException {
        block24: {
            try {
                if (this.profileType == 301 || this.profileType == 302 || this.profileType == 300) {
                    return;
                }
                DN dN = new DN(this.entryDN);
                String string = ((RDN)dN.getRDNs().firstElement()).getValues()[0];
                String[] stringArray = dN.explodeDN(false);
                int n = stringArray.length;
                if (n < 2) {
                    return;
                }
                String string2 = stringArray[n - 1];
                AMStoreConnection aMStoreConnection = new AMStoreConnection(this.internalToken);
                DN dN2 = new DN(AMStoreConnection.rootSuffix);
                DN dN3 = new DN(string2);
                int n2 = n - 2;
                while (n2 >= 0) {
                    Object object;
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.validateAttributeUniqueness: try DN = " + string2);
                    }
                    int n3 = -1;
                    if (!dN2.isDescendantOf(dN3)) {
                        try {
                            n3 = aMStoreConnection.getAMObjectType(string2);
                        }
                        catch (AMException aMException) {
                            if (debug.warningEnabled()) {
                                debug.warning("AMObjectImpl.validateAttributeUniqueness: Unable to determine object type of " + string2 + " :Attribute uniqueness check aborted..", (Throwable)aMException);
                            }
                            return;
                        }
                    }
                    Set set = null;
                    Object object2 = null;
                    if (n3 == 2) {
                        object = new AMOrganizationImpl(this.internalToken, string2);
                        set = ((AMObjectImpl)object).getAttribute("sunnamespaceuniqueattrs");
                        object2 = object;
                    } else if (n3 == 3) {
                        object = new AMOrganizationalUnitImpl(this.internalToken, string2);
                        set = ((AMObjectImpl)object).getAttribute("sunnamespaceuniqueattrs");
                        object2 = object;
                    }
                    if (set != null && !set.isEmpty()) {
                        Object object3;
                        Object object4;
                        if (debug.messageEnabled()) {
                            debug.message("AMObjectImpl.validateAttributeUniqueness: list = " + set);
                        }
                        object = set.iterator();
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("(|");
                        while (object.hasNext()) {
                            object4 = this.getAttrList((String)object.next());
                            object3 = this.getAttrValues((String[])object4);
                            int n4 = 0;
                            while (n4 < ((String[])object4).length) {
                                String string3 = object4[n4];
                                if (string3.equals(AMNamingAttrManager.getNamingAttr(this.profileType)) && bl) {
                                    stringBuffer.append("(").append(stringArray[0]).append(")");
                                }
                                if (object3 != null) {
                                    Iterator iterator = object3.iterator();
                                    while (iterator.hasNext()) {
                                        stringBuffer.append("(").append(string3);
                                        stringBuffer.append("=").append((String)iterator.next());
                                        stringBuffer.append(")");
                                    }
                                }
                                ++n4;
                            }
                        }
                        if (stringBuffer.length() > 2) {
                            DN dN4;
                            stringBuffer.append(")");
                            if (debug.messageEnabled()) {
                                debug.message("AMObjectImpl.validateAttributeUniqueness: filter = " + stringBuffer.toString());
                            }
                            if ((object4 = object2.search(2, stringBuffer.toString())) != null && object4.size() == 1 && (dN4 = new DN((String)(object3 = (String)object4.iterator().next()))).equals(new DN(this.entryDN))) {
                                return;
                            }
                            if (object4 != null && !object4.isEmpty()) {
                                throw new AMException(AMSDKBundle.getString("162"), "162");
                            }
                        }
                    }
                    string2 = stringArray[n2] + "," + string2;
                    dN3 = new DN(string2);
                    --n2;
                }
            }
            catch (SSOException sSOException) {
                if (!debug.warningEnabled()) break block24;
                debug.warning("Unable to validate attribute uniqneness", (Throwable)sSOException);
            }
        }
    }

    private SSOToken getSSOToken() {
        return this.token;
    }

    private String setToString(Set set) {
        if (set == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("    ").append((String)iterator.next()).append("\n");
        }
        return stringBuffer.toString();
    }

    private String[] setToStringArray(Set set) {
        if (set == null) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToProfileNameTable(SSOToken sSOToken, String string) throws SSOException {
        Hashtable hashtable;
        if (debug.messageEnabled()) {
            debug.message("In AMObjectImpl.addToProfileNameTable(SSOToken,dn)..");
        }
        Hashtable hashtable2 = hashtable = profileNameTable;
        synchronized (hashtable2) {
            HashSet<String> hashSet = (HashSet<String>)hashtable.get(sSOToken.getPrincipal().getName());
            if (hashSet == null) {
                AMSSOTokenListener aMSSOTokenListener = new AMSSOTokenListener(sSOToken.getPrincipal().getName());
                sSOToken.addSSOTokenListener((SSOTokenListener)aMSSOTokenListener);
                hashSet = new HashSet<String>();
                hashtable.put(sSOToken.getPrincipal().getName(), hashSet);
            }
            hashSet.add(string);
        }
    }

    private String arrayToString(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("    ").append(stringArray[n2]).append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String mapToString(Map map) {
        if (map == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equalsIgnoreCase("userpassword") || string.equalsIgnoreCase("encrypteduserpassword")) continue;
            Set set = (Set)map.get(string);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append("    ").append(string).append(": ").append((String)iterator2.next()).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyAffectedDNs(String string, AMEvent aMEvent) {
        if (debug.messageEnabled()) {
            debug.message("In AMObjectImpl.notifyAffectedDNs(..): ");
        }
        Map map = objImplListeners;
        synchronized (map) {
            Iterator iterator = objImplListeners.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((String)entry.getKey()).endsWith(string)) continue;
                Set set = (Set)entry.getValue();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    AMObjectImpl aMObjectImpl = (AMObjectImpl)iterator2.next();
                    aMObjectImpl.sendEvents(aMEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromProfileNameTable(SSOToken sSOToken, String string) {
        Hashtable hashtable;
        if (debug.messageEnabled()) {
            debug.message("In ProfileService.removeFromProfileNameTable(SSOToken,dn)..");
        }
        if ((hashtable = profileNameTable) == null || hashtable.isEmpty()) {
            return;
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            String string2;
            try {
                string2 = sSOToken.getPrincipal().getName();
            }
            catch (SSOException sSOException) {
                debug.error("AMObjectImpl.removeFromProfileNameTable(): Could not update PFN table");
                return;
            }
            Set set = (Set)hashtable.get(string2);
            if (set != null) {
                set.remove(string);
                if (set.isEmpty()) {
                    hashtable.remove(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvents(AMEvent aMEvent) {
        Set set = this.listeners;
        synchronized (set) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                AMEventListener aMEventListener = (AMEventListener)iterator.next();
                try {
                    switch (aMEvent.getEventType()) {
                        case 4: {
                            aMEventListener.objectChanged(aMEvent);
                            break;
                        }
                        case 2: {
                            aMEventListener.objectRemoved(aMEvent);
                            break;
                        }
                        case 8: {
                            aMEventListener.objectRenamed(aMEvent);
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private Set stringArrayToSet(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
        }
        return hashSet;
    }

    private AMHashMap integrateLocale() throws AMException, SSOException {
        String string;
        Object object;
        Iterator iterator;
        Set<String> set;
        Set set2;
        if (AMCommonUtils.integrateLocale && (this.profileType == 1 || this.profileType == 301) && this.stringValueModMap.containsKey("preferredLocale")) {
            set2 = (Set)this.stringValueModMap.get("preferredLocale");
            set = (HashSet<String>)this.stringValueModMap.get("preferredLanguage");
            if (set == null) {
                set = new HashSet<String>();
            }
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                string = ((String)object).replace('_', '-');
                set.add(string);
            }
            if (set.isEmpty()) {
                object = this.getAttribute("preferredLanguage");
                if (object != null && !object.isEmpty()) {
                    this.stringValueModMap.put("preferredLanguage", set);
                }
            } else {
                this.stringValueModMap.put("preferredLanguage", set);
            }
        }
        if (AMCommonUtils.integrateLocale && (this.profileType == 1 || this.profileType == 301) && this.stringValueModMap.containsKey("preferredLanguage")) {
            set2 = (Set)this.stringValueModMap.get("preferredLanguage");
            set = (Set)this.stringValueModMap.get("preferredLocale");
            if (set == null) {
                set = new HashSet();
            }
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                string = ((String)object).replace('-', '_');
                set.add(string);
            }
            if (set.isEmpty()) {
                object = this.getAttribute("preferredLocale");
                if (object != null && !object.isEmpty()) {
                    this.stringValueModMap.put("preferredLocale", set);
                }
            } else {
                this.stringValueModMap.put("preferredLocale", set);
            }
        }
        return this.stringValueModMap;
    }

    private Map integrateLocaleForTemplateCreation(Map map) {
        if (AMCommonUtils.integrateLocale) {
            AMHashMap aMHashMap = new AMHashMap();
            aMHashMap.copy(map);
            if (aMHashMap.containsKey("preferredLocale")) {
                Set set = (Set)aMHashMap.get("preferredLocale");
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = string.replace('_', '-');
                    hashSet.add(string2);
                }
                aMHashMap.put("preferredLanguage", hashSet);
            } else if (aMHashMap.containsKey("preferredLanguage")) {
                Set set = (Set)aMHashMap.get("preferredLanguage");
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string3 = string.replace('-', '_');
                    hashSet.add(string3);
                }
                aMHashMap.put("preferredLocale", hashSet);
            }
            map.clear();
            map.putAll(aMHashMap);
        }
        return map;
    }
}

