/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.util.Debug;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AMHashMap
extends HashMap {
    private boolean byteValues = false;
    private Set byteNegativeAttrs = Collections.EMPTY_SET;
    private Debug debug = AMCommonUtils.debug;

    public AMHashMap() {
    }

    public AMHashMap(boolean bl) {
        this.byteValues = bl;
    }

    public AMHashMap(int n) {
        super(n);
    }

    public AMHashMap(int n, boolean bl) {
        super(n);
        this.byteValues = bl;
    }

    public boolean containsKey(Object object) {
        return super.containsKey(((String)object).toLowerCase());
    }

    public Object get(Object object) {
        return super.get(((String)object).toLowerCase());
    }

    public Object put(Object object, Object object2) {
        return super.put(((String)object).toLowerCase(), object2);
    }

    public Object remove(Object object) {
        return super.remove(((String)object).toLowerCase());
    }

    public boolean isEmpty() {
        if (!this.byteValues) {
            return super.isEmpty();
        }
        return super.isEmpty() && this.byteNegativeAttrs.isEmpty();
    }

    public void clear() {
        super.clear();
        if (this.byteValues) {
            this.clearNegativeByteAttrs();
        }
    }

    private void addNegativeByteAttr(String string) {
        if (this.byteNegativeAttrs == Collections.EMPTY_SET) {
            this.byteNegativeAttrs = new HashSet();
        }
        this.byteNegativeAttrs.add(string.toLowerCase());
    }

    private void removeNegativeByteAttr(String string) {
        if (this.byteNegativeAttrs != Collections.EMPTY_SET) {
            this.byteNegativeAttrs.remove(string.toLowerCase());
        }
    }

    protected void clearNegativeByteAttrs() {
        if (this.byteNegativeAttrs != Collections.EMPTY_SET) {
            this.byteNegativeAttrs.clear();
        }
    }

    private boolean isNegativeByteAttr(String string) {
        return this.byteNegativeAttrs.contains(string.toLowerCase());
    }

    protected void setNegativeByteAttr(Set set) {
        this.byteNegativeAttrs = set;
    }

    protected Set getNegativeByteAttrClone() {
        if (this.byteNegativeAttrs == Collections.EMPTY_SET) {
            return Collections.EMPTY_SET;
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = this.byteNegativeAttrs.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    protected Set getMissingKeys(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.get(string) != null) continue;
            if (this.byteValues) {
                if (this.isNegativeByteAttr(string)) continue;
                hashSet.add(string);
                this.addNegativeByteAttr(string);
                continue;
            }
            hashSet.add(string);
            this.put(string, new HashSet());
        }
        return hashSet;
    }

    /*
     * Unable to fully structure code
     */
    protected Set getMissingAndEmptyKeys(Set var1_1) {
        block4: {
            var2_2 = new HashSet<String>();
            var3_3 = var1_1.iterator();
            if (this.byteValues) ** GOTO lbl28
            while (var3_3.hasNext()) {
                var4_4 = (String)var3_3.next();
                var5_6 = (Set)this.get(var4_4);
                if (var5_6 == null) {
                    var2_2.add(var4_4);
                    this.put(var4_4, new HashSet<E>());
                    continue;
                }
                if (!var5_6.isEmpty()) continue;
                var2_2.add(var4_4);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                var4_5 = (String)var3_3.next();
                var5_7 = (byte[][])this.get(var4_5);
                if (var5_7 == null) {
                    var2_2.add(var4_5);
                    this.addNegativeByteAttr(var4_5);
                    continue;
                }
                if (!this.isNegativeByteAttr(var4_5)) continue;
                var2_2.add(var4_5);
lbl28:
                // 4 sources

                ** while (var3_3.hasNext())
            }
        }
        return var2_2;
    }

    protected void removeKeys(Set set) {
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.remove(string);
                this.removeNegativeByteAttr(string);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void copy(Map var1_1) {
        block4: {
            if (var1_1 == null || var1_1.isEmpty()) {
                return;
            }
            var2_2 = var1_1.keySet().iterator();
            if (this.byteValues) ** GOTO lbl17
            while (var2_2.hasNext()) {
                var3_3 = (String)var2_2.next();
                var4_5 = (Set)var1_1.get(var3_3);
                this.put(var3_3, this.getSetCopy(var4_5));
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                var3_4 = (String)var2_2.next();
                var4_6 = (byte[][])var1_1.get(var3_4);
                this.put(var3_4, var4_6);
                this.removeNegativeByteAttr(var3_4);
lbl17:
                // 2 sources

                ** while (var2_2.hasNext())
            }
lbl18:
            // 1 sources

            if (var1_1 instanceof AMHashMap) {
                this.setNegativeByteAttr(((AMHashMap)var1_1).getNegativeByteAttrClone());
            }
        }
    }

    protected void merge(Map map) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (!this.byteValues) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)this.get(string);
                if (set != null) {
                    set.addAll((Set)map.get(string));
                    continue;
                }
                this.put(string, (Set)map.get(string));
            }
        } else {
            this.putAll(map);
        }
    }

    protected void removeEmptyValues() {
        HashSet<String> hashSet = new HashSet<String>();
        if (!this.byteValues) {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)this.get(string);
                if (!set.isEmpty()) continue;
                hashSet.add(string);
            }
            this.removeKeys(hashSet);
        }
        this.clearNegativeByteAttrs();
    }

    protected Map getCopy() {
        if (!this.byteValues) {
            AMHashMap aMHashMap = new AMHashMap(this.size(), false);
            if (!this.isEmpty()) {
                Iterator iterator = this.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Set set = (Set)this.get(string);
                    aMHashMap.put(string, this.getSetCopy(set));
                }
            }
            return aMHashMap;
        }
        AMHashMap aMHashMap = new AMHashMap(this.size(), true);
        if (!this.isEmpty()) {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[][] byArray = (byte[][])this.get(string);
                aMHashMap.put(string, this.getByteArrayCopy(byArray));
            }
        }
        aMHashMap.setNegativeByteAttr(this.getNegativeByteAttrClone());
        return aMHashMap;
    }

    protected Map getCopy(Set set) {
        if (!this.byteValues) {
            AMHashMap aMHashMap = new AMHashMap(false);
            if (!this.isEmpty() && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Set set2 = (Set)this.get(string);
                    if (set2 == null) continue;
                    aMHashMap.put(string, this.getSetCopy(set2));
                }
            }
            return aMHashMap;
        }
        AMHashMap aMHashMap = new AMHashMap(true);
        if (!this.isEmpty() && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[][] byArray = (byte[][])this.get(string);
                if (byArray == null) continue;
                aMHashMap.put(string, this.getByteArrayCopy(byArray));
            }
        }
        aMHashMap.setNegativeByteAttr(this.getNegativeByteAttrClone());
        return aMHashMap;
    }

    private Set getSetCopy(Set set) {
        HashSet<String> hashSet = new HashSet<String>(set.size());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private byte[][] getByteArrayCopy(byte[][] byArray) {
        int n = byArray.length;
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2].length;
            byArrayArray[n2] = new byte[n3];
            int n4 = 0;
            while (n4 < n3) {
                byArrayArray[n2][n4] = byArray[n2][n4];
                ++n4;
            }
            ++n2;
        }
        return byArrayArray;
    }
}

