/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCacheManager;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMEvent;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.Set;
import netscape.ldap.util.DN;

class AMEntryEventListener
implements IDSEventListener {
    protected static final String SEARCH_FILTER = "(&(objectclass=*)(!(|(objectclass=sunService)(objectclass=sunServiceComponent)(aci=*))))";
    protected static final int OPERATIONS = 15;
    private Debug debug;
    private SSOToken internalToken = AMCommonUtils.getInternalToken();
    private AMDirectoryManager dsManager;

    public AMEntryEventListener() {
        this.debug = AMCommonUtils.debug;
        this.dsManager = AMDirectoryWrapper.getInstance();
    }

    private Set getDynamicAttributeNames(String string) {
        Set set;
        block4: {
            set = Collections.EMPTY_SET;
            try {
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.internalToken);
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
                set = serviceSchema.getAttributeSchemaNames();
            }
            catch (SMSException sMSException) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("AMEntryEventListener.entryChanged(): caught SMSException: ", (Throwable)sMSException);
                }
            }
            catch (SSOException sSOException) {
                if (!this.debug.warningEnabled()) break block4;
                this.debug.error("AMEntryEventListener.entryChanged(): caught SSOException: ", (Throwable)sSOException);
            }
        }
        return set;
    }

    public void entryChanged(DSEvent dSEvent) {
        String string;
        boolean bl;
        block12: {
            DN dN = new DN(dSEvent.getID());
            String string2 = dN.toRFCString().toLowerCase();
            if (this.debug.messageEnabled()) {
                this.debug.message("AMEntryEventListener.entryChanged(): DSEvent generated for: " + dN);
            }
            bl = true;
            string = "";
            Set set = Collections.EMPTY_SET;
            String string3 = null;
            String string4 = dSEvent.getClassName();
            if (string4.indexOf("cosClassicDefinition") != -1) {
                string = dN.getParent().toRFCString().toLowerCase();
                string3 = dN.explodeDN(true)[0];
                set = this.getDynamicAttributeNames(string3);
                if (this.debug.messageEnabled()) {
                    this.debug.message("AMEntryEventListener.entryChanged() Cos Definition changed for service: " + string3 + "Dynamic Attributes: " + set);
                }
            } else if (string4.indexOf("costemplate") != -1) {
                string = dN.getParent().getParent().toRFCString().toLowerCase();
                string3 = dN.getParent().explodeDN(true)[0];
                set = this.getDynamicAttributeNames(string3);
                if (this.debug.messageEnabled()) {
                    this.debug.message("AMEntryEventListener.entryChanged()Cos template changed for service: " + string3 + "Dynamic Attributes: " + set);
                }
            } else {
                bl = false;
                string = dN.toRFCString().toLowerCase();
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("AMEntryEventListener.entryChanged(): Affected dn: " + string + " cosType: " + bl);
            }
            this.dsManager.dirtyCache(dSEvent, string, bl, false, string2, set);
            AMStoreConnection.updateCache(dSEvent, string2);
            try {
                if (AMCompliance.isComplianceUserDeletionEnabled()) {
                    AMCompliance.cleanDeletedOrgCache(string2);
                }
                if (AMDCTree.isRequired()) {
                    AMDCTree.cleanDomainMap(dN.toRFCString().toLowerCase());
                }
            }
            catch (AMException aMException) {
                if (!this.debug.warningEnabled()) break block12;
                this.debug.warning("AMEntryEventListener.entryChanged() AMException occured: ", (Throwable)aMException);
            }
        }
        AMObjectImpl.notifyEntryEvent(dSEvent, string, bl);
    }

    public void eventError(String string) {
        this.debug.error("AMEntryEventListener.eventError(): " + string);
    }

    public void allEntriesChanged() {
        this.debug.error("AMEntryEventListener: Received all entries changed eventfrom event service");
        AMDirectoryManager aMDirectoryManager = AMCacheManager.getInstance();
        aMDirectoryManager.clearCache();
        AMEvent aMEvent = new AMEvent(AMStoreConnection.rootSuffix);
        AMObjectImpl.notifyAffectedDNs(AMStoreConnection.rootSuffix, aMEvent);
    }
}

