/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.util.AMSendMail;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.MessagingException;

class AMEmailNotification {
    protected static final String ADMINISTRATION_SERVICE = "iPlanetAMAdminConsoleService";
    protected static final String USER_CREATE_NOTIFICATION_LIST = "iplanet-am-user-create-notification-list";
    protected static final String USER_DELETE_NOTIFICATION_LIST = "iplanet-am-user-delete-notification-list";
    protected static final String USER_MODIFY_NOTIFICATION_LIST = "iplanet-am-user-modify-notification-list";
    protected static final String EMAIL_ATTRIBUTE = "mail";
    private static AMDirectoryManager dsManager = AMDirectoryWrapper.getInstance();
    private static SSOToken internalToken = AMCommonUtils.getInternalToken();
    private static Debug debug = AMCommonUtils.debug;
    private AMSendMail mailer = null;
    private String entryDN;
    private String organizationDN;
    private Set createNotifyList = Collections.EMPTY_SET;
    private Set deleteNotifyList = Collections.EMPTY_SET;
    private Set modifyNotifyList = Collections.EMPTY_SET;

    protected AMEmailNotification(String string) {
        this.entryDN = string;
        this.mailer = new AMSendMail();
    }

    private void sendEmail(Set set, Map map, String string, String string2, String string3) throws MessagingException {
        String string4 = AMSDKBundle.getString("504");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            String[] stringArray;
            Object object2;
            StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next(), "|");
            String string5 = stringTokenizer.nextToken();
            if (string5.equals(string4)) {
                object2 = (Set)map.get(EMAIL_ATTRIBUTE);
                if (object2 == null || object2.isEmpty()) continue;
                debug.message("AMEmailNotification.sendMail(): Converting to array for: " + object2);
                stringArray = object2.toArray(new String[object2.size()]);
            } else if (string5.startsWith(string4 + ":")) {
                object2 = string5.substring((string4 + ":").length());
                if (object2 == null || ((String)object2).length() == 0 || (object = (Set)map.get(object2)) == null || object.isEmpty()) continue;
                debug.message("AMEmailNotification.sendMail(): Converting to array for: " + object);
                stringArray = object.toArray(new String[object.size()]);
            } else {
                stringArray = new String[]{string5};
            }
            object2 = null;
            object = null;
            if (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                }
            }
            String string6 = AMSDKBundle.getString(string, (String)object2);
            String string7 = AMSDKBundle.getString(string2, (String)object2);
            String string8 = AMSDKBundle.getString(string3, (String)object2) + " " + this.entryDN;
            this.mailer.postMail(stringArray, string7, string8, string6, (String)object);
        }
    }

    private Set getNotificationList(String string) {
        Set set = Collections.EMPTY_SET;
        try {
            String string2 = dsManager.getOrganizationDN(internalToken, this.entryDN);
            AMOrganizationImpl aMOrganizationImpl = new AMOrganizationImpl(internalToken, string2);
            set = aMOrganizationImpl.getOrgTypeAttributes(ADMINISTRATION_SERVICE, string);
        }
        catch (AMException aMException) {
            debug.error("AMEmailNotification.getNotificationList() Unable to get notification List for " + string + " for user: " + this.entryDN, (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.error("AMEmailNotification.getNotificationList() Unable to get notification List for " + string + " for user: " + this.entryDN, (Throwable)sSOException);
        }
        return set;
    }

    protected void setUserCreateNotificationList() {
        this.createNotifyList = this.getNotificationList(USER_CREATE_NOTIFICATION_LIST);
    }

    protected void setUserDeleteNotificationList() {
        this.deleteNotifyList = this.getNotificationList(USER_DELETE_NOTIFICATION_LIST);
    }

    protected void setUserModifyNotificationList() {
        this.modifyNotifyList = this.getNotificationList(USER_MODIFY_NOTIFICATION_LIST);
    }

    protected boolean isPresentUserCreateNotificationList() {
        return this.createNotifyList != null && !this.createNotifyList.isEmpty();
    }

    protected boolean isPresentUserDeleteNotificationList() {
        return this.deleteNotifyList != null && !this.deleteNotifyList.isEmpty();
    }

    protected boolean isPresentUserModifyNotificationList() {
        return this.modifyNotifyList != null && !this.modifyNotifyList.isEmpty();
    }

    protected void sendUserCreateNotification(Map map) {
        block3: {
            try {
                if (this.createNotifyList != null && !this.createNotifyList.isEmpty()) {
                    this.sendEmail(this.createNotifyList, map, "497", "490", "493");
                }
            }
            catch (MessagingException messagingException) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("AMEmailNotification.sendUserCreateNotification() Unable to send email for user: " + this.entryDN, (Throwable)messagingException);
            }
        }
    }

    protected void sendUserDeleteNotification(Map map) {
        block3: {
            try {
                if (this.deleteNotifyList != null && !this.deleteNotifyList.isEmpty()) {
                    this.sendEmail(this.deleteNotifyList, map, "497", "491", "494");
                }
            }
            catch (MessagingException messagingException) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("AMEmailNotification.sendUserDeleteNotification() Unable to send email for user: " + this.entryDN, (Throwable)messagingException);
            }
        }
    }

    protected void sendUserModifyNotification(SSOToken sSOToken, Map map, Map map2) {
        if (this.modifyNotifyList == null || this.modifyNotifyList.isEmpty()) {
            return;
        }
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        AttrSet attrSet2 = AMCommonUtils.mapToAttrSet(map2);
        try {
            String string = AMSDKBundle.getString("504");
            Iterator iterator = this.modifyNotifyList.iterator();
            while (iterator.hasNext()) {
                String string2;
                String string3 = (String)iterator.next();
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                int n = stringTokenizer.countTokens();
                if (n <= 1 || !attrSet.contains(string2 = stringTokenizer.nextToken().toLowerCase())) continue;
                while (stringTokenizer.hasMoreTokens()) {
                    int n2;
                    Object object;
                    Object object2;
                    String[] stringArray;
                    Object object3;
                    Object object4;
                    Object object5;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "|");
                    String string4 = stringTokenizer2.nextToken();
                    if (string4.equals(string)) {
                        object5 = new HashSet<String>(1);
                        object5.add(EMAIL_ATTRIBUTE);
                        object4 = dsManager.getAttributes(sSOToken, this.entryDN, (Set)object5, 1);
                        object3 = (Set)object4.get(EMAIL_ATTRIBUTE);
                        if (object3 == null || object3.isEmpty()) continue;
                        stringArray = object3.toArray(new String[object3.size()]);
                    } else if (string4.startsWith(string + ":")) {
                        object5 = string4.substring((string + ":").length());
                        if (object5 == null || ((String)object5).length() == 0) continue;
                        object4 = new HashSet(1);
                        object4.add(object5);
                        object3 = dsManager.getAttributes(sSOToken, this.entryDN, (Set)object4, 1);
                        object2 = (Set)object3.get(object5);
                        if (object2 == null || object2.isEmpty()) continue;
                        stringArray = object2.toArray(new String[object2.size()]);
                    } else {
                        stringArray = new String[]{string4};
                    }
                    object5 = null;
                    object4 = null;
                    if (stringTokenizer2.hasMoreTokens()) {
                        object5 = stringTokenizer2.nextToken();
                        if (stringTokenizer2.hasMoreTokens()) {
                            object4 = stringTokenizer2.nextToken();
                        }
                    }
                    object3 = attrSet2.getAttribute(string2);
                    object2 = attrSet.getAttribute(string2);
                    String string5 = AMSDKBundle.getString("492", (String)object5);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(AMSDKBundle.getString("495", (String)object5)).append(" ").append(this.entryDN).append("\n").append(AMSDKBundle.getString("496", (String)object5)).append(" ").append(string2).append("\n").append(AMSDKBundle.getString("502", (String)object5)).append("\n");
                    if (object3 != null) {
                        object = ((Attr)object3).getStringValues();
                        n2 = 0;
                        while (n2 < ((String[])object).length) {
                            stringBuffer.append("    ").append(object[n2]).append("\n");
                            ++n2;
                        }
                    }
                    stringBuffer.append(AMSDKBundle.getString("503", (String)object5)).append("\n");
                    if (object2 != null) {
                        object = ((Attr)object2).getStringValues();
                        n2 = 0;
                        while (n2 < ((String[])object).length) {
                            stringBuffer.append("    ").append(object[n2]).append("\n");
                            ++n2;
                        }
                    }
                    object = AMSDKBundle.getString("497", (String)object5);
                    this.mailer.postMail(stringArray, string5, stringBuffer.toString(), (String)object, (String)object4);
                }
            }
        }
        catch (MessagingException messagingException) {
            if (debug.warningEnabled()) {
                debug.warning("AMEmailNotification.sendUserModifyNotification() Unable to send email for user: " + this.entryDN, (Throwable)messagingException);
            }
        }
        catch (SSOException sSOException) {
            debug.error("AMEmailNotification.sendUserModifyNotification() Error occured while trying to send email for user: " + this.entryDN, (Throwable)sSOException);
        }
        catch (AMException aMException) {
            debug.error("AMEmailNotification.sendUserModifyNotification() Error occured while trying to send email for user: " + this.entryDN, (Throwable)aMException);
        }
    }
}

