/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCallBackImpl;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMEmailNotification;
import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMInvalidDNException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectClassManager;
import com.iplanet.am.sdk.AMPreCallBackException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchFilterManager;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUserEntryProcessed;
import com.iplanet.am.sdk.AMUserPasswordValidationImpl;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.AssignableDynamicGroup;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DynamicGroup;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.FilteredRole;
import com.iplanet.ums.Guid;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.ManagedRole;
import com.iplanet.ums.Organization;
import com.iplanet.ums.OrganizationalUnit;
import com.iplanet.ums.PeopleContainer;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.Resource;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SizeLimitExceededException;
import com.iplanet.ums.SortKey;
import com.iplanet.ums.StaticGroup;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.TimeLimitExceededException;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.cos.COSManager;
import com.iplanet.ums.cos.COSNotFoundException;
import com.iplanet.ums.cos.COSTemplate;
import com.iplanet.ums.cos.DirectCOSDefinition;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class AMDirectoryManager
implements AMConstants {
    protected static Debug debug = AMCommonUtils.debug;
    protected static boolean isUserPluginInitialized = false;
    private static AMUserEntryProcessed userEntry = null;
    private static AMDirectoryManager instance = null;
    protected SSOToken internalToken = AMCommonUtils.getInternalToken();

    protected AMDirectoryManager() {
    }

    protected static synchronized AMDirectoryManager getInstance() {
        if (instance == null) {
            debug.message("AMDirectoryManager.getInstance(): Creating a new Instance of AMDirectoryManager()");
            instance = new AMDirectoryManager();
        }
        return instance;
    }

    protected String getEntryName(UMSException uMSException) {
        DN dN = this.getExceptionDN(uMSException);
        String string = "";
        if (dN != null) {
            string = ((RDN)dN.getRDNs().firstElement()).getValues()[0];
        }
        return string;
    }

    private DN getExceptionDN(UMSException uMSException) {
        String string;
        int n;
        DN dN = null;
        String string2 = uMSException.getMessage();
        if (string2 != null && (n = string2.indexOf("::")) != -1 && DN.isDN(string = string2.substring(0, n))) {
            dN = new DN(string);
        }
        return dN;
    }

    protected String getEntryNotFoundMsgID(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                return "465";
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "466";
            }
            case 2: {
                return "467";
            }
            case 1: {
                return "468";
            }
            case 3: {
                return "469";
            }
            case 5: {
                return "470";
            }
            case 4: {
                return "471";
            }
        }
        return "461";
    }

    private String getEntryExistsMsgID(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                return "472";
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "473";
            }
            case 2: {
                return "474";
            }
            case 1: {
                return "475";
            }
            case 3: {
                return "476";
            }
            case 5: {
                return "477";
            }
            case 4: {
                return "483";
            }
        }
        return "462";
    }

    private void processInternalException(SSOToken sSOToken, UMSException uMSException, String string) throws AMException {
        try {
            LDAPException lDAPException = (LDAPException)uMSException.getRootCause();
            int n = lDAPException.getLDAPResultCode();
            switch (n) {
                case 19: {
                    throw new AMException(sSOToken, "19");
                }
                case 67: {
                    throw new AMException(sSOToken, "967");
                }
                case 11: {
                    throw new AMException(sSOToken, "968");
                }
            }
            throw new AMException(sSOToken, string);
        }
        catch (Exception exception) {
            throw new AMException(sSOToken, string);
        }
    }

    protected static AMUserEntryProcessed getUserPostPlugin() {
        if (!isUserPluginInitialized) {
            String string = SystemProperties.get((String)"com.iplanet.am.sdk.userEntryProcessingImpl");
            if (string != null && string.length() != 0) {
                try {
                    userEntry = (AMUserEntryProcessed)Class.forName(string).newInstance();
                    if (debug.messageEnabled()) {
                        debug.message("AMDirectoryManager.getUserPostPlugin: Class " + string + " instantiated.");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    debug.error("AMDirectoryManager.getUserPostPlugin(): Class not found: " + string, (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    debug.error("AMDirectoryManager.getUserPostPlugin(): Unable to instantiate: " + string, (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    debug.error("AMDirectoryManager.getUserPostPlugin(): IllegalAccessException: " + string, (Throwable)illegalAccessException);
                }
            }
            isUserPluginInitialized = true;
        }
        return userEntry;
    }

    protected void dirtyCache(DSEvent dSEvent, String string, boolean bl, boolean bl2, String string2, Set set) {
    }

    protected void clearCache() {
    }

    protected boolean doesEntryExists(SSOToken sSOToken, String string) {
        try {
            PersistentObject persistentObject = UMSObject.getObject(this.internalToken, new Guid(string));
        }
        catch (UMSException uMSException) {
            if (debug.messageEnabled()) {
                debug.message("AMDirectoryManager.doesProfileExist(): + Exception caught: ", (Throwable)uMSException);
            }
            return false;
        }
        return true;
    }

    protected int getObjectType(SSOToken sSOToken, String string) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryManager.getObjectType() Getting object type for: " + string);
        }
        if (!DN.isDN(string)) {
            throw new AMInvalidDNException(AMSDKBundle.getString("157"), "157");
        }
        SSOTokenManager.getInstance().validateToken(sSOToken);
        String[] stringArray = new String[]{"objectClass"};
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add("objectclass");
        Map map = this.getAttributes(sSOToken, string, hashSet, -9999);
        if (map.size() == 1) {
            Set set = (Set)map.get("objectclass");
            Iterator iterator = set.iterator();
            int n = -1;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                int n2 = AMObjectClassManager.getObjectType(string2);
                if (n2 == 6) {
                    n = n2;
                    continue;
                }
                if (n2 == -1) continue;
                return n2;
            }
            if (n != -1) {
                return n;
            }
            throw new AMException(AMSDKBundle.getString("156"), "156");
        }
        throw new AMException(AMSDKBundle.getString("151"), "151");
    }

    protected Map getDCTreeAttributes(SSOToken sSOToken, String string, Set set, boolean bl, int n) throws AMException, SSOException {
        String string2;
        String string3 = AMStoreConnection.rootSuffix;
        if (AMDCTree.isRequired() && n == 2 && !AMCommonUtils.formatToRFC(string).equalsIgnoreCase(string3) && (string2 = AMDCTree.getCanonicalDomain(this.internalToken, string)) != null) {
            String[] stringArray = set == null ? null : set.toArray(new String[set.size()]);
            AttrSet attrSet = AMDCTree.getDomainAttributes(this.internalToken, string, stringArray);
            return AMCommonUtils.attrSetToMap(attrSet, bl);
        }
        return null;
    }

    private void checkComplianceAttributes(AttrSet attrSet, boolean bl) throws AMException {
        if (!bl && AMCompliance.isComplianceUserDeletionEnabled()) {
            AMCompliance.verifyAttributes(attrSet);
        }
    }

    protected Map getAttributes(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = false;
        return this.getAttributes(sSOToken, string, bl, bl2, n);
    }

    protected Map getAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = false;
        return this.getAttributes(sSOToken, string, set, bl, bl2, n);
    }

    protected Map getAttributesByteValues(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = true;
        return this.getAttributes(sSOToken, string, bl2, bl, n);
    }

    protected Map getAttributesByteValues(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = true;
        return this.getAttributes(sSOToken, string, set, bl2, bl, n);
    }

    protected Map getAttributes(SSOToken sSOToken, String string, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            AttrSet attrSet = persistentObject.getAttributes(persistentObject.getAttributeNames());
            this.checkComplianceAttributes(attrSet, bl);
            AMHashMap aMHashMap = (AMHashMap)AMCommonUtils.attrSetToMap(attrSet, bl2);
            Map map = this.getDCTreeAttributes(sSOToken, string, null, bl2, n);
            aMHashMap.copy(map);
            return aMHashMap;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.getProfileAttribute(): Unable to get attributes: ", (Throwable)illegalArgumentException);
            }
            String string2 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("330", string2), "330");
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.getProfileAttribute(): Unable to get attributes: ", (Throwable)uMSException);
            }
            String string3 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("330", string3), "330");
        }
    }

    protected Map getAttributes(SSOToken sSOToken, String string, Set set, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        if (set == null) {
            return this.getAttributes(sSOToken, string, bl, bl2, n);
        }
        try {
            String[] stringArray = set.toArray(new String[set.size()]);
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            AttrSet attrSet = !bl && AMCompliance.isComplianceUserDeletionEnabled() ? AMCompliance.verifyAndGetAttributes(persistentObject, stringArray) : persistentObject.getAttributes(stringArray);
            AMHashMap aMHashMap = (AMHashMap)AMCommonUtils.attrSetToMap(attrSet, bl2);
            Map map = this.getDCTreeAttributes(sSOToken, string, set, bl2, n);
            aMHashMap.copy(map);
            return aMHashMap;
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.getProfileAttribute(): Unable to get attributes: ", (Throwable)uMSException);
            }
            String string2 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("330", string2), "330");
        }
    }

    protected String getOrgSearchFilter(String string) {
        String string2 = AMSearchFilterManager.getSearchFilter(2, string, null, true);
        String string3 = AMSearchFilterManager.getSearchFilter(3, string, null, true);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(|").append(string2).append(string3);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected String getOrganizationDN(SSOToken sSOToken, String string) throws AMException {
        String string2;
        if (string.equals("") || !DN.isDN(string)) {
            debug.error("AMDirectoryManager.getOrganizationDN() Invalid DN: " + string);
            throw new AMException(sSOToken, "157");
        }
        DN dN = new DN(string);
        String[] stringArray = new String[]{"objectclass"};
        SearchControl searchControl = new SearchControl();
        searchControl.setSearchScope(0);
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        try {
            while (!bl && !bl2) {
                String string4;
                string2 = dN.toString();
                PersistentObject persistentObject = UMSObject.getObjectHandle(this.internalToken, new Guid(string2));
                SearchResults searchResults = persistentObject.search(string4 = this.getOrgSearchFilter(string), stringArray, searchControl);
                if (searchResults.hasMoreElements()) {
                    bl2 = true;
                    searchResults.abandon();
                    string3 = persistentObject.getGuid().toString().toLowerCase();
                    continue;
                }
                if (dN.countRDNs() == 1) {
                    bl = true;
                    debug.error("AMDirectoryManager.getOrganizationDN(): Reached root suffix. Unable to get parent Org");
                    continue;
                }
                dN = dN.getParent();
            }
        }
        catch (InvalidSearchFilterException invalidSearchFilterException) {
            bl = true;
            debug.error("AMDirectoryManager.getOrganizationDN(): Invalid search filter, unable to get Parent Organization: ", (Throwable)invalidSearchFilterException);
        }
        catch (UMSException uMSException) {
            bl = true;
            debug.error("AMDirectoryManager.getOrganizationDN(): Unable to Obtain Parent Organization", (Throwable)uMSException);
        }
        if (bl) {
            string2 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("124", string2), "124");
        }
        return string3;
    }

    protected void updateUserAttribute(SSOToken sSOToken, Set set, String string, boolean bl) throws AMException {
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryManager.updateUserAttribute(): groupDN:" + string + ", toAdd: " + bl + " members: " + set);
        }
        Attr attr = new Attr("iplanet-am-static-group-dn", string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            try {
                PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string2));
                if (bl) {
                    persistentObject.modify(attr, 0);
                } else {
                    persistentObject.modify(attr, 1);
                }
                persistentObject.save();
            }
            catch (UMSException uMSException) {
                debug.error("AMDirectoryManager.updateUserAttribute(): Failed while trying to set the static groupDN " + string + " for user: " + string2, (Throwable)uMSException);
                throw new AMException(sSOToken, "351", uMSException);
            }
        }
    }

    private void makeNamingFirst(AttrSet attrSet, String string, String string2) {
        int n = attrSet.indexOf(string);
        if (n == -1) {
            attrSet.add(new Attr(string, string2));
        } else {
            Attr attr = attrSet.elementAt(n);
            attr.removeValue(string2);
            String[] stringArray = attr.getStringValues();
            attr = new Attr(string, string2);
            attr.addValues(stringArray);
            attrSet.replace(attr);
        }
    }

    private AttrSet combineOCs(CreationTemplate creationTemplate, AttrSet attrSet) {
        Attr attr = attrSet.getAttribute("objectclass");
        Attr attr2 = creationTemplate.getAttribute("objectclass");
        Set set = attr != null ? AMCommonUtils.stringArrayToSet(attr.getStringValues()) : new HashSet();
        Set set2 = AMCommonUtils.stringArrayToSet(attr2.getStringValues());
        Set set3 = AMCommonUtils.combineOCs(set, set2);
        attrSet.remove("objectclass");
        Attr attr3 = new Attr("objectclass", set3.toArray(new String[set3.size()]));
        attrSet.add(attr3);
        return attrSet;
    }

    private void createUser(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMEntryExistsException, AMException {
        Object object;
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(1) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 1, false);
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(1), string);
        AMUserPasswordValidationImpl aMUserPasswordValidationImpl = new AMUserPasswordValidationImpl(sSOToken, string2);
        aMUserPasswordValidationImpl.validate(AMCommonUtils.attrSetToMap(attrSet));
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicUser", new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        PersistentObject persistentObject2 = new PersistentObject(creationTemplate, attrSet);
        try {
            persistentObject.addChild(persistentObject2);
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createUser(): Insufficient Access rights to create user", (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            if (AMCompliance.isComplianceUserDeletionEnabled()) {
                AMCompliance.checkIfDeletedUser(sSOToken, persistentObject2.getDN());
            }
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createUser() User already exists: ", (Throwable)entryAlreadyExistsException);
            }
            throw new AMEntryExistsException(sSOToken, "328", (UMSException)entryAlreadyExistsException);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createUser(): Internal Error occurred. Unable to create User Entry", (Throwable)uMSException);
            }
            this.processInternalException(sSOToken, uMSException, "324");
        }
        AMCallBackImpl.postProcess(sSOToken, persistentObject2.getDN(), string2, null, map, 1, 1, false);
        AMUserEntryProcessed aMUserEntryProcessed = AMDirectoryManager.getUserPostPlugin();
        if (aMUserEntryProcessed != null) {
            object = AMCommonUtils.attrSetToMap(attrSet);
            aMUserEntryProcessed.processUserAdd(sSOToken, persistentObject2.getDN(), (Map)object);
        }
        object = new AMEmailNotification(persistentObject2.getDN());
        ((AMEmailNotification)object).setUserCreateNotificationList();
        ((AMEmailNotification)object).sendUserCreateNotification(map);
    }

    private void createEntity(SSOToken sSOToken, PersistentObject persistentObject, int n, Map map, String string) throws UMSException, AMEntryExistsException, AMException {
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(n) + "=" + string + "," + persistentObject.getDN();
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(n), string);
        String string4 = AMNamingAttrManager.getCreationTemplateName(n);
        if (string4 == null) {
            string4 = "BasicUser";
        }
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(string4, new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        PersistentObject persistentObject2 = new PersistentObject(creationTemplate, attrSet);
        try {
            persistentObject.addChild(persistentObject2);
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createEntity(): Insufficient Access rights to create entity", (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            if (AMCompliance.isComplianceUserDeletionEnabled()) {
                AMCompliance.checkIfDeletedUser(sSOToken, persistentObject2.getDN());
            }
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createEntity() Entity already exists: ", (Throwable)entryAlreadyExistsException);
            }
            throw new AMEntryExistsException(sSOToken, "462", (UMSException)entryAlreadyExistsException);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createEntity(): Internal Error occurred. Unable to create User Entry", (Throwable)uMSException);
            }
            this.processInternalException(sSOToken, uMSException, "324");
        }
    }

    private void createResource(PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(21), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicResource", new Guid(string2), 1);
        Resource resource = new Resource(creationTemplate, attrSet);
        persistentObject.addChild(resource);
    }

    private void createRole(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(6) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 6, false);
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(6), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicManagedRole", new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        ManagedRole managedRole = new ManagedRole(creationTemplate, attrSet);
        persistentObject.addChild(managedRole);
        AMCallBackImpl.postProcess(sSOToken, managedRole.getDN(), string2, null, map, 1, 6, false);
    }

    private void createOrganization(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        Organization organization = null;
        String string3 = AMNamingAttrManager.getNamingAttr(2) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 2, false);
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(2), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicOrganization", new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        if (AMDCTree.isRequired()) {
            AttrSet[] attrSetArray = AMDCTree.splitAttrSet(persistentObject.getDN(), attrSet);
            organization = new Organization(creationTemplate, attrSetArray[0]);
            AMDCTree.createDomain(sSOToken, new Guid(string3), attrSet);
        } else {
            organization = new Organization(creationTemplate, attrSet);
        }
        try {
            persistentObject.addChild(organization);
        }
        catch (UMSException uMSException) {
            if (AMDCTree.isRequired()) {
                AMDCTree.removeDomain(sSOToken, string3);
            }
            throw uMSException;
        }
        if (AMCompliance.isAdminGroupsEnabled(organization.getDN())) {
            AMCompliance.createAdminGroups(sSOToken, organization);
        }
        AMCallBackImpl.postProcess(sSOToken, organization.getDN(), string2, null, map, 1, 2, false);
    }

    private void createGroup(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 9, false);
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(9), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicGroup", new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        StaticGroup staticGroup = new StaticGroup(creationTemplate, attrSet);
        persistentObject.addChild(staticGroup);
        Attr attr = attrSet.getAttribute("uniquemember");
        if (attr != null) {
            String[] stringArray = attr.getStringValues();
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
            this.updateUserAttribute(sSOToken, hashSet, staticGroup.getDN(), true);
        }
        AMCallBackImpl.postProcess(sSOToken, staticGroup.getDN(), string2, null, map, 1, 9, false);
    }

    private void createAssignDynamicGroup(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 12, false);
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(12), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicAssignableDynamicGroup", new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        AssignableDynamicGroup assignableDynamicGroup = new AssignableDynamicGroup(creationTemplate, attrSet);
        assignableDynamicGroup.setSearchFilter("(memberof=" + string3 + ")");
        assignableDynamicGroup.setSearchScope(2);
        assignableDynamicGroup.setSearchBase(new Guid(this.getOrganizationDN(sSOToken, persistentObject.getDN())));
        persistentObject.addChild(assignableDynamicGroup);
        AMCallBackImpl.postProcess(sSOToken, assignableDynamicGroup.getDN(), string2, null, map, 1, 12, false);
    }

    private void createDynamicGroup(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 11, false);
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(11), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicDynamicGroup", new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        DynamicGroup dynamicGroup = new DynamicGroup(creationTemplate, attrSet);
        String string4 = persistentObject.getDN();
        String string5 = dynamicGroup.getSearchFilter();
        if (LDAPUrl.defaultFilter.equalsIgnoreCase(string5)) {
            dynamicGroup.setSearchFilter(AMSearchFilterManager.getSearchFilter(1, string2));
        }
        dynamicGroup.setSearchScope(2);
        dynamicGroup.setSearchBase(new Guid(this.getOrganizationDN(sSOToken, string4)));
        persistentObject.addChild(dynamicGroup);
        AMCallBackImpl.postProcess(sSOToken, dynamicGroup.getDN(), string2, null, map, 1, 11, false);
    }

    private void createPeopleContainer(PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(5), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicPeopleContainer", new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        PeopleContainer peopleContainer = new PeopleContainer(creationTemplate, attrSet);
        persistentObject.addChild(peopleContainer);
    }

    private void createOrganizationalUnit(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(3) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 3, false);
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(3), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicOrganizationalUnit", new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        OrganizationalUnit organizationalUnit = new OrganizationalUnit(creationTemplate, attrSet);
        persistentObject.addChild(organizationalUnit);
        AMCallBackImpl.postProcess(sSOToken, organizationalUnit.getDN(), string2, null, map, 1, 3, false);
    }

    private void createGroupContainer(PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(4), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicGroupContainer", new Guid(string2), 1);
        OrganizationalUnit organizationalUnit = new OrganizationalUnit(creationTemplate, attrSet);
        persistentObject.addChild(organizationalUnit);
    }

    private void createFilteredRole(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        Serializable serializable;
        String string2 = this.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(8) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 8, false);
        AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(8), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicFilteredRole", new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        if (!attrSet.contains("nsRoleFilter")) {
            serializable = new Attr("nsRoleFilter", AMSearchFilterManager.getSearchFilter(1, string2));
            attrSet.add((Attr)serializable);
        }
        serializable = new FilteredRole(creationTemplate, attrSet);
        persistentObject.addChild((PersistentObject)serializable);
        AMCallBackImpl.postProcess(sSOToken, ((PersistentObject)serializable).getDN(), string2, null, map, 1, 8, false);
    }

    protected void createEntry(SSOToken sSOToken, String string, int n, String string2, Map map) throws AMEntryExistsException, AMException {
        try {
            if (string == null || string.equals("")) {
                throw new AMException(sSOToken, "320");
            }
            if (string2 == null) {
                throw new AMException(sSOToken, "322");
            }
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string2));
            switch (n) {
                case 1: {
                    this.createUser(sSOToken, persistentObject, map, string);
                    break;
                }
                case 6: 
                case 7: {
                    this.createRole(sSOToken, persistentObject, map, string);
                    break;
                }
                case 2: {
                    this.createOrganization(sSOToken, persistentObject, map, string);
                    break;
                }
                case 9: 
                case 10: {
                    this.createGroup(sSOToken, persistentObject, map, string);
                    break;
                }
                case 12: {
                    this.createAssignDynamicGroup(sSOToken, persistentObject, map, string);
                    break;
                }
                case 11: {
                    this.createDynamicGroup(sSOToken, persistentObject, map, string);
                    break;
                }
                case 5: {
                    this.createPeopleContainer(persistentObject, map, string);
                    break;
                }
                case 3: {
                    this.createOrganizationalUnit(sSOToken, persistentObject, map, string);
                    break;
                }
                case 4: {
                    this.createGroupContainer(persistentObject, map, string);
                    break;
                }
                case 8: {
                    this.createFilteredRole(sSOToken, persistentObject, map, string);
                    break;
                }
                case 21: {
                    this.createResource(persistentObject, map, string);
                    break;
                }
                case -9999: 
                case -1: {
                    throw new AMException(sSOToken, "326");
                }
                default: {
                    this.createEntity(sSOToken, persistentObject, n, map, string);
                    break;
                }
            }
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createEntry() Insufficient access rights to create entry: " + string, (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createEntry() Entry: " + string + "already exists: ", (Throwable)entryAlreadyExistsException);
            }
            String string3 = this.getEntryExistsMsgID(n);
            String string4 = this.getEntryName(entryAlreadyExistsException);
            Object[] objectArray = new Object[]{string4};
            throw new AMException(AMSDKBundle.getString(string3, objectArray), string3, objectArray);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createEntry() Unable to create entry: " + string, (Throwable)uMSException);
            }
            throw new AMException(sSOToken, "324", uMSException);
        }
    }

    private void processPreDeleteCallBacks(SSOToken sSOToken, String string, Map map, String string2, int n, boolean bl) throws AMException, SSOException {
        if (n != 5 && n != 4) {
            DN dN;
            DN dN2;
            String string3 = string2;
            if (!(n != 2 && n != 3 || (dN2 = new DN(AMStoreConnection.rootSuffix)).equals(dN = new DN(string2)))) {
                String string4 = new DN(string2).getParent().toString();
                string3 = this.getOrganizationDN(this.internalToken, string4);
            }
            if (map == null) {
                map = this.getAttributes(sSOToken, string, n);
            }
            AMCallBackImpl.preProcess(sSOToken, string, string3, map, null, 2, n, bl);
        }
    }

    private void processPostDeleteCallBacks(SSOToken sSOToken, String string, Map map, String string2, int n, boolean bl) throws AMException {
        if (n != 5 && n != 4) {
            DN dN;
            DN dN2;
            String string3 = string2;
            if (!(n != 2 && n != 3 || (dN2 = new DN(AMStoreConnection.rootSuffix)).equals(dN = new DN(string2)))) {
                String string4 = new DN(string2).getParent().toString();
                string3 = this.getOrganizationDN(this.internalToken, string4);
            }
            AMCallBackImpl.postProcess(sSOToken, string, string3, map, null, 2, n, bl);
        }
    }

    protected void removeEntry(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryManager.removeEntry(): Removing: " + string + " & recursive: " + bl);
        }
        if (bl) {
            this.removeSubtree(sSOToken, string, bl2);
            return;
        }
        this.removeSingleEntry(sSOToken, string, n, bl2);
    }

    private void removeSingleEntry(SSOToken sSOToken, String string, int n, boolean bl) throws AMException, SSOException {
        Object object;
        Map map = null;
        AMEmailNotification aMEmailNotification = null;
        String string2 = this.getOrganizationDN(this.internalToken, string);
        try {
            if (n == 1) {
                aMEmailNotification = new AMEmailNotification(string);
                aMEmailNotification.setUserDeleteNotificationList();
            }
            if (AMDirectoryManager.getUserPostPlugin() != null || aMEmailNotification != null && aMEmailNotification.isPresentUserDeleteNotificationList()) {
                map = this.getAttributes(sSOToken, string, n);
            }
            this.processPreDeleteCallBacks(sSOToken, string, map, string2, n, bl);
            if (AMDCTree.isRequired()) {
                object = AMCommonUtils.formatToRFC(string);
                AMDCTree.removeDomain(this.internalToken, (String)object);
            }
            object = new Guid(string);
            UMSObject.removeObject(sSOToken, (Guid)object);
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("AMDirectoryManager.removeEntry() Insufficient access rights to remove entry: " + string, (Throwable)accessRightsException);
            throw new AMException(sSOToken, "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            String string3 = this.getEntryName(entryNotFoundException);
            debug.error("AMDirectoryManager.removeEntry() Entry not found: " + string3, (Throwable)entryNotFoundException);
            String string4 = this.getEntryNotFoundMsgID(n);
            Object[] objectArray = new Object[]{string3};
            String string5 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString(string4, objectArray, string5), string4, objectArray);
        }
        catch (UMSException uMSException) {
            debug.error("AMDirectoryManager.removeEntry() Unable to remove:  Internal error occurred: ", (Throwable)uMSException);
            throw new AMException(sSOToken, "325", uMSException);
        }
        this.processPostDeleteCallBacks(sSOToken, string, map, string2, n, bl);
        if (n == 1) {
            object = AMDirectoryManager.getUserPostPlugin();
            if (object != null) {
                object.processUserDelete(sSOToken, string, map);
            }
            if (aMEmailNotification != null && aMEmailNotification.isPresentUserDeleteNotificationList()) {
                aMEmailNotification.sendUserDeleteNotification(map);
            }
        }
    }

    private void removeSubtree(SSOToken sSOToken, String string, boolean bl) throws AMException, SSOException {
        int n = -1;
        try {
            int n2;
            int n3;
            Guid guid = new Guid(string);
            PersistentObject persistentObject = UMSObject.getObjectHandle(this.internalToken, guid);
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(2);
            String string2 = "(|(objectclass=*)(objectclass=ldapsubEntry))";
            ArrayList<DN> arrayList = new ArrayList<DN>();
            int n4 = n3 = new DN(string).countRDNs();
            SearchResults searchResults = persistentObject.getChildren(string2, searchControl);
            while (searchResults.hasMoreElements()) {
                PersistentObject persistentObject2 = searchResults.next();
                DN dN = new DN(persistentObject2.getDN());
                if (debug.messageEnabled()) {
                    debug.message("AMDirectoryManager.removeEntry(): found child: " + persistentObject2.getDN());
                }
                if ((n2 = dN.countRDNs()) > n4) {
                    n4 = n2;
                }
                arrayList.add(dN);
            }
            if (debug.messageEnabled()) {
                debug.message("AMDirectoryManager.removeEntry(): max RDNs: " + n4);
            }
            int n5 = arrayList.size();
            int n6 = n4;
            while (n6 >= n3) {
                n2 = 0;
                while (n2 < n5) {
                    DN dN = (DN)arrayList.get(n2);
                    if (dN.countRDNs() == n6) {
                        if (debug.messageEnabled()) {
                            debug.message("AMDirectoryManager.removeEntry(): del " + dN.toRFCString());
                        }
                        String string3 = dN.toRFCString();
                        n = -1;
                        try {
                            n = this.getObjectType(this.internalToken, string3);
                        }
                        catch (AMException aMException) {
                            Guid guid2 = new Guid(string3);
                            UMSObject.removeObject(sSOToken, guid2);
                        }
                        if (n != -1 && n != -9999) {
                            try {
                                this.removeSingleEntry(sSOToken, string3, n, bl);
                            }
                            catch (AMPreCallBackException aMPreCallBackException) {
                                debug.error("AMDirectoryManager.removeSubTree: Aborting delete of: " + string3 + " due to pre-callback exception", (Throwable)aMPreCallBackException);
                            }
                        }
                        arrayList.remove(n2);
                        --n2;
                        --n5;
                    }
                    ++n2;
                }
                --n6;
            }
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("AMDirectoryManager.removeEntry() Insufficient access rights to remove entry: " + string, (Throwable)accessRightsException);
            throw new AMException(sSOToken, "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            String string4 = this.getEntryName(entryNotFoundException);
            debug.error("AMDirectoryManager.removeEntry() Entry not found: " + string4, (Throwable)entryNotFoundException);
            String string5 = this.getEntryNotFoundMsgID(n);
            Object[] objectArray = new Object[]{string4};
            String string6 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString(string5, objectArray, string6), string5, objectArray);
        }
        catch (UMSException uMSException) {
            debug.error("AMDirectoryManager.removeEntry() Unable to remove:  Internal error occurred: ", (Throwable)uMSException);
            throw new AMException(sSOToken, "325", uMSException);
        }
    }

    protected void removeAdminRole(SSOToken sSOToken, String string, boolean bl) throws SSOException, AMException {
        CharSequence charSequence;
        Object object;
        SSOTokenManager.getInstance().validateToken(sSOToken);
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryManager.removeAdminRole() dn: " + string + " recursive: " + bl);
        }
        DN dN = new DN(string);
        String string2 = this.getOrganizationDN(sSOToken, dN.getParent().toString());
        String string3 = string.replace(',', '_');
        String string4 = AMNamingAttrManager.getNamingAttr(6);
        String string5 = string4 + "=" + string3 + "," + string2;
        Set<String> set = Collections.EMPTY_SET;
        if (bl) {
            object = AMSearchFilterManager.getSearchFilter(6, string2);
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("(&").append((String)object).append("(");
            ((StringBuffer)charSequence).append(string4).append("=*").append(string3).append("))");
            set = this.search(sSOToken, string2, ((StringBuffer)charSequence).toString(), 1);
        } else {
            set = new HashSet<String>();
            set.add(string5);
        }
        object = set.iterator();
        while (object.hasNext()) {
            charSequence = (String)object.next();
            try {
                ManagedRole managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid((String)charSequence));
                managedRole.removeAllMembers();
                AMStoreConnection aMStoreConnection = new AMStoreConnection(this.internalToken);
                AMRole aMRole = aMStoreConnection.getRole((String)charSequence);
                aMRole.delete(bl);
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) continue;
                debug.message("AMDirectoryManager.removeAdminRole() Unable to  admin roles:", (Throwable)exception);
            }
        }
    }

    private Set searchResultsToSet(SearchResults searchResults) throws UMSException {
        OrderedSet orderedSet = new OrderedSet();
        if (searchResults != null) {
            while (searchResults.hasMoreElements()) {
                PersistentObject persistentObject = searchResults.next();
                orderedSet.add(persistentObject.getGuid().toString());
            }
        }
        return orderedSet;
    }

    protected Set search(SSOToken sSOToken, String string, String string2, int n) throws AMException {
        Set set = Collections.EMPTY_SET;
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(n);
            SearchResults searchResults = persistentObject.search(string2, searchControl);
            set = this.searchResultsToSet(searchResults);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.search(token:, entryDN: " + string + ", searchFilter: " + string2 + "searchScope: " + n + " error occurred: ", (Throwable)uMSException);
            }
            this.processInternalException(sSOToken, uMSException, "341");
        }
        return set;
    }

    protected AMSearchResults getSearchResults(SearchResults searchResults, SortKey sortKey, String[] stringArray, Collator collator, boolean bl) throws UMSException {
        TreeSet<Object> treeSet;
        Object object;
        Serializable serializable;
        TreeMap<Object, Object> treeMap = null;
        TreeSet<String> treeSet2 = null;
        if (sortKey != null) {
            treeMap = new TreeMap<Object, Object>(collator);
            treeSet2 = new TreeSet<String>();
        }
        OrderedSet orderedSet = new OrderedSet();
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        int n = 0;
        try {
            if (searchResults != null) {
                while (searchResults.hasMoreElements()) {
                    serializable = searchResults.next();
                    String string = ((PersistentObject)serializable).getGuid().toString();
                    if (treeMap != null) {
                        object = ((PersistentObject)serializable).getAttribute(sortKey.attributeName);
                        if (object != null) {
                            String string2 = object.getStringValues()[0];
                            Object v = treeMap.get(string2);
                            if (v == null) {
                                treeMap.put(string2, string);
                            } else if (v instanceof String) {
                                treeSet = new TreeSet<Object>();
                                treeSet.add(v);
                                treeSet.add(string);
                                treeMap.put(string2, treeSet);
                            } else {
                                ((TreeSet)v).add(string);
                            }
                        } else {
                            treeSet2.add(string);
                        }
                    } else {
                        orderedSet.add(string);
                    }
                    object = new AttrSet();
                    if (stringArray != null) {
                        object = ((PersistentObject)serializable).getAttributes(stringArray, true);
                    } else if (bl) {
                        object = ((PersistentObject)serializable).getAttributes(((PersistentObject)serializable).getAttributeNames(), true);
                    }
                    hashMap.put(string, AMCommonUtils.attrSetToMap((AttrSet)object));
                }
            }
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
            n = 1;
        }
        catch (TimeLimitExceededException timeLimitExceededException) {
            n = 2;
        }
        serializable = (Integer)searchResults.get("vlvContentCount");
        int n2 = serializable == null ? -1 : (Integer)serializable;
        if (treeMap != null) {
            int n3;
            object = treeMap.values().toArray();
            int n4 = ((Object[])object).length;
            if (sortKey.reverse) {
                n3 = n4 - 1;
                while (n3 >= 0) {
                    treeSet = object[n3];
                    if (treeSet instanceof String) {
                        orderedSet.add(treeSet);
                    } else {
                        orderedSet.addAll((Collection)treeSet);
                    }
                    --n3;
                }
            } else {
                n3 = 0;
                while (n3 < n4) {
                    treeSet = object[n3];
                    if (treeSet instanceof String) {
                        orderedSet.add(treeSet);
                    } else {
                        orderedSet.addAll((Collection)treeSet);
                    }
                    ++n3;
                }
            }
            Iterator iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                orderedSet.add(iterator.next());
            }
        }
        object = new AMSearchResults(n2, (Set)orderedSet, n, hashMap);
        return object;
    }

    protected AMSearchResults search(SSOToken sSOToken, String string, String string2, SearchControl searchControl, String[] stringArray) throws AMException {
        AMSearchResults aMSearchResults = null;
        try {
            SearchResults searchResults;
            SearchControl searchControl2;
            SortKey[] sortKeyArray = searchControl.getSortKeys();
            SortKey sortKey = null;
            if (sortKeyArray != null && sortKeyArray.length > 0 && sortKeyArray[0].attributeName != null) {
                sortKey = sortKeyArray[0];
            }
            String string3 = AMCommonUtils.getUserLocale(sSOToken);
            if (debug.messageEnabled()) {
                debug.message("AMDirectoryManager.search() search with searchcontrol locale = " + string3);
            }
            Collator collator = Collator.getInstance(Locale.getLocale((String)string3));
            if (sortKey != null) {
                searchControl2 = new SearchControl();
                searchControl2.setMaxResults(searchControl.getMaxResults());
                searchControl2.setSearchScope(searchControl.getSearchScope());
                searchControl2.setTimeOut(searchControl.getTimeOut());
            } else {
                searchControl2 = searchControl;
            }
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            if (stringArray == null) {
                if (sortKey == null) {
                    searchResults = persistentObject.search(string2, searchControl2);
                } else {
                    String[] stringArray2 = new String[]{sortKey.attributeName};
                    searchResults = persistentObject.search(string2, stringArray2, searchControl2);
                }
            } else if (sortKey == null) {
                searchResults = persistentObject.search(string2, stringArray, searchControl2);
            } else {
                String[] stringArray3 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                stringArray3[stringArray.length] = sortKey.attributeName;
                searchResults = persistentObject.search(string2, stringArray3, searchControl2);
            }
            aMSearchResults = this.getSearchResults(searchResults, sortKey, stringArray, collator, searchControl2.isGetAllReturnAttributesEnabled());
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.search() with search control entryDN: " + string + " Search Filter: " + string2 + " Error occurred: ", (Throwable)uMSException);
            }
            this.processInternalException(sSOToken, uMSException, "341");
        }
        return aMSearchResults;
    }

    protected Set getMembers(SSOToken sSOToken, String string, int n) throws AMException {
        try {
            switch (n) {
                case 6: 
                case 7: {
                    ManagedRole managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid(string));
                    SearchResults searchResults = managedRole.getMemberIDs();
                    return this.searchResultsToSet(searchResults);
                }
                case 8: {
                    FilteredRole filteredRole = (FilteredRole)UMSObject.getObject(sSOToken, new Guid(string));
                    SearchResults searchResults = filteredRole.getMemberIDs();
                    return this.searchResultsToSet(searchResults);
                }
                case 9: 
                case 10: {
                    StaticGroup staticGroup = (StaticGroup)UMSObject.getObject(sSOToken, new Guid(string));
                    SearchResults searchResults = staticGroup.getMemberIDs();
                    return this.searchResultsToSet(searchResults);
                }
                case 11: {
                    DynamicGroup dynamicGroup = (DynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
                    SearchResults searchResults = dynamicGroup.getMemberIDs();
                    return this.searchResultsToSet(searchResults);
                }
                case 12: {
                    AssignableDynamicGroup assignableDynamicGroup = new AssignableDynamicGroup();
                    AssignableDynamicGroup assignableDynamicGroup2 = (AssignableDynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
                    SearchResults searchResults = assignableDynamicGroup2.getMemberIDs();
                    return this.searchResultsToSet(searchResults);
                }
            }
            throw new AMException(sSOToken, "114");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            debug.error("AMDirectoryManager.getMembers() entryDN " + string + " objectType: " + n + " Unable to get members: ", (Throwable)entryNotFoundException);
            String string2 = this.getEntryNotFoundMsgID(n);
            String string3 = this.getEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string3};
            throw new AMException(AMSDKBundle.getString(string2, objectArray), string2, objectArray);
        }
        catch (UMSException uMSException) {
            debug.error("AMDirectoryManager.getMembers() entryDN " + string + " objectType: " + n + " Unable to get members: ", (Throwable)uMSException);
            throw new AMException(sSOToken, "454", uMSException);
        }
    }

    protected String renameEntry(SSOToken sSOToken, int n, String string, String string2, boolean bl) throws AMException {
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            String string3 = AMNamingAttrManager.getNamingAttr(n) + "=" + string2;
            persistentObject.rename(string3, bl);
            return persistentObject.getDN();
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.renameEntry(): User does not have sufficient access rights ", (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.renameEntry(): Entry not found: ", (Throwable)entryNotFoundException);
            }
            String string4 = this.getEntryNotFoundMsgID(n);
            String string5 = this.getEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string5};
            throw new AMException(AMSDKBundle.getString(string4, objectArray), string4, objectArray);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.renameEntry(): Unable to rename entry: ", (Throwable)uMSException);
            }
            throw new AMException(sSOToken, "360");
        }
    }

    private Map setDCTreeAttributes(SSOToken sSOToken, String string, Map map, int n) throws AMException {
        if (n == 2 && AMDCTree.isRequired() && !string.equals(AMStoreConnection.rootSuffix)) {
            AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
            String string2 = attrSet.getValue("inetdomainstatus");
            if (string2 != null) {
                AMDCTree.updateDomainStatus(sSOToken, string, string2);
            }
            AttrSet[] attrSetArray = AMDCTree.splitAttrSet(string, attrSet);
            attrSet = attrSetArray[0];
            map = AMCommonUtils.attrSetToMap(attrSet);
            AttrSet attrSet2 = attrSetArray[1];
            AMDCTree.setDomainAttributes(sSOToken, string, attrSet2);
        }
        return map;
    }

    private void processPostModifyCallBacks(SSOToken sSOToken, String string, Map map, Map map2, String string2, int n) throws AMException {
        if (n != 5 && n != 4) {
            DN dN;
            DN dN2;
            String string3 = string2;
            if (!(n != 2 && n != 3 || (dN2 = new DN(AMStoreConnection.rootSuffix)).equals(dN = new DN(string2)))) {
                String string4 = new DN(string2).getParent().toString();
                string3 = this.getOrganizationDN(this.internalToken, string4);
            }
            AMCallBackImpl.postProcess(sSOToken, string, string3, map, map2, 3, n, false);
        }
    }

    private Map processPreModifyCallBacks(SSOToken sSOToken, String string, Map map, Map map2, String string2, int n) throws AMException, SSOException {
        if (n != 5 && n != 4) {
            DN dN;
            Object object;
            String string3 = string2;
            if (!(n != 2 && n != 3 || ((DN)(object = new DN(AMStoreConnection.rootSuffix))).equals(dN = new DN(string2)))) {
                String string4 = new DN(string2).getParent().toString();
                string3 = this.getOrganizationDN(this.internalToken, string4);
            }
            if (map == null) {
                object = map2.keySet();
                map = this.getAttributes(sSOToken, string, (Set)object, n);
            }
            map2 = AMCallBackImpl.preProcess(sSOToken, string, string3, map, map2, 3, n, false);
        }
        return map2;
    }

    private void modifyPersistentObject(PersistentObject persistentObject, Attr attr, boolean bl) {
        if (attr.size() == 0) {
            persistentObject.modify(attr, 1);
        } else if (bl) {
            persistentObject.modify(attr, 0);
        } else {
            persistentObject.modify(attr, 2);
        }
    }

    private void modifyAndSaveEntry(SSOToken sSOToken, String string, Map map, Map map2, boolean bl) throws AccessRightsException, EntryNotFoundException, UMSException {
        String[] stringArray;
        Object object;
        String string2;
        Iterator iterator;
        PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
        if (map != null && !map.isEmpty()) {
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                object = (Set)map.get(string2);
                stringArray = object == null ? null : object.toArray(new String[object.size()]);
                Attr attr = new Attr(string2, stringArray);
                this.modifyPersistentObject(persistentObject, attr, bl);
            }
        }
        if (map2 != null && !map2.isEmpty()) {
            iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                object = (byte[][])map2.get(string2);
                stringArray = new Attr(string2, (byte[][])object);
                this.modifyPersistentObject(persistentObject, (Attr)stringArray, bl);
            }
        }
        persistentObject.save();
    }

    protected void setAttributes(SSOToken sSOToken, String string, int n, Map map, Map map2, boolean bl) throws AMException, SSOException {
        Object object;
        Map map3 = null;
        AMEmailNotification aMEmailNotification = null;
        String string2 = this.getOrganizationDN(this.internalToken, string);
        try {
            if (debug.messageEnabled()) {
                debug.message("AMDirectoryManager.setAttributes() entryDN: " + string);
            }
            if (n == 1) {
                object = new AMUserPasswordValidationImpl(sSOToken, string2);
                ((AMUserPasswordValidationImpl)object).validate(map);
                aMEmailNotification = new AMEmailNotification(string);
                aMEmailNotification.setUserModifyNotificationList();
            }
            if (AMDirectoryManager.getUserPostPlugin() != null || aMEmailNotification != null && aMEmailNotification.isPresentUserModifyNotificationList()) {
                object = map.keySet();
                map3 = this.getAttributes(sSOToken, string, (Set)object, n);
            }
            map = this.processPreModifyCallBacks(sSOToken, string, map3, map, string2, n);
            this.setDCTreeAttributes(sSOToken, string, map, n);
            this.modifyAndSaveEntry(sSOToken, string, map, map2, bl);
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.setAttributes() User does not have sufficient access rights: ", (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.setAttributes() Entry not found: ", (Throwable)entryNotFoundException);
            }
            String string3 = this.getEntryNotFoundMsgID(n);
            String string4 = this.getEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string4};
            throw new AMException(AMSDKBundle.getString(string3, objectArray), string3, objectArray);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.setAttributes() Internal error occurred", (Throwable)uMSException);
            }
            this.processInternalException(sSOToken, uMSException, "452");
        }
        this.processPostModifyCallBacks(sSOToken, string, map3, map, string2, n);
        if (n == 1) {
            object = AMDirectoryManager.getUserPostPlugin();
            if (object != null) {
                object.processUserModify(sSOToken, string, map3, map);
            }
            if (aMEmailNotification != null && aMEmailNotification.isPresentUserModifyNotificationList()) {
                aMEmailNotification.sendUserModifyNotification(sSOToken, map, map3);
            }
        }
    }

    protected void modifyRoleMembership(SSOToken sSOToken, String string, Set set, int n, int n2) throws UMSException, AMException {
        ManagedRole managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid(string));
        String string2 = managedRole.getParentGuid().getDn();
        String string3 = this.getOrganizationDN(sSOToken, string2);
        if (AMCallBackImpl.isExistsPrePostPlugins(string3) && ((set = AMCallBackImpl.preProcessModifyMemberShip(sSOToken, string, string3, set, n, n2)) == null || set.isEmpty())) {
            return;
        }
        switch (n) {
            case 1: {
                Guid[] guidArray = AMCommonUtils.toGuidArray(set);
                managedRole.addMembers(guidArray);
                Iterator iterator = set.iterator();
                if (!AMCompliance.isAdminGroupsEnabled(string2)) break;
                AMCompliance.verifyAndLinkRoleToGroup(sSOToken, guidArray, string);
                break;
            }
            case 2: {
                Object[] objectArray = set.toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    managedRole.removeMember(new Guid((String)objectArray[n3]));
                    ++n3;
                }
                if (!AMCompliance.isAdminGroupsEnabled(string2)) break;
                AMCompliance.verifyAndUnLinkRoleToGroup(sSOToken, set, string);
                break;
            }
            default: {
                throw new AMException(sSOToken, "114");
            }
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string3)) {
            AMCallBackImpl.postProcessModifyMemberShip(sSOToken, string, string3, set, n, n2);
        }
    }

    private void modifyGroupMembership(SSOToken sSOToken, String string, Set set, int n, int n2) throws UMSException, AMException {
        StaticGroup staticGroup = (StaticGroup)UMSObject.getObject(sSOToken, new Guid(string));
        String string2 = staticGroup.getParentGuid().getDn();
        String string3 = this.getOrganizationDN(sSOToken, string2);
        if (AMCallBackImpl.isExistsPrePostPlugins(string3) && ((set = AMCallBackImpl.preProcessModifyMemberShip(sSOToken, string, string3, set, n, n2)) == null || set.isEmpty())) {
            return;
        }
        switch (n) {
            case 1: {
                staticGroup.addMembers(AMCommonUtils.toGuidArray(set));
                this.updateUserAttribute(sSOToken, set, string, true);
                break;
            }
            case 2: {
                Object[] objectArray = set.toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    staticGroup.removeMember(new Guid((String)objectArray[n3]));
                    ++n3;
                }
                this.updateUserAttribute(sSOToken, set, string, false);
                break;
            }
            default: {
                throw new AMException(sSOToken, "114");
            }
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string3)) {
            AMCallBackImpl.postProcessModifyMemberShip(sSOToken, string, string3, set, n, n2);
        }
    }

    private void modifyAssignDynamicGroupMembership(SSOToken sSOToken, String string, Set set, int n, int n2) throws UMSException, AMException {
        AssignableDynamicGroup assignableDynamicGroup = new AssignableDynamicGroup();
        AssignableDynamicGroup assignableDynamicGroup2 = (AssignableDynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
        String string2 = assignableDynamicGroup2.getParentGuid().getDn();
        String string3 = this.getOrganizationDN(sSOToken, string2);
        if (AMCallBackImpl.isExistsPrePostPlugins(string3) && ((set = AMCallBackImpl.preProcessModifyMemberShip(sSOToken, string, string3, set, n, n2)) == null || set.isEmpty())) {
            return;
        }
        switch (n) {
            case 1: {
                Guid[] guidArray = AMCommonUtils.toGuidArray(set);
                assignableDynamicGroup2.addMembers(AMCommonUtils.toGuidArray(set));
                if (!AMCompliance.isAdminGroupsEnabled(AMStoreConnection.rootSuffix)) break;
                AMCompliance.verifyAndLinkGroupToRole(sSOToken, guidArray, string);
                break;
            }
            case 2: {
                Object[] objectArray = set.toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    assignableDynamicGroup2.removeMember(new Guid((String)objectArray[n3]));
                    ++n3;
                }
                if (!AMCompliance.isAdminGroupsEnabled(AMStoreConnection.rootSuffix)) break;
                AMCompliance.verifyAndUnLinkGroupToRole(sSOToken, set, string);
                break;
            }
            default: {
                throw new AMException(sSOToken, "114");
            }
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string3)) {
            AMCallBackImpl.postProcessModifyMemberShip(sSOToken, string, string3, set, n, n2);
        }
    }

    private AMException generateMemberShipException(SSOToken sSOToken, String string, int n, EntryNotFoundException entryNotFoundException) {
        DN dN = this.getExceptionDN(entryNotFoundException);
        DN dN2 = new DN(string);
        if (dN == null) {
            debug.error("AMDirectoryManager.modMemberShip", (Throwable)entryNotFoundException);
            Object[] objectArray = new Object[]{string};
            String string2 = AMCommonUtils.getUserLocale(sSOToken);
            return new AMException(AMSDKBundle.getString("461", objectArray, string2), "461", objectArray);
        }
        String string3 = ((RDN)dN.getRDNs().firstElement()).getValues()[0];
        String string4 = null;
        if (dN.equals(dN2)) {
            switch (n) {
                case 6: 
                case 7: {
                    string4 = "465";
                    break;
                }
                case 9: 
                case 10: 
                case 12: {
                    string4 = "466";
                }
            }
        } else {
            string4 = "468";
        }
        debug.error("AMDirectoryManager.modMemberShip() - Entry not found " + string, (Throwable)entryNotFoundException);
        Object[] objectArray = new Object[]{string3};
        return new AMException(AMSDKBundle.getString(string4, objectArray), string4, objectArray);
    }

    protected void modifyMemberShip(SSOToken sSOToken, Set set, String string, int n, int n2) throws AMException {
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryManager.modMemberShip: targetDN = <" + string + ">, Members: " + set + ", object Type = " + n + "Operation = " + n2);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals("") && DN.isDN(string2)) continue;
            debug.error("AMDirectoryManager.modifyMemberShip() Invalid DN: " + string2);
            throw new AMException(sSOToken, "157");
        }
        try {
            switch (n) {
                case 6: 
                case 7: {
                    this.modifyRoleMembership(sSOToken, string, set, n2, n);
                    break;
                }
                case 9: 
                case 10: {
                    this.modifyGroupMembership(sSOToken, string, set, n2, n);
                    break;
                }
                case 12: {
                    this.modifyAssignDynamicGroupMembership(sSOToken, string, set, n2, n);
                    break;
                }
                default: {
                    throw new AMException(sSOToken, "114");
                }
            }
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("AMDirectoryManager.modMemberShip() - Insufficient access rights: ", (Throwable)accessRightsException);
            throw new AMException(sSOToken, "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            throw this.generateMemberShipException(sSOToken, string, n, entryNotFoundException);
        }
        catch (UMSException uMSException) {
            debug.message("AMDirectoryManager.modMemberShip() - Unable to modify membership", (Throwable)uMSException);
            throw new AMException(sSOToken, "350", uMSException);
        }
    }

    protected Set getRegisteredServiceNames(SSOToken sSOToken, String string) throws AMException {
        try {
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add("sunRegisteredServiceName");
            Map map = this.getAttributes(this.internalToken, string, hashSet, -9999);
            Set set = Collections.EMPTY_SET;
            if (map.size() == 1) {
                set = (Set)map.get("sunRegisteredServiceName");
            }
            if (debug.messageEnabled()) {
                debug.message("AMDirectoryManager.getRegisteredServiceNames() Registered Service Names for entryDN: " + string + " are: " + set);
            }
            return set;
        }
        catch (Exception exception) {
            debug.error("AMDirectoryManager.getRegisteredService", (Throwable)exception);
            throw new AMException(sSOToken, "455");
        }
    }

    protected void registerService(SSOToken sSOToken, String string, String string2) throws AMException, SSOException {
        try {
            Set set = this.getServiceAttributesWithQualifier(sSOToken, string2);
            if (set != null && !set.isEmpty()) {
                PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
                DirectCOSDefinition directCOSDefinition = this.createCOSDefinition(string2, set);
                COSManager cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getGuid());
                cOSManager.addDefinition(directCOSDefinition);
            }
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("AMDirectoryManager.registerService() Insufficient access rights to register service: " + string2, (Throwable)accessRightsException);
            throw new AMException(sSOToken, "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            debug.error("AMDirectoryManager.registerService() Service " + string2 + " already registered", (Throwable)entryAlreadyExistsException);
            Object[] objectArray = new Object[]{string2};
            String string3 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("464", objectArray, string3), "464", objectArray);
        }
        catch (SMSException sMSException) {
            debug.error("AMDirectoryManager.registerService() Unable to register service: " + string2, (Throwable)sMSException);
            throw new AMException(sSOToken, "914");
        }
        catch (UMSException uMSException) {
            debug.error("AMDirectoryManager.registerService() Unable to register service: " + string2, (Throwable)uMSException);
            throw new AMException(sSOToken, "914", uMSException);
        }
    }

    private Set getServiceAttributesWithQualifier(SSOToken sSOToken, String string) throws SMSException, SSOException {
        ServiceSchema serviceSchema;
        block4: {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            serviceSchema = null;
            try {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
            }
            catch (SMSException sMSException) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMDirectoryManager.getServiceNames(): No schema defined for SchemaType.DYNAMIC type");
            }
        }
        if (serviceSchema == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set set = serviceSchema.getAttributeSchemaNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string2);
            String string3 = string2 + " " + attributeSchema.getCosQualifier();
            hashSet.add(string3);
        }
        return hashSet;
    }

    private DirectCOSDefinition createCOSDefinition(String string, Set set) throws UMSException {
        AttrSet attrSet = new AttrSet();
        Attr attr = new Attr("cn", string);
        attrSet.add(attr);
        attr = new Attr("cosSpecifier", "nsrole");
        attrSet.add(attr);
        attr = new Attr("cosAttribute");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            attr.addValue(string2);
        }
        attrSet.add(attr);
        return new DirectCOSDefinition(attrSet);
    }

    protected void unRegisterService(SSOToken sSOToken, String string, int n, String string2, int n2) throws AMException {
        if (n2 != 301) {
            return;
        }
        try {
            DirectCOSDefinition directCOSDefinition;
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            COSManager cOSManager = null;
            switch (n) {
                case 6: 
                case 8: {
                    cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getParentGuid());
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getGuid());
                    break;
                }
                default: {
                    throw new AMException(sSOToken, "450");
                }
            }
            try {
                directCOSDefinition = (DirectCOSDefinition)cOSManager.getDefinition(string2);
            }
            catch (COSNotFoundException cOSNotFoundException) {
                if (debug.messageEnabled()) {
                    debug.message("AMDirectoryManager.unRegisterService() No COSDefinition found for service: " + string2);
                }
                Object[] objectArray = new Object[]{string2};
                String string3 = AMCommonUtils.getUserLocale(sSOToken);
                throw new AMException(AMSDKBundle.getString("463", objectArray, string3), "463", objectArray);
            }
            directCOSDefinition.removeCOSTemplates();
            cOSManager.removeDefinition(string2);
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("AMDirectoryManager.unregisterService() Insufficient Access rights to unRegister service: ", (Throwable)accessRightsException);
            throw new AMException(sSOToken, "460");
        }
        catch (UMSException uMSException) {
            debug.error("AMDirectoryManager.removeService", (Throwable)uMSException);
            throw new AMException(sSOToken, "855", uMSException);
        }
    }

    protected String getAMTemplateDN(SSOToken sSOToken, String string, int n, String string2, int n2) throws AMException {
        String string3 = null;
        try {
            switch (n) {
                case 6: 
                case 8: {
                    string3 = string;
                    PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
                    return "cn=\"" + string3 + "\",cn=" + string2 + "," + persistentObject.getParentGuid().toString();
                }
                case 2: 
                case 3: 
                case 5: {
                    string3 = "cn=ContainerDefaultTemplateRole," + string;
                    return "cn=\"" + string3 + "\",cn=" + string2 + "," + string;
                }
            }
            throw new AMException(sSOToken, "450");
        }
        catch (UMSException uMSException) {
            debug.error("AMDirectoryManager.getAMTemplateDN() Unable to get AMTemplate DN for service: " + string2 + " entryDN: " + string, (Throwable)uMSException);
            throw new AMException(sSOToken, "349", uMSException);
        }
    }

    protected String createAMTemplate(SSOToken sSOToken, String string, int n, String string2, Map map, int n2) throws AMException {
        COSManager cOSManager = null;
        DirectCOSDefinition directCOSDefinition = null;
        String string3 = null;
        try {
            Serializable serializable;
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            switch (n) {
                case 6: 
                case 8: {
                    string3 = string;
                    cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getParentGuid());
                    directCOSDefinition = (DirectCOSDefinition)cOSManager.getDefinition(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string3 = "cn=ContainerDefaultTemplateRole," + string;
                    cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getGuid());
                    directCOSDefinition = (DirectCOSDefinition)cOSManager.getDefinition(string2);
                    break;
                }
                default: {
                    throw new AMException(sSOToken, "450");
                }
            }
            AttrSet attrSet = AMCommonUtils.mapToAttrSet(map);
            if (n2 != -1) {
                serializable = new Attr("cospriority");
                ((Attr)serializable).addValue("" + n2);
                attrSet.add((Attr)serializable);
            }
            serializable = this.createCOSTemplate(string2, attrSet, string3);
            directCOSDefinition.addCOSTemplate((COSTemplate)serializable);
            return ((PersistentObject)serializable).getGuid().toString();
        }
        catch (COSNotFoundException cOSNotFoundException) {
            if (debug.messageEnabled()) {
                debug.message("AMDirectoryManager.createAMTemplate() COSDefinition for service: " + string2 + " not found: ", (Throwable)cOSNotFoundException);
            }
            Object[] objectArray = new Object[]{string2};
            String string4 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("459", string4), "459", objectArray);
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            if (debug.messageEnabled()) {
                debug.message("AMDirectoryManager.createAMTemplate: template already exists for " + string2, (Throwable)entryAlreadyExistsException);
            }
            Object[] objectArray = new String[]{string2};
            String string5 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("854", objectArray, string5), "854", objectArray);
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createAMTemplate() Insufficient access rights to create template for: " + string2 + " & entryDN: " + string, (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createAMTemplate() Unable to create AMTemplate for: " + string2 + " & entryDN: " + string, (Throwable)uMSException);
            }
            Object[] objectArray = new Object[]{string2};
            String string6 = AMCommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("459", string6), "459", objectArray, uMSException);
        }
        catch (Exception exception) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager.createAMTemplate", (Throwable)exception);
            }
            throw new AMException(sSOToken, "451");
        }
    }

    private COSTemplate createCOSTemplate(String string, AttrSet attrSet, String string2) throws UMSException {
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicCOSTemplate", null);
        COSTemplate cOSTemplate = new COSTemplate(creationTemplate, "\"" + string2 + "\"");
        cOSTemplate.addTemplateAttribute("objectclass", "extensibleObject");
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryManager.newCOSTemplate: cn = " + string2 + " COSTemplate = " + cOSTemplate);
        }
        int n = attrSet.size();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = attrSet.elementAt(n2);
            cOSTemplate.modify(attr, 0);
            ++n2;
        }
        return cOSTemplate;
    }
}

