/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.sso.SSOToken;
import java.util.Collections;
import netscape.ldap.util.DN;

class AMACIEventListener
implements IDSEventListener {
    protected static final String SEARCH_FILTER = "(aci=*)";
    protected static final int OPERATIONS = 15;
    private Debug debug;
    private SSOToken internalToken = AMCommonUtils.getInternalToken();
    private AMDirectoryManager dsManager;

    public AMACIEventListener() {
        this.debug = AMCommonUtils.debug;
        this.dsManager = AMDirectoryWrapper.getInstance();
    }

    public void entryChanged(DSEvent dSEvent) {
        String string;
        DN dN = new DN(dSEvent.getID());
        String string2 = dN.toRFCString().toLowerCase();
        if (this.debug.messageEnabled()) {
            this.debug.message("AMACIEventListener.entryChanged() DSEvent for dn: " + dSEvent.getID());
        }
        if ((string = dSEvent.getClassName()).indexOf("cosClassicDefinition") != -1 || string.indexOf("costemplate") != -1) {
            return;
        }
        this.dsManager.dirtyCache(dSEvent, string2, false, true, string2, Collections.EMPTY_SET);
        AMStoreConnection.updateCache(dSEvent, string2);
        AMObjectImpl.notifyACIChangeEvent(dSEvent);
    }

    public void eventError(String string) {
        this.debug.error("AMACIEventListener.eventError(): " + string);
    }

    public void allEntriesChanged() {
    }
}

