/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;

class UserUnregisterServicesReq
extends AdminReq {
    private Set serviceSet = new HashSet();

    UserUnregisterServicesReq(String string) {
        super(string);
    }

    void unregisterServicesReq(String string) {
        this.serviceSet.add(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription60") + " " + this.targetDN);
        printUtils.printSet(this.serviceSet, 1);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("unregisteredservices"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("user") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("unregisteredservices"));
        try {
            AMUser aMUser = aMStoreConnection.getUser(this.targetDN);
            aMUser.unassignServices(this.serviceSet);
            PrintUtils printUtils = new PrintUtils(AdminReq.writer);
            printUtils.printSet(this.serviceSet, 1);
            this.doLogStringSet(this.serviceSet, aMUser, "unregister-service");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

