/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.GetUserReq;
import com.iplanet.am.admin.cli.UserUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

class RoleGetUserReq
extends GetUserReq {
    RoleGetUserReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription56") + " " + this.targetDN);
        printWriter.println("   DNsOnly =" + this.DNsOnly);
        if (this.userDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.userDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("role") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getusers"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("role") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getusers"));
        Set set = this.getUserDNs(aMStoreConnection);
        AdminReq.writer.println(this.targetDN);
        if (this.userDNs.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                UserUtils.printUserInformation(printUtils, string, aMStoreConnection, this.DNsOnly);
            }
        } else {
            Iterator iterator = this.userDNs.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (!set.contains(string)) continue;
                UserUtils.printUserInformation(printUtils, string, aMStoreConnection, this.DNsOnly);
            }
        }
    }

    protected Set getUserDNs(AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            AMRole aMRole = aMStoreConnection.getRole(this.targetDN);
            return aMRole.getUserDNs();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

