/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SchemaType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class PCCreateUserReq
extends AdminReq {
    private Map userReq = new HashMap();
    private SSOToken ssoToken;

    PCCreateUserReq(String string, SSOToken sSOToken) {
        super(string);
        this.ssoToken = sSOToken;
    }

    void addUserReq(String string, Map map) {
        this.userReq.put(string, map);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription47") + " " + this.targetDN);
        AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, this.ssoToken, this.userReq, "iPlanetAMUserService", SchemaType.USER);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("peoplecontainer") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("createusers"));
        try {
            AMPeopleContainer aMPeopleContainer = aMStoreConnection.getPeopleContainer(this.targetDN);
            Set set = aMPeopleContainer.createUsers(this.userReq);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("statusmsg26"));
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMUser aMUser = (AMUser)iterator.next();
                AdminReq.writer.println(aMUser.getDN());
            }
            this.doLog(set, "create-user");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

