/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class OrgDeleteServiceTemplateReq
extends AdminReq {
    private String serviceName;
    private String schemaType;

    OrgDeleteServiceTemplateReq() {
    }

    OrgDeleteServiceTemplateReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription62") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void setServiceTemplateReq(String string, String string2) {
        this.serviceName = string;
        this.schemaType = string2;
    }

    void process(AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deleteservicetemplates"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deleteservicetemplates"));
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            List list = this.getSchemaTypesToDelete();
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(sSOToken, this.serviceName);
            Set set = serviceSchemaManager.getSchemaTypes();
            AdminReq.writer.println(this.serviceName);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMTemplate aMTemplate;
                SchemaType schemaType = (SchemaType)iterator.next();
                if (!list.contains(schemaType)) continue;
                if (schemaType.equals(SchemaType.ORGANIZATION)) {
                    aMTemplate = aMOrganization.getTemplate(this.serviceName, 302);
                    aMTemplate.delete();
                    this.doLog(this.serviceName, aMOrganization, "delete-servtemplate");
                    continue;
                }
                if (schemaType.equals(SchemaType.DYNAMIC)) {
                    aMTemplate = aMOrganization.getTemplate(this.serviceName, 301);
                    aMTemplate.delete();
                    this.doLog(this.serviceName, aMOrganization, "delete-servtemplate");
                    continue;
                }
                if (!schemaType.equals(SchemaType.POLICY)) continue;
                aMTemplate = aMOrganization.getTemplate(this.serviceName, 300);
                aMTemplate.delete();
                this.doLog(this.serviceName, aMOrganization, "delete-servtemplate");
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private List getSchemaTypesToDelete() {
        ArrayList<SchemaType> arrayList = Collections.EMPTY_LIST;
        if (this.schemaType == null || this.schemaType.length() == 0) {
            arrayList = new ArrayList<SchemaType>(3);
            arrayList.add(SchemaType.ORGANIZATION);
            arrayList.add(SchemaType.DYNAMIC);
            arrayList.add(SchemaType.POLICY);
        } else if (this.schemaType.equalsIgnoreCase("organization")) {
            arrayList = new ArrayList(1);
            arrayList.add(SchemaType.ORGANIZATION);
        } else if (this.schemaType.equalsIgnoreCase("dynamic")) {
            arrayList = new ArrayList(1);
            arrayList.add(SchemaType.DYNAMIC);
        } else if (this.schemaType.equalsIgnoreCase("policy")) {
            arrayList = new ArrayList(1);
            arrayList.add(SchemaType.POLICY);
        }
        return arrayList;
    }
}

