/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AddDeleteReq;
import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;

class OrgDeleteAgentsReq
extends AddDeleteReq {
    OrgDeleteAgentsReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription88") + " " + this.targetDN);
        if (this.DNSet.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.DNSet, 1);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deleteagents"));
        try {
            HashSet<String> hashSet = new HashSet<String>();
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            Iterator iterator = this.DNSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.deleteAgent(aMStoreConnection, aMOrganizationalUnit, string)) continue;
                hashSet.add(string);
            }
            this.doLogStringSet(hashSet, "delete-agent");
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private boolean deleteAgent(AMStoreConnection aMStoreConnection, AMOrganizationalUnit aMOrganizationalUnit, String string) {
        boolean bl;
        block11: {
            AMEntity aMEntity;
            block10: {
                bl = false;
                aMEntity = null;
                try {
                    aMEntity = aMStoreConnection.getEntity(string);
                    if (!aMEntity.isExists()) {
                        aMEntity = null;
                    }
                }
                catch (SSOException sSOException) {
                    if (!AdminUtils.logEnabled()) break block10;
                    AdminUtils.log(sSOException.getMessage());
                }
            }
            if (aMEntity != null) {
                try {
                    aMEntity.delete(true);
                    bl = true;
                }
                catch (AMException aMException) {
                    if (AdminUtils.logEnabled()) {
                        AdminUtils.log(aMException.getMessage());
                    }
                    break block11;
                }
                catch (SSOException sSOException) {
                    if (AdminUtils.logEnabled()) {
                        AdminUtils.log(sSOException.getMessage());
                    }
                    break block11;
                }
            }
            if (AdminUtils.logEnabled()) {
                Object[] objectArray = new String[]{string};
                String string2 = AdminReq.bundle.getString("agentDoNotExists");
                AdminUtils.log(MessageFormat.format(string2, objectArray));
            }
        }
        return bl;
    }
}

