/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class OrgCreateAgentReq
extends AdminReq {
    private Map agentReq = new HashMap();

    OrgCreateAgentReq(String string) {
        super(string);
    }

    void addRequest(String string, Map map) {
        this.agentReq.put(string, map);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription87") + " " + this.targetDN);
        AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, this.agentReq);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("createagent"));
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            AMOrganizationalUnit aMOrganizationalUnit = this.getAgentContainer(aMStoreConnection, aMOrganization);
            Set set = aMOrganizationalUnit.createEntities("Agent", this.agentReq);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("statusmsg45"));
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMEntity aMEntity = (AMEntity)iterator.next();
                AdminReq.writer.println(aMEntity.getDN());
            }
            this.doLogForEntity(set, "create-agent");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private AMOrganizationalUnit getAgentContainer(AMStoreConnection aMStoreConnection, AMOrganization aMOrganization) throws SSOException, AMException {
        AMOrganizationalUnit aMOrganizationalUnit;
        block5: {
            aMOrganizationalUnit = null;
            String string = "ou=" + AdminInterfaceUtils.defaultAgentContainerName() + "," + aMOrganization.getDN();
            try {
                aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(string);
                if (!aMOrganizationalUnit.isExists()) {
                    if (AdminUtils.logEnabled()) {
                        AdminUtils.log(AdminReq.bundle.getString("agentContainerDoNotExist"));
                    }
                    aMOrganizationalUnit = null;
                }
            }
            catch (SSOException sSOException) {
                if (!AdminUtils.logEnabled()) break block5;
                AdminUtils.log(AdminReq.bundle.getString("agentContainerDoNotExist"));
            }
        }
        if (aMOrganizationalUnit == null) {
            HashSet<String> hashSet = new HashSet<String>(2);
            hashSet.add(AdminInterfaceUtils.defaultAgentContainerName());
            Set set = aMOrganization.createOrganizationalUnits(hashSet);
            aMOrganizationalUnit = (AMOrganizationalUnit)set.iterator().next();
        }
        return aMOrganizationalUnit;
    }
}

