/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.GroupUtils;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class GroupModifySubGroupReq
extends AdminReq {
    protected Map values;
    protected String subGroupDN;
    private Map subGroupReq = new HashMap();

    GroupModifySubGroupReq(String string) {
        super(string);
    }

    void addSubGroupReq(String string, Map map) {
        this.subGroupDN = string;
        this.values = map;
        this.subGroupReq.put(string, map);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription72") + " " + this.targetDN);
        AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, this.subGroupReq);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("group") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("modifygroup"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("group") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("modifygroup"));
        int n = GroupUtils.getGroupType(this.subGroupDN, aMStoreConnection, AdminReq.bundle);
        switch (n) {
            case 9: {
                this.modifyGroup(aMStoreConnection);
                break;
            }
            case 11: {
                this.modifyDynamicGroup(aMStoreConnection);
                break;
            }
            case 12: {
                this.modifyAssignableDynamicGroup(aMStoreConnection);
            }
        }
    }

    private void modifyGroup(AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            AMStaticGroup aMStaticGroup = aMStoreConnection.getStaticGroup(this.subGroupDN);
            aMStaticGroup.setAttributes(this.values);
            aMStaticGroup.store();
            this.doLog(aMStaticGroup, "modify-group");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private void modifyDynamicGroup(AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            Object object;
            String string = null;
            if (this.values != null && this.values.get("filterinfo") != null && (object = (Set)this.values.remove("filterinfo")) != null && !object.isEmpty()) {
                string = (String)object.iterator().next();
            }
            object = aMStoreConnection.getDynamicGroup(this.subGroupDN);
            if (string != null) {
                object.setFilter(string);
            }
            if (this.values != null && !this.values.isEmpty()) {
                object.setAttributes(this.values);
                object.store();
            }
            this.doLog((AMObject)object, "modify-group");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    protected void modifyAssignableDynamicGroup(AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            AMAssignableDynamicGroup aMAssignableDynamicGroup = aMStoreConnection.getAssignableDynamicGroup(this.subGroupDN);
            aMAssignableDynamicGroup.setAttributes(this.values);
            aMAssignableDynamicGroup.store();
            this.doLog(aMAssignableDynamicGroup, "modify-group");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

