/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ContGetSubContReq
extends AdminReq {
    private Set subContDNs = new HashSet();
    private boolean DNsOnly = true;

    ContGetSubContReq() {
    }

    ContGetSubContReq(String string) {
        super(string);
    }

    void setDNsOnly(boolean bl) {
        this.DNsOnly = bl;
    }

    boolean isDNsOnly() {
        return this.DNsOnly;
    }

    void addSubContDNs(String string) {
        this.subContDNs.add(string);
    }

    Set getSubContDNs() {
        return this.subContDNs;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription17") + " " + this.targetDN);
        printWriter.println("   DNsOnly =" + this.DNsOnly);
        if (this.subContDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.subContDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        try {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getsubcontainers"));
            }
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + "\n" + AdminReq.bundle.getString("getsubcontainers"));
            AdminReq.writer.println(this.targetDN);
            boolean bl = false;
            if (this.subContDNs.isEmpty()) {
                this.subContDNs = aMOrganizationalUnit.searchSubOrganizationalUnits("*", 1);
            } else {
                bl = true;
            }
            Iterator iterator = this.subContDNs.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMOrganizationalUnit aMOrganizationalUnit2 = aMOrganizationalUnit.getSubOrganizationalUnit(string);
                if (bl && (!aMOrganizationalUnit2.isExists() || !AdminUtils.isChildOf(aMOrganizationalUnit2, this.targetDN))) continue;
                AdminReq.writer.println("  " + string);
                if (this.DNsOnly) continue;
                printUtils.printAVPairs(aMOrganizationalUnit2.getAttributes(), 2);
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

