/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.SchemaType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ContCreateUserReq
extends AdminReq {
    private Map userReq = new HashMap();
    private SSOToken ssoToken;

    ContCreateUserReq(String string, SSOToken sSOToken) {
        super(string);
        this.ssoToken = sSOToken;
    }

    void addUserReq(String string, Map map) {
        this.userReq.put(string, map);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription81") + " " + this.targetDN);
        AdminUtils.printAttributeNameValuesMap(printWriter, printUtils, this.ssoToken, this.userReq, "iPlanetAMUserService", SchemaType.USER);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("createusers"));
        try {
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            AMPeopleContainer aMPeopleContainer = this.getDefaultPeopleContainer(aMStoreConnection, aMOrganizationalUnit);
            Set set = aMPeopleContainer.createUsers(this.userReq);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(AdminReq.bundle.getString("statusmsg43"));
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMUser aMUser = (AMUser)iterator.next();
                AdminReq.writer.println(aMUser.getDN());
            }
            this.doLog(set, "create-user");
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private AMPeopleContainer getDefaultPeopleContainer(AMStoreConnection aMStoreConnection, AMOrganizationalUnit aMOrganizationalUnit) throws AdminException {
        AMPeopleContainer aMPeopleContainer = null;
        try {
            String string = AdminInterfaceUtils.getNamingAttribute((int)5, (Debug)AdminReq.debug) + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + aMOrganizationalUnit.getDN();
            aMPeopleContainer = aMStoreConnection.getPeopleContainer(string);
            if (aMPeopleContainer == null || !aMPeopleContainer.isExists()) {
                Object[] objectArray = new String[]{string};
                String string2 = MessageFormat.format(AdminReq.bundle.getString("defaultPeopleContainerNotFound"), objectArray);
                throw new AdminException(string2);
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        return aMPeopleContainer;
    }
}

