/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.JSSSocketFactory;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import java.io.File;
import java.security.AccessController;
import java.security.Principal;
import java.util.ResourceBundle;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import netscape.ldap.LDAPException;

class Authenticator {
    private ResourceBundle bundle;
    private SSOToken ssoToken;

    Authenticator(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    SSOToken getSSOToken() {
        return this.ssoToken;
    }

    void sessionBasedLogin(String string, String string2) throws AdminException {
        try {
            this.sessionBasedLoginInternal(string, string2);
        }
        catch (AdminException adminException) {
            this.logLoginFailure(string);
            throw adminException;
        }
    }

    private void sessionBasedLoginInternal(String string, String string2) throws AdminException {
        com.sun.identity.authentication.AuthContext authContext = this.getAuthContext();
        this.processCallback(authContext, string, string2);
        try {
            this.ssoToken = authContext.getSSOToken();
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    void ldapLogin(String string, String string2) throws AdminException {
        try {
            this.ldapLoginInternal(string, string2);
        }
        catch (AdminException adminException) {
            this.logLoginFailure(string);
            throw adminException;
        }
    }

    void ldapLoginInternal(String string, String string2) throws AdminException {
        this.initializeJSS();
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(this.bundle.getString("statusmsg6"));
        }
        try {
            AuthContext authContext = this.getLDAPAuthContext(string, string2);
            if (authContext.getLoginStatus() == 3) {
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log(this.bundle.getString("statusmsg7"));
                    AdminUtils.log(this.bundle.getString("statusmsg8"));
                }
            } else {
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log(this.bundle.getString("statusmsg9"));
                }
                throw new AdminException(this.bundle.getString("ldapauthfail"));
            }
            this.ssoToken = authContext.getSSOToken();
            AdminUtils.setSSOToken(this.ssoToken);
        }
        catch (LoginException loginException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(this.bundle.getString("ldapauthfail"), loginException);
            }
            throw new AdminException(this.bundle.getString("ldapauthfail"));
        }
        catch (InvalidAuthContextException invalidAuthContextException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(this.bundle.getString("ldapauthfail"), invalidAuthContextException);
            }
            throw new AdminException(this.bundle.getString("ldapauthfail"));
        }
    }

    private AuthContext getLDAPAuthContext(String string, String string2) throws LoginException {
        AuthPrincipal authPrincipal = new AuthPrincipal(string);
        AuthContext authContext = new AuthContext(authPrincipal, string2.toCharArray());
        return authContext;
    }

    private void initializeJSS() throws AdminException {
        String string = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.dir");
        String string2 = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.prefix");
        File file = new File(string + File.separatorChar + string2 + "cert7.db");
        if (file.isFile()) {
            try {
                JSSSocketFactory.initialize(string, string2, string2, "", true);
            }
            catch (LDAPException lDAPException) {
                throw new AdminException(lDAPException);
            }
        }
    }

    private com.sun.identity.authentication.AuthContext getAuthContext() throws AdminException {
        try {
            com.sun.identity.authentication.AuthContext authContext = new com.sun.identity.authentication.AuthContext("/");
            authContext.login(AuthContext.IndexType.MODULE_INSTANCE, "LDAP");
            return authContext;
        }
        catch (LoginException loginException) {
            loginException.printStackTrace();
            throw new AdminException(this.bundle.getString("loginFailed"));
        }
    }

    private void processCallback(com.sun.identity.authentication.AuthContext authContext, String string, String string2) throws AdminException {
        while (authContext.hasMoreRequirements()) {
            Callback[] callbackArray = authContext.getRequirements();
            if (callbackArray == null) continue;
            this.setCallbackValues(callbackArray, string, string2);
            authContext.submitRequirements(callbackArray);
        }
        if (authContext.getStatus() != AuthContext.Status.SUCCESS) {
            throw new AdminException(this.bundle.getString("loginFailed"));
        }
    }

    private void setCallbackValues(Callback[] callbackArray, String string, String string2) {
        int n = 0;
        while (n < callbackArray.length) {
            Callback callback;
            if (callbackArray[n] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[n];
                ((NameCallback)callback).setName(string);
            } else if (callbackArray[n] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[n];
                char[] cArray = string2.toCharArray();
                ((PasswordCallback)callback).setPassword(cArray);
            }
            ++n;
        }
    }

    private void logLoginFailure(String string) {
        SSOToken sSOToken = this.getAdminSSOToken();
        if (sSOToken != null) {
            String string2 = this.bundle.getString("loginFail") + " " + string;
            AdminUtils.logOperation(1, string2, sSOToken);
        }
    }

    private SSOToken getAdminSSOToken() {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (SSOException sSOException) {
            AdminUtils.log(sSOException.getMessage());
        }
        return sSOToken;
    }
}

