/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminResourceBundle;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.AssignableDynamicGroupAddNestedGroupReq;
import com.iplanet.am.admin.cli.AssignableDynamicGroupAddUserReq;
import com.iplanet.am.admin.cli.AssignableDynamicGroupCreateSubGroupReq;
import com.iplanet.am.admin.cli.AssignableDynamicGroupGetNestedGroupReq;
import com.iplanet.am.admin.cli.AssignableDynamicGroupGetNumOfNestedGroupsReq;
import com.iplanet.am.admin.cli.AssignableDynamicGroupGetNumOfUserReq;
import com.iplanet.am.admin.cli.AssignableDynamicGroupGetUserReq;
import com.iplanet.am.admin.cli.ContAddServiceTemplateAttrValuesReq;
import com.iplanet.am.admin.cli.ContCreateAgentReq;
import com.iplanet.am.admin.cli.ContCreateFilteredRoleReq;
import com.iplanet.am.admin.cli.ContCreateGroupContainerReq;
import com.iplanet.am.admin.cli.ContCreateGroupReq;
import com.iplanet.am.admin.cli.ContCreatePCReq;
import com.iplanet.am.admin.cli.ContCreateRoleReq;
import com.iplanet.am.admin.cli.ContCreateServiceTemplateReq;
import com.iplanet.am.admin.cli.ContCreateSubContReq;
import com.iplanet.am.admin.cli.ContCreateUserReq;
import com.iplanet.am.admin.cli.ContDeleteAgentsReq;
import com.iplanet.am.admin.cli.ContDeleteGroupReq;
import com.iplanet.am.admin.cli.ContDeletePCReq;
import com.iplanet.am.admin.cli.ContDeleteRoleReq;
import com.iplanet.am.admin.cli.ContDeleteServiceTemplateReq;
import com.iplanet.am.admin.cli.ContDeleteSubContReq;
import com.iplanet.am.admin.cli.ContGetAgentsReq;
import com.iplanet.am.admin.cli.ContGetGroupReq;
import com.iplanet.am.admin.cli.ContGetNumOfServicesReq;
import com.iplanet.am.admin.cli.ContGetPCReq;
import com.iplanet.am.admin.cli.ContGetRegisteredServicesReq;
import com.iplanet.am.admin.cli.ContGetRoleReq;
import com.iplanet.am.admin.cli.ContGetServiceTemplateReq;
import com.iplanet.am.admin.cli.ContGetSubContReq;
import com.iplanet.am.admin.cli.ContGetUserReq;
import com.iplanet.am.admin.cli.ContModifyAgentReq;
import com.iplanet.am.admin.cli.ContModifyPCReq;
import com.iplanet.am.admin.cli.ContModifyRoleReq;
import com.iplanet.am.admin.cli.ContModifyServiceTemplateReq;
import com.iplanet.am.admin.cli.ContModifySubContReq;
import com.iplanet.am.admin.cli.ContRegisterServicesReq;
import com.iplanet.am.admin.cli.ContRemoveServiceTemplateAttrValuesReq;
import com.iplanet.am.admin.cli.ContUnregisterServicesReq;
import com.iplanet.am.admin.cli.DynamicGroupAddNestedGroupReq;
import com.iplanet.am.admin.cli.DynamicGroupCreateSubGroupReq;
import com.iplanet.am.admin.cli.DynamicGroupGetNestedGroupReq;
import com.iplanet.am.admin.cli.DynamicGroupGetNumOfNestedGroupsReq;
import com.iplanet.am.admin.cli.DynamicGroupGetNumOfUserReq;
import com.iplanet.am.admin.cli.DynamicGroupGetUserReq;
import com.iplanet.am.admin.cli.FedServicesRequestHandler;
import com.iplanet.am.admin.cli.FilteredRoleGetNumOfUserReq;
import com.iplanet.am.admin.cli.FilteredRoleGetServiceTemplateReq;
import com.iplanet.am.admin.cli.FilteredRoleGetUserReq;
import com.iplanet.am.admin.cli.FilteredRoleModifyServiceTemplateReq;
import com.iplanet.am.admin.cli.GroupAddNestedGroupReq;
import com.iplanet.am.admin.cli.GroupAddUserReq;
import com.iplanet.am.admin.cli.GroupCreateSubGroupReq;
import com.iplanet.am.admin.cli.GroupDeleteSubGroupReq;
import com.iplanet.am.admin.cli.GroupDeleteUserReq;
import com.iplanet.am.admin.cli.GroupGetNestedGroupReq;
import com.iplanet.am.admin.cli.GroupGetNumOfNestedGroupsReq;
import com.iplanet.am.admin.cli.GroupGetNumOfUserReq;
import com.iplanet.am.admin.cli.GroupGetSubGroupReq;
import com.iplanet.am.admin.cli.GroupGetUserReq;
import com.iplanet.am.admin.cli.GroupModifySubGroupReq;
import com.iplanet.am.admin.cli.GroupRemoveNestedGroupReq;
import com.iplanet.am.admin.cli.OrgAddServiceTemplateAttrValuesReq;
import com.iplanet.am.admin.cli.OrgCreateAgentReq;
import com.iplanet.am.admin.cli.OrgCreateFilteredRoleReq;
import com.iplanet.am.admin.cli.OrgCreateGroupContainerReq;
import com.iplanet.am.admin.cli.OrgCreateGroupReq;
import com.iplanet.am.admin.cli.OrgCreatePCReq;
import com.iplanet.am.admin.cli.OrgCreateRoleReq;
import com.iplanet.am.admin.cli.OrgCreateServiceTemplateReq;
import com.iplanet.am.admin.cli.OrgCreateSubContReq;
import com.iplanet.am.admin.cli.OrgCreateSubOrgReq;
import com.iplanet.am.admin.cli.OrgCreateUserReq;
import com.iplanet.am.admin.cli.OrgDeleteAgentsReq;
import com.iplanet.am.admin.cli.OrgDeleteGroupReq;
import com.iplanet.am.admin.cli.OrgDeletePCReq;
import com.iplanet.am.admin.cli.OrgDeleteRoleReq;
import com.iplanet.am.admin.cli.OrgDeleteServiceTemplateReq;
import com.iplanet.am.admin.cli.OrgDeleteSubOrgReq;
import com.iplanet.am.admin.cli.OrgGetAgentsReq;
import com.iplanet.am.admin.cli.OrgGetGroupReq;
import com.iplanet.am.admin.cli.OrgGetNumOfServicesReq;
import com.iplanet.am.admin.cli.OrgGetPCReq;
import com.iplanet.am.admin.cli.OrgGetRegisteredServicesReq;
import com.iplanet.am.admin.cli.OrgGetRoleReq;
import com.iplanet.am.admin.cli.OrgGetServiceTemplateReq;
import com.iplanet.am.admin.cli.OrgGetSubOrgReq;
import com.iplanet.am.admin.cli.OrgGetUserReq;
import com.iplanet.am.admin.cli.OrgModifyAgentReq;
import com.iplanet.am.admin.cli.OrgModifyPCReq;
import com.iplanet.am.admin.cli.OrgModifyRoleReq;
import com.iplanet.am.admin.cli.OrgModifyServiceTemplateReq;
import com.iplanet.am.admin.cli.OrgModifySubOrgReq;
import com.iplanet.am.admin.cli.OrgRegisterServicesReq;
import com.iplanet.am.admin.cli.OrgRemoveServiceTemplateAttrValuesReq;
import com.iplanet.am.admin.cli.OrgUnregisterServicesReq;
import com.iplanet.am.admin.cli.PCCreateSubPCReq;
import com.iplanet.am.admin.cli.PCCreateUserReq;
import com.iplanet.am.admin.cli.PCDeleteSubPCReq;
import com.iplanet.am.admin.cli.PCDeleteUserReq;
import com.iplanet.am.admin.cli.PCGetNumOfUserReq;
import com.iplanet.am.admin.cli.PCGetSubPCReq;
import com.iplanet.am.admin.cli.PCGetUserReq;
import com.iplanet.am.admin.cli.PCModifySubPCReq;
import com.iplanet.am.admin.cli.PCModifyUserReq;
import com.iplanet.am.admin.cli.RoleAddUserReq;
import com.iplanet.am.admin.cli.RoleCreateServiceTemplateReq;
import com.iplanet.am.admin.cli.RoleDeleteUserReq;
import com.iplanet.am.admin.cli.RoleGetNumOfUserReq;
import com.iplanet.am.admin.cli.RoleGetServiceTemplateReq;
import com.iplanet.am.admin.cli.RoleGetUserReq;
import com.iplanet.am.admin.cli.RoleModifyServiceTemplateReq;
import com.iplanet.am.admin.cli.UserRegisterServicesReq;
import com.iplanet.am.admin.cli.UserUnregisterServicesReq;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.ServiceUtil;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLHandler;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class AdminXMLParser {
    private static ResourceBundle bundle = AdminResourceBundle.getResources();
    private Document document;
    private String fileName = "";
    private static boolean continueFlag = false;
    Debug debug = Debug.getInstance((String)"amAdmin");
    private static final int CSO = 0;
    private static final int CPC = 1;
    private static final int CG = 2;
    private static final int CR = 3;
    private static final int GSO = 4;
    private static final int GPC = 5;
    private static final int GG = 6;
    private static final int GR = 7;
    private static final int GU = 8;
    private static final int DSO = 9;
    private static final int DPC = 10;
    private static final int DG = 11;
    private static final int DR = 12;
    private static final int CSPC = 13;
    private static final int CU = 14;
    private static final int DSPC = 15;
    private static final int DU = 16;
    private static final int GNOU = 17;
    private static final int GSPC = 18;
    private static final int AU = 19;
    private static final int CSG = 20;
    private static final int DSG = 21;
    private static final int GSG = 22;
    private static final int RS = 23;
    private static final int URS = 24;
    private static final int GRS = 27;
    private static final int GNOS = 29;
    private static final int CSC = 30;
    private static final int GSC = 31;
    private static final int DSC = 32;
    private static final int CP = 33;
    private static final int DP = 34;
    private static final int MSO = 35;
    private static final int MPC = 36;
    private static final int MR = 37;
    private static final int CST = 38;
    private static final int MST = 39;
    private static final int CRST = 42;
    private static final int MPCST = 43;
    private static final int MRST = 44;
    private static final int MSC = 45;
    private static final int MU = 49;
    private static final int MSG = 50;
    private static final int RDV = 51;
    private static final int MDV = 52;
    private static final int ATEV = 53;
    private static final int DST = 54;
    private static final int DSV = 55;
    private static final int ASC = 56;
    private static final int RSC = 57;
    private static final int ACV = 58;
    private static final int DCV = 59;
    private static final int DASC = 71;
    private static final int CC = 72;
    private static final int MT = 73;
    private static final int MUIT = 74;
    private static final int MIK = 75;
    private static final int MS = 76;
    private static final int APVB = 77;
    private static final int ASR = 78;
    private static final int AER = 79;
    private static final int ASSC = 80;
    private static final int AAS = 81;
    private static final int RSS = 82;
    private static final int RAS = 83;
    private static final int CGC = 84;
    private static final int RU = 85;
    private static final int GST = 86;
    private static final int RSTAV = 87;
    private static final int ASTAV = 88;
    private static final int RPDV = 89;
    private static final int CA = 90;
    private static final int DA = 91;
    private static final int MA = 92;
    private static final int GA = 93;
    private static final int ANG = 94;
    private static final int RNG = 95;
    private static final int GNG = 96;
    private static final int GNONG = 97;
    private static final int SPVBU = 98;
    private static final int CRPROV = 60;
    private static final int DPROV = 61;
    private static final int CAD = 62;
    private static final int MAD = 63;
    private static final int DAD = 64;
    private static final int GAD = 65;
    private static final int GPROV = 66;
    private static final int MRPROV = 67;
    private static final int MHPROV = 68;
    private static final int CHPROV = 69;
    private static final int LACCTS = 70;
    private static Map requestTypes = new HashMap();

    AdminXMLParser() {
    }

    private static int getToken(String string) {
        return (Integer)requestTypes.get(string);
    }

    private Document parseXML(String string) throws AdminException {
        String string2 = "Requests";
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ValidationErrorHandler());
            documentBuilder.setEntityResolver((EntityResolver)new XMLHandler());
            document = documentBuilder.parse(new File(string));
            DocumentType documentType = document.getDoctype();
            String string3 = documentType.getName();
            if (!string3.equalsIgnoreCase(string2)) {
                throw new AdminException(bundle.getString("parseerr") + this.fileName + "\n" + bundle.getString("doctypeerror"));
            }
        }
        catch (SAXParseException sAXParseException) {
            if (AdminUtils.logEnabled() && AdminUtils.debugEnabled) {
                AdminUtils.log(bundle.getString("parseerr") + this.fileName + "/n" + sAXParseException);
            }
            throw new AdminException(bundle.getString("parseerr") + this.fileName + "/n" + sAXParseException);
        }
        catch (SAXException sAXException) {
            if (AdminUtils.logEnabled() && AdminUtils.debugEnabled) {
                AdminUtils.log(bundle.getString("parseiniterr") + "\n" + sAXException);
            }
            throw new AdminException(bundle.getString("parseiniterr") + "\n" + sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            if (AdminUtils.logEnabled() && AdminUtils.debugEnabled) {
                AdminUtils.log(bundle.getString("parsebuilterr") + "n" + parserConfigurationException);
            }
            throw new AdminException(bundle.getString("parsebuilterr") + "\n" + parserConfigurationException);
        }
        catch (IOException iOException) {
            if (AdminUtils.logEnabled() && AdminUtils.debugEnabled) {
                AdminUtils.log(bundle.getString("ioexception") + this.fileName + " .", iOException);
            }
            throw new AdminException(iOException);
        }
        return document;
    }

    public void processAdminReqs(String string, AMStoreConnection aMStoreConnection, SSOToken sSOToken, boolean bl) throws AdminException {
        this.fileName = string;
        this.document = this.parseXML(string);
        continueFlag = bl;
        System.gc();
        Element element = this.document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block24: {
                Node node = nodeList.item(n2);
                if (node != null && node.getNodeType() == 1) {
                    String string2 = node.getNodeName();
                    try {
                        if (string2.equals("OrganizationRequests")) {
                            this.doOrganizationRequests(node, aMStoreConnection, sSOToken);
                        } else if (string2.equals("ContainerRequests")) {
                            this.doContainerRequests(node, aMStoreConnection, sSOToken);
                        } else if (string2.equals("PeopleContainerRequests")) {
                            this.doPeopleContainerRequests(node, aMStoreConnection, sSOToken);
                        } else if (string2.equals("RoleRequests")) {
                            this.doRoleRequests(node, aMStoreConnection, sSOToken);
                        } else if (string2.equals("GroupRequests")) {
                            this.doGroupRequests(node, aMStoreConnection);
                        } else if (string2.equals("SchemaRequests")) {
                            this.doSchemaRequests(node, sSOToken);
                        } else if (string2.equals("SchemaRootNodeRequests")) {
                            this.doSchemaRootNodeRequests(node, sSOToken);
                        } else if (string2.equals("ServiceConfigurationRequests")) {
                            this.doServiceConfigurationRequests(node, sSOToken);
                        } else if (string2.equals("ListAccts")) {
                            this.doListAccts(node);
                        } else if (string2.equals("UserRequests")) {
                            this.doUserRequests(node, aMStoreConnection);
                        }
                    }
                    catch (AdminException adminException) {
                        AdminUtils.logOperation(1, adminException.toString());
                        if (!bl) {
                            throw adminException;
                        }
                        if (!AdminUtils.logEnabled()) break block24;
                        AdminUtils.log(adminException.toString());
                    }
                }
            }
            ++n2;
        }
    }

    private void doOrganizationRequests(Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        Node node2 = node;
        String string = ((Element)node2).getAttribute("DN");
        this.validateObjectType(aMStoreConnection, string, 2);
        NodeList nodeList = node2.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block53: {
                Node node3 = nodeList.item(n2);
                if (node3.getNodeType() == 1) {
                    String string2 = node3.getNodeName();
                    int n3 = AdminXMLParser.getToken(string2);
                    try {
                        switch (n3) {
                            case 0: {
                                this.createSubOrganizationInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 35: {
                                this.modifySubOrganizationInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 33: {
                                this.createPolicy(aMStoreConnection, string, node3, sSOToken);
                                break;
                            }
                            case 34: {
                                this.deletePolicy(string, node3, sSOToken);
                                break;
                            }
                            case 1: {
                                this.createPeopleContainerInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 84: {
                                this.createGroupContainerInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 36: {
                                this.modifyPeopleContainerInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 86: {
                                this.getServiceTemplateInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 39: {
                                this.modifyServiceTemplateInOrganization(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 88: {
                                this.addServiceTemplateAttrValuesInOrganization(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 87: {
                                this.removeServiceTemplateAttrValuesInOrganization(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 54: {
                                this.deleteServiceTemplateInOrganization(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 2: {
                                this.createGroupInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 14: {
                                this.createUserInOrganization(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 3: {
                                this.createRoleInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 37: {
                                this.modifyRole(string, node3, aMStoreConnection);
                                break;
                            }
                            case 4: {
                                this.getSubOrganizationsInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 5: {
                                this.getPeopleContainersInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 6: {
                                this.getGroupsInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 7: {
                                this.getRolesInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 8: {
                                this.getUserInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 9: {
                                this.deleteSubOrganizationsInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 10: {
                                this.deletePeopleContainersInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 11: {
                                this.deleteGroupsInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 12: {
                                this.deleteRolesInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 23: {
                                this.registerServicesInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 24: {
                                this.unregisterServicesInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 27: {
                                this.getRegisteredServicesInOrganization(string, aMStoreConnection);
                                break;
                            }
                            case 29: {
                                this.getNumberOfServicesInOrganization(string, aMStoreConnection);
                                break;
                            }
                            case 38: {
                                this.createServiceTemplatesInOrganization(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 90: {
                                this.createAgentInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 92: {
                                this.modifyAgentInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 91: {
                                this.deleteAgentInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 93: {
                                this.getAgentsInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 72: {
                                this.createSubContainersInOrganization(string, node3, aMStoreConnection);
                                break;
                            }
                            case 56: {
                                this.addSubConfigurationsInOrganization(string, node3, sSOToken);
                                break;
                            }
                            case 57: {
                                this.removeSubConfigurationsInOrganization(string, node3, sSOToken);
                                break;
                            }
                            case 60: {
                                this.createRemoteProvider(string, node3, sSOToken);
                                break;
                            }
                            case 67: {
                                this.modifyRemoteProvider(string, node3, sSOToken);
                                break;
                            }
                            case 68: {
                                this.modifyHostedProvider(string, node3, sSOToken);
                                break;
                            }
                            case 69: {
                                this.createHostedProvider(string, node3, sSOToken);
                                break;
                            }
                            case 61: {
                                this.deleteHostedProvider(string, node3, sSOToken);
                                break;
                            }
                            case 66: {
                                this.getFederationProvider(string, node3, sSOToken);
                                break;
                            }
                            case 62: {
                                this.createFederationAuthenticationDomain(string, node3, sSOToken);
                                break;
                            }
                            case 64: {
                                this.deleteFederationAuthenticationDomain(string, node3, sSOToken);
                                break;
                            }
                            case 65: {
                                this.getFederationAuthenticationDomain(string, node3, sSOToken);
                                break;
                            }
                            case 63: {
                                this.modifyFederationAuthenticationDomain(string, node3, sSOToken);
                            }
                        }
                    }
                    catch (AdminException adminException) {
                        if (continueFlag) break block53;
                        throw adminException;
                    }
                }
            }
            ++n2;
        }
    }

    private void createSubOrganizationInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgCreateSubOrgReq orgCreateSubOrgReq = new OrgCreateSubOrgReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        orgCreateSubOrgReq.addSubOrgReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgCreateSubOrgReq.toString());
        }
        orgCreateSubOrgReq.process(aMStoreConnection);
    }

    private void modifySubOrganizationInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgModifySubOrgReq orgModifySubOrgReq = new OrgModifySubOrgReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        orgModifySubOrgReq.addSubOrgReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgModifySubOrgReq.toString());
        }
        orgModifySubOrgReq.process(aMStoreConnection);
    }

    private void createPolicy(AMStoreConnection aMStoreConnection, String string, Node node, SSOToken sSOToken) throws AdminException {
        this.doCreatePolicy(aMStoreConnection, node, sSOToken);
        String string2 = XMLUtils.getNodeAttributeValue((Node)XMLUtils.getChildNode((Node)node, (String)"Policy"), (String)"name");
        Object[] objectArray = new String[]{string2, string};
        AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("create-policy"), objectArray));
    }

    private void deletePolicy(String string, Node node, SSOToken sSOToken) throws AdminException {
        this.doDeletePolicy(node, sSOToken);
        String string2 = XMLUtils.getNodeAttributeValue((Node)XMLUtils.getChildNode((Node)node, (String)"PolicyName"), (String)"name");
        Object[] objectArray = new String[]{string2, string};
        AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("delete-policy"), objectArray));
    }

    private void createPeopleContainerInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgCreatePCReq orgCreatePCReq = new OrgCreatePCReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        orgCreatePCReq.addPCReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgCreatePCReq.toString());
        }
        orgCreatePCReq.process(aMStoreConnection);
    }

    private void createGroupContainerInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgCreateGroupContainerReq orgCreateGroupContainerReq = new OrgCreateGroupContainerReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        orgCreateGroupContainerReq.addGroupContainerRequest(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgCreateGroupContainerReq.toString());
        }
        orgCreateGroupContainerReq.process(aMStoreConnection);
    }

    private void modifyPeopleContainerInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgModifyPCReq orgModifyPCReq = new OrgModifyPCReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        orgModifyPCReq.addPCReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgModifyPCReq.toString());
        }
        orgModifyPCReq.process(aMStoreConnection);
    }

    private void getServiceTemplateInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgGetServiceTemplateReq orgGetServiceTemplateReq = new OrgGetServiceTemplateReq(string);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        orgGetServiceTemplateReq.setServiceNameSchemaType(string2, string3);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgGetServiceTemplateReq.toString());
        }
        orgGetServiceTemplateReq.process(aMStoreConnection);
    }

    private void modifyServiceTemplateInOrganization(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        OrgModifyServiceTemplateReq orgModifyServiceTemplateReq = new OrgModifyServiceTemplateReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        String string4 = ((Element)node).getAttribute("level");
        String string5 = ((Element)node).getAttribute("roleTemplate");
        if (!string3.equalsIgnoreCase("dynamic") && string5.equalsIgnoreCase("true")) {
            throw new UnsupportedOperationException("\n" + bundle.getString("roletemplateexception"));
        }
        orgModifyServiceTemplateReq.addServiceTemplateReq(string2, string3, string4, string5, map, sSOToken);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgModifyServiceTemplateReq.toString());
        }
        orgModifyServiceTemplateReq.process(aMStoreConnection);
    }

    private void addServiceTemplateAttrValuesInOrganization(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        OrgAddServiceTemplateAttrValuesReq orgAddServiceTemplateAttrValuesReq = new OrgAddServiceTemplateAttrValuesReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        String string4 = ((Element)node).getAttribute("level");
        String string5 = ((Element)node).getAttribute("roleTemplate");
        if (!string3.equalsIgnoreCase("dynamic") && string5.equalsIgnoreCase("true")) {
            throw new UnsupportedOperationException(bundle.getString("roletemplateexception"));
        }
        orgAddServiceTemplateAttrValuesReq.addRequest(string2, string3, string4, string5, map, sSOToken);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgAddServiceTemplateAttrValuesReq.toString());
        }
        orgAddServiceTemplateAttrValuesReq.process(aMStoreConnection);
    }

    private void removeServiceTemplateAttrValuesInOrganization(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        OrgRemoveServiceTemplateAttrValuesReq orgRemoveServiceTemplateAttrValuesReq = new OrgRemoveServiceTemplateAttrValuesReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        String string4 = ((Element)node).getAttribute("level");
        String string5 = ((Element)node).getAttribute("roleTemplate");
        if (!string3.equalsIgnoreCase("dynamic") && string5.equalsIgnoreCase("true")) {
            throw new UnsupportedOperationException(bundle.getString("roletemplateexception"));
        }
        orgRemoveServiceTemplateAttrValuesReq.addRequest(string2, string3, string4, string5, map, sSOToken);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgRemoveServiceTemplateAttrValuesReq.toString());
        }
        orgRemoveServiceTemplateAttrValuesReq.process(aMStoreConnection);
    }

    private void deleteServiceTemplateInOrganization(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        OrgDeleteServiceTemplateReq orgDeleteServiceTemplateReq = new OrgDeleteServiceTemplateReq(string);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        orgDeleteServiceTemplateReq.setServiceTemplateReq(string2, string3);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgDeleteServiceTemplateReq.toString());
        }
        orgDeleteServiceTemplateReq.process(aMStoreConnection, sSOToken);
    }

    private void createGroupInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgCreateGroupReq orgCreateGroupReq = new OrgCreateGroupReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        String string3 = ((Element)node).getAttribute("groupType");
        orgCreateGroupReq.addGroupReq(string2, string3, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgCreateGroupReq.toString());
        }
        orgCreateGroupReq.process(aMStoreConnection);
    }

    private void createUserInOrganization(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        OrgCreateUserReq orgCreateUserReq = new OrgCreateUserReq(string, sSOToken);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        orgCreateUserReq.addUserReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgCreateUserReq.toString());
        }
        orgCreateUserReq.process(aMStoreConnection);
    }

    private void createRoleInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgCreateRoleReq orgCreateRoleReq = null;
        String string2 = ((Element)node).getAttribute("roleType");
        orgCreateRoleReq = string2.equals("filtered") ? new OrgCreateFilteredRoleReq(string) : new OrgCreateRoleReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string3 = ((Element)node).getAttribute("createDN");
        orgCreateRoleReq.addRoleReq(string3, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgCreateRoleReq.toString());
        }
        orgCreateRoleReq.process(aMStoreConnection);
    }

    private void modifyRole(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgModifyRoleReq orgModifyRoleReq = new OrgModifyRoleReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        orgModifyRoleReq.addRoleReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgModifyRoleReq.toString());
        }
        orgModifyRoleReq.process(aMStoreConnection);
    }

    private void getSubOrganizationsInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgGetSubOrgReq orgGetSubOrgReq = new OrgGetSubOrgReq(string);
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        orgGetSubOrgReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            orgGetSubOrgReq.addSubOrgDNs((String)iterator.next());
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgGetSubOrgReq.toString());
        }
        orgGetSubOrgReq.process(aMStoreConnection);
    }

    private void getPeopleContainersInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgGetPCReq orgGetPCReq = new OrgGetPCReq(string);
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        orgGetPCReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            orgGetPCReq.addPCDNs((String)iterator.next());
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgGetPCReq.toString());
        }
        orgGetPCReq.process(aMStoreConnection);
    }

    private void getGroupsInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgGetGroupReq orgGetGroupReq = new OrgGetGroupReq(string);
        orgGetGroupReq.setLevel(this.validateLevel(node));
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgGetGroupReq.toString());
        }
        orgGetGroupReq.process(aMStoreConnection);
    }

    private void getRolesInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgGetRoleReq orgGetRoleReq = new OrgGetRoleReq(string);
        orgGetRoleReq.setLevel(this.validateLevel(node));
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgGetRoleReq.toString());
        }
        orgGetRoleReq.process(aMStoreConnection);
    }

    private void getUserInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgGetUserReq orgGetUserReq = new OrgGetUserReq(string);
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        orgGetUserReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            orgGetUserReq.addUserDNs((String)iterator.next());
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgGetUserReq.toString());
        }
        orgGetUserReq.process(aMStoreConnection);
    }

    private void getAgentsInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgGetAgentsReq orgGetAgentsReq = new OrgGetAgentsReq(string);
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        orgGetAgentsReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        orgGetAgentsReq.addDNs(set);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgGetAgentsReq.toString());
        }
        orgGetAgentsReq.process(aMStoreConnection);
    }

    private void getAgentsInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContGetAgentsReq contGetAgentsReq = new ContGetAgentsReq(string);
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        contGetAgentsReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        contGetAgentsReq.addDNs(set);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contGetAgentsReq.toString());
        }
        contGetAgentsReq.process(aMStoreConnection);
    }

    private void deleteSubOrganizationsInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgDeleteSubOrgReq orgDeleteSubOrgReq = new OrgDeleteSubOrgReq(string);
        String string2 = ((Element)node).getAttribute("deleteRecursively");
        boolean bl = Boolean.valueOf(string2);
        orgDeleteSubOrgReq.setRecursiveDelete(bl);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(orgDeleteSubOrgReq.toString());
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                orgDeleteSubOrgReq.addDNSet((String)iterator.next());
            }
            orgDeleteSubOrgReq.process(aMStoreConnection);
        }
    }

    private void deletePeopleContainersInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgDeletePCReq orgDeletePCReq = new OrgDeletePCReq(string);
        String string2 = ((Element)node).getAttribute("deleteRecursively");
        boolean bl = Boolean.valueOf(string2);
        orgDeletePCReq.setRecursiveDelete(bl);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(orgDeletePCReq.toString());
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                orgDeletePCReq.addDNSet((String)iterator.next());
            }
            orgDeletePCReq.process(aMStoreConnection);
        }
    }

    private void deleteGroupsInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgDeleteGroupReq orgDeleteGroupReq = new OrgDeleteGroupReq(string);
        String string2 = ((Element)node).getAttribute("deleteRecursively");
        boolean bl = Boolean.valueOf(string2);
        orgDeleteGroupReq.setRecursiveDelete(bl);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(orgDeleteGroupReq.toString());
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                orgDeleteGroupReq.addDNSet((String)iterator.next());
            }
            orgDeleteGroupReq.process(aMStoreConnection);
        }
    }

    private void deleteRolesInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgDeleteRoleReq orgDeleteRoleReq = new OrgDeleteRoleReq(string);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(orgDeleteRoleReq.toString());
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                orgDeleteRoleReq.addDNSet((String)iterator.next());
            }
            orgDeleteRoleReq.process(aMStoreConnection);
        }
    }

    private void registerServicesInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgRegisterServicesReq orgRegisterServicesReq = new OrgRegisterServicesReq(string);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(orgRegisterServicesReq.toString());
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                orgRegisterServicesReq.registerServicesReq((String)iterator.next());
            }
            orgRegisterServicesReq.process(aMStoreConnection);
        }
    }

    private void unregisterServicesInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgUnregisterServicesReq orgUnregisterServicesReq = new OrgUnregisterServicesReq(string);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(orgUnregisterServicesReq.toString());
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                orgUnregisterServicesReq.unregisterServicesReq((String)iterator.next());
            }
            orgUnregisterServicesReq.process(aMStoreConnection);
        }
    }

    private void getRegisteredServicesInOrganization(String string, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgGetRegisteredServicesReq orgGetRegisteredServicesReq = new OrgGetRegisteredServicesReq(string);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgGetRegisteredServicesReq.toString());
        }
        orgGetRegisteredServicesReq.process(aMStoreConnection);
    }

    private void getNumberOfServicesInOrganization(String string, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgGetNumOfServicesReq orgGetNumOfServicesReq = new OrgGetNumOfServicesReq(string);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgGetNumOfServicesReq.toString());
        }
        orgGetNumOfServicesReq.process(aMStoreConnection);
    }

    private void createServiceTemplatesInOrganization(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        OrgCreateServiceTemplateReq orgCreateServiceTemplateReq = new OrgCreateServiceTemplateReq(string);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                orgCreateServiceTemplateReq.addServiceTmplReq((String)iterator.next());
            }
            orgCreateServiceTemplateReq.process(aMStoreConnection, sSOToken);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(orgCreateServiceTemplateReq.toString());
            }
        }
    }

    private void createSubContainersInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgCreateSubContReq orgCreateSubContReq = new OrgCreateSubContReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        orgCreateSubContReq.addSubContReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgCreateSubContReq.toString());
        }
        orgCreateSubContReq.process(aMStoreConnection);
    }

    private void addSubConfigurationsInOrganization(String string, Node node, SSOToken sSOToken) throws AdminException {
        try {
            String string2 = ((Element)node).getAttribute("serviceName");
            if (string2 != null && string2.length() > 0) {
                ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string2, sSOToken);
                ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
                if (serviceConfig == null) {
                    serviceConfig = serviceConfigManager.createOrganizationConfig(string, null);
                }
                Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
                String string3 = ((Element)node).getAttribute("subConfigName");
                String string4 = ((Element)node).getAttribute("subConfigId");
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
                int n = stringTokenizer.countTokens();
                int n2 = 1;
                while (n2 <= n) {
                    String string5 = SMSSchema.unescapeName(stringTokenizer.nextToken());
                    if (n2 != n) {
                        serviceConfig = serviceConfig.getSubConfig(string5);
                    } else {
                        if (string4.equals("")) {
                            string4 = string5;
                            this.debug.message("subConfigId is null");
                        }
                        serviceConfig.addSubConfig(string5, string4, 0, map);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception.toString());
        }
    }

    private void removeSubConfigurationsInOrganization(String string, Node node, SSOToken sSOToken) throws AdminException {
        try {
            String string2 = ((Element)node).getAttribute("serviceName");
            if (string2 != null) {
                String string3 = ((Element)node).getAttribute("subConfigName");
                ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string2, sSOToken);
                ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
                int n = stringTokenizer.countTokens();
                int n2 = 1;
                while (n2 <= n) {
                    String string4 = SMSSchema.unescapeName(stringTokenizer.nextToken());
                    if (n2 != n) {
                        serviceConfig = serviceConfig.getSubConfig(string4);
                    } else {
                        serviceConfig.removeSubConfig(string4);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception.toString());
        }
    }

    private void createRemoteProvider(String string, Node node, SSOToken sSOToken) throws AdminException {
        Object[] objectArray;
        String string2 = ((Element)node).getAttributeNode("id").getValue();
        try {
            objectArray = new FedServicesRequestHandler(string, sSOToken);
            objectArray.createRemoteProvider(node);
        }
        catch (Exception exception) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)exception);
            throw new AdminException(exception);
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser::Created Remote Provider" + string2);
        }
        objectArray = new String[]{string2, string};
        AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("create-remote-prov"), objectArray));
    }

    private void modifyRemoteProvider(String string, Node node, SSOToken sSOToken) throws AdminException {
        Object[] objectArray;
        String string2 = ((Element)node).getAttributeNode("id").getValue();
        try {
            objectArray = new FedServicesRequestHandler(string, sSOToken);
            objectArray.modifyRemoteProvider(node);
        }
        catch (Exception exception) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)exception);
            throw new AdminException(exception);
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser::Modified Remote Provider" + string2);
        }
        objectArray = new String[]{string2, string};
        AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("modify-remote-prov"), objectArray));
    }

    private void modifyHostedProvider(String string, Node node, SSOToken sSOToken) throws AdminException {
        Object[] objectArray;
        String string2 = ((Element)node).getAttributeNode("id").getValue();
        try {
            objectArray = new FedServicesRequestHandler(string, sSOToken);
            objectArray.modifyHostedProvider(node);
        }
        catch (FSInvalidNameException fSInvalidNameException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSInvalidNameException));
            throw new AdminException((Throwable)((Object)fSInvalidNameException));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSAllianceManagementException));
            throw new AdminException((Throwable)((Object)fSAllianceManagementException));
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser::Modified Remote Provider" + string2);
        }
        objectArray = new String[]{string2, string};
        AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("modify-hosted-prov"), objectArray));
    }

    private void createHostedProvider(String string, Node node, SSOToken sSOToken) throws AdminException {
        Object[] objectArray;
        String string2 = ((Element)node).getAttributeNode("id").getValue();
        try {
            objectArray = new FedServicesRequestHandler(string, sSOToken);
            objectArray.createHostedProvider(node);
        }
        catch (FSInvalidNameException fSInvalidNameException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSInvalidNameException));
            throw new AdminException((Throwable)((Object)fSInvalidNameException));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSAllianceManagementException));
            throw new AdminException((Throwable)((Object)fSAllianceManagementException));
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser::Created Hosted Provider" + string2);
        }
        objectArray = new String[]{string2, string};
        AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("create-hosted-prov"), objectArray));
    }

    private void deleteHostedProvider(String string, Node node, SSOToken sSOToken) throws AdminException {
        Object[] objectArray;
        String string2 = ((Element)node).getAttributeNode("id").getValue();
        try {
            objectArray = new FedServicesRequestHandler(string, sSOToken);
            objectArray.deleteProvider(string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSAllianceManagementException));
            throw new AdminException((Throwable)((Object)fSAllianceManagementException));
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser::Deleted Provider:" + string2);
        }
        objectArray = new String[]{string2, string};
        AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("delete-prov"), objectArray));
    }

    private void getFederationProvider(String string, Node node, SSOToken sSOToken) throws AdminException {
        String string2 = ((Element)node).getAttributeNode("id").getValue();
        try {
            FedServicesRequestHandler fedServicesRequestHandler = new FedServicesRequestHandler(string, sSOToken);
            fedServicesRequestHandler.getProvider(string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSAllianceManagementException));
            throw new AdminException((Throwable)((Object)fSAllianceManagementException));
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser::Read Provider " + string2);
        }
    }

    private void createFederationAuthenticationDomain(String string, Node node, SSOToken sSOToken) throws AdminException {
        Object[] objectArray;
        String string2 = ((Element)node).getAttributeNode("name").getValue();
        try {
            objectArray = new FedServicesRequestHandler(string, sSOToken);
            objectArray.createAuthenticationDomain(node);
        }
        catch (FSInvalidNameException fSInvalidNameException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSInvalidNameException));
            throw new AdminException((Throwable)((Object)fSInvalidNameException));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSAllianceManagementException));
            throw new AdminException((Throwable)((Object)fSAllianceManagementException));
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser::Created Circle of Trust " + string2);
        }
        objectArray = new String[]{string2, string};
        AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("create-cot"), objectArray));
    }

    private void deleteFederationAuthenticationDomain(String string, Node node, SSOToken sSOToken) throws AdminException {
        Object[] objectArray;
        String string2 = ((Element)node).getAttributeNode("name").getValue();
        try {
            objectArray = new FedServicesRequestHandler(string, sSOToken);
            objectArray.deleteAuthenticationDomain(string2);
        }
        catch (FSInvalidNameException fSInvalidNameException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSInvalidNameException));
            throw new AdminException((Throwable)((Object)fSInvalidNameException));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSAllianceManagementException));
            throw new AdminException((Throwable)((Object)fSAllianceManagementException));
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser::Deleted Authentication Domain " + string2);
        }
        objectArray = new String[]{string2, string};
        AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("delete-cot"), objectArray));
    }

    private void getFederationAuthenticationDomain(String string, Node node, SSOToken sSOToken) throws AdminException {
        String string2 = ((Element)node).getAttributeNode("name").getValue();
        try {
            FedServicesRequestHandler fedServicesRequestHandler = new FedServicesRequestHandler(string, sSOToken);
            fedServicesRequestHandler.getAuthenticationDomain(string2);
        }
        catch (FSInvalidNameException fSInvalidNameException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSInvalidNameException));
            throw new AdminException((Throwable)((Object)fSInvalidNameException));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSAllianceManagementException));
            throw new AdminException((Throwable)((Object)fSAllianceManagementException));
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser::Read Auth Domain " + string2);
        }
    }

    private void modifyFederationAuthenticationDomain(String string, Node node, SSOToken sSOToken) throws AdminException {
        Object[] objectArray;
        String string2 = ((Element)node).getAttributeNode("name").getValue();
        try {
            objectArray = new FedServicesRequestHandler(string, sSOToken);
            objectArray.modifyAuthenticationDomain(node);
        }
        catch (FSInvalidNameException fSInvalidNameException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSInvalidNameException));
            throw new AdminException((Throwable)((Object)fSInvalidNameException));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            this.debug.error("AdminXMLParser::Error in alliance manager:", (Throwable)((Object)fSAllianceManagementException));
            throw new AdminException((Throwable)((Object)fSAllianceManagementException));
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser::Modified Auth Domain " + string2);
        }
        objectArray = new String[]{string2, string};
        AdminUtils.logOperation(0, MessageFormat.format(bundle.getString("modify-cot"), objectArray));
    }

    private Set getSubNodeElementNodeDNValues(NodeList nodeList) {
        int n = nodeList.getLength();
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1 && node.getNodeName().equals("DN")) {
                Text text = (Text)node.getFirstChild();
                hashSet.add(text.getNodeValue());
            }
            ++n2;
        }
        return hashSet;
    }

    private Set getSubNodeElementNodeValues(NodeList nodeList) {
        int n = nodeList.getLength();
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Text text = (Text)node.getFirstChild();
                hashSet.add(text.getNodeValue());
            }
            ++n2;
        }
        return hashSet;
    }

    private SchemaType getSchemaType(String string) {
        SchemaType schemaType = null;
        if (string.equalsIgnoreCase("global")) {
            schemaType = SchemaType.GLOBAL;
        } else if (string.equalsIgnoreCase("organization")) {
            schemaType = SchemaType.ORGANIZATION;
        } else if (string.equalsIgnoreCase("dynamic")) {
            schemaType = SchemaType.DYNAMIC;
        } else if (string.equalsIgnoreCase("user")) {
            schemaType = SchemaType.USER;
        } else if (string.equalsIgnoreCase("policy")) {
            schemaType = SchemaType.POLICY;
        }
        return schemaType;
    }

    private ServiceSchema parseSubSchema(String string, String string2, String string3, SSOToken sSOToken) throws AdminException {
        Object[] objectArray;
        ServiceSchema serviceSchema = null;
        if (string != null && string2 != null) {
            try {
                objectArray = this.getSchemaType(string2);
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
                serviceSchema = serviceSchemaManager.getSchema((SchemaType)objectArray);
                if (string3 != null) {
                    boolean bl = false;
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
                    while (stringTokenizer.hasMoreTokens() && !bl) {
                        String string4 = stringTokenizer.nextToken();
                        if (string4 != null) {
                            if ((serviceSchema = serviceSchema.getSubSchema(string4)) != null) continue;
                            this.debug.error("SubSchema" + string4 + "does not exist");
                            Object[] objectArray2 = new String[]{string4};
                            String string5 = MessageFormat.format(bundle.getString("subSchemaStringDoesNotExist"), objectArray2);
                            throw new AdminException(string5);
                        }
                        bl = true;
                    }
                }
            }
            catch (SMSException sMSException) {
                throw new AdminException(sMSException);
            }
            catch (SSOException sSOException) {
                throw new AdminException(sSOException);
            }
            catch (Exception exception) {
                throw new AdminException(exception);
            }
        }
        if (serviceSchema == null) {
            objectArray = new String[]{string, string2};
            throw new AdminException(MessageFormat.format(bundle.getString("serviceschemaexception"), objectArray));
        }
        return serviceSchema;
    }

    private void doSchemaRootNodeRequests(Node node, SSOToken sSOToken) throws AdminException {
        Object var3_3 = null;
        String string = ((Element)node).getAttribute("serviceName");
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1) {
                    String string2 = node2.getNodeName();
                    int n3 = AdminXMLParser.getToken(string2);
                    try {
                        switch (n3) {
                            case 98: {
                                this.setPropertiesViewBeanURLonSchema(node2, string, sSOToken);
                            }
                        }
                    }
                    catch (AdminException adminException) {
                        if (continueFlag) break block7;
                        throw adminException;
                    }
                }
            }
            ++n2;
        }
    }

    private void setPropertiesViewBeanURLonSchema(Node node, String string, SSOToken sSOToken) throws AdminException {
        String string2 = ((Element)node).getAttribute("url");
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            serviceSchemaManager.setPropertiesViewBeanURL(string2);
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private void doSchemaRequests(Node node, SSOToken sSOToken) throws AdminException {
        Object object;
        ServiceSchema serviceSchema = null;
        String string = ((Element)node).getAttribute("serviceName");
        String string2 = ((Element)node).getAttribute("SchemaType");
        String string3 = ((Element)node).getAttribute("i18nKey");
        String string4 = ((Element)node).getAttribute("SubSchema");
        if (string4 != null && string4.length() > 0 && !string2.equalsIgnoreCase("global") && !string2.equalsIgnoreCase("organization")) {
            object = bundle.getString("subschemaexception");
            if (!continueFlag) {
                throw new AdminException((String)object);
            }
        }
        object = node.getChildNodes();
        int n = object.getLength();
        int n2 = 0;
        while (n2 < n) {
            block14: {
                Node node2 = object.item(n2);
                if (node2.getNodeType() == 1) {
                    String string5 = node2.getNodeName();
                    int n3 = AdminXMLParser.getToken(string5);
                    try {
                        switch (n3) {
                            case 51: 
                            case 52: 
                            case 53: 
                            case 55: {
                                this.processServiceSchemaRequest(n3, node2, string2, string, string4, sSOToken);
                                break;
                            }
                            case 58: 
                            case 59: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 89: {
                                this.processAttributeSchemaRequest(n3, node2, string2, string, string4, sSOToken, string3);
                                break;
                            }
                            case 80: {
                                this.addSubSchema(node2, string, string2, string4, sSOToken);
                                break;
                            }
                            case 81: {
                                this.addAttributeSchema(node2, string, string2, string4, sSOToken);
                                break;
                            }
                            case 83: {
                                serviceSchema = this.parseSubSchema(string, string2, string4, sSOToken);
                                this.removeAttributeSchema(serviceSchema, XMLUtils.parseAttributesTag((Node)node2));
                                break;
                            }
                            case 82: {
                                serviceSchema = this.parseSubSchema(string, string2, string4, sSOToken);
                                this.removeSubSchema(serviceSchema, XMLUtils.parseAttributesTag((Node)node2));
                            }
                        }
                    }
                    catch (AdminException adminException) {
                        if (continueFlag) break block14;
                        throw adminException;
                    }
                }
            }
            ++n2;
        }
    }

    private void removeAttributeSchema(ServiceSchema serviceSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                serviceSchema.removeAttributeSchema((String)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void removeSubSchema(ServiceSchema serviceSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                serviceSchema.removeSubSchema((String)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void addSubSchema(Node node, String string, String string2, String string3, SSOToken sSOToken) throws AdminException {
        if (!string2.equalsIgnoreCase("global") && !string2.equalsIgnoreCase("organization")) {
            throw new AdminException(bundle.getString("subschemaexception"));
        }
        ServiceSchema serviceSchema = this.parseSubSchema(string, string2, string3, sSOToken);
        this.fileName = ((Element)node).getAttribute("fileName");
        try {
            serviceSchema.addSubSchema(new FileInputStream(this.fileName));
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void addAttributeSchema(Node node, String string, String string2, String string3, SSOToken sSOToken) throws AdminException {
        ServiceSchema serviceSchema = this.parseSubSchema(string, string2, string3, sSOToken);
        this.fileName = ((Element)node).getAttribute("fileName");
        try {
            serviceSchema.addAttributeSchema(new FileInputStream(this.fileName));
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void processServiceSchemaRequest(int n, Node node, String string, String string2, String string3, SSOToken sSOToken) throws AdminException {
        ServiceSchema serviceSchema = this.parseSubSchema(string2, string, string3, sSOToken);
        if (serviceSchema != null) {
            this.processServiceSchemaRequest(n, node, serviceSchema);
        }
    }

    private void processAttributeSchemaRequest(int n, Node node, String string, String string2, String string3, SSOToken sSOToken, String string4) throws AdminException {
        ServiceSchema serviceSchema = this.parseSubSchema(string2, string, string3, sSOToken);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string5);
            Set set = (Set)map.get(string5);
            this.processAttributeSchemaRequest(n, attributeSchema, set, string4);
        }
    }

    private ServiceSchema getServiceSchema(String string, String string2, SSOToken sSOToken) throws AdminException {
        ServiceSchema serviceSchema = null;
        SchemaType schemaType = this.getSchemaType(string);
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string2, sSOToken);
            serviceSchema = serviceSchemaManager.getSchema(schemaType);
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
        return serviceSchema;
    }

    private void processServiceSchemaRequest(int n, Node node, ServiceSchema serviceSchema) throws AdminException {
        try {
            switch (n) {
                case 51: {
                    serviceSchema.removeAttributeDefaults(XMLUtils.parseAttributesTag((Node)node));
                    break;
                }
                case 52: {
                    serviceSchema.setAttributeDefaults(XMLUtils.parseAttributeValuePairTags((Node)node));
                    break;
                }
                case 53: {
                    this.addDefaultValuesToServiceSchema(node, serviceSchema);
                    break;
                }
                case 55: {
                    this.getServiceDefaultValues(node, serviceSchema);
                }
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void processAttributeSchemaRequest(int n, AttributeSchema attributeSchema, Set set, String string) throws AdminException {
        try {
            switch (n) {
                case 58: {
                    this.addAttributeSchemaChoiceValues(attributeSchema, set, string);
                    break;
                }
                case 59: {
                    this.removeAttributeSchemaChoiceValues(attributeSchema, set);
                    break;
                }
                case 73: {
                    this.modifyAttributeSchemaTypes(attributeSchema, set);
                    break;
                }
                case 74: {
                    this.modifyAttributeSchemaUITypes(attributeSchema, set);
                    break;
                }
                case 75: {
                    this.modifyAttributeSchemaI18nKeys(attributeSchema, set);
                    break;
                }
                case 77: {
                    this.modifyAttributeSchemaPropertiesViewBean(attributeSchema, set);
                    break;
                }
                case 78: {
                    this.modifyAttributeSchemaStartRange(attributeSchema, set);
                    break;
                }
                case 79: {
                    this.modifyAttributeSchemaEndRange(attributeSchema, set);
                    break;
                }
                case 76: {
                    this.modifyAttributeSchemaSyntax(attributeSchema, set);
                    break;
                }
                case 89: {
                    this.removePartialDefaultValues(attributeSchema, set);
                }
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void addDefaultValuesToServiceSchema(Node node, ServiceSchema serviceSchema) throws AdminException {
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        try {
            Map map2 = serviceSchema.getAttributeDefaults();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)map2.get(string);
                HashSet hashSet = set == null || set.isEmpty() ? new HashSet() : new HashSet(set);
                hashSet.addAll((Set)map.get(string));
                serviceSchema.setAttributeDefaults(string, hashSet);
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void getServiceDefaultValues(Node node, ServiceSchema serviceSchema) {
        Set set = XMLUtils.parseAttributesTag((Node)node);
        Map map = serviceSchema.getAttributeDefaults();
        if (set == null || set.isEmpty()) {
            set = map.keySet();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set2 = (Set)map.get(string);
            if (set2 == null) continue;
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
            AttributeSchema.Syntax syntax = attributeSchema.getSyntax();
            if (syntax == AttributeSchema.Syntax.PASSWORD) {
                set2 = this.maskPasswordField(set2);
            }
            System.out.println(string + "=" + set2.toString());
        }
    }

    private Set maskPasswordField(Set set) {
        int n = set.size();
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            hashSet.add("********");
            ++n2;
        }
        return hashSet;
    }

    private void addAttributeSchemaChoiceValues(AttributeSchema attributeSchema, Set set, String string) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attributeSchema.addChoiceValue((String)iterator.next(), string);
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void removeAttributeSchemaChoiceValues(AttributeSchema attributeSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attributeSchema.removeChoiceValue((String)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void modifyAttributeSchemaTypes(AttributeSchema attributeSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attributeSchema.setType((String)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void modifyAttributeSchemaUITypes(AttributeSchema attributeSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attributeSchema.setUIType((String)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void modifyAttributeSchemaI18nKeys(AttributeSchema attributeSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attributeSchema.setI18NKey((String)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void modifyAttributeSchemaPropertiesViewBean(AttributeSchema attributeSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attributeSchema.setPropertiesViewBeanUR((String)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void modifyAttributeSchemaStartRange(AttributeSchema attributeSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attributeSchema.setStartRange((String)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void modifyAttributeSchemaEndRange(AttributeSchema attributeSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attributeSchema.setEndRange((String)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void modifyAttributeSchemaSyntax(AttributeSchema attributeSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attributeSchema.setSyntax((String)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private void removePartialDefaultValues(AttributeSchema attributeSchema, Set set) throws AdminException {
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attributeSchema.removeDefaultValue((String)iterator.next());
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
    }

    private void doServiceConfigurationRequests(Node node, SSOToken sSOToken) throws AdminException {
        Node node2 = node;
        String string = ((Element)node2).getAttribute("serviceName");
        NodeList nodeList = node2.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block9: {
                Node node3 = nodeList.item(n2);
                if (node3.getNodeType() == 1) {
                    String string2 = node3.getNodeName();
                    int n3 = AdminXMLParser.getToken(string2);
                    try {
                        switch (n3) {
                            case 56: {
                                this.addSubConfigToDefault(string, node3, sSOToken);
                                break;
                            }
                            case 57: {
                                this.removeSubConfigFromDefault(string, node3, sSOToken);
                                break;
                            }
                            case 71: {
                                this.deleteAllServiceConfiguration(string, node3, sSOToken);
                            }
                        }
                    }
                    catch (AdminException adminException) {
                        if (continueFlag) break block9;
                        throw adminException;
                    }
                }
            }
            ++n2;
        }
    }

    private void addSubConfigToDefault(String string, Node node, SSOToken sSOToken) throws AdminException {
        try {
            String string2 = ((Element)node).getAttribute("subConfigName");
            String string3 = ((Element)node).getAttribute("subConfigId");
            Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string, sSOToken);
            ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
            int n = stringTokenizer.countTokens();
            int n2 = 1;
            while (n2 <= n) {
                String string4 = SMSSchema.unescapeName(stringTokenizer.nextToken());
                if (n2 != n) {
                    serviceConfig = serviceConfig.getSubConfig(string4);
                } else {
                    if (string3 == null) {
                        string3 = string2;
                    }
                    serviceConfig.addSubConfig(string4, string3, 0, map);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            this.debug.error("AdminXMLParse.addSubConfigToDefault", (Throwable)exception);
            throw new AdminException(exception.toString());
        }
    }

    private void removeSubConfigFromDefault(String string, Node node, SSOToken sSOToken) throws AdminException {
        try {
            String string2 = ((Element)node).getAttribute("subConfigName");
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string, sSOToken);
            ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
            int n = stringTokenizer.countTokens();
            int n2 = 1;
            while (n2 <= n) {
                String string3 = SMSSchema.unescapeName(stringTokenizer.nextToken());
                if (n2 != n) {
                    serviceConfig = serviceConfig.getSubConfig(string3);
                } else {
                    serviceConfig.removeSubConfig(string3);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            this.debug.error("AdminXMLParse.removeSubConfigFromDefault", (Throwable)exception);
            throw new AdminException(exception.toString());
        }
    }

    private void deleteAllServiceConfiguration(String string, Node node, SSOToken sSOToken) throws AdminException {
        if (string != null) {
            String string2 = ((Element)node).getAttribute("userAtt");
            boolean bl = Boolean.valueOf(string2);
            try {
                ServiceManager serviceManager = new ServiceManager(sSOToken);
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log(bundle.getString("statusmsg12") + string);
                }
                if (string.equalsIgnoreCase("iPlanetAMAuthService")) {
                    serviceManager.deleteService(string);
                } else {
                    Set set = serviceManager.getServiceVersions(string);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        ServiceUtil serviceUtil = new ServiceUtil(sSOToken, this.debug);
                        String string3 = (String)iterator.next();
                        if (serviceUtil.deleteService(string, bl, string3)) {
                            serviceManager.removeService(string, string3);
                            this.debug.message("Service Config deletion successful");
                            continue;
                        }
                        this.debug.error("Service Config deletion failed");
                    }
                }
            }
            catch (Exception exception) {
                this.debug.error("AdminXMLParser.deleteAllServiceConfiguration", (Throwable)exception);
                throw new AdminException(exception.toString());
            }
        }
    }

    private void doUserRequests(Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        String string = ((Element)node).getAttribute("DN");
        this.validateObjectType(aMStoreConnection, string, 1);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block8: {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1) {
                    String string2 = node2.getNodeName();
                    int n3 = AdminXMLParser.getToken(string2);
                    try {
                        switch (n3) {
                            case 23: {
                                this.registerServicesToUser(string, node2, aMStoreConnection);
                                break;
                            }
                            case 24: {
                                this.unregisterServicesToUser(string, node2, aMStoreConnection);
                            }
                        }
                    }
                    catch (AdminException adminException) {
                        if (continueFlag) break block8;
                        throw adminException;
                    }
                }
            }
            ++n2;
        }
    }

    private void registerServicesToUser(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        UserRegisterServicesReq userRegisterServicesReq = new UserRegisterServicesReq(string);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                userRegisterServicesReq.registerServicesReq((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(userRegisterServicesReq.toString());
            }
            userRegisterServicesReq.process(aMStoreConnection);
        }
    }

    private void unregisterServicesToUser(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        UserUnregisterServicesReq userUnregisterServicesReq = new UserUnregisterServicesReq(string);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                userUnregisterServicesReq.unregisterServicesReq((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(userUnregisterServicesReq.toString());
            }
            userUnregisterServicesReq.process(aMStoreConnection);
        }
    }

    private void doContainerRequests(Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        Node node2 = node;
        String string = ((Element)node2).getAttribute("DN");
        this.validateObjectType(aMStoreConnection, string, 3);
        NodeList nodeList = node2.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block38: {
                Node node3 = nodeList.item(n2);
                if (node3.getNodeType() == 1) {
                    int n3 = AdminXMLParser.getToken(node3.getNodeName());
                    try {
                        switch (n3) {
                            case 30: {
                                this.createSubContainerInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 45: {
                                this.modifySubContainerInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 86: {
                                this.getServiceTemplateInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 39: {
                                this.modifyServiceTemplateInContainer(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 88: {
                                this.addServiceTemplateAttrValuesInContainer(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 87: {
                                this.removeServiceTemplateAttrValuesInContainer(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 1: {
                                this.createPeopleContainerInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 84: {
                                this.createGroupContainerInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 36: {
                                this.modifyPeopleContainerInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 2: {
                                this.createGroupsInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 14: {
                                this.createUsersInContainer(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 3: {
                                this.createRolesInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 37: {
                                this.modifyRolesInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 31: {
                                this.getSubContainersInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 5: {
                                this.getPeopleContainersInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 6: {
                                this.getGroupsInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 7: {
                                this.getRolesInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 8: {
                                this.getUsersInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 32: {
                                this.deleteSubContainersInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 10: {
                                this.deletePeopleContainersInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 11: {
                                this.deleteGroupsInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 12: {
                                this.deleteRolesInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 54: {
                                this.deleteServiceTemplateInContainer(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 23: {
                                this.registerServicesInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 24: {
                                this.unregisterServicesInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 27: {
                                this.getRegisteredServicesInContainer(string, aMStoreConnection);
                                break;
                            }
                            case 29: {
                                this.getNumberOfServicesInContainer(string, aMStoreConnection);
                                break;
                            }
                            case 38: {
                                this.createServiceTemplatesInContainer(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 90: {
                                this.createAgentInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 92: {
                                this.modifyAgentInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 91: {
                                this.deleteAgentsInContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 93: {
                                this.getAgentsInContainer(string, node3, aMStoreConnection);
                            }
                        }
                    }
                    catch (AdminException adminException) {
                        if (continueFlag) break block38;
                        throw adminException;
                    }
                }
            }
            ++n2;
        }
    }

    private void createSubContainerInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContCreateSubContReq contCreateSubContReq = new ContCreateSubContReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        contCreateSubContReq.addSubContReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contCreateSubContReq.toString());
        }
        contCreateSubContReq.process(aMStoreConnection);
    }

    private void modifySubContainerInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContModifySubContReq contModifySubContReq = new ContModifySubContReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        contModifySubContReq.addSubContReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contModifySubContReq.toString());
        }
        contModifySubContReq.process(aMStoreConnection);
    }

    private void getServiceTemplateInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContGetServiceTemplateReq contGetServiceTemplateReq = new ContGetServiceTemplateReq(string);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        contGetServiceTemplateReq.setServiceNameSchemaType(string2, string3);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contGetServiceTemplateReq.toString());
        }
        contGetServiceTemplateReq.process(aMStoreConnection);
    }

    private void modifyServiceTemplateInContainer(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        ContModifyServiceTemplateReq contModifyServiceTemplateReq = new ContModifyServiceTemplateReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        String string4 = ((Element)node).getAttribute("level");
        String string5 = ((Element)node).getAttribute("roleTemplate");
        if (!string3.equalsIgnoreCase("dynamic") && string5.equalsIgnoreCase("true")) {
            throw new UnsupportedOperationException("\n" + bundle.getString("roletemplateexception"));
        }
        contModifyServiceTemplateReq.addServiceTemplateReq(string2, string3, string4, string5, map, sSOToken);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contModifyServiceTemplateReq.toString());
        }
        contModifyServiceTemplateReq.process(aMStoreConnection);
    }

    private void addServiceTemplateAttrValuesInContainer(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        ContAddServiceTemplateAttrValuesReq contAddServiceTemplateAttrValuesReq = new ContAddServiceTemplateAttrValuesReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        String string4 = ((Element)node).getAttribute("level");
        String string5 = ((Element)node).getAttribute("roleTemplate");
        if (!string3.equalsIgnoreCase("dynamic") && string5.equalsIgnoreCase("true")) {
            throw new UnsupportedOperationException(bundle.getString("roletemplateexception"));
        }
        contAddServiceTemplateAttrValuesReq.addRequest(string2, string3, string4, string5, map, sSOToken);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contAddServiceTemplateAttrValuesReq.toString());
        }
        contAddServiceTemplateAttrValuesReq.process(aMStoreConnection);
    }

    private void removeServiceTemplateAttrValuesInContainer(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        ContRemoveServiceTemplateAttrValuesReq contRemoveServiceTemplateAttrValuesReq = new ContRemoveServiceTemplateAttrValuesReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        String string4 = ((Element)node).getAttribute("level");
        String string5 = ((Element)node).getAttribute("roleTemplate");
        if (!string3.equalsIgnoreCase("dynamic") && string5.equalsIgnoreCase("true")) {
            throw new UnsupportedOperationException(bundle.getString("roletemplateexception"));
        }
        contRemoveServiceTemplateAttrValuesReq.addRequest(string2, string3, string4, string5, map, sSOToken);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contRemoveServiceTemplateAttrValuesReq.toString());
        }
        contRemoveServiceTemplateAttrValuesReq.process(aMStoreConnection);
    }

    private void createPeopleContainerInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContCreatePCReq contCreatePCReq = new ContCreatePCReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        contCreatePCReq.addPCReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contCreatePCReq.toString());
        }
        contCreatePCReq.process(aMStoreConnection);
    }

    private void createGroupContainerInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContCreateGroupContainerReq contCreateGroupContainerReq = new ContCreateGroupContainerReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        contCreateGroupContainerReq.addGroupContainerRequest(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contCreateGroupContainerReq.toString());
        }
        contCreateGroupContainerReq.process(aMStoreConnection);
    }

    private void modifyPeopleContainerInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContModifyPCReq contModifyPCReq = new ContModifyPCReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        contModifyPCReq.addPCReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contModifyPCReq.toString());
        }
        contModifyPCReq.process(aMStoreConnection);
    }

    private void createUsersInContainer(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        ContCreateUserReq contCreateUserReq = new ContCreateUserReq(string, sSOToken);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        contCreateUserReq.addUserReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contCreateUserReq.toString());
        }
        contCreateUserReq.process(aMStoreConnection);
    }

    private void createAgentInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgCreateAgentReq orgCreateAgentReq = new OrgCreateAgentReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        orgCreateAgentReq.addRequest(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgCreateAgentReq.toString());
        }
        orgCreateAgentReq.process(aMStoreConnection);
    }

    private void createAgentInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContCreateAgentReq contCreateAgentReq = new ContCreateAgentReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        contCreateAgentReq.addAgent(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contCreateAgentReq.toString());
        }
        contCreateAgentReq.process(aMStoreConnection);
    }

    private void modifyAgentInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgModifyAgentReq orgModifyAgentReq = new OrgModifyAgentReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        orgModifyAgentReq.addRequest(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(orgModifyAgentReq.toString());
        }
        orgModifyAgentReq.process(aMStoreConnection);
    }

    private void modifyAgentInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContModifyAgentReq contModifyAgentReq = new ContModifyAgentReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        contModifyAgentReq.addRequest(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contModifyAgentReq.toString());
        }
        contModifyAgentReq.process(aMStoreConnection);
    }

    private void deleteAgentInOrganization(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        OrgDeleteAgentsReq orgDeleteAgentsReq = new OrgDeleteAgentsReq(string);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                orgDeleteAgentsReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(orgDeleteAgentsReq.toString());
            }
            orgDeleteAgentsReq.process(aMStoreConnection);
        }
    }

    private void deleteAgentsInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContDeleteAgentsReq contDeleteAgentsReq = new ContDeleteAgentsReq(string);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                contDeleteAgentsReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(contDeleteAgentsReq.toString());
            }
            contDeleteAgentsReq.process(aMStoreConnection);
        }
    }

    private void createGroupsInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContCreateGroupReq contCreateGroupReq = new ContCreateGroupReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        String string3 = ((Element)node).getAttribute("groupType");
        contCreateGroupReq.addGroupReq(string2, string3, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contCreateGroupReq.toString());
        }
        contCreateGroupReq.process(aMStoreConnection);
    }

    private void createRolesInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContCreateRoleReq contCreateRoleReq = null;
        String string2 = ((Element)node).getAttribute("roleType");
        contCreateRoleReq = string2.equals("filtered") ? new ContCreateFilteredRoleReq(string) : new ContCreateRoleReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string3 = ((Element)node).getAttribute("createDN");
        contCreateRoleReq.addRoleReq(string3, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contCreateRoleReq.toString());
        }
        contCreateRoleReq.process(aMStoreConnection);
    }

    private void modifyRolesInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContModifyRoleReq contModifyRoleReq = new ContModifyRoleReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        contModifyRoleReq.addRoleReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contModifyRoleReq.toString());
        }
        contModifyRoleReq.process(aMStoreConnection);
    }

    private void getSubContainersInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContGetSubContReq contGetSubContReq = new ContGetSubContReq(string);
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        contGetSubContReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            contGetSubContReq.addSubContDNs((String)iterator.next());
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contGetSubContReq.toString());
        }
        contGetSubContReq.process(aMStoreConnection);
    }

    private void getPeopleContainersInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContGetPCReq contGetPCReq = new ContGetPCReq(string);
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        contGetPCReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            contGetPCReq.addPCDNs((String)iterator.next());
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contGetPCReq.toString());
        }
        contGetPCReq.process(aMStoreConnection);
    }

    private void getGroupsInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContGetGroupReq contGetGroupReq = new ContGetGroupReq(string);
        contGetGroupReq.setLevel(this.validateLevel(node));
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contGetGroupReq.toString());
        }
        contGetGroupReq.process(aMStoreConnection);
    }

    private void getRolesInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContGetRoleReq contGetRoleReq = new ContGetRoleReq(string);
        contGetRoleReq.setLevel(this.validateLevel(node));
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contGetRoleReq.toString());
        }
        contGetRoleReq.process(aMStoreConnection);
    }

    private void getUsersInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContGetUserReq contGetUserReq = new ContGetUserReq(string);
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        contGetUserReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            contGetUserReq.addUserDNs((String)iterator.next());
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contGetUserReq.toString());
        }
        contGetUserReq.process(aMStoreConnection);
    }

    private void deleteSubContainersInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContDeleteSubContReq contDeleteSubContReq = new ContDeleteSubContReq(string);
        String string2 = ((Element)node).getAttribute("deleteRecursively");
        boolean bl = Boolean.valueOf(string2);
        contDeleteSubContReq.setRecursiveDelete(bl);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                contDeleteSubContReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(contDeleteSubContReq.toString());
            }
            contDeleteSubContReq.process(aMStoreConnection);
        }
    }

    private void deletePeopleContainersInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContDeletePCReq contDeletePCReq = new ContDeletePCReq(string);
        String string2 = ((Element)node).getAttribute("deleteRecursively");
        boolean bl = Boolean.valueOf(string2);
        contDeletePCReq.setRecursiveDelete(bl);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                contDeletePCReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(contDeletePCReq.toString());
            }
            contDeletePCReq.process(aMStoreConnection);
        }
    }

    private void deleteGroupsInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContDeleteGroupReq contDeleteGroupReq = new ContDeleteGroupReq(string);
        String string2 = ((Element)node).getAttribute("deleteRecursively");
        boolean bl = Boolean.valueOf(string2);
        contDeleteGroupReq.setRecursiveDelete(bl);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                contDeleteGroupReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(contDeleteGroupReq.toString());
            }
            contDeleteGroupReq.process(aMStoreConnection);
        }
    }

    private void deleteRolesInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContDeleteRoleReq contDeleteRoleReq = new ContDeleteRoleReq(string);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                contDeleteRoleReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(contDeleteRoleReq.toString());
            }
            contDeleteRoleReq.process(aMStoreConnection);
        }
    }

    private void deleteServiceTemplateInContainer(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        ContDeleteServiceTemplateReq contDeleteServiceTemplateReq = new ContDeleteServiceTemplateReq(string);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        contDeleteServiceTemplateReq.setServiceTemplateReq(string2, string3);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contDeleteServiceTemplateReq.toString());
        }
        contDeleteServiceTemplateReq.process(aMStoreConnection, sSOToken);
    }

    private void registerServicesInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContRegisterServicesReq contRegisterServicesReq = new ContRegisterServicesReq(string);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                contRegisterServicesReq.registerServicesReq((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(contRegisterServicesReq.toString());
            }
            contRegisterServicesReq.process(aMStoreConnection);
        }
    }

    private void unregisterServicesInContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        ContUnregisterServicesReq contUnregisterServicesReq = new ContUnregisterServicesReq(string);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                contUnregisterServicesReq.unregisterServicesReq((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(contUnregisterServicesReq.toString());
            }
            contUnregisterServicesReq.process(aMStoreConnection);
        }
    }

    private void getRegisteredServicesInContainer(String string, AMStoreConnection aMStoreConnection) throws AdminException {
        ContGetRegisteredServicesReq contGetRegisteredServicesReq = new ContGetRegisteredServicesReq(string);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contGetRegisteredServicesReq.toString());
        }
        contGetRegisteredServicesReq.process(aMStoreConnection);
    }

    private void getNumberOfServicesInContainer(String string, AMStoreConnection aMStoreConnection) throws AdminException {
        ContGetNumOfServicesReq contGetNumOfServicesReq = new ContGetNumOfServicesReq(string);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(contGetNumOfServicesReq.toString());
        }
        contGetNumOfServicesReq.process(aMStoreConnection);
    }

    private void createServiceTemplatesInContainer(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        ContCreateServiceTemplateReq contCreateServiceTemplateReq = new ContCreateServiceTemplateReq(string);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                contCreateServiceTemplateReq.addContServiceTmplReq((String)iterator.next());
            }
            contCreateServiceTemplateReq.process(aMStoreConnection, sSOToken);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(contCreateServiceTemplateReq.toString());
            }
        }
    }

    private void doPeopleContainerRequests(Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        Node node2 = node;
        String string = ((Element)node2).getAttribute("DN");
        this.validateObjectType(aMStoreConnection, string, 5);
        NodeList nodeList = node2.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            block15: {
                Node node3 = nodeList.item(n2);
                if (node3.getNodeType() == 1) {
                    String string2 = node3.getNodeName();
                    int n3 = AdminXMLParser.getToken(string2);
                    try {
                        switch (n3) {
                            case 13: {
                                this.createSubPeopleContainerInPeopleContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 36: {
                                this.modifySubPeopleContainerInPeopleContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 14: {
                                this.createUserInPeopleContainer(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 49: {
                                this.modifyUserInPeopleContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 15: {
                                this.deleteSubPeopleContainersInPeopleContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 16: {
                                this.deleteUsersInPeopleContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 17: {
                                this.getNumberOfUsersInPeopleContainer(string, aMStoreConnection);
                                break;
                            }
                            case 8: {
                                this.getUsersInPeopleContainer(string, node3, aMStoreConnection);
                                break;
                            }
                            case 18: {
                                this.getSubPeopleContainersInPeopleContainer(string, node3, aMStoreConnection);
                            }
                        }
                    }
                    catch (AdminException adminException) {
                        if (continueFlag) break block15;
                        throw adminException;
                    }
                }
            }
            ++n2;
        }
    }

    private void createSubPeopleContainerInPeopleContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        PCCreateSubPCReq pCCreateSubPCReq = new PCCreateSubPCReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        pCCreateSubPCReq.addSubPCReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(pCCreateSubPCReq.toString());
        }
        pCCreateSubPCReq.process(aMStoreConnection);
    }

    private void modifySubPeopleContainerInPeopleContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        PCModifySubPCReq pCModifySubPCReq = new PCModifySubPCReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        pCModifySubPCReq.addSubPCReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(pCModifySubPCReq.toString());
        }
        pCModifySubPCReq.process(aMStoreConnection);
    }

    private void createUserInPeopleContainer(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        PCCreateUserReq pCCreateUserReq = new PCCreateUserReq(string, sSOToken);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        pCCreateUserReq.addUserReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(pCCreateUserReq.toString());
        }
        pCCreateUserReq.process(aMStoreConnection);
    }

    private void modifyUserInPeopleContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        PCModifyUserReq pCModifyUserReq = new PCModifyUserReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        pCModifyUserReq.addUserReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(pCModifyUserReq.toString());
        }
        pCModifyUserReq.process(aMStoreConnection);
    }

    private void deleteSubPeopleContainersInPeopleContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        PCDeleteSubPCReq pCDeleteSubPCReq = new PCDeleteSubPCReq(string);
        String string2 = ((Element)node).getAttribute("deleteRecursively");
        boolean bl = Boolean.valueOf(string2);
        pCDeleteSubPCReq.setRecursiveDelete(bl);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                pCDeleteSubPCReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(pCDeleteSubPCReq.toString());
            }
            pCDeleteSubPCReq.process(aMStoreConnection);
        }
    }

    private void deleteUsersInPeopleContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        PCDeleteUserReq pCDeleteUserReq = new PCDeleteUserReq(string);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                pCDeleteUserReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(pCDeleteUserReq.toString());
            }
            pCDeleteUserReq.process(aMStoreConnection);
        }
    }

    private void getNumberOfUsersInPeopleContainer(String string, AMStoreConnection aMStoreConnection) throws AdminException {
        PCGetNumOfUserReq pCGetNumOfUserReq = new PCGetNumOfUserReq(string);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(pCGetNumOfUserReq.toString());
        }
        pCGetNumOfUserReq.process(aMStoreConnection);
    }

    private void getUsersInPeopleContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        PCGetUserReq pCGetUserReq = new PCGetUserReq(string);
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        pCGetUserReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                pCGetUserReq.addUserDNs((String)iterator.next());
            }
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(pCGetUserReq.toString());
        }
        pCGetUserReq.process(aMStoreConnection);
    }

    private void getSubPeopleContainersInPeopleContainer(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        PCGetSubPCReq pCGetSubPCReq = new PCGetSubPCReq(string);
        pCGetSubPCReq.setLevel(this.validateLevel(node));
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        pCGetSubPCReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                pCGetSubPCReq.addSubPCDNs((String)iterator.next());
            }
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(pCGetSubPCReq.toString());
        }
        pCGetSubPCReq.process(aMStoreConnection);
    }

    private void doRoleRequests(Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        Node node2 = node;
        String string = ((Element)node2).getAttribute("DN");
        int n = this.validateObjectType(aMStoreConnection, string, 6);
        NodeList nodeList = node2.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            block13: {
                Node node3 = nodeList.item(n3);
                if (node3.getNodeType() == 1) {
                    String string2 = node3.getNodeName();
                    int n4 = AdminXMLParser.getToken(string2);
                    try {
                        switch (n4) {
                            case 38: {
                                this.createServiceTemplateInRole(string, node3, aMStoreConnection, sSOToken);
                                break;
                            }
                            case 17: {
                                this.getNumberOfUsersInRole(string, aMStoreConnection, n);
                                break;
                            }
                            case 86: {
                                this.getServiceTemplateInRole(string, node3, aMStoreConnection, n);
                                break;
                            }
                            case 39: {
                                this.modifyServiceTemplateInRole(string, node3, aMStoreConnection, n);
                                break;
                            }
                            case 8: {
                                this.getUsersInRole(string, node3, aMStoreConnection, n);
                                break;
                            }
                            case 85: {
                                this.removeUsersInRole(string, node3, aMStoreConnection);
                                break;
                            }
                            case 19: {
                                this.addUsersToRole(string, node3, aMStoreConnection, n);
                            }
                        }
                    }
                    catch (AdminException adminException) {
                        if (continueFlag) break block13;
                        throw adminException;
                    }
                }
            }
            ++n3;
        }
    }

    private void createServiceTemplateInRole(String string, Node node, AMStoreConnection aMStoreConnection, SSOToken sSOToken) throws AdminException {
        RoleCreateServiceTemplateReq roleCreateServiceTemplateReq = new RoleCreateServiceTemplateReq(string);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                roleCreateServiceTemplateReq.addRoleServiceTmplReq((String)iterator.next());
                roleCreateServiceTemplateReq.process(aMStoreConnection, sSOToken);
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(roleCreateServiceTemplateReq.toString());
            }
        }
    }

    private void getNumberOfUsersInRole(String string, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        RoleGetNumOfUserReq roleGetNumOfUserReq;
        RoleGetNumOfUserReq roleGetNumOfUserReq2 = roleGetNumOfUserReq = n == 6 ? new RoleGetNumOfUserReq(string) : new FilteredRoleGetNumOfUserReq(string);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(roleGetNumOfUserReq.toString());
        }
        roleGetNumOfUserReq.process(aMStoreConnection);
    }

    private void getServiceTemplateInRole(String string, Node node, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        RoleGetServiceTemplateReq roleGetServiceTemplateReq = n == 6 ? new RoleGetServiceTemplateReq(string) : new FilteredRoleGetServiceTemplateReq(string);
        String string2 = ((Element)node).getAttribute("serviceName");
        String string3 = ((Element)node).getAttribute("schemaType");
        roleGetServiceTemplateReq.setServiceNameSchemaType(string2, string3);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(roleGetServiceTemplateReq.toString());
        }
        roleGetServiceTemplateReq.process(aMStoreConnection);
    }

    private void modifyServiceTemplateInRole(String string, Node node, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        RoleModifyServiceTemplateReq roleModifyServiceTemplateReq = n == 6 ? new RoleModifyServiceTemplateReq(string) : new FilteredRoleModifyServiceTemplateReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("serviceName");
        roleModifyServiceTemplateReq.addServiceTemplateReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(roleModifyServiceTemplateReq.toString());
        }
        roleModifyServiceTemplateReq.process(aMStoreConnection);
    }

    private void getUsersInRole(String string, Node node, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        RoleGetUserReq roleGetUserReq = n == 6 ? new RoleGetUserReq(string) : new FilteredRoleGetUserReq(string);
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        roleGetUserReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                roleGetUserReq.addUserDNs((String)iterator.next());
            }
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(roleGetUserReq.toString());
        }
        roleGetUserReq.process(aMStoreConnection);
    }

    private void removeUsersInRole(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        RoleDeleteUserReq roleDeleteUserReq = new RoleDeleteUserReq(string);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                roleDeleteUserReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(roleDeleteUserReq.toString());
            }
            roleDeleteUserReq.process(aMStoreConnection);
        }
    }

    private void addUsersToRole(String string, Node node, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        if (n == 8) {
            throw new AdminException(bundle.getString("cannotAddUsersToFilteredRole"));
        }
        RoleAddUserReq roleAddUserReq = new RoleAddUserReq(string);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                roleAddUserReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(roleAddUserReq.toString());
            }
            roleAddUserReq.process(aMStoreConnection);
        }
    }

    private void doGroupRequests(Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        Node node2 = node;
        String string = ((Element)node2).getAttribute("DN");
        int n = this.validateObjectType(aMStoreConnection, string, 9);
        NodeList nodeList = node2.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            block18: {
                Node node3 = nodeList.item(n3);
                if (node3.getNodeType() == 1) {
                    String string2 = node3.getNodeName();
                    int n4 = AdminXMLParser.getToken(string2);
                    try {
                        switch (n4) {
                            case 20: {
                                this.createSubGroupInGroup(string, node3, aMStoreConnection, n);
                                break;
                            }
                            case 50: {
                                this.modifySubGroupInGroup(string, node3, aMStoreConnection);
                                break;
                            }
                            case 21: {
                                this.deleteSubGroupInGroup(string, node3, aMStoreConnection);
                                break;
                            }
                            case 22: {
                                this.getSubGroupInGroup(string, node3, aMStoreConnection);
                                break;
                            }
                            case 17: {
                                this.getNumberOfUsersInGroup(string, aMStoreConnection, n);
                                break;
                            }
                            case 8: {
                                this.getUsersInGroup(string, node3, aMStoreConnection, n);
                                break;
                            }
                            case 85: {
                                this.removeUsersInGroup(string, node3, aMStoreConnection);
                                break;
                            }
                            case 19: {
                                this.addUsersToGroup(string, node3, aMStoreConnection, n);
                                break;
                            }
                            case 94: {
                                this.addNestedGroupsToGroup(string, node3, aMStoreConnection, n);
                                break;
                            }
                            case 96: {
                                this.getNestedGroupsInGroup(string, node3, aMStoreConnection, n);
                                break;
                            }
                            case 97: {
                                this.getNumberOfNestedGroupsInGroup(string, aMStoreConnection, n);
                                break;
                            }
                            case 95: {
                                this.removeNestedGroupsFromGroup(string, node3, aMStoreConnection, n);
                            }
                        }
                    }
                    catch (AdminException adminException) {
                        if (continueFlag) break block18;
                        throw adminException;
                    }
                }
            }
            ++n3;
        }
    }

    private void createSubGroupInGroup(String string, Node node, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        GroupCreateSubGroupReq groupCreateSubGroupReq = null;
        groupCreateSubGroupReq = n == 11 ? new DynamicGroupCreateSubGroupReq(string) : (n == 12 ? new AssignableDynamicGroupCreateSubGroupReq(string) : new GroupCreateSubGroupReq(string));
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("createDN");
        String string3 = ((Element)node).getAttribute("groupType");
        groupCreateSubGroupReq.addSubGroupReq(string2, string3, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(groupCreateSubGroupReq.toString());
        }
        groupCreateSubGroupReq.process(aMStoreConnection);
    }

    private void modifySubGroupInGroup(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        GroupModifySubGroupReq groupModifySubGroupReq = new GroupModifySubGroupReq(string);
        Map map = XMLUtils.parseAttributeValuePairTags((Node)node);
        String string2 = ((Element)node).getAttribute("modifyDN");
        groupModifySubGroupReq.addSubGroupReq(string2, map);
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(groupModifySubGroupReq.toString());
        }
        groupModifySubGroupReq.process(aMStoreConnection);
    }

    private void deleteSubGroupInGroup(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        GroupDeleteSubGroupReq groupDeleteSubGroupReq = new GroupDeleteSubGroupReq(string);
        String string2 = ((Element)node).getAttribute("deleteRecursively");
        boolean bl = Boolean.valueOf(string2);
        groupDeleteSubGroupReq.setRecursiveDelete(bl);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                groupDeleteSubGroupReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(groupDeleteSubGroupReq.toString());
            }
            groupDeleteSubGroupReq.process(aMStoreConnection);
        }
    }

    private void getSubGroupInGroup(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        GroupGetSubGroupReq groupGetSubGroupReq = new GroupGetSubGroupReq(string);
        groupGetSubGroupReq.setLevel(this.validateLevel(node));
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        groupGetSubGroupReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                groupGetSubGroupReq.addSubGroupDNs((String)iterator.next());
            }
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(groupGetSubGroupReq.toString());
        }
        groupGetSubGroupReq.process(aMStoreConnection);
    }

    private void getNumberOfUsersInGroup(String string, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        GroupGetNumOfUserReq groupGetNumOfUserReq = null;
        groupGetNumOfUserReq = n == 11 ? new DynamicGroupGetNumOfUserReq(string) : (n == 12 ? new AssignableDynamicGroupGetNumOfUserReq(string) : new GroupGetNumOfUserReq(string));
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(groupGetNumOfUserReq.toString());
        }
        groupGetNumOfUserReq.process(aMStoreConnection);
    }

    private void getNumberOfNestedGroupsInGroup(String string, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        GroupGetNumOfNestedGroupsReq groupGetNumOfNestedGroupsReq = null;
        switch (n) {
            case 11: {
                groupGetNumOfNestedGroupsReq = new DynamicGroupGetNumOfNestedGroupsReq(string);
                break;
            }
            case 12: {
                groupGetNumOfNestedGroupsReq = new AssignableDynamicGroupGetNumOfNestedGroupsReq(string);
                break;
            }
            default: {
                groupGetNumOfNestedGroupsReq = new GroupGetNumOfNestedGroupsReq(string);
            }
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(groupGetNumOfNestedGroupsReq.toString());
        }
        groupGetNumOfNestedGroupsReq.process(aMStoreConnection);
    }

    private void removeUsersInGroup(String string, Node node, AMStoreConnection aMStoreConnection) throws AdminException {
        GroupDeleteUserReq groupDeleteUserReq = new GroupDeleteUserReq(string);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                groupDeleteUserReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(groupDeleteUserReq.toString());
            }
            groupDeleteUserReq.process(aMStoreConnection);
        }
    }

    private void getUsersInGroup(String string, Node node, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        GroupGetUserReq groupGetUserReq = null;
        groupGetUserReq = n == 11 ? new DynamicGroupGetUserReq(string) : (n == 12 ? new AssignableDynamicGroupGetUserReq(string) : new GroupGetUserReq(string));
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        groupGetUserReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                groupGetUserReq.addUserDNs((String)iterator.next());
            }
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(groupGetUserReq.toString());
        }
        groupGetUserReq.process(aMStoreConnection);
    }

    private void getNestedGroupsInGroup(String string, Node node, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        GroupGetNestedGroupReq groupGetNestedGroupReq = null;
        switch (n) {
            case 11: {
                groupGetNestedGroupReq = new DynamicGroupGetNestedGroupReq(string);
                break;
            }
            case 12: {
                groupGetNestedGroupReq = new AssignableDynamicGroupGetNestedGroupReq(string);
                break;
            }
            default: {
                groupGetNestedGroupReq = new GroupGetNestedGroupReq(string);
            }
        }
        String string2 = ((Element)node).getAttribute("DNsOnly");
        boolean bl = Boolean.valueOf(string2);
        groupGetNestedGroupReq.setDNsOnly(bl);
        Set set = this.getSubNodeElementNodeValues(node.getChildNodes());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            groupGetNestedGroupReq.addNestedGroupDNs((String)iterator.next());
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(groupGetNestedGroupReq.toString());
        }
        groupGetNestedGroupReq.process(aMStoreConnection);
    }

    private void addUsersToGroup(String string, Node node, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        GroupAddUserReq groupAddUserReq = null;
        if (n == 11) {
            throw new UnsupportedOperationException(bundle.getString("cannotAddUsersToDynamicGroup"));
        }
        groupAddUserReq = n == 12 ? new AssignableDynamicGroupAddUserReq(string) : new GroupAddUserReq(string);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                groupAddUserReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(groupAddUserReq.toString());
            }
            groupAddUserReq.process(aMStoreConnection);
        }
    }

    private void addNestedGroupsToGroup(String string, Node node, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        GroupAddNestedGroupReq groupAddNestedGroupReq = null;
        switch (n) {
            case 12: {
                groupAddNestedGroupReq = new AssignableDynamicGroupAddNestedGroupReq(string);
                break;
            }
            case 9: 
            case 10: {
                groupAddNestedGroupReq = new GroupAddNestedGroupReq(string);
                break;
            }
            case 11: {
                groupAddNestedGroupReq = new DynamicGroupAddNestedGroupReq(string);
            }
        }
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                groupAddNestedGroupReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(groupAddNestedGroupReq.toString());
            }
            groupAddNestedGroupReq.process(aMStoreConnection);
        }
    }

    private void removeNestedGroupsFromGroup(String string, Node node, AMStoreConnection aMStoreConnection, int n) throws AdminException {
        GroupRemoveNestedGroupReq groupRemoveNestedGroupReq = new GroupRemoveNestedGroupReq(string);
        Set set = this.getSubNodeElementNodeDNValues(node.getChildNodes());
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                groupRemoveNestedGroupReq.addDNSet((String)iterator.next());
            }
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(groupRemoveNestedGroupReq.toString());
            }
            groupRemoveNestedGroupReq.process(aMStoreConnection);
        }
    }

    private PolicyManager getPolicyManager(SSOToken sSOToken, String string, String string2) throws AdminException {
        try {
            return new PolicyManager(sSOToken, string);
        }
        catch (SSOException sSOException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg30"), sSOException);
            }
            throw new AdminException(bundle.getString(string2) + "\n\n" + sSOException.getLocalizedMessage());
        }
        catch (PolicyException policyException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg31"), policyException);
            }
            throw new AdminException(bundle.getString(string2) + "\n\n" + policyException.getLocalizedMessage());
        }
    }

    private void doCreatePolicy(AMStoreConnection aMStoreConnection, Node node, SSOToken sSOToken) throws AdminException {
        String string = ((Element)node).getAttribute("createDN");
        try {
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string);
            if (AdminInterfaceUtils.inOrganizationalUnit((Debug)this.debug, (AMStoreConnection)aMStoreConnection, (AMObject)aMOrganization)) {
                throw new AdminException(bundle.getString("cannotCreatePolicyUnderContainer"));
            }
            PolicyManager policyManager = this.getPolicyManager(sSOToken, string, "policycreatexception");
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1) {
                    this.addPolicy(string, policyManager, node2);
                }
                ++n2;
            }
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }

    private void addPolicy(String string, PolicyManager policyManager, Node node) throws AdminException {
        try {
            policyManager.addPolicy(new Policy(policyManager, node));
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg32"));
                AdminUtils.log(string);
            }
        }
        catch (SSOException sSOException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg30"), sSOException);
            }
            throw new AdminException(bundle.getString("policycreatexception") + "\n\n" + sSOException.getLocalizedMessage());
        }
        catch (PolicyException policyException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg31"), policyException);
            }
            throw new AdminException(bundle.getString("policycreatexception") + "\n\n" + policyException.getLocalizedMessage());
        }
    }

    private void doListAccts(Node node) {
        FedServicesRequestHandler fedServicesRequestHandler = null;
        try {
            fedServicesRequestHandler = new FedServicesRequestHandler();
            fedServicesRequestHandler.ListAccts(node);
            if (fedServicesRequestHandler.errorMessage != null) {
                System.out.println(bundle.getString(fedServicesRequestHandler.errorMessage));
            }
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            System.out.println(bundle.getString(fedServicesRequestHandler.errorMessage));
            this.debug.error("AdminXMLParser::Error in account manager:" + fSAccountMgmtException.getMessage());
        }
        if (AdminUtils.logEnabled()) {
            AdminUtils.log("AdminXMLParser:: Listed accounts");
        }
    }

    public void processLibertyMetaData(String string, SSOToken sSOToken, String string2, String string3) throws AdminException {
        String string4 = "com/iplanet/am/admin/cli/transformMetaData.xsl";
        String string5 = "provType";
        String string6 = "defaultUrlPrefix";
        String string7 = "remote";
        String string8 = "hosted";
        FedServicesRequestHandler fedServicesRequestHandler = null;
        try {
            Node node;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMResult dOMResult = new DOMResult();
            StreamResult streamResult = new StreamResult(System.out);
            Document document = documentBuilder.parse(string);
            JarFile jarFile = new JarFile("am_services.jar");
            InputStream inputStream = jarFile.getInputStream(jarFile.getEntry(string4));
            StreamSource streamSource = new StreamSource(inputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            DOMSource dOMSource = new DOMSource(document);
            transformer.setParameter(string5, string2);
            String string9 = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
            fedServicesRequestHandler = new FedServicesRequestHandler(string9, sSOToken);
            if (string2.equalsIgnoreCase(string7)) {
                transformer.transform(dOMSource, dOMResult);
                node = dOMResult.getNode().getFirstChild();
                fedServicesRequestHandler.createRemoteProvider(node);
            }
            if (string2.equalsIgnoreCase(string8)) {
                transformer.setParameter(string6, string3);
                transformer.transform(dOMSource, dOMResult);
                node = dOMResult.getNode().getFirstChild();
                fedServicesRequestHandler.createHostedProvider(node);
            }
        }
        catch (TransformerException transformerException) {
            System.err.println(bundle.getString("failedToProcessXML") + " " + string + "\n" + transformerException.getMessage());
            System.exit(1);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            System.out.println(fSAllianceManagementException.getMessage());
            this.debug.error("AdminXMLParser::Error in alliance manager:" + fSAllianceManagementException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(bundle.getString("failedToProcessXML") + " " + string + "\n");
            System.exit(1);
        }
    }

    private void doDeletePolicy(Node node, SSOToken sSOToken) throws AdminException {
        String string = ((Element)node).getAttribute("deleteDN");
        PolicyManager policyManager = this.getPolicyManager(sSOToken, string, "policydeletexception");
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            if (node2.getNodeType() == 1) {
                String string2 = ((Element)node2).getAttribute("name");
                this.deletePolicy(string, string2, policyManager);
            }
            ++n2;
        }
    }

    private void deletePolicy(String string, String string2, PolicyManager policyManager) throws AdminException {
        try {
            policyManager.removePolicy(string2);
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg33"));
                AdminUtils.log(bundle.getString("policy") + string2);
                AdminUtils.log(bundle.getString("organization") + string);
            }
        }
        catch (SSOException sSOException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg30"), sSOException);
            }
            throw new AdminException(bundle.getString("policydeletexception") + "\n\n" + sSOException.getLocalizedMessage());
        }
        catch (PolicyException policyException) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(bundle.getString("statusmsg31"), policyException);
            }
            throw new AdminException(bundle.getString("policydeletexception") + "\n\n" + policyException.getLocalizedMessage() + "\n");
        }
    }

    private String validateLevel(Node node) {
        String string = ((Element)node).getAttribute("level");
        if (!string.equals("SCOPE_SUB") && !string.equals("SCOPE_ONE")) {
            System.err.println("\n" + bundle.getString("parseerr") + this.fileName + "\n" + bundle.getString("levelerr"));
            System.exit(1);
        }
        return string;
    }

    private int validateObjectType(AMStoreConnection aMStoreConnection, String string, int n) throws AdminException {
        try {
            int n2 = aMStoreConnection.getAMObjectType(string);
            if (!this.equalsObjectType(n2, n)) {
                String string2 = "";
                switch (n) {
                    case 6: {
                        string2 = "invalidRoleDN";
                        break;
                    }
                    case 9: {
                        string2 = "invalidStaticGroupDN";
                        break;
                    }
                    case 2: {
                        string2 = "invalidOrgDN";
                        break;
                    }
                    case 1: {
                        string2 = "invalidUserDN";
                        break;
                    }
                    case 5: {
                        string2 = "invalidPeopleContainerDN";
                        break;
                    }
                    case 3: {
                        string2 = "invalidOrgUnitDN";
                    }
                }
                String string3 = bundle.getString(string2) + " " + string;
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log(string3);
                }
                throw new AdminException(string3);
            }
            return n2;
        }
        catch (Exception exception) {
            String string4 = bundle.getString("failToGetObjType") + " " + string;
            if (AdminUtils.logEnabled()) {
                AdminUtils.log(string4, exception);
            }
            throw new AdminException(string4);
        }
    }

    private boolean equalsObjectType(int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 6: {
                bl = n == 6 || n == 8;
                break;
            }
            case 9: {
                bl = n == 9 || n == 11 || n == 12;
                break;
            }
            default: {
                bl = n == n2;
            }
        }
        return bl;
    }

    static {
        requestTypes.put("CreateSubOrganization", new Integer(0));
        requestTypes.put("CreatePeopleContainer", new Integer(1));
        requestTypes.put("CreateGroupContainer", new Integer(84));
        requestTypes.put("CreateGroup", new Integer(2));
        requestTypes.put("CreateRole", new Integer(3));
        requestTypes.put("GetSubOrganizations", new Integer(4));
        requestTypes.put("GetPeopleContainers", new Integer(5));
        requestTypes.put("GetGroups", new Integer(6));
        requestTypes.put("GetRoles", new Integer(7));
        requestTypes.put("GetUsers", new Integer(8));
        requestTypes.put("DeleteSubOrganizations", new Integer(9));
        requestTypes.put("DeletePeopleContainers", new Integer(10));
        requestTypes.put("DeleteGroups", new Integer(11));
        requestTypes.put("DeleteRoles", new Integer(12));
        requestTypes.put("CreateSubPeopleContainer", new Integer(13));
        requestTypes.put("CreateUser", new Integer(14));
        requestTypes.put("ModifyUser", new Integer(49));
        requestTypes.put("DeleteSubPeopleContainers", new Integer(15));
        requestTypes.put("DeleteUsers", new Integer(16));
        requestTypes.put("RemoveUsers", new Integer(85));
        requestTypes.put("GetNumberOfUsers", new Integer(17));
        requestTypes.put("GetSubPeopleContainers", new Integer(18));
        requestTypes.put("AddUsers", new Integer(19));
        requestTypes.put("CreateSubGroup", new Integer(20));
        requestTypes.put("ModifySubGroups", new Integer(50));
        requestTypes.put("RemoveDefaultValues", new Integer(51));
        requestTypes.put("RemovePartialDefaultValues", new Integer(89));
        requestTypes.put("ModifyDefaultValues", new Integer(52));
        requestTypes.put("AddDefaultValues", new Integer(53));
        requestTypes.put("ModifyType", new Integer(73));
        requestTypes.put("AddPropertiesViewBean", new Integer(77));
        requestTypes.put("AddStartRange", new Integer(78));
        requestTypes.put("AddEndRange", new Integer(79));
        requestTypes.put("ModifyUIType", new Integer(74));
        requestTypes.put("ModifySyntax", new Integer(76));
        requestTypes.put("Modifyi18nKey", new Integer(75));
        requestTypes.put("AddSubSchema", new Integer(80));
        requestTypes.put("AddAttributeSchema", new Integer(81));
        requestTypes.put("RemoveSubSchema", new Integer(82));
        requestTypes.put("RemoveAttributeSchema", new Integer(83));
        requestTypes.put("AddChoiceValues", new Integer(58));
        requestTypes.put("RemoveChoiceValues", new Integer(59));
        requestTypes.put("DeleteSubGroups", new Integer(21));
        requestTypes.put("GetSubGroups", new Integer(22));
        requestTypes.put("RegisterServices", new Integer(23));
        requestTypes.put("UnregisterServices", new Integer(24));
        requestTypes.put("GetRegisteredServiceNames", new Integer(27));
        requestTypes.put("GetNumberOfServices", new Integer(29));
        requestTypes.put("CreateSubContainer", new Integer(30));
        requestTypes.put("ModifySubContainer", new Integer(45));
        requestTypes.put("GetSubContainers", new Integer(31));
        requestTypes.put("DeleteSubContainers", new Integer(32));
        requestTypes.put("CreatePolicy", new Integer(33));
        requestTypes.put("DeletePolicy", new Integer(34));
        requestTypes.put("ModifySubOrganization", new Integer(35));
        requestTypes.put("ModifyPeopleContainer", new Integer(36));
        requestTypes.put("ModifyRole", new Integer(37));
        requestTypes.put("CreateServiceTemplate", new Integer(38));
        requestTypes.put("CreateRoleSTemplate", new Integer(42));
        requestTypes.put("GetServiceTemplate", new Integer(86));
        requestTypes.put("ModifyServiceTemplate", new Integer(39));
        requestTypes.put("AddServiceTemplateAttributeValues", new Integer(88));
        requestTypes.put("RemoveServiceTemplateAttributeValues", new Integer(87));
        requestTypes.put("DeleteServiceTemplate", new Integer(54));
        requestTypes.put("GetServiceDefaultValues", new Integer(55));
        requestTypes.put("AddSubConfiguration", new Integer(56));
        requestTypes.put("DeleteSubConfiguration", new Integer(57));
        requestTypes.put("DeleteAllServiceConfiguration", new Integer(71));
        requestTypes.put("ModifyPCSTemplate", new Integer(43));
        requestTypes.put("ModifyRoleSTemplate", new Integer(44));
        requestTypes.put("CreateContainer", new Integer(72));
        requestTypes.put("CreateAgent", new Integer(90));
        requestTypes.put("DeleteAgents", new Integer(91));
        requestTypes.put("ModifyAgent", new Integer(92));
        requestTypes.put("GetAgents", new Integer(93));
        requestTypes.put("AddNestedGroups", new Integer(94));
        requestTypes.put("RemoveNestedGroups", new Integer(95));
        requestTypes.put("GetNestedGroups", new Integer(96));
        requestTypes.put("GetNumberOfNestedGroups", new Integer(97));
        requestTypes.put("SetPropertiesViewBeanURL", new Integer(98));
        requestTypes.put("CreateRemoteProvider", new Integer(60));
        requestTypes.put("DeleteProvider", new Integer(61));
        requestTypes.put("CreateAuthenticationDomain", new Integer(62));
        requestTypes.put("ModifyAuthenticationDomain", new Integer(63));
        requestTypes.put("DeleteAuthenticationDomain", new Integer(64));
        requestTypes.put("GetAuthenticationDomain", new Integer(65));
        requestTypes.put("GetProvider", new Integer(66));
        requestTypes.put("ModifyRemoteProvider", new Integer(67));
        requestTypes.put("ModifyHostedProvider", new Integer(68));
        requestTypes.put("CreateHostedProvider", new Integer(69));
        requestTypes.put("ListAccts", new Integer(70));
    }

    class ValidationErrorHandler
    implements ErrorHandler {
        ValidationErrorHandler() {
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            System.err.println(bundle.getString("fatalvaliderr") + AdminXMLParser.this.fileName + "\n" + sAXParseException.getMessage() + "\nLine Number in XML file : " + sAXParseException.getLineNumber() + "\nColumn Number in XML file : " + sAXParseException.getColumnNumber());
            this.printValidationMessages(sAXParseException, "Fatal, XML Validation Error - XML file is not a valid file." + AdminXMLParser.this.fileName);
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            System.err.println(bundle.getString("nonfatalvaliderr") + AdminXMLParser.this.fileName + "\n" + sAXParseException.getMessage() + "\nLine Number in XML file : " + sAXParseException.getLineNumber() + "\nColumn Number in XML file : " + sAXParseException.getColumnNumber());
            this.printValidationMessages(sAXParseException, "Non-Fatal, XML Validation Error - XML file is not a valid file." + AdminXMLParser.this.fileName);
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            System.err.println(bundle.getString("validwarn") + AdminXMLParser.this.fileName + "\n" + sAXParseException.getMessage() + "\nLine Number in XML file : " + sAXParseException.getLineNumber() + "\nColumn Number in XML file : " + sAXParseException.getColumnNumber());
            this.printValidationMessages(sAXParseException, "XML file Validation Warnings." + AdminXMLParser.this.fileName);
        }

        void printValidationMessages(SAXParseException sAXParseException, String string) {
            if (AdminUtils.logEnabled()) {
                AdminUtils.log("Error is : " + string, sAXParseException);
                AdminUtils.log("Detailed Message is : " + sAXParseException.getMessage(), null);
                AdminUtils.log("Line Number : " + sAXParseException.getLineNumber(), null);
                AdminUtils.log("Column Number : " + sAXParseException.getColumnNumber(), null);
            }
        }
    }
}

