/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMUserServiceSelectModel;
import com.iplanet.am.console.user.model.UMUserViewModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.sso.SSOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMUserServiceSelectModelImpl
extends UMUserViewModelImpl
implements UMUserServiceSelectModel {
    private boolean servicesModified = false;

    public UMUserServiceSelectModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.getAssignedServices();
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("services.header");
    }

    public void updateServices(Set set) throws AMConsoleException {
        if (this.curUser == null || !this.isAdministrator()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (set != null && !set.isEmpty()) {
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("removing " + set + " from user services");
            }
            try {
                this.curUser.unassignServices(set);
                this.servicesModified = true;
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append(this.getLocalizedString("removedServicesFromUser.message")).append(" " + this.curUser.getDN()).append(":" + set);
                this.logger.doLog(stringBuffer.toString());
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("unassigning services from user", (Throwable)aMException);
                arrayList.add(this.getErrorString((Exception)((Object)aMException)));
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("unassigning services from user", (Throwable)sSOException);
                arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
            }
        }
        if (!arrayList.isEmpty()) {
            throw new AMConsoleException(arrayList);
        }
    }

    public String getSuccessMessage() {
        if (this.servicesModified) {
            return this.getLocalizedString("updateUser.message");
        }
        return this.getLocalizedString("noChangesMade.message");
    }

    public String getAddBtnLabel() {
        return this.getLocalizedString("add.button");
    }

    public String getRemoveBtnLabel() {
        return this.getLocalizedString("remove.button");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userServices.help");
        if (string.equals("userServices.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getServiceNotSelectedMessage() {
        return this.getLocalizedString("serviceNotSelected.message");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("serviceNotSelected.title");
    }
}

