/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMSelectionModelImpl;
import com.iplanet.am.console.user.model.UMUserSelectionModel;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class UMUserSelectionModelImpl
extends UMSelectionModelImpl
implements UMUserSelectionModel {
    private String errorMessage = null;
    private Map localizedAttrNames = null;

    public UMUserSelectionModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public void setResultsMap(Map map) {
        this.resultsMap = map == null ? new HashMap(0) : map;
    }

    public List getSearchReturnAttributes() {
        String string;
        block12: {
            if (this.searchReturnAttrs != null) {
                return this.searchReturnAttrs;
            }
            string = null;
            try {
                switch (this.locationType) {
                    case 2: {
                        string = this.getSearchReturnAttribute(this.locationDN);
                        break;
                    }
                    case 3: {
                        string = this.getSearchReturnAttribute(this.locationDN);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        AMGroup aMGroup = (AMGroup)this.getAMObject(this.locationDN);
                        string = this.getSearchReturnAttribute(aMGroup.getOrganizationDN());
                        break;
                    }
                    case 6: {
                        AMRole aMRole = this.dpStoreConn.getRole(this.locationDN);
                        string = this.getSearchReturnAttribute(aMRole.getOrganizationDN());
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMUserSelectionModelImpl.getSearchReturnAttributes invalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("UMUserSelectionModelImpl.getSearchReturnAttributes", (Throwable)sSOException);
                }
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) break block12;
                AMModelBase.debug.warning("UMUserSelectionModelImpl.getSearchReturnAttributes", (Throwable)aMException);
            }
        }
        this.searchReturnAttrs = this.getValidatedAttributes(string);
        return this.searchReturnAttrs;
    }

    public void setSearchReturnAttributes(String string) {
        this.searchReturnAttrs = this.getValidatedAttributes(string);
    }

    public String getAttributeValue(String string) {
        this.getSearchReturnAttributes();
        if (this.searchReturnAttrs.isEmpty()) {
            return AMFormatUtils.DNToName(this, string);
        }
        int n = this.searchReturnAttrs.size();
        return this.getAttributeValue(string, (String)this.searchReturnAttrs.get(n - 1));
    }

    public String getAttributeValue(String string, String string2) {
        if (this.resultsMap == null) {
            return AMFormatUtils.DNToName(this, string);
        }
        Map map = (Map)this.resultsMap.get(string);
        if (map == null) {
            return AMFormatUtils.DNToName(this, string);
        }
        Set set = (Set)map.get(string2);
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(25);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(this.getLocalizedString("multiValuedAttrSeparator") + " ");
            }
            stringBuffer.append((String)iterator.next());
        }
        return stringBuffer.toString();
    }

    public String getAttributeLocalizedName(String string) {
        String string2;
        if (this.localizedAttrNames == null) {
            this.localizedAttrNames = this.getLocalizedAttributes();
        }
        if ((string2 = (String)this.localizedAttrNames.get(string)) == null) {
            string2 = string;
        }
        return string2;
    }

    public String getAttributeLocalizedName() {
        this.getSearchReturnAttributes();
        if (this.searchReturnAttrs.isEmpty()) {
            return this.getAttributeLocalizedName(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
        }
        int n = this.searchReturnAttrs.size();
        return this.getAttributeLocalizedName((String)this.searchReturnAttrs.get(n - 1));
    }

    public boolean addUsers(String string, Set set) {
        if (string == null || string.length() == 0 || set == null || set.isEmpty()) {
            return true;
        }
        boolean bl = true;
        try {
            int n = this.getObjectType(string);
            switch (n) {
                case 9: 
                case 10: {
                    AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(string);
                    aMStaticGroup.addUsers(set);
                    this.writeLog("addedUsersToGroup.message", aMStaticGroup.getDN(), set);
                    break;
                }
                case 12: {
                    AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(string);
                    aMAssignableDynamicGroup.addUsers(set);
                    this.writeLog("addedUsersToGroup.message", aMAssignableDynamicGroup.getDN(), set);
                    break;
                }
                case 6: 
                case 7: {
                    AMRole aMRole = this.dpStoreConn.getRole(string);
                    aMRole.addUsers(set);
                    this.writeLog("addedUsersToRole.message", aMRole.getDN(), set);
                    break;
                }
                default: {
                    if (AMModelBase.debug.messageEnabled()) {
                        AMModelBase.debug.message("UMUserSelectionModelImpl:addUsers invalid container " + string);
                    }
                    break;
                }
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserSelectionModelImpl.addUsers", (Throwable)aMException);
            this.errorMessage = this.getErrorString((Exception)((Object)aMException));
            bl = false;
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("Error in SSO Token", (Throwable)sSOException);
            this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
            bl = false;
        }
        return bl;
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            this.errorMessage = "";
        }
        return this.errorMessage;
    }

    public String getErrorTitle() {
        return this.getLocalizedString("modifyMembershipFailed.title");
    }

    public String getPageTitle() {
        return this.getLocalizedString("userSelection.title");
    }

    public String getAvailableColumnLabel() {
        return this.getLocalizedString("availableUsers.title");
    }

    public String getDisplayName(String string) {
        if (string == null || string.length() == 0 || !DN.isDN((String)string)) {
            return string;
        }
        String string2 = string;
        if (this.showPeopleContainers()) {
            string2 = this.convertDNToDisplayName(string, (String)this.resultsMap.get(string));
        } else {
            DN dN = null;
            try {
                AMUser aMUser = this.dpStoreConn.getUser(string);
                dN = new DN(aMUser.getOrganizationDN());
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMUserSelectionModelImpl::getDisplayName", (Throwable)aMException);
                return string2;
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMUserSelectionModelImpl::getDisplayName", (Throwable)sSOException);
                return string2;
            }
            dN.addRDN(new RDN(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug) + "=" + AMFormatUtils.DNToName(this, string, false)));
            string2 = this.convertDNToDisplayName(dN.toString(), (String)this.resultsMap.get(string));
        }
        return string2;
    }

    private String getSearchReturnAttribute(String string) {
        String string2 = null;
        AMTemplate aMTemplate = this.getOrgTemplate(string);
        try {
            if (aMTemplate != null) {
                string2 = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-return-attribute");
            } else {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string2 = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-return-attribute");
                }
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserSelectionModelImpl.getSearchReturnAttribute", (Throwable)aMException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMUserSelectionModelImpl.getSearchReturnAttribute", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserSelectionModelImpl.getSearchReturnAttribute", (Throwable)sSOException);
        }
        return string2;
    }

    private List getValidatedAttributes(String string) {
        ArrayList<String> arrayList = null;
        if (string == null || string.length() == 0) {
            arrayList = new ArrayList<String>(1);
            arrayList.add(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        arrayList = new ArrayList(stringTokenizer.countTokens());
        Set set = this.getUserAttributeNames();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if (!set.contains(string2) || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
        }
        return arrayList;
    }

    private Map getLocalizedAttributes() {
        Set set = null;
        ServiceSchemaManager serviceSchemaManager = null;
        ServiceSchema serviceSchema = null;
        try {
            serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMUserService");
            if (serviceSchemaManager != null) {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
                set = serviceSchema.getAttributeSchemaNames();
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMUserSelectionModelImpl:getUserAttributeNames", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserSelectionModelImpl.getUserAttributeNames", (Throwable)sSOException);
        }
        if (set == null) {
            return new HashMap(0);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string2);
            if (attributeSchema == null || (string = attributeSchema.getI18NKey()) == null || string.length() == 0) continue;
            hashMap.put(string2, this.getL10NAttributeName(serviceSchemaManager, string));
        }
        return hashMap;
    }

    private String convertDNToDisplayName(String string, String string2) {
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)true);
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer(50);
        int n2 = n - 1;
        while (n2 >= 0) {
            if (n2 == 0) {
                if (string2 != null && string2.length() != 0) {
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append(stringArray[0]);
                }
            } else {
                stringBuffer.append(stringArray[n2]).append("&nbsp;").append("&gt;").append("&nbsp;");
            }
            --n2;
        }
        return stringBuffer.toString();
    }

    private void writeLog(String string, String string2, Set set) {
        if (this.logger.isEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(this.getLocalizedString(string)).append(" " + string2).append(":" + set);
            this.logger.doLog(stringBuffer.toString());
        }
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userSelection.help");
        if (string.equals("userSelection.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getShowParentagePathButtonLabel() {
        return this.getLocalizedString("showParentagePath.button");
    }

    public String getHideParentagePathButtonLabel() {
        return this.getLocalizedString("hideParentagePath.button");
    }

    public String getParentagePathLabel() {
        return this.getLocalizedString("parentagePath.label");
    }

    public String getSelectUsersMessage() {
        return this.getLocalizedString("selectUsers.message");
    }
}

