/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMAttributeDisplayImpl;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.user.model.UMSearchModelImpl;
import com.iplanet.am.console.user.model.UMUserSearchModel;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class UMUserSearchModelImpl
extends UMSearchModelImpl
implements UMUserSearchModel {
    private static final String LOGICAL_OR = "OR";
    private static final String LOGICAL_AND = "AND";
    private int searchType = 0;
    private Map resultsMap = null;
    private ServiceSchemaManager userSvcMgr = null;

    public UMUserSearchModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.setServiceName("iPlanetAMUserService");
    }

    public int getSize() {
        return this.getFilterAttributeNames().size();
    }

    public int getNumberOfAttributes() {
        return this.getFilterAttributeNames().size();
    }

    private ServiceSchemaManager getUserServiceSchemaManager() {
        block3: {
            if (this.userSvcMgr != null) break block3;
            try {
                this.userSvcMgr = this.getServiceSchemaManager("iPlanetAMUserService");
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMUserSearchModelImpl.getUserServiceSchemaManager", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMUserSearchModelImpl.getUserServiceSchemaManager", (Throwable)sMSException);
            }
        }
        return this.userSvcMgr;
    }

    public void createComponentList() {
        this.componentList.clear();
        ServiceSchemaManager serviceSchemaManager = this.getUserServiceSchemaManager();
        if (serviceSchemaManager == null) {
            return;
        }
        ServiceSchema serviceSchema = null;
        try {
            serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
        }
        catch (SMSException sMSException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("UMUserSearchModelImpl.createComponentList: unable to get user schema", (Throwable)sMSException);
            }
            return;
        }
        List list = this.getFilterAttributeNames();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DynamicGUI dynamicGUI;
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema((String)iterator.next());
            if (attributeSchema == null || (dynamicGUI = this.createDynamicGUIComponent(attributeSchema, Collections.EMPTY_SET)) == null) continue;
            this.componentList.add(dynamicGUI);
        }
    }

    public Set searchUsers(String string, Map map) {
        return this.searchUsers(string, "2", map);
    }

    public Set searchUsers(String string, String string2, Map map) {
        Set set = Collections.EMPTY_SET;
        if (this.isUserServiceDenied()) {
            this.errorMessage = this.getLocalizedString("userServiceDenied.message");
            return set;
        }
        int n = 1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.warning("using default value of one for scope level");
        }
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setSearchScope(n);
        this.setSearchControlAttributes(aMSearchControl, map);
        AMSearchResults aMSearchResults = null;
        try {
            if (this.searchType == 1) {
                aMSearchResults = this.searchUsersForMembership(string, map, aMSearchControl);
            } else if (this.searchType == 2) {
                aMSearchResults = this.searchUsersForInitialization(string, map, aMSearchControl);
            } else if (this.searchType == 0) {
                aMSearchResults = this.searchUsers(string, map, aMSearchControl);
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserSearchModelImpl.searchUsers", (Throwable)aMException);
            this.errorMessage = this.getErrorString((Exception)((Object)aMException));
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserSearchModelImpl.searchUsers", (Throwable)sSOException);
            this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
        }
        if (aMSearchResults != null) {
            set = aMSearchResults.getSearchResults();
            this.resultsMap = aMSearchResults.getResultAttributes();
            this.errorCode = aMSearchResults.getErrorCode();
            this.errorMessage = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
        }
        return set;
    }

    public Map getResultsMap() {
        if (this.resultsMap == null) {
            this.resultsMap = new HashMap(0);
        }
        return this.resultsMap;
    }

    public String getLogicalOperatorLabel() {
        return this.getLocalizedString("operator.label");
    }

    public String getLogicalOrOpLabel() {
        return this.getLocalizedString("logicalOR.label");
    }

    public String getLogicalOrOpValue() {
        return LOGICAL_OR;
    }

    public String getOpTextLabel() {
        return this.getLocalizedString("operatorText.label");
    }

    public String getLogicalAndOpLabel() {
        return this.getLocalizedString("logicalAND.label");
    }

    public String getLogicalAndOpValue() {
        return LOGICAL_AND;
    }

    public void setSearchType(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.searchType = n;
        }
    }

    public int getSearchType() {
        return this.searchType;
    }

    public String getUserSearchReturnLabel() {
        return this.getLocalizedString("userSearchReturn.label");
    }

    public String getUserSearchReturnValue() {
        String string = null;
        try {
            int n = this.getObjectType(this.locationDN);
            switch (n) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    string = this.getUserSearchReturnAttribute((AMObject)aMOrganization);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    string = this.getUserSearchReturnAttribute((AMObject)aMOrganizationalUnit);
                    break;
                }
                case 6: 
                case 7: {
                    AMRole aMRole = this.dpStoreConn.getRole(this.locationDN);
                    string = this.getUserSearchReturnAttribute((AMObject)this.dpStoreConn.getOrganization(aMRole.getOrganizationDN()));
                    break;
                }
                case 8: {
                    AMFilteredRole aMFilteredRole = this.dpStoreConn.getFilteredRole(this.locationDN);
                    string = this.getUserSearchReturnAttribute((AMObject)this.dpStoreConn.getOrganization(aMFilteredRole.getOrganizationDN()));
                    break;
                }
                case 9: 
                case 10: {
                    AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(this.locationDN);
                    string = this.getUserSearchReturnAttribute((AMObject)this.dpStoreConn.getOrganization(aMStaticGroup.getOrganizationDN()));
                    break;
                }
                case 11: {
                    AMDynamicGroup aMDynamicGroup = this.dpStoreConn.getDynamicGroup(this.locationDN);
                    string = this.getUserSearchReturnAttribute((AMObject)this.dpStoreConn.getOrganization(aMDynamicGroup.getOrganizationDN()));
                    break;
                }
                case 12: {
                    AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(this.locationDN);
                    string = this.getUserSearchReturnAttribute((AMObject)this.dpStoreConn.getOrganization(aMAssignableDynamicGroup.getOrganizationDN()));
                    break;
                }
                case 5: {
                    AMPeopleContainer aMPeopleContainer = this.dpStoreConn.getPeopleContainer(this.locationDN);
                    string = this.getUserSearchReturnAttribute((AMObject)this.dpStoreConn.getOrganization(aMPeopleContainer.getOrganizationDN()));
                    break;
                }
                default: {
                    if (AMModelBase.debug.messageEnabled()) {
                        AMModelBase.debug.message("getUserSearchReturnAttribute invalid search location " + this.locationDN);
                    }
                    break;
                }
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserSearchModelImpl:getUserSearchReturnAttribute", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMUserSearchModelImpl:getUserSearchReturnAttribute", (Throwable)sSOException);
        }
        if (string == null || string.length() == 0) {
            string = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
        }
        return string;
    }

    public String getSearchFailedTitle() {
        return this.getLocalizedString("searchFailed.title");
    }

    public boolean isUserServiceDenied() {
        return this.isServiceDenied("iPlanetAMUserService");
    }

    public String getNoServiceAccessMessage() {
        return this.getLocalizedString("userServiceDenied.message");
    }

    public String getNoAttributeAccessMessage() {
        return this.getLocalizedString("noSearchAttributes.message");
    }

    public String getNoMatchMsg() {
        return this.getLocalizedString("noMatchingEntries.message");
    }

    public boolean isTimeSizeLimit() {
        return this.errorCode == 1 || this.errorCode == 2;
    }

    public String getWarningTitle() {
        return this.getLocalizedString("warningMessage.title");
    }

    private AMSearchResults searchUsers(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        AMSearchResults aMSearchResults = null;
        AMPeopleContainer aMPeopleContainer = null;
        int n = aMSearchControl.getSearchScope();
        int n2 = this.getObjectType(this.searchLocationDN);
        switch (n2) {
            case 2: {
                if (n == 1) {
                    aMPeopleContainer = this.getDefaultPeopleContainer();
                }
                if (aMPeopleContainer != null) {
                    aMSearchResults = this.searchUsers(aMPeopleContainer, this.createFilter(string, map), aMSearchControl);
                    break;
                }
                AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.searchLocationDN);
                aMSearchResults = this.searchUsers(aMOrganization, this.createFilter(string, map), aMSearchControl);
                break;
            }
            case 3: {
                if (n == 1) {
                    aMPeopleContainer = this.getDefaultPeopleContainer();
                }
                if (aMPeopleContainer != null) {
                    aMSearchResults = this.searchUsers(aMPeopleContainer, this.createFilter(string, map), aMSearchControl);
                    break;
                }
                AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.searchLocationDN);
                aMSearchResults = this.searchUsers(aMOrganizationalUnit, this.createFilter(string, map), aMSearchControl);
                break;
            }
            case 5: {
                AMPeopleContainer aMPeopleContainer2 = this.dpStoreConn.getPeopleContainer(this.searchLocationDN);
                aMSearchResults = this.searchUsers(aMPeopleContainer2, this.createFilter(string, map), aMSearchControl);
                break;
            }
            case 6: 
            case 7: {
                AMRole aMRole = this.dpStoreConn.getRole(this.searchLocationDN);
                aMSearchResults = this.searchUsers(aMRole, this.createFilter(string, map), aMSearchControl);
                break;
            }
            case 8: {
                AMFilteredRole aMFilteredRole = this.dpStoreConn.getFilteredRole(this.searchLocationDN);
                aMSearchResults = this.searchUsers((AMRole)aMFilteredRole, this.createFilter(string, map), aMSearchControl);
                break;
            }
            case 9: 
            case 10: {
                AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(this.searchLocationDN);
                aMSearchResults = this.searchUsers((AMGroup)aMStaticGroup, this.createFilter(string, map), aMSearchControl);
                break;
            }
            case 12: {
                AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(this.searchLocationDN);
                aMSearchResults = this.searchUsers((AMGroup)aMAssignableDynamicGroup, this.createFilter(string, map), aMSearchControl);
                break;
            }
            case 11: {
                AMDynamicGroup aMDynamicGroup = this.dpStoreConn.getDynamicGroup(this.searchLocationDN);
                aMSearchResults = this.searchUsers((AMGroup)aMDynamicGroup, this.createFilter(string, map), aMSearchControl);
                break;
            }
            default: {
                if (!AMModelBase.debug.messageEnabled()) break;
                AMModelBase.debug.message("UMUserSearchModelImpl.searchUsers invalid location " + this.searchLocationDN);
            }
        }
        return aMSearchResults;
    }

    private AMSearchResults searchUsersForMembership(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        AMSearchResults aMSearchResults = null;
        String string2 = this.createFilter(string, map);
        int n = this.getObjectType(this.searchLocationDN);
        switch (n) {
            case 6: 
            case 7: {
                String string3 = "(&" + string2 + "(!(nsroledn=" + this.searchLocationDN + ")))";
                AMRole aMRole = this.dpStoreConn.getRole(this.searchLocationDN);
                AMObject aMObject = this.getParentOrganization((AMObject)aMRole);
                if (aMObject instanceof AMOrganization) {
                    aMSearchResults = this.searchUsers((AMOrganization)aMObject, string3, aMSearchControl);
                    break;
                }
                aMSearchResults = this.searchUsers((AMOrganizationalUnit)aMObject, string3, aMSearchControl);
                break;
            }
            case 9: 
            case 10: {
                String string4 = "(&" + string2 + "(!(iplanet-am-static-group-dn=" + this.searchLocationDN + ")))";
                AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(this.searchLocationDN);
                AMObject aMObject = this.getParentOrganization((AMObject)aMStaticGroup);
                if (aMObject instanceof AMOrganization) {
                    aMSearchResults = this.searchUsers((AMOrganization)aMObject, string4, aMSearchControl);
                    break;
                }
                aMSearchResults = this.searchUsers((AMOrganizationalUnit)aMObject, string4, aMSearchControl);
                break;
            }
            case 12: {
                String string5 = "(&" + string2 + "(!(memberof=" + this.searchLocationDN + ")))";
                AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(this.searchLocationDN);
                AMObject aMObject = this.getParentOrganization((AMObject)aMAssignableDynamicGroup);
                if (aMObject instanceof AMOrganization) {
                    aMSearchResults = this.searchUsers((AMOrganization)aMObject, string5, aMSearchControl);
                    break;
                }
                aMSearchResults = this.searchUsers((AMOrganizationalUnit)aMObject, string5, aMSearchControl);
                break;
            }
            default: {
                if (!AMModelBase.debug.messageEnabled()) break;
                AMModelBase.debug.message("UMUserSearchModelImpl.searchUsersForMembership invalid location " + this.searchLocationDN);
            }
        }
        return aMSearchResults;
    }

    private AMSearchResults searchUsersForInitialization(String string, Map map, AMSearchControl aMSearchControl) throws AMException, SSOException {
        AMSearchResults aMSearchResults = null;
        String string2 = this.createFilter(string, map);
        switch (this.locationType) {
            case 2: {
                AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.searchLocationDN);
                aMSearchResults = this.searchUsers(aMOrganization, string2, aMSearchControl);
                break;
            }
            case 3: {
                AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.searchLocationDN);
                aMSearchResults = this.searchUsers(aMOrganizationalUnit, string2, aMSearchControl);
                break;
            }
            case 4: {
                AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer(this.searchLocationDN);
                AMObject aMObject = this.getParentOrganization((AMObject)aMGroupContainer);
                if (aMObject instanceof AMOrganization) {
                    aMSearchResults = this.searchUsers((AMOrganization)aMObject, string2, aMSearchControl);
                    break;
                }
                aMSearchResults = this.searchUsers((AMOrganizationalUnit)aMObject, string2, aMSearchControl);
                break;
            }
            case 9: 
            case 10: {
                AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(this.searchLocationDN);
                AMObject aMObject = this.getParentOrganization((AMObject)aMStaticGroup);
                if (aMObject instanceof AMOrganization) {
                    aMSearchResults = this.searchUsers((AMOrganization)aMObject, string2, aMSearchControl);
                    break;
                }
                aMSearchResults = this.searchUsers((AMOrganizationalUnit)aMObject, string2, aMSearchControl);
                break;
            }
            case 11: {
                AMDynamicGroup aMDynamicGroup = this.dpStoreConn.getDynamicGroup(this.searchLocationDN);
                AMObject aMObject = this.getParentOrganization((AMObject)aMDynamicGroup);
                if (aMObject instanceof AMOrganization) {
                    aMSearchResults = this.searchUsers((AMOrganization)aMObject, string2, aMSearchControl);
                    break;
                }
                aMSearchResults = this.searchUsers((AMOrganizationalUnit)aMObject, string2, aMSearchControl);
                break;
            }
            case 12: {
                AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(this.searchLocationDN);
                AMObject aMObject = this.getParentOrganization((AMObject)aMAssignableDynamicGroup);
                if (aMObject instanceof AMOrganization) {
                    aMSearchResults = this.searchUsers((AMOrganization)aMObject, string2, aMSearchControl);
                    break;
                }
                aMSearchResults = this.searchUsers((AMOrganizationalUnit)aMObject, string2, aMSearchControl);
                break;
            }
            default: {
                if (!AMModelBase.debug.messageEnabled()) break;
                AMModelBase.debug.message("UMUserSearchModelImpl.searchUsers invalid location " + this.searchLocationDN);
            }
        }
        return aMSearchResults;
    }

    private AMSearchResults searchUsers(AMOrganization aMOrganization, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
        return aMOrganization.searchUsers(aMSearchControl, string);
    }

    private AMSearchResults searchUsers(AMOrganizationalUnit aMOrganizationalUnit, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
        return aMOrganizationalUnit.searchUsers(aMSearchControl, string);
    }

    private AMSearchResults searchUsers(AMPeopleContainer aMPeopleContainer, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        AMSearchResults aMSearchResults = null;
        String string2 = aMPeopleContainer.getOrganizationDN();
        int n = this.getObjectType(string2);
        if (n == 2) {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
            aMSearchResults = aMPeopleContainer.searchUsers(aMSearchControl, string);
        } else if (n == 3) {
            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
            aMSearchResults = aMPeopleContainer.searchUsers(aMSearchControl, string);
        }
        return aMSearchResults;
    }

    private AMSearchResults searchUsers(AMRole aMRole, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        AMSearchResults aMSearchResults = null;
        String string2 = aMRole.getOrganizationDN();
        int n = this.getObjectType(string2);
        if (n == 2) {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
            aMSearchResults = aMRole.searchUsers(aMSearchControl, string);
        } else if (n == 3) {
            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
            aMSearchResults = aMRole.searchUsers(aMSearchControl, string);
        }
        return aMSearchResults;
    }

    private AMSearchResults searchUsers(AMGroup aMGroup, String string, AMSearchControl aMSearchControl) throws AMException, SSOException {
        AMSearchResults aMSearchResults = null;
        String string2 = aMGroup.getOrganizationDN();
        int n = this.getObjectType(string2);
        if (n == 2) {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
            aMSearchResults = aMGroup.searchUsers(aMSearchControl, string);
        } else if (n == 3) {
            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
            aMSearchResults = aMGroup.searchUsers(aMSearchControl, string);
        }
        return aMSearchResults;
    }

    private String createFilter(String string, Map map) {
        Object object;
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("UMUserSearchModelImpl.createFilter");
            AMModelBase.debug.message("logical operator = " + string);
            AMModelBase.debug.message("av pairs = " + map);
        }
        Iterator iterator = map.entrySet().iterator();
        StringBuffer stringBuffer = new StringBuffer(100);
        while (iterator.hasNext()) {
            boolean bl;
            object = iterator.next();
            String string2 = (String)object.getKey();
            Set set = (Set)object.getValue();
            if (set == null || set.isEmpty()) continue;
            boolean bl2 = bl = set.size() > 1;
            if (bl) {
                stringBuffer.append("(|");
            }
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                if (string2.equalsIgnoreCase("inetuserstatus")) {
                    if (string3.equalsIgnoreCase("active")) {
                        stringBuffer.append("(|(").append("inetuserstatus").append("=active)(!(").append("inetuserstatus").append("=*)))");
                        continue;
                    }
                    stringBuffer.append("(").append("inetuserstatus").append("=").append(string3).append(")");
                    continue;
                }
                stringBuffer.append("(").append(string2).append("=").append(string3).append(")");
            }
            if (!bl) continue;
            stringBuffer.append(")");
        }
        object = new StringBuffer(100);
        if (stringBuffer.length() != 0) {
            if (map.size() > 1) {
                if (string != null && string.equalsIgnoreCase(LOGICAL_AND)) {
                    ((StringBuffer)object).append("(&");
                } else {
                    ((StringBuffer)object).append("(|");
                }
                ((StringBuffer)object).append(stringBuffer + ")");
            } else {
                ((StringBuffer)object).append(stringBuffer);
            }
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("created filter = " + ((StringBuffer)object).toString());
        }
        return ((StringBuffer)object).toString();
    }

    private AMObject getParentOrganization(AMObject aMObject) throws AMException, SSOException {
        String string = aMObject.getOrganizationDN();
        int n = this.getObjectType(string);
        if (n == 2) {
            return this.dpStoreConn.getOrganization(string);
        }
        return this.dpStoreConn.getOrganizationalUnit(string);
    }

    private List getFilterAttributeNames() {
        List list = Collections.EMPTY_LIST;
        ServiceSchemaManager serviceSchemaManager = this.getUserServiceSchemaManager();
        if (serviceSchemaManager != null) {
            list = this.getFilterAttributeNames(serviceSchemaManager);
            Map map = this.getUserServiceDisplayOptions(serviceSchemaManager);
            if (map != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Set set = (Set)map.get(string);
                    if (set != null && !set.isEmpty()) continue;
                    iterator.remove();
                }
            }
        }
        return list;
    }

    private List getFilterAttributeNames(ServiceSchemaManager serviceSchemaManager) {
        List list;
        block4: {
            list = Collections.EMPTY_LIST;
            try {
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
                Set set = serviceSchema.getAttributeSchemaNames();
                if (set != null && !set.isEmpty()) {
                    HashMap<String, String> hashMap = new HashMap<String, String>(set.size());
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string;
                        String string2;
                        String string3 = (String)iterator.next();
                        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string3);
                        if (attributeSchema == null || (string2 = attributeSchema.getI18NKey()) == null || string2.length() <= 0 || (string = attributeSchema.getAny()) == null || string.indexOf("filter") == -1) continue;
                        hashMap.put(string3, string2);
                    }
                    list = AMFormatUtils.sortMapByValue(hashMap, this.getUserLocale());
                }
            }
            catch (SMSException sMSException) {
                if (!AMModelBase.debug.warningEnabled()) break block4;
                AMModelBase.debug.warning("UMUserSearchModelImpl.getFilterAttributeNames: unable to get user based schema", (Throwable)sMSException);
            }
        }
        return list;
    }

    private Map getUserServiceDisplayOptions(ServiceSchemaManager serviceSchemaManager) {
        Map map;
        block6: {
            map = Collections.EMPTY_MAP;
            try {
                AMAttributeDisplayImpl aMAttributeDisplayImpl = new AMAttributeDisplayImpl(this.dpStoreConn, this.ssoToken);
                map = aMAttributeDisplayImpl.getServiceDisplayOptions("iPlanetAMUserService", serviceSchemaManager, this.dpUser);
            }
            catch (AMException aMException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("UMUserSearchModelImpl.getUserServiceDisplayOptions: unable to get user based display options", (Throwable)aMException);
                }
            }
            catch (SMSException sMSException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("UMUserSearchModelImpl.getUserServiceDisplayOptions: unable to get user based display options", (Throwable)sMSException);
                }
            }
            catch (SSOException sSOException) {
                if (!AMModelBase.debug.warningEnabled()) break block6;
                AMModelBase.debug.warning("UMUserSearchModelImpl.getUserServiceDisplayOptions: unable to get user based display options", (Throwable)sSOException);
            }
        }
        return map;
    }

    private void setSearchControlAttributes(AMSearchControl aMSearchControl, Map map) {
        String string = (String)map.remove("userReturnField");
        if (string == null || string.length() == 0) {
            string = this.getUserSearchReturnValue();
        }
        List list = this.getValidatedAttributes(string);
        String[] stringArray = new String[]{(String)list.get(0)};
        aMSearchControl.setSortKeys(stringArray);
        aMSearchControl.setReturnAttributes(new HashSet(list));
    }

    private String getUserSearchReturnAttribute(AMObject aMObject) {
        String string = null;
        try {
            AMTemplate aMTemplate = this.getOrgTemplate(aMObject);
            if (aMTemplate != null) {
                string = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-return-attribute");
            } else {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-return-attribute");
                }
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMUserSearchModelImpl.getUserSearchReturnAttribute", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserSearchModelImpl.getUserSearchReturnAttribute", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserSearchModelImpl.getUserSearchReturnAttribute", (Throwable)aMException);
        }
        if (string == null || string.length() == 0) {
            string = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
        }
        return string;
    }

    private List getValidatedAttributes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        Set set = this.getUserAttributeNames();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if (!set.contains(string2) || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
        }
        return arrayList;
    }

    private AMPeopleContainer getDefaultPeopleContainer() {
        AMPeopleContainer aMPeopleContainer = null;
        Set set = Collections.EMPTY_SET;
        try {
            Iterator iterator;
            String string = AdminInterfaceUtils.getNamingAttribute((int)5, (Debug)AMModelBase.debug);
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    aMPeopleContainer = this.dpStoreConn.getPeopleContainer(string + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + aMOrganization.getDN());
                    if (aMPeopleContainer != null && aMPeopleContainer.isExists()) break;
                    set = aMOrganization.getPeopleContainers(1);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    aMPeopleContainer = this.dpStoreConn.getPeopleContainer(string + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + aMOrganizationalUnit.getDN());
                    if (aMPeopleContainer != null && aMPeopleContainer.isExists()) break;
                    set = aMOrganizationalUnit.getPeopleContainers(1);
                    break;
                }
                default: {
                    AMModelBase.debug.warning("Unsupported object type for people containers");
                }
            }
            if (!set.isEmpty() && (iterator = set.iterator()).hasNext()) {
                aMPeopleContainer = this.dpStoreConn.getPeopleContainer((String)iterator.next());
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserNavModelImpl.getDefaultPeopleContainer", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserNavModelImpl.getDefaultPeopleContainer", (Throwable)sSOException);
        }
        return aMPeopleContainer;
    }

    public String getPageTitle() {
        return this.getLocalizedString("advancedUserSearchPage.title");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userSearch.help");
        if (string.equals("userSearch.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getAddUsersLabel() {
        return this.getLocalizedString("addUsers.label");
    }
}

