/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMUserRoleSelectModel;
import com.iplanet.am.console.user.model.UMUserViewModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.sso.SSOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public class UMUserRoleSelectModelImpl
extends UMUserViewModelImpl
implements UMUserRoleSelectModel {
    private Set roles = null;
    private Set userRoles = null;
    private boolean rolesModified = false;

    public UMUserRoleSelectModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.getUserRoleDNs();
    }

    public Set getUserRoleDNs() {
        if (this.userRoles != null) {
            return this.userRoles;
        }
        try {
            if (this.curUser != null) {
                this.userRoles = this.curUser.getRoleDNs();
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserRoleSelectModelImpl.getUserRoleDNs", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserRoleSelectModelImpl.getUserRoleDNs", (Throwable)aMException);
        }
        if (this.userRoles == null) {
            this.userRoles = Collections.EMPTY_SET;
        }
        return this.userRoles;
    }

    public boolean isRoleAvailable() {
        boolean bl;
        block4: {
            AMOrganization aMOrganization;
            bl = false;
            this.getUserRoleDNs();
            if (!this.isAdministrator() || (aMOrganization = this.getUserOrg()) == null) break block4;
            try {
                Set set = aMOrganization.searchRoles("*", 1);
                if (set != null) {
                    set.removeAll(this.userRoles);
                    bl = !set.isEmpty();
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMUserRoleSelectModel.rolesAvailable", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMUserRoleSelectModelImpl.getRoles", (Throwable)aMException);
            }
        }
        return bl;
    }

    public String getNoRolesAvailableMsg() {
        return this.getLocalizedString("noAddRoleEntries.message");
    }

    public Set getRoles() {
        if (this.roles == null) {
            AMOrganization aMOrganization;
            Set set = this.getUserRoleDNs();
            if (this.isAdministrator() && (aMOrganization = this.getUserOrg()) != null) {
                try {
                    this.combineRoles(set, aMOrganization.searchRoles("*", 1));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("UMUserRoleSelectModelImpl.getRoles", (Throwable)sSOException);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("UMUserRoleSelectModelImpl.getRoles", (Throwable)aMException);
                }
            }
            this.roles = this.convertToOrderedSet(set);
        }
        return this.roles;
    }

    public boolean isRoleAssigned(String string) {
        return this.userRoles.contains(string);
    }

    public void removeRoles(Set set) throws AMConsoleException {
        if (this.curUser == null || !this.isAdministrator()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    this.curUser.removeRole(string);
                    this.rolesModified = true;
                    this.userRoles.remove(string);
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append(this.getLocalizedString("removedUserFromRole.message")).append(" " + string).append(":[" + this.curUser.getDN() + "]");
                    this.logger.doLog(stringBuffer.toString());
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("failed to remove role from user", (Throwable)aMException);
                    arrayList.add(this.getErrorString((Exception)((Object)aMException)));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("failed to remove role from user", (Throwable)sSOException);
                    arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
                }
            }
        }
        if (!arrayList.isEmpty()) {
            throw new AMConsoleException(arrayList);
        }
    }

    public void updateRoles(Set set) throws AMConsoleException {
        this.removeRoles(set);
    }

    public String getRoleDisplayName(String string) {
        return AMFormatUtils.DNToName(this, string, true);
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("viewRole.label");
    }

    public String getNoRoleMessage() {
        return this.getLocalizedString("roleNotFound.message");
    }

    private void combineRoles(Set set, Set set2) {
        if (set == null || set2 == null || set2.isEmpty()) {
            return;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            String string = (String)iterator.next();
            DN dN = new DN(string);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext() && !bl) {
                String string2 = (String)iterator2.next();
                DN dN2 = new DN(string2);
                bl = dN.equals(dN2);
            }
            if (bl) continue;
            set.add(string);
        }
    }

    public Set getAttrList() {
        return this.userRoles;
    }

    public void setAttrList(Set set) {
        this.userRoles = set;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("roles.header");
    }

    public void updateRoles(Set set, List list) throws AMConsoleException {
        if (set == null || list == null || list.isEmpty()) {
            return;
        }
        Set set2 = this.getUserRoleDNs();
        Set set3 = this.getObjAssignNotInCurPage(list, set2);
        if (set3 != null) {
            set.addAll(set3);
        }
    }

    public String getSuccessMessage() {
        if (this.rolesModified) {
            return this.getLocalizedString("updateUser.message");
        }
        return this.getLocalizedString("noChangesMade.message");
    }

    public String getAddBtnLabel() {
        return this.getLocalizedString("add.button");
    }

    public String getRemoveBtnLabel() {
        return this.getLocalizedString("remove.button");
    }

    public Set getAssignedRoles() {
        return this.getUserRoleDNs();
    }

    public String getNoRoleEntriesMsg() {
        String string = this.getLocalizedString("noRoleEntriesUser.message");
        if (this.isAdministrator()) {
            string = this.getLocalizedString("noRoleEntries.message");
        }
        return string;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userRoles.help");
        if (string.equals("userRoles.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getRoleNotSelectedMessage() {
        return this.getLocalizedString("roleNotSelected.message");
    }

    public String getRoleNotSelectedTitle() {
        return this.getLocalizedString("roleNotSelected.title");
    }
}

