/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMUserRoleAddModel;
import com.iplanet.am.console.user.model.UMUserViewModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.sso.SSOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public class UMUserRoleAddModelImpl
extends UMUserViewModelImpl
implements UMUserRoleAddModel {
    private Set roles = null;
    private boolean rolesAssigned = false;
    private boolean rolesUnassigned = false;

    public UMUserRoleAddModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public Set getUserRoleDNs() {
        Set set = Collections.EMPTY_SET;
        try {
            if (this.curUser != null) {
                set = this.curUser.getRoleDNs();
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMUserRoleAddModelImpl.getUserRoleDNs", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserRoleAddModelImpl.getUserRoleDNs", (Throwable)aMException);
        }
        return set;
    }

    public Set getRoles() {
        if (this.roles == null) {
            AMOrganization aMOrganization;
            Set set = this.getUserRoleDNs();
            if (this.isAdministrator() && (aMOrganization = this.getUserOrg()) != null) {
                try {
                    this.combineRoles(set, aMOrganization.searchRoles("*", 1));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("UMUserRoleAddModelImpl.getRoles", (Throwable)sSOException);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("UMUserRoleAddModelImpl.getRoles", (Throwable)aMException);
                }
            }
            this.roles = this.convertToOrderedSet(set);
        }
        return this.roles;
    }

    public boolean isRoleAssigned(String string) {
        Set set = this.getUserRoleDNs();
        return set.contains(string);
    }

    public void updateRoles(Set set) throws AMConsoleException {
        this.setAttrList(null);
        if (this.curUser == null || !this.isAdministrator()) {
            return;
        }
        Set set2 = this.getUserRoleDNs();
        if (set2.equals(set)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        Set set3 = this.excludedObjFromSet(set, set2);
        if (set3 != null && !set3.isEmpty()) {
            Iterator iterator = set3.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    this.curUser.assignRole(string);
                    this.rolesAssigned = true;
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append(this.getLocalizedString("assignedUserToRole.message")).append(" " + string).append(":[" + this.curUser.getDN() + "]");
                    this.logger.doLog(stringBuffer.toString());
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("assigning roles to user", (Throwable)aMException);
                    arrayList.add(this.getErrorString((Exception)((Object)aMException)));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("assigning roles to user", (Throwable)sSOException);
                    arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
                }
            }
        }
        if (!arrayList.isEmpty()) {
            throw new AMConsoleException(arrayList);
        }
    }

    public String getRoleDisplayName(String string) {
        return AMFormatUtils.DNToName(this, string, true);
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("viewRole.label");
    }

    public String getNoRoleMessage() {
        return this.getLocalizedString("roleNotFound.message");
    }

    private void combineRoles(Set set, Set set2) {
        if (set == null || set2 == null || set2.isEmpty()) {
            return;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            String string = (String)iterator.next();
            DN dN = new DN(string);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext() && !bl) {
                String string2 = (String)iterator2.next();
                DN dN2 = new DN(string2);
                bl = dN.equals(dN2);
            }
            if (bl) continue;
            set.add(string);
        }
    }

    public Set getAttrList() {
        return this.roles;
    }

    public void setAttrList(Set set) {
        this.roles = set;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("roles.header");
    }

    public void updateRoles(Set set, List list) throws AMConsoleException {
        if (set == null || list == null || list.isEmpty()) {
            return;
        }
        Set set2 = this.getUserRoleDNs();
        Set set3 = this.getObjAssignNotInCurPage(list, set2);
        if (set3 != null) {
            set.addAll(set3);
        }
        this.updateRoles(set);
    }

    public String getSuccessMessage() {
        if (this.rolesAssigned || this.rolesUnassigned) {
            return this.getLocalizedString("updateUser.message");
        }
        return this.getLocalizedString("noChangesMade.message");
    }

    public String getAddBtnLabel() {
        return this.getLocalizedString("add.button");
    }

    public String getRemoveBtnLabel() {
        return this.getLocalizedString("remove.button");
    }

    public Set getUnAssignedRoles() {
        Set set = Collections.EMPTY_SET;
        set = this.excludedObjFromSet(this.getRoles(), this.getUserRoleDNs());
        return set;
    }

    public String getNoAddRoleEntriesMsg() {
        return this.getLocalizedString("noAddRoleEntries.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userRoleAdd.help");
        if (string.equals("userRoleAdd.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

