/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMAttributeDisplayImpl;
import com.iplanet.am.console.base.model.AMCommonNameGenerator;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMDisplayTypeConverter;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMUserProfileModel;
import com.iplanet.am.console.user.model.UMUserViewModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMUserProfileModelImpl
extends UMUserViewModelImpl
implements UMUserProfileModel {
    private String svcName = null;
    private Map mapUserAttrs = null;
    private Map mapDynAttrs = null;
    private Map userSchemaCache = null;
    private Map dynSchemaCache = null;
    private Set userAttrNames = null;
    private Set dynAttrNames = null;
    private Map userAttrStatus = null;
    private Map customViewBeans = null;
    private ServiceSchemaManager svcSchemaMgr = null;
    private boolean curUserRenamed = false;

    public UMUserProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.svcName = (String)map.get("IS-IdentityUserSubView");
        if (this.svcName == null || this.svcName.length() == 0) {
            this.svcName = "iPlanetAMUserService";
        }
    }

    private ServiceSchemaManager getSvcSchemaMgr() {
        block3: {
            if (this.svcSchemaMgr != null) break block3;
            try {
                this.svcSchemaMgr = this.getServiceSchemaManager(this.svcName);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMUserProfileModelImpl.getSvcSchemaMgr", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMUserProfileModelImpl.getSvcSchemaMgr", (Throwable)sMSException);
            }
        }
        return this.svcSchemaMgr;
    }

    public void initModel() {
        if (this.dpUser != null) {
            this.displayOptions = this.getDisplayOptions();
            this.getAttrSchema();
            if (this.userAttrNames != null && !this.userAttrNames.isEmpty()) {
                this.mapUserAttrs = this.getUserAttrValues();
            }
            if (this.dynAttrNames != null && !this.dynAttrNames.isEmpty()) {
                this.mapDynAttrs = this.getDynAttrValues();
            }
            if (this.userAttrStatus != null) {
                this.userAttrStatus.clear();
            }
        }
    }

    public void setAttributeValues(Map map) throws AMConsoleException {
        if (map != null) {
            this.mapUserAttrs = this.getUserAttrValues();
            this.mapUserAttrs.putAll(map);
        } else {
            this.mapUserAttrs = this.getUserAttrValues();
        }
    }

    public boolean isAttributeAccessDenied() {
        if (this.isCombinedDisplay()) {
            return !(this.userAttrNames != null && !this.userAttrNames.isEmpty() || this.dynAttrNames != null && !this.dynAttrNames.isEmpty());
        }
        if (this.hasSchemaType(SchemaType.USER)) {
            return this.userAttrNames == null || this.userAttrNames.isEmpty();
        }
        return false;
    }

    public boolean hasEditableAttributes() {
        if (this.isServiceDenied(this.svcName)) {
            return false;
        }
        if (this.userAttrNames == null || this.userAttrNames.isEmpty()) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = this.userAttrNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isAttrReadOnly(0, string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getServiceName() {
        return this.svcName;
    }

    private Map getDisplayOptions() {
        Map map = null;
        AMAttributeDisplayImpl aMAttributeDisplayImpl = new AMAttributeDisplayImpl(this.dpStoreConn, this.ssoToken);
        try {
            ServiceSchemaManager serviceSchemaManager = this.getSvcSchemaMgr();
            if (serviceSchemaManager != null) {
                map = aMAttributeDisplayImpl.getServiceDisplayOptions(this.svcName, serviceSchemaManager, this.dpUser);
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("Error getting display options", (Throwable)aMException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("Error getting display options", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("Error getting display options", (Throwable)sSOException);
        }
        return map;
    }

    private Map getUserAttrValues() {
        if (this.curUser == null) {
            return new HashMap(0);
        }
        if (!this.hasSchemaType(SchemaType.USER)) {
            return new HashMap(0);
        }
        HashMap hashMap = null;
        try {
            hashMap = this.curUser.getAttributes(this.userAttrNames);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserProfileModelImpl.getUserAttrValues", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserProfileModelImpl.getUserAttrValues", (Throwable)aMException);
        }
        if (hashMap == null) {
            hashMap = new HashMap(0);
        }
        return hashMap;
    }

    public Set getUserAttributeNames(int n) {
        Set set = Collections.EMPTY_SET;
        Set set2 = null;
        set2 = n == 1 ? this.dynAttrNames : this.userAttrNames;
        if (set2 != null) {
            set = set2;
        }
        return set;
    }

    private Map getDynAttrValues() {
        if (this.curUser == null) {
            return new HashMap(0);
        }
        if (!this.hasSchemaType(SchemaType.DYNAMIC)) {
            return new HashMap(0);
        }
        HashMap hashMap = null;
        try {
            hashMap = this.curUser.getAttributes(this.dynAttrNames);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserProfileModelImpl.getDynAttrValues", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserProfileModelImpl.getDynAttrValues", (Throwable)aMException);
        }
        if (hashMap == null) {
            hashMap = new HashMap(0);
        }
        return hashMap;
    }

    private void renameUser() throws AMConsoleException {
        String string = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
        Set set = (Set)this.mapUserAttrs.get(string);
        if (set != null && !set.isEmpty()) {
            String string2 = AMAdminUtils.getFirstElement(set);
            try {
                Set set2 = AMAdminUtils.getAttrValues((AMObject)this.curUser, string);
                String string3 = AMFormatUtils.DNToName(this, this.curUser.getDN());
                boolean bl = true;
                Iterator iterator = set.iterator();
                while (iterator.hasNext() && bl) {
                    String string4 = (String)iterator.next();
                    if (!string3.equalsIgnoreCase(string4)) continue;
                    AMModelBase.debug.message("current user dn was not changed, don't rename");
                    bl = false;
                }
                if (bl) {
                    AMModelBase.debug.message("renaming user to " + string2);
                    this.curUser.rename(string2, true);
                    this.curUserRenamed = true;
                }
            }
            catch (AMException aMException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
            catch (SSOException sSOException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
        }
    }

    public void updateProfile() throws AMConsoleException {
        Set<String> set;
        Object object;
        Set<String> set2;
        if (this.userAttrNames == null || this.mapUserAttrs == null || this.curUser == null) {
            return;
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("updating users profile : " + this.mapUserAttrs);
        }
        this.fireBeforeUpdateValuesEvent(1, (AMObject)this.curUser, this.mapUserAttrs);
        this.renameUser();
        if (this.getAutoGenerateCN()) {
            set2 = (Set)this.mapUserAttrs.remove("cn");
            if (set2 == null || set2.isEmpty()) {
                set2 = new HashSet<String>(3);
            }
            if (!this.isAttributeMultiValued("cn")) {
                set2.clear();
            }
            object = AMCommonNameGenerator.getInstance();
            set2.add(((AMCommonNameGenerator)object).generateCommonName(this.mapUserAttrs, this.getUserOrganizationDN(), this));
            set = null;
            try {
                set = this.curUser.getAttribute("cn");
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("error getting current cn value ");
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("error getting current cn value ");
            }
            if (!set2.equals(set)) {
                this.mapUserAttrs.put("cn", set2);
            }
        }
        set2 = new HashMap(this.mapUserAttrs.size());
        object = new HashMap(this.mapUserAttrs.size());
        set = new HashSet(this.mapUserAttrs.size());
        Iterator iterator = this.userAttrNames.iterator();
        while (iterator.hasNext()) {
            Set set3;
            String string = (String)iterator.next();
            if (this.isAttrReadOnly(0, string)) continue;
            String string2 = string;
            String string3 = "iPlanetEncryptedPassword" + string;
            if (this.mapUserAttrs.containsKey(string3)) {
                string = string3;
            }
            if ((set3 = (Set)this.mapUserAttrs.get(string)) == null) continue;
            String string4 = (String)this.userAttrStatus.get(string);
            AttributeSchema attributeSchema = this.getAttrSchemaFromCache(0, string2);
            if (attributeSchema != null && attributeSchema.getSyntax().equals((Object)AttributeSchema.Syntax.PASSWORD)) {
                string = "iPlanetPlainTextPassword" + string;
            }
            if (string4 == null || string4.length() == 0) {
                set2.put(string, set3);
                continue;
            }
            if (string4.equals(this.getCustomizeValue())) {
                object.put(string, set3);
                continue;
            }
            if (!string4.equals(this.getInheritValue())) continue;
            set.add(string);
        }
        this.modifyProfile((Map)((Object)set2), (Map)object, set);
        this.fireAfterUpdateValuesEvent(1, (AMObject)this.curUser);
    }

    private String getUserOrganizationDN() throws AMConsoleException {
        try {
            return this.curUser.getOrganizationDN();
        }
        catch (AMException aMException) {
            throw new AMConsoleException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AMConsoleException(sSOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyProfile(Map map, Map map2, Set set) throws AMConsoleException {
        ArrayList<String> arrayList = null;
        if (!map.isEmpty()) {
            try {
                this.setModifiedMessage("userChanged.message");
                this.writeProfile((AMObject)this.curUser, map);
            }
            catch (AMConsoleException aMConsoleException) {
                arrayList = aMConsoleException.getErrors();
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMUserProfileModelImpl.modifyProfile", (Throwable)sSOException);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
            }
        }
        if (!map2.isEmpty()) {
            try {
                this.setModifiedMessage("userChanged.message");
                this.writeProfile((AMObject)this.curUser, map2, true);
            }
            catch (AMConsoleException aMConsoleException) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.addAll(aMConsoleException.getErrors());
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMUserProfileModelImpl.modifyProfile", (Throwable)sSOException);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
            }
        }
        boolean bl = false;
        if (!set.isEmpty()) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("setting the following attributes to inherited" + set);
            }
            if (arrayList == null) {
                arrayList = new ArrayList(set.size());
            }
            HashSet<String> hashSet = new HashSet<String>(1);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object var13_18;
                String string = (String)iterator.next();
                Set set2 = this.getAttributeValues(0, string);
                if (set2 == null || set2.isEmpty()) {
                    AMModelBase.debug.warning("skipping " + string + ", not in user entry");
                    continue;
                }
                hashSet.add(string);
                try {
                    try {
                        this.curUser.removeAttributes(hashSet);
                        this.writeFormatLog("attribute.remove", string, this.curUser.getDN());
                        bl = true;
                    }
                    catch (AMException aMException) {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("error removing " + string);
                        }
                        var13_18 = null;
                        hashSet.clear();
                        continue;
                    }
                    catch (SSOException sSOException) {
                        AMModelBase.debug.error("UMUserProfileModelImpl.modifyProfile", (Throwable)sSOException);
                        arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
                        var13_18 = null;
                        hashSet.clear();
                        continue;
                    }
                    var13_18 = null;
                    hashSet.clear();
                }
                catch (Throwable throwable) {
                    var13_18 = null;
                    hashSet.clear();
                    throw throwable;
                }
            }
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            throw new AMConsoleException(arrayList);
        }
        if (bl) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.initModel();
    }

    private void getAttrSchema() {
        if (this.hasSchemaType(SchemaType.USER)) {
            this.userSchemaCache = this.getAttrSchema(SchemaType.USER);
            if (this.userSchemaCache != null && !this.userSchemaCache.isEmpty()) {
                this.userAttrNames = this.userSchemaCache.keySet();
            }
        }
        if (this.hasSchemaType(SchemaType.DYNAMIC)) {
            this.dynSchemaCache = this.getAttrSchema(SchemaType.DYNAMIC);
            if (this.dynSchemaCache != null && !this.dynSchemaCache.isEmpty()) {
                this.dynAttrNames = this.dynSchemaCache.keySet();
            }
        }
    }

    private Map getAttrSchema(SchemaType schemaType) {
        HashMap<String, AttributeSchema> hashMap;
        block3: {
            hashMap = null;
            try {
                ServiceSchemaManager serviceSchemaManager = this.getSvcSchemaMgr();
                if (serviceSchemaManager == null) break block3;
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
                Set set = serviceSchema.getAttributeSchemaNames();
                hashMap = new HashMap<String, AttributeSchema>(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
                    if (!this.toDisplayAttr(schemaType, attributeSchema)) continue;
                    hashMap.put(string, attributeSchema);
                }
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMUserProfileModelImpl.getAttrSchemas", (Throwable)sMSException);
            }
        }
        return hashMap;
    }

    private boolean toDisplayAttr(SchemaType schemaType, AttributeSchema attributeSchema) {
        if (this.displayOptions == null) {
            return this.isAttributeDisplayedInSchema(schemaType, attributeSchema);
        }
        if (this.displayOptions.isEmpty()) {
            return false;
        }
        Set set = (Set)this.displayOptions.get(attributeSchema.getName());
        if (set == null || set.isEmpty()) {
            return false;
        }
        return set.contains("display") || set.contains("readOnly") || set.contains("userReadOnly") || this.isAdministrator() && set.contains("adminDisplay");
    }

    private boolean isAttributeDisplayedInSchema(SchemaType schemaType, AttributeSchema attributeSchema) {
        boolean bl = false;
        if (!schemaType.equals((Object)SchemaType.USER)) {
            String string = attributeSchema.getI18NKey();
            if (string != null && string.length() > 0) {
                bl = true;
            }
        } else {
            bl = AMAdminUtils.isAttributeDisplayable(this.getUserType(), attributeSchema);
        }
        return bl;
    }

    private boolean hasSchemaType(SchemaType schemaType) {
        boolean bl;
        block2: {
            bl = false;
            ServiceSchemaManager serviceSchemaManager = this.getSvcSchemaMgr();
            if (serviceSchemaManager == null) break block2;
            try {
                Set set = serviceSchemaManager.getSchemaTypes();
                bl = AMAdminUtils.containsSchemaType(set, schemaType);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMUserProfileModelImpl.hasSchemaType", (Throwable)sMSException);
            }
        }
        return bl;
    }

    public List getDynamicGUIs(int n, Map map) {
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        HashSet hashSet = null;
        if (n == 1) {
            if (this.dynAttrNames != null && !this.dynAttrNames.isEmpty()) {
                hashSet = new HashSet(this.dynAttrNames.size());
                hashSet.addAll(this.dynAttrNames);
                if (this.userAttrNames != null && !this.userAttrNames.isEmpty()) {
                    hashSet.removeAll(this.userAttrNames);
                }
                this.fireRetrieveAttributeValuesEvent((AMObject)this.curUser, 2, 1, this.svcName, SchemaType.DYNAMIC, this.mapDynAttrs);
                hashSet.retainAll(this.mapDynAttrs.keySet());
            }
        } else if (n == 0) {
            hashSet = this.userAttrNames;
            if (this.mapUserAttrs != null && !this.mapUserAttrs.isEmpty()) {
                this.fireRetrieveAttributeValuesEvent((AMObject)this.curUser, 2, 1, this.svcName, SchemaType.USER, this.mapUserAttrs);
                hashSet.retainAll(this.mapUserAttrs.keySet());
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(3);
        arrayList2.add(this.getCustomizeLabel());
        arrayList2.add(this.getInheritLabel());
        arrayList2.add(this.getSkipLabel());
        ArrayList<String> arrayList3 = new ArrayList<String>(3);
        arrayList3.add(this.getCustomizeValue());
        arrayList3.add(this.getInheritValue());
        arrayList3.add(this.getSkipValue());
        if (hashSet != null && !hashSet.isEmpty()) {
            DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
            arrayList = new ArrayList<DynamicGUI>(hashSet.size());
            List list = this.orderAttrNamesByI18nKeys(n, hashSet);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.equals("iplanet-am-user-password-reset-options") && !this.isPasswordResetEnabled()) continue;
                AttributeSchema attributeSchema = this.getAttrSchemaFromCache(n, string);
                boolean bl = this.isAttrReadOnly(n, string);
                String string2 = null;
                if (!bl && (string2 = this.getAttributeStatus(string)) != null && string2.length() == 0) {
                    string2 = null;
                }
                DynamicGUI dynamicGUI = dynamicGUIGenerator.createDynamicGUI(attributeSchema, this.svcName, this.getAttributeValues(n, string, dynamicGUIGenerator), bl, string2, arrayList2, arrayList3, this, Setting.ACTION_USER);
                int n2 = AMDisplayTypeConverter.getDisplaySyntax(attributeSchema);
                if (n2 == 6 || n2 == 7) {
                    this.storeDynGUILinkInfo(n, string, map);
                }
                arrayList.add(dynamicGUI);
            }
        }
        return arrayList;
    }

    protected void storeDynGUILinkInfo(int n, String string, Map map) {
        String string2 = Integer.toString(3);
        if (n == 1) {
            string2 = Integer.toString(2);
        }
        String[] stringArray = new String[]{this.svcName, string2};
        map.put(string, stringArray);
    }

    protected List orderAttrNamesByI18nKeys(int n, Set set) {
        HashSet<Object> hashSet;
        String string;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(set.size());
        HashMap<String, HashSet<Object>> hashMap = new HashMap<String, HashSet<Object>>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            string = this.getI18nKey(n, (String)object);
            hashSet2.add(string);
            hashSet = (HashSet<Object>)hashMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<Object>(3);
                hashMap.put(string, hashSet);
            }
            hashSet.add(object);
        }
        object = AMFormatUtils.sortItemsInSet(hashSet2, this.getUserLocale());
        iterator = object.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            hashSet = (Set)hashMap.get(string);
            arrayList.addAll(hashSet);
        }
        return arrayList;
    }

    public String getI18nKey(int n, String string) {
        String string2 = "";
        AttributeSchema attributeSchema = this.getAttrSchemaFromCache(n, string);
        if (attributeSchema != null) {
            string2 = attributeSchema.getI18NKey();
        }
        return string2;
    }

    private boolean isAttrReadOnly(int n, String string) {
        if (n == 1) {
            return true;
        }
        if (this.displayOptions == null) {
            return this.isAttrReadOnlyInSchema(n, string);
        }
        if (this.displayOptions.isEmpty()) {
            return false;
        }
        Set set = (Set)this.displayOptions.get(string);
        if (set == null || set.isEmpty()) {
            return false;
        }
        boolean bl = false;
        if (set.contains("readOnly") || set.contains("userReadOnly") && this.getUserType() == 3) {
            bl = true;
        }
        return bl;
    }

    private boolean isAttrReadOnlyInSchema(int n, String string) {
        boolean bl = false;
        AttributeSchema attributeSchema = this.getAttrSchemaFromCache(n, string);
        if (attributeSchema != null) {
            SchemaType schemaType = SchemaType.USER;
            if (n == 1) {
                schemaType = SchemaType.DYNAMIC;
            }
            bl = !AMAdminUtils.isAttributeEditableByUser(this.getUserType(), attributeSchema, schemaType);
        }
        return bl;
    }

    private Set getAttributeValues(int n, String string, DynamicGUIGenerator dynamicGUIGenerator) {
        Set set = null;
        if (n == 0 && this.mapUserAttrs != null) {
            set = (Set)this.mapUserAttrs.get(string);
            if (set == null) {
                set = (Set)this.mapUserAttrs.get(string.toLowerCase());
            }
        } else if (n == 1 && this.mapDynAttrs != null && (set = (Set)this.mapDynAttrs.get(string)) == null) {
            set = (Set)this.mapDynAttrs.get(string.toLowerCase());
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        } else {
            AttributeSchema attributeSchema = this.getAttrSchemaFromCache(n, string);
            if (attributeSchema != null && AMDisplayTypeConverter.getDisplaySyntax(attributeSchema) == 4) {
                set = this.getDateInUserLocale(set);
            }
        }
        return set;
    }

    public void setAttributeStatus(Map map) {
        this.userAttrStatus = map == null ? new HashMap(0) : map;
    }

    private String getAttributeStatus(String string) {
        String string2 = null;
        if (this.hasDynamicAttribute(string)) {
            if (this.userAttrStatus != null) {
                string2 = (String)this.userAttrStatus.get(string);
            }
            if (string2 == null || string2.length() == 0) {
                string2 = this.getSkipValue();
            }
        }
        return string2;
    }

    private AttributeSchema getAttrSchemaFromCache(int n, String string) {
        Map map = this.userSchemaCache;
        if (n == 1) {
            map = this.dynSchemaCache;
        }
        return (AttributeSchema)map.get(string);
    }

    private boolean hasDynamicAttribute(String string) {
        if (this.dynAttrNames == null || this.dynAttrNames.isEmpty()) {
            return false;
        }
        return this.dynAttrNames.contains(string);
    }

    public String getLocalizedUserString() {
        return this.getLocalizedString("userSvcAttr.label");
    }

    public String getLocalizedDynamicString() {
        return this.getLocalizedString("dynamicSvcAttr.label");
    }

    protected SchemaType getSchemaType(int n) {
        SchemaType schemaType = SchemaType.USER;
        if (n == 1) {
            schemaType = SchemaType.DYNAMIC;
        }
        return schemaType;
    }

    public String getAssociatedViewBean() {
        if (this.customViewBeans == null) {
            this.customViewBeans = this.getCustomSvcViewBeans();
        }
        return (String)this.customViewBeans.get(this.svcName);
    }

    public String getEditSvcAttrLabel() {
        return this.getLocalizedString("editService.label");
    }

    public String getServiceCustomVBNotFoundMsg() {
        return this.getLocalizedString("userProfileCustomViewBeanNotFound.message");
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateUser.message");
    }

    public String getUserRenamedMessage() {
        return this.getLocalizedString("userRenamed.message");
    }

    public String getNoPrivilegeTitle() {
        return this.getLocalizedString("noUserProfileAccess.title");
    }

    public String getNoPrivilegeMessage() {
        return this.getLocalizedString("noUserProfileAccess.message");
    }

    public boolean isUserProfileDisabled() {
        return this.getUserType() == 3 && !this.isUserMgtEnabled();
    }

    public boolean isUserProfileExists() {
        return this.dpUser != null;
    }

    public String getNoUserProfileMessage() {
        return this.getLocalizedString("noUserProfileExists.message");
    }

    public Set getAttributeValues(int n, String string) {
        Set set = null;
        if (n == 0 && this.mapUserAttrs != null) {
            set = (Set)this.mapUserAttrs.get(string);
            if (set == null) {
                set = (Set)this.mapUserAttrs.get(string.toLowerCase());
            }
        } else if (n == 1 && this.mapDynAttrs != null && (set = (Set)this.mapDynAttrs.get(string)) == null) {
            set = (Set)this.mapDynAttrs.get(string.toLowerCase());
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userProfile.help");
        if (string.equals("userProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isUserRenamed() {
        return this.curUserRenamed;
    }

    public String getSuccessfulLoginMessage() {
        return this.getLocalizedString("successfullyLogin.message");
    }
}

