/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.user.model.UMUserPasswordResetOptionsData;
import com.iplanet.am.console.user.model.UMUserPasswordResetOptionsModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.sun.identity.security.DecryptAction;
import com.sun.identity.security.EncryptAction;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class UMUserPasswordResetOptionsModelImpl
extends AMProfileModelBase
implements UMUserPasswordResetOptionsModel {
    private static final String TOKEN = "\t";
    private static final String PW_RESET_QUESTION_ANSWER = "iplanet-am-user-password-reset-question-answer";
    private static final String PW_RESET_QUESTION = "iplanet-am-password-reset-question";
    private static final String PW_RESET_PERSONAL_ANSWER = "iplanet-am-password-reset-user-personal-question";
    private static final String PW_RESET_FORCE_RESET = "iplanet-am-user-password-reset-force-reset";
    private static final String PW_RESET_MAX_NUM_OF_QUESTIONS = "iplanet-am-password-reset-max-num-of-questions";
    private Map optionMap = null;
    private String userQuestionValue = null;

    public UMUserPasswordResetOptionsModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getQuestionAnswerLabel() {
        return this.getLocalizedString("questionAnswer.label");
    }

    public String getAdminOptionLabel() {
        return this.getLocalizedString("adminOption.label");
    }

    public String getForceResetLabel() {
        return this.getLocalizedString("forceReset.label");
    }

    public String getCloseButtonLabel() {
        return this.getLocalizedString("close.button");
    }

    public Map getResetQuestion() {
        HashMap<String, String> hashMap = Collections.EMPTY_MAP;
        Set set = this.getAttrValues(PW_RESET_QUESTION, "iPlanetAMPasswordResetService");
        if (set != null && !set.isEmpty()) {
            hashMap = new HashMap<String, String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashMap.put(string, this.getL10NAttributeName("iPlanetAMPasswordResetService", string));
            }
        }
        return hashMap;
    }

    public boolean isUserQuestionEnabled() {
        if (this.userQuestionValue == null) {
            this.userQuestionValue = AMAdminUtils.getFirstElement(this.getAttrValues(PW_RESET_PERSONAL_ANSWER, "iPlanetAMPasswordResetService"));
        }
        return this.userQuestionValue != null && this.userQuestionValue.equals("true");
    }

    public String getUserInfoTxt() {
        int n = this.getMaxNumQuestions();
        Object[] objectArray = new String[]{String.valueOf(n)};
        String string = "";
        string = this.isUserQuestionEnabled() ? MessageFormat.format(this.getLocalizedString("userPersonalInfo.message"), objectArray) : MessageFormat.format(this.getLocalizedString("userInfo.message"), objectArray);
        return string;
    }

    public String getTitle(String string) {
        Object[] objectArray = new String[]{AMFormatUtils.DNToName(this, string)};
        return MessageFormat.format(this.getLocalizedString("passwordResetPage.title"), objectArray);
    }

    public void saveUserOptions(Map map, String string, boolean bl) throws AMConsoleException {
        AMUser aMUser;
        Object object;
        if (map == null) {
            AMModelBase.debug.warning("saveUserOptions: question and answer data is null");
            return;
        }
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (map.isEmpty()) {
            hashSet = new HashSet<String>(1);
            hashSet.add("");
        } else {
            object = map.keySet();
            aMUser = object.iterator();
            hashSet = new HashSet(object.size());
            while (aMUser.hasNext()) {
                StringBuffer stringBuffer = new StringBuffer(100);
                String string2 = (String)aMUser.next();
                UMUserPasswordResetOptionsData uMUserPasswordResetOptionsData = (UMUserPasswordResetOptionsData)map.get(string2);
                if (uMUserPasswordResetOptionsData == null) continue;
                stringBuffer.append(string2).append(TOKEN).append(uMUserPasswordResetOptionsData.getAnswer()).append(TOKEN).append(uMUserPasswordResetOptionsData.getDataStatus());
                String string3 = (String)AccessController.doPrivileged(new EncryptAction(stringBuffer.toString()));
                hashSet.add(string3);
            }
        }
        try {
            object = new HashMap(2);
            aMUser = this.dpStoreConn.getUser(string);
            object.put(PW_RESET_QUESTION_ANSWER, hashSet);
            if (this.isAdministrator()) {
                hashSet = new HashSet(1);
                hashSet.add(String.valueOf(bl));
                object.put(PW_RESET_FORCE_RESET, hashSet);
            }
            aMUser.setAttributes((Map)object);
            aMUser.store();
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("could not save question and answer for " + string, (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("could not save question and answer for " + string, (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
    }

    public Map getUserQuestionsAnswers(String string) {
        try {
            Set set;
            AMUser aMUser = this.dpStoreConn.getUser(string);
            if (aMUser != null && (set = aMUser.getAttribute(PW_RESET_QUESTION_ANSWER)) != null && !set.isEmpty()) {
                this.optionMap = this.getQuestionsAnswers(set);
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("Could not get questions and answers for " + string, (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("Could not get questions and answers for " + string, (Throwable)aMException);
        }
        return this.optionMap;
    }

    private Map getQuestionsAnswers(Set set) {
        if (set == null || set.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, UMUserPasswordResetOptionsData> hashMap = new HashMap<String, UMUserPasswordResetOptionsData>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)AccessController.doPrivileged(new DecryptAction(string));
            StringTokenizer stringTokenizer = new StringTokenizer(string2, TOKEN);
            if (stringTokenizer.countTokens() != 3) continue;
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            hashMap.put(string3, new UMUserPasswordResetOptionsData(string4, Integer.parseInt(string5)));
        }
        return hashMap;
    }

    public String getAnswer(String string) {
        if (this.optionMap == null) {
            return null;
        }
        UMUserPasswordResetOptionsData uMUserPasswordResetOptionsData = (UMUserPasswordResetOptionsData)this.optionMap.get(string);
        if (uMUserPasswordResetOptionsData == null) {
            return null;
        }
        return uMUserPasswordResetOptionsData.getAnswer();
    }

    public boolean isQuestionSelected(String string) {
        UMUserPasswordResetOptionsData uMUserPasswordResetOptionsData;
        boolean bl = false;
        if (this.optionMap != null && !this.optionMap.isEmpty() && (uMUserPasswordResetOptionsData = (UMUserPasswordResetOptionsData)this.optionMap.get(string)) != null) {
            bl = uMUserPasswordResetOptionsData.isSelected();
        }
        return bl;
    }

    public boolean isPersonalQuestion(String string) {
        UMUserPasswordResetOptionsData uMUserPasswordResetOptionsData;
        boolean bl = false;
        if (this.optionMap != null && !this.optionMap.isEmpty() && (uMUserPasswordResetOptionsData = (UMUserPasswordResetOptionsData)this.optionMap.get(string)) != null) {
            bl = uMUserPasswordResetOptionsData.isPersonalQuestion();
        }
        return bl;
    }

    public void updateForceReset(String string, boolean bl) throws AMConsoleException {
        HashMap hashMap = new HashMap(1);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(String.valueOf(bl));
        try {
            AMUser aMUser = this.dpStoreConn.getUser(string);
            hashMap.put(PW_RESET_FORCE_RESET, hashSet);
            aMUser.setAttributes(hashMap);
            aMUser.store();
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("Unable to update force reset attribute for user " + string, (Throwable)sSOException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("Unable to update force reset attribute for user " + string, (Throwable)aMException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
    }

    public boolean isForceReset(String string) {
        try {
            String string2;
            Set set;
            AMUser aMUser = this.dpStoreConn.getUser(string);
            if (aMUser != null && (set = aMUser.getAttribute(PW_RESET_FORCE_RESET)) != null && !set.isEmpty() && (string2 = (String)set.iterator().next()) != null && string2.equals("true")) {
                return true;
            }
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("could not  get iplanet-am-user-password-reset-force-resetattribute for " + string, (Throwable)sSOException);
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("could not  get iplanet-am-user-password-reset-force-resetattribute for " + string, (Throwable)aMException);
        }
        return false;
    }

    public int getMaxNumQuestions() {
        int n = 1;
        Set set = this.getAttrValues(PW_RESET_MAX_NUM_OF_QUESTIONS, "iPlanetAMPasswordResetService");
        if (set != null && !set.isEmpty()) {
            String string = (String)set.iterator().next();
            n = Integer.parseInt(string);
        }
        return n;
    }

    public String getPersonalQuestion() {
        if (this.optionMap == null) {
            return null;
        }
        Set set = this.optionMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.isPersonalQuestion(string)) continue;
            return string;
        }
        return null;
    }

    public boolean isQuestionAvailable() {
        Map map = this.getResetQuestion();
        return map != null && !map.isEmpty() || this.isUserQuestionEnabled();
    }

    public String getMaxQuestionSelectedMessage() {
        return this.getLocalizedString("maxQuestionSelected.message");
    }

    public String getMissingAnswerMessage() {
        return this.getLocalizedString("selQuestionMissingAnswer.message");
    }

    public String getQuestionLabel() {
        return this.getLocalizedString("question.label");
    }

    public String getAnswerLabel() {
        return this.getLocalizedString("answer.label");
    }

    public String getSelectLabel() {
        return this.getLocalizedString("select.label");
    }

    public String getHTMLPageTitle() {
        return this.getLocalizedString("questionAnswer.label");
    }
}

