/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMUserModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMUserModelImpl
extends AMProfileModelBase
implements UMUserModel {
    protected String errorMessage = null;
    protected List errorMessageList = null;
    protected Set deniedSvcs = Collections.EMPTY_SET;
    protected Map displayOptions = null;
    protected String curUserDN = "";
    protected AMUser curUser = null;
    protected Map allRegisteredServices = null;
    private static final String PW_RESET_ENABLED_ATTR = "iplanet-am-password-reset-enabled";

    public UMUserModelImpl(HttpServletRequest httpServletRequest, String string, Map map) {
        super(httpServletRequest, string, map);
        this.getUserDNFromQueryParameter(httpServletRequest, map);
        this.setCurrentUser((String)map.get("com-iplanet-am-admin-user-current-object"));
        this.deniedSvcs = this.getDeniedServices();
    }

    public UMUserModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.getUserDNFromQueryParameter(httpServletRequest, map);
        this.setCurrentUser((String)map.get("com-iplanet-am-admin-user-current-object"));
        if (this.dpUser != null) {
            this.deniedSvcs = this.getDeniedServices();
        }
    }

    private void getUserDNFromQueryParameter(HttpServletRequest httpServletRequest, Map map) {
        String string = httpServletRequest.getParameter("User");
        if (string != null && string.length() > 0) {
            map.put("com-iplanet-am-admin-user-current-object", string);
        }
    }

    public String getProfileTitle() {
        String string = null;
        if (this.curUser != null) {
            String string2 = null;
            Set set = this.getUserSettings(Setting.USER_PROFILE_TITLE);
            string2 = set != null && !set.isEmpty() ? (String)set.iterator().next() : AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
            try {
                Set set2 = AMAdminUtils.getAttrValues((AMObject)this.curUser, string2);
                if (set2 != null && !set2.isEmpty()) {
                    string = AMAdminUtils.getFirstElement(set2);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMUserModelImpl.getProfileTitle", (Throwable)sSOException);
            }
            if (string == null || string.length() == 0) {
                AMModelBase.debug.message("setting profile title to naming attribute");
                string = AMFormatUtils.DNToName(this, this.curUser.getDN());
            }
        }
        return string;
    }

    public String getUserServiceName() {
        return "iPlanetAMUserService";
    }

    protected AMUser getCurrentUser() {
        return this.curUser;
    }

    protected void setCurrentUser(String string) {
        block4: {
            this.curUserDN = string;
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("UMUserModelImpl:setCurrentUser to " + string);
            }
            try {
                if (this.curUserDN == null || this.curUserDN.length() <= 0) break block4;
                this.curUser = this.dpStoreConn.getUser(this.curUserDN);
                if (this.curUser != null && !this.curUser.isExists()) {
                    AMModelBase.debug.message("user doesn't exist, setting user to null");
                    this.curUser = null;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMUserModelImpl.setCurrentUser", (Throwable)sSOException);
            }
        }
    }

    protected AMOrganization getAuthenticatedOrg() {
        AMStoreConnection aMStoreConnection = null;
        if (!this.isAdministrator()) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (AMConsoleException aMConsoleException) {
                        AMModelBase.debug.error("UMUserModelImpl.getAuthenticatedOrg", (Throwable)aMConsoleException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        AMOrganization aMOrganization = null;
        try {
            aMOrganization = aMStoreConnection.getOrganization(this.getAuthenticatedOrgDN());
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserModelImpl.getAuthenticatedOrg", (Throwable)sSOException);
        }
        return aMOrganization;
    }

    protected AMOrganization getUserOrg() {
        return this.curUser != null ? this.getUserOrg(this.curUser) : null;
    }

    protected AMOrganization getUserOrg(AMUser aMUser) {
        AMOrganization aMOrganization = null;
        AMStoreConnection aMStoreConnection = null;
        if (!this.isAdministrator()) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (AMConsoleException aMConsoleException) {
                        AMModelBase.debug.error("UMUserModelImpl.getAuthenticatedOrg", (Throwable)aMConsoleException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        try {
            String string = null;
            string = this.getUserType() == 3 ? this.getUserOrganization() : aMUser.getOrganizationDN();
            aMOrganization = aMStoreConnection.getOrganization(string);
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("UMUserModelImpl.getUserOrg, ", (Throwable)sSOException);
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("UMUserModelImpl.getUserOrg, ", (Throwable)aMException);
        }
        return aMOrganization;
    }

    public boolean isServiceDenied(String string) {
        return this.deniedSvcs.contains(string);
    }

    public String getServiceDeniedMessage() {
        return this.getLocalizedString("serviceDenied.message");
    }

    public String getNoAttributeAccessMessage() {
        return this.getLocalizedString("noAttributeAccess.message");
    }

    public Set getDateInUserLocale(Set set) {
        return super.getDateInUserLocale(set);
    }

    public Set getDateInDefaultLocale(Set set) throws AMConsoleException {
        return super.getDateInDefaultLocale(set);
    }

    public String getPasswordMessage() {
        return this.getLocalizedString("passwordMismatch.message");
    }

    public String getRequiredMessage() {
        return this.getLocalizedString("missingAttributes.message");
    }

    public String getInheritLabel() {
        return this.getLocalizedString("dynGUIInheritAttribute.label");
    }

    public String getInheritValue() {
        return "0";
    }

    public String getCustomizeLabel() {
        return this.getLocalizedString("dynGUICustomizeAttribute.label");
    }

    public String getCustomizeValue() {
        return "1";
    }

    public String getSkipLabel() {
        return this.getLocalizedString("dynGUISkipAttribute.label");
    }

    public String getSkipValue() {
        return "2";
    }

    public String getSubViewTrackingAttributeName() {
        return "IS-IdentityUserSubView";
    }

    public boolean isPasswordResetEnabled() {
        Set set = this.getAttrValues(PW_RESET_ENABLED_ATTR, "iPlanetAMPasswordResetService");
        String string = AMAdminUtils.getFirstElement(set);
        return string != null && string.equals("true");
    }

    public String getNoServiceAvailableMessage() {
        return this.getLocalizedString("noServiceAvailableForReg.message");
    }

    public String getNoAssignedAndNoneAvailableServiceMessage() {
        return this.getLocalizedString("noServiceEntriesAndNoneAvailableForAssignment.message");
    }

    public String getNoAssignedServiceMessage() {
        return this.getLocalizedString("noServiceEntries.message");
    }

    protected Map getAllRegisteredServices() {
        if (this.allRegisteredServices == null) {
            this.allRegisteredServices = this.getAllRegisteredService(this.curUserDN);
        }
        return this.allRegisteredServices;
    }

    public Map getAssignableServices() {
        Map map = this.getAllRegisteredServices();
        HashMap hashMap = new HashMap(map.size());
        Set set = this.getServicesForUser();
        Set set2 = map.keySet();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set.contains(string)) continue;
            hashMap.put(string, map.get(string));
        }
        return hashMap;
    }

    public Map getAssignedServices() {
        HashMap<String, String> hashMap = Collections.EMPTY_MAP;
        Set set = this.getServicesForUser();
        set.remove("iPlanetAMUserService");
        if (!set.isEmpty()) {
            Map map = this.getAllRegisteredServices();
            hashMap = new HashMap<String, String>(set.size() * 2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                if (string2 != null && string2.length() > 0) {
                    hashMap.put(string, string2);
                    continue;
                }
                AMModelBase.debug.error("UMUserModelImpl.getAssignedServices: cannot get localized name for service, " + string);
            }
        }
        return hashMap;
    }

    protected Map getAllRegisteredService(String string) {
        Map map = Collections.EMPTY_MAP;
        if (string != null && string.length() > 0) {
            map = this.mapServiceToLocalizedNames(this.getRegisteredServiceNames(string));
        } else {
            AMModelBase.debug.warning("UMUserModelImpl.getAllRegisteredService: dn is null");
        }
        return map;
    }

    private Map mapServiceToLocalizedNames(Set set) {
        HashMap<String, String> hashMap = Collections.EMPTY_MAP;
        if (set != null && !set.isEmpty()) {
            hashMap = new HashMap<String, String>(set.size() * 2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                if (string2.equals(string = this.getLocalizedServiceName(string2))) continue;
                hashMap.put(string2, string);
            }
        }
        return hashMap;
    }

    private Set getRegisteredServiceNames(String string) {
        Set set;
        block5: {
            set = Collections.EMPTY_SET;
            try {
                set = this.getServiceList(string);
                if (!set.isEmpty()) {
                    set.remove("iPlanetAMUserService");
                    set.removeAll(this.deniedSvcs);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (this.hasDynPolicyUserSchemaType(string2)) continue;
                        iterator.remove();
                    }
                    break block5;
                }
                if (!AMModelBase.debug.messageEnabled()) break block5;
                AMModelBase.debug.message("UMUserViewModelImpl.getRegisteredServiceNames: no services are registered");
            }
            catch (AMException aMException) {
                AMModelBase.debug.error("UMUserViewModelImpl.getRegisteredServiceNames", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMUserViewModelImpl.getRegisteredServiceNames", (Throwable)sSOException);
            }
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasDynPolicyUserSchemaType(String string) {
        boolean bl = false;
        ServiceSchemaManager serviceSchemaManager = null;
        try {
            serviceSchemaManager = this.getServiceSchemaManager(string);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMUserViewModelImpl.hasDynPolicyUserSchemaType", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserViewModelImpl.hasDynPolicyUserSchemaType", (Throwable)sSOException);
        }
        if (serviceSchemaManager == null) return bl;
        try {
            Set set = serviceSchemaManager.getSchemaTypes();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    return bl;
                }
                SchemaType schemaType = (SchemaType)iterator.next();
                bl = schemaType.equals((Object)SchemaType.DYNAMIC) || schemaType.equals((Object)SchemaType.POLICY) || schemaType.equals((Object)SchemaType.USER);
            }
            return bl;
        }
        catch (SMSException sMSException) {
            if (!AMModelBase.debug.warningEnabled()) return bl;
            AMModelBase.debug.warning("UMUserViewModelImpl.hasDynPolicyUserSchemaType: error in getting schema types", (Throwable)sMSException);
            return bl;
        }
    }

    Set getServicesForUser() {
        HashSet<String> hashSet = null;
        if (this.curUser != null) {
            try {
                hashSet = this.curUser.getAssignedServices();
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMUserViewModelImpl.getServicesForUser", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMUserViewModelImpl.getServicesForUser", (Throwable)sSOException);
            }
            if (hashSet == null || hashSet.isEmpty()) {
                hashSet = new HashSet<String>(2);
            }
            hashSet.add("iPlanetAMUserService");
            hashSet.remove(this.deniedSvcs);
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("UMUserViewModelImpl.getServicesForUser " + hashSet);
        }
        return hashSet == null ? Collections.EMPTY_SET : hashSet;
    }

    public boolean isAttributeMultiValued(String string) {
        ServiceSchemaManager serviceSchemaManager;
        ServiceSchema serviceSchema = null;
        boolean bl = false;
        try {
            serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMUserService");
            serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("Error getting service schema", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("Error getting service schema", (Throwable)sSOException);
        }
        if (serviceSchema != null && (serviceSchemaManager = serviceSchema.getAttributeSchema(string)) != null) {
            bl = serviceSchemaManager.getType().equals((Object)AttributeSchema.Type.LIST);
        }
        return bl;
    }

    public boolean isPeopleContainer(String string) {
        boolean bl;
        block3: {
            bl = false;
            try {
                bl = this.getObjectType(string) == 5;
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMUserModelImpl.isPeopleContainer ", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) break block3;
                AMModelBase.debug.warning("UMUserModelImpl.isPeopleContainer: " + string + " is not a valid people container.");
            }
        }
        return bl;
    }
}

