/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMUserGroupAddModel;
import com.iplanet.am.console.user.model.UMUserViewModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public class UMUserGroupAddModelImpl
extends UMUserViewModelImpl
implements UMUserGroupAddModel {
    private Set groups = null;
    private boolean groupsAssigned = false;
    private boolean groupsUnassigned = false;

    public UMUserGroupAddModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public void updateGroups(Set set) throws AMConsoleException {
        this.setAttrList(null);
        if (this.curUser == null || set == null) {
            return;
        }
        Set set2 = this.getUserGroupDNs();
        if (set2.equals(set)) {
            return;
        }
        AMStoreConnection aMStoreConnection = null;
        if (!this.isAdministrator()) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (AMConsoleException aMConsoleException) {
                        AMModelBase.debug.error("UMUserGroupAddModelImpl.updateGroups", (Throwable)aMConsoleException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        AMUser aMUser = this.curUser;
        try {
            aMUser = aMStoreConnection.getUser(this.curUser.getDN());
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMUserGroupAddModelImpl.updateGroups", (Throwable)sSOException);
            arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
        }
        Set set3 = this.excludedObjFromSet(set, set2);
        if (set3 != null && !set3.isEmpty()) {
            Iterator iterator = set3.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    int n = this.getObjectType(string);
                    if (n == 9 || n == 10) {
                        aMUser.assignStaticGroup(string);
                    } else {
                        aMUser.assignAssignableDynamicGroup(string);
                    }
                    this.groupsAssigned = true;
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append(this.getLocalizedString("assignedUserToGroup.message")).append(" " + string).append(":[" + this.curUser.getDN() + "]");
                    this.logger.doLog(stringBuffer.toString());
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("assigning groups to user", (Throwable)aMException);
                    arrayList.add(this.getErrorString((Exception)((Object)aMException)));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("assigning groups to user", (Throwable)sSOException);
                    arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
                }
            }
        }
        if (!arrayList.isEmpty()) {
            throw new AMConsoleException(arrayList);
        }
    }

    public Set getGroups() {
        if (!this.getShowUserGroupFlag()) {
            return Collections.EMPTY_SET;
        }
        if (this.groups == null) {
            Set set = this.getUserGroupDNs();
            if (!this.getUserGroupSubscribe()) {
                this.groups = this.convertToOrderedSet(set);
                return this.groups;
            }
            HashMap hashMap = new HashMap(1);
            HashSet<String> hashSet = new HashSet<String>(1);
            if (this.isAdministrator()) {
                hashSet.add("*");
            } else {
                hashSet.add("true");
            }
            hashMap.put("iplanet-am-group-subscribable", hashSet);
            AMOrganization aMOrganization = this.getUserOrg();
            if (aMOrganization != null) {
                Set set2 = null;
                try {
                    Set set3 = aMOrganization.getGroupContainers(1);
                    set2 = set3 == null || set3.isEmpty() ? this.getGroupsInOrg(aMOrganization, hashMap) : this.getGroupsInContainers(set3, hashMap);
                    if (set2 != null && !this.isAdminGroupsEnabled()) {
                        set2 = this.removeHiddenGroups(set2);
                    }
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("UMUserGroupAddModelImpl.getGroupsInOrg, ", (Throwable)sSOException);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("UMUserGroupAddModelImpl.getGroupsInOrg, ", (Throwable)aMException);
                }
                if (set == null || set.isEmpty()) {
                    set = set2;
                } else {
                    this.combineGroups(set, set2);
                }
            }
            this.groups = this.convertToOrderedSet(set);
        }
        return this.groups;
    }

    public boolean isGroupAssigned(String string) {
        Set set = this.getUserGroupDNs();
        return set.contains(string);
    }

    public String getGroupDisplayName(String string) {
        return AMFormatUtils.DNToName(this, string);
    }

    public String getNoGroupTitle() {
        return this.getLocalizedString("nosubscribablegroups.title");
    }

    public String getNoGroupMessage() {
        return this.getLocalizedString("nosubscribablegroups.message");
    }

    public Set getUserGroupDNs() {
        Set set = Collections.EMPTY_SET;
        if (this.curUser != null) {
            try {
                set = this.curUser.getStaticGroupDNs();
                set.addAll(this.curUser.getAssignableDynamicGroupDNs());
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMUserProfileModelImpl.getUserGroupDNs", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMUserProfileModelImpl.getUserGroupDNs", (Throwable)sSOException);
            }
        }
        if (!this.isAdminGroupsEnabled()) {
            set = this.removeHiddenGroups(set);
        }
        return set;
    }

    private Set getGroupsInOrg(AMOrganization aMOrganization, Map map) throws AMException, SSOException {
        Set set = this.searchGroups(aMOrganization, "*", null, 1);
        HashSet hashSet = new HashSet(25);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMGroup aMGroup = this.getGroupObjectByDN(string);
                if (aMGroup == null) continue;
                hashSet.addAll(aMGroup.searchGroups("*", map, 2));
            }
        }
        return hashSet;
    }

    private Set getGroupsInContainers(Set set, Map map) throws AMException, SSOException {
        AMStoreConnection aMStoreConnection = null;
        if (!this.isAdministrator()) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (AMConsoleException aMConsoleException) {
                        AMModelBase.debug.error("UMUserGroupAddModelImpl.getGroupsInContainers", (Throwable)aMConsoleException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        HashSet hashSet = new HashSet(25);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMGroupContainer aMGroupContainer = aMStoreConnection.getGroupContainer((String)iterator.next());
            hashSet.addAll(aMGroupContainer.searchGroups("*", map, 2));
        }
        return hashSet;
    }

    private Set searchGroups(AMOrganization aMOrganization, String string, Map map, int n) throws AMException, SSOException {
        Set set = aMOrganization.searchStaticGroups(string, map, n);
        set.addAll(aMOrganization.searchAssignableDynamicGroups(string, map, n));
        return set;
    }

    private AMGroup getGroupObjectByDN(String string) throws AMException, SSOException {
        AMStaticGroup aMStaticGroup = null;
        AMStoreConnection aMStoreConnection = null;
        if (!this.isAdministrator()) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (AMConsoleException aMConsoleException) {
                        AMModelBase.debug.error("UMUserGroupAddModelImpl.getGroupObjectByDN", (Throwable)aMConsoleException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        int n = aMStoreConnection.getAMObjectType(string);
        switch (n) {
            case 9: 
            case 10: {
                aMStaticGroup = aMStoreConnection.getStaticGroup(string);
                break;
            }
            case 11: {
                aMStaticGroup = aMStoreConnection.getDynamicGroup(string);
                break;
            }
            default: {
                aMStaticGroup = aMStoreConnection.getAssignableDynamicGroup(string);
            }
        }
        return aMStaticGroup;
    }

    private Set removeHiddenGroups(Set set) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (set != null && !set.isEmpty()) {
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = AMFormatUtils.DNToName(this, string);
                if (string2.equalsIgnoreCase("DomainAdministrators") || string2.equalsIgnoreCase("DomainHelpDeskAdministrators") || string2.equalsIgnoreCase("ServiceAdministrators") || string2.equalsIgnoreCase("ServiceHelpDeskAdministrators")) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private void combineGroups(Set set, Set set2) {
        if (set2 == null || set2.isEmpty() || set == null) {
            return;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            String string = (String)iterator.next();
            DN dN = new DN(string);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext() && !bl) {
                String string2 = (String)iterator2.next();
                DN dN2 = new DN(string2);
                bl = dN.equals(dN2);
            }
            if (bl) continue;
            set.add(string);
        }
    }

    public Set getAttrList() {
        return this.groups;
    }

    public void setAttrList(Set set) {
        this.groups = set;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("groups.header");
    }

    public void updateGroups(Set set, List list) throws AMConsoleException {
        if (set == null || list == null || list.isEmpty()) {
            return;
        }
        Set set2 = this.getUserGroupDNs();
        Set set3 = this.getObjAssignNotInCurPage(list, set2);
        if (set3 != null) {
            set.addAll(set3);
        }
        this.updateGroups(set);
    }

    public String getSuccessMessage() {
        if (this.groupsAssigned || this.groupsUnassigned) {
            return this.getLocalizedString("updateUser.message");
        }
        return this.getLocalizedString("noChangesMade.message");
    }

    public String getAddBtnLabel() {
        return this.getLocalizedString("add.button");
    }

    public String getRemoveBtnLabel() {
        return this.getLocalizedString("remove.button");
    }

    public Set getUnAssignedGroups() {
        Set set = Collections.EMPTY_SET;
        set = this.excludedObjFromSet(this.getGroups(), this.getUserGroupDNs());
        return set;
    }

    public String getNoAddGroupEntriesMsg() {
        return this.getLocalizedString("noAddGroupEntries.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userGroupAdd.help");
        if (string.equals("userGroupAdd.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

