/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMMenuValidator;
import com.iplanet.am.console.base.model.AMMenuValidatorImpl;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMUserDataModel;
import com.iplanet.am.console.user.model.UMUserNavModelImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMUserDataModelImpl
extends UMUserNavModelImpl
implements UMUserDataModel {
    public UMUserDataModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public Class getViewBeanTypeClass(String string) {
        return AMAdminUtils.getProfileViewBeanClass(this, this.profileDN, string);
    }

    public String getPageTitle() {
        if (this.profileDN == null || this.profileDN.length() == 0) {
            return "";
        }
        if (this.isRoleType(this.locationDN)) {
            return AMFormatUtils.DNToName(this, this.profileDN, true);
        }
        return AMFormatUtils.DNToName(this, this.profileDN);
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("editUser.label");
    }

    protected List getRoleMenu() {
        String string;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>(5);
        arrayList.add("general");
        if (this.showUsers()) {
            arrayList.add("users");
        }
        if (!(string2 = AMAdminUtils.getParent(this.locationDN)).equalsIgnoreCase(string = AMSystemConfig.rootSuffix) || string.equalsIgnoreCase(AMSystemConfig.defaultOrg) && string2.equalsIgnoreCase(string)) {
            arrayList.add("services");
        }
        arrayList.add("displayoptions");
        arrayList.add("permissions");
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        this.removeHiddenOptions(aMMenuValidator.getRoleProfileMenuOptions(this), arrayList);
        return arrayList;
    }

    protected List getGroupMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("general");
        if (this.showUsers()) {
            arrayList.add("users");
        }
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        this.removeHiddenOptions(aMMenuValidator.getGroupProfileMenuOptions(this), arrayList);
        return arrayList;
    }

    private void removeHiddenOptions(Set set, List list) {
        if (set != null) {
            if (!set.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (set.contains(iterator.next())) continue;
                    iterator.remove();
                }
            } else {
                list.clear();
            }
        }
    }

    public String getNoUserSelectedForRemovalTitle() {
        return this.getLocalizedString("noUserSelectForRemoval.title");
    }

    public String getNoUserSelectedForRemovalMessage() {
        return this.getLocalizedString("noUserSelectForRemoval.message");
    }

    public String getNoUserSelectedForDeleteTitle() {
        return this.getLocalizedString("noUserSelectForDeletion.title");
    }

    public String getNoUserSelectedForDeleteMessage() {
        return this.getLocalizedString("noUserSelectForDeletion.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("staticGroupUsers.help");
        if (this.isRoleType(this.locationDN)) {
            string = this.getLocalizedString("roleUsers.help");
        }
        if (string.endsWith(".help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isProfileObjectExists() {
        return this.locationType != -1;
    }

    public boolean isProfileModifiable() {
        boolean bl = false;
        switch (this.locationType) {
            case 6: 
            case 7: 
            case 8: {
                bl = this.canPerform(Setting.ACTION_ROLE, "modifyproperties");
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                bl = this.canPerform(Setting.ACTION_GROUP, "modifyproperties");
                break;
            }
            default: {
                AMModelBase.debug.error("UMUserDataModelImpl.isProfileModifiable: unsupported type, " + Integer.toString(this.locationType));
            }
        }
        return bl;
    }

    public String getActionLabel() {
        return this.getLocalizedString("action.label");
    }
}

