/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMDataModelImpl;
import com.iplanet.am.console.user.model.UMStaticGroupProfileModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMStaticGroupProfileModelImpl
extends UMDataModelImpl
implements UMStaticGroupProfileModel {
    public UMStaticGroupProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean modify(Map map) {
        AMModelBase.debug.message("UMStaticGroupProfileModelImpl.modify");
        boolean bl = false;
        AMGroup aMGroup = this.getSelectedGroup();
        try {
            if (aMGroup != null && aMGroup.isExists()) {
                AMModelBase.debug.message("UMStaticGroupProfileModelImpl.modify group exists");
                try {
                    this.fireBeforeUpdateValuesEvent(10, (AMObject)aMGroup, map);
                    bl = this.setAttributes((AMObject)aMGroup, map, "groupChanged.message");
                    this.fireAfterUpdateValuesEvent(10, (AMObject)aMGroup);
                }
                catch (AMConsoleException aMConsoleException) {
                    this.errorMessage = this.getErrorString(aMConsoleException);
                }
            } else {
                this.errorMessage = this.getLocalizedString("nogroup.message");
                if (AMModelBase.debug.messageEnabled()) {
                    AMModelBase.debug.message("UMStaticGroupProfileModelImpl.modify group does not exists");
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMStaticGroupProfileModelImpl.modify", (Throwable)sSOException);
        }
        return bl;
    }

    protected boolean isDisplayed(AttributeSchema attributeSchema) {
        if (attributeSchema == null || attributeSchema.getI18NKey() == null || attributeSchema.getI18NKey().length() == 0) {
            return false;
        }
        return !attributeSchema.getName().equals("uniquemember");
    }

    private AMGroup getSelectedGroup() {
        AMStaticGroup aMStaticGroup = null;
        try {
            int n = this.getObjectType(this.profileDN);
            switch (n) {
                case 9: 
                case 10: {
                    aMStaticGroup = this.dpStoreConn.getStaticGroup(this.profileDN);
                    break;
                }
                case 12: {
                    aMStaticGroup = this.dpStoreConn.getAssignableDynamicGroup(this.profileDN);
                    break;
                }
                default: {
                    if (AMModelBase.debug.warningEnabled()) {
                        AMModelBase.debug.warning("UMStaticGroupProfileModelImpl:invalid group type " + this.profileDN);
                    }
                    break;
                }
            }
        }
        catch (AMException aMException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("Could not get group for " + this.profileDN, (Throwable)aMException);
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMStaticGroupProfileModelImpl.getSelectedGroup", (Throwable)sSOException);
        }
        return aMStaticGroup;
    }

    public List getDynamicGUIComponents() {
        ArrayList<DynamicGUI> arrayList = Collections.EMPTY_LIST;
        ServiceSchemaManager serviceSchemaManager = this.getEntrySpecificSvcSchemaMgr();
        AMGroup aMGroup = this.getSelectedGroup();
        if (serviceSchemaManager != null && aMGroup != null) {
            Map map = null;
            try {
                map = aMGroup.getAttributes();
            }
            catch (AMException aMException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("Could not get values for " + aMGroup.getDN(), (Throwable)aMException);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("Error in SSO Token");
            }
            if (map != null && !map.isEmpty()) {
                Set set = this.getAttributesToDisplay(serviceSchemaManager, SchemaType.GLOBAL, "Group");
                map = this.sanitizeAttributeValuesMap(set, map);
                this.fireRetrieveAttributeValuesEvent((AMObject)aMGroup, 2, 10, "iPlanetAMEntrySpecificService", SchemaType.GLOBAL, map);
                AMAdminUtils.excludeAttributeSchemas(set, map.keySet());
                DynamicGUIGenerator dynamicGUIGenerator = DynamicGUIGenerator.getInstance();
                arrayList = new ArrayList<DynamicGUI>(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    DynamicGUI dynamicGUI;
                    AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                    String string = attributeSchema.getName();
                    Set set2 = (Set)map.get(string);
                    if (set2 == null) {
                        set2 = Collections.EMPTY_SET;
                    }
                    if ((dynamicGUI = dynamicGUIGenerator.createDynamicGUI(attributeSchema, "iPlanetAMEntrySpecificService", set2, this, Setting.ACTION_GROUP)) == null) continue;
                    arrayList.add(dynamicGUI);
                }
            }
        }
        return arrayList;
    }

    private Map sanitizeAttributeValuesMap(Set set, Map map) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(map.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            String string = attributeSchema.getName();
            Set set2 = (Set)map.get(string);
            if (set2 == null) {
                set2 = Collections.EMPTY_SET;
            }
            hashMap.put(string, set2);
        }
        return hashMap;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateGroup.message");
    }

    public String getDefaultSubView() {
        String string = null;
        Set set = this.getUserSettings(Setting.DEFAULT_GROUP_PROFILE_VIEW);
        if (set != null && !set.isEmpty()) {
            string = (String)set.iterator().next();
            string = string.toLowerCase();
        }
        if (string == null) {
            string = "users";
        }
        return string;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("staticGroupProfile.help");
        if (string.equals("staticGroupProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public boolean isGroupExists() {
        return this.getSelectedGroup() != null;
    }

    public String getInvalidGroupMessage() {
        return this.getLocalizedString("invalidGroupProfile.message");
    }
}

