/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMServiceDisplayModelImpl;
import com.iplanet.am.console.service.model.SMNavModelImpl;
import com.iplanet.am.console.user.model.UMServiceNavModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMServiceNavModelImpl
extends SMNavModelImpl
implements UMServiceNavModel {
    private List errorMessage = Collections.EMPTY_LIST;
    private boolean hasServices = false;

    public UMServiceNavModelImpl(HttpServletRequest httpServletRequest, String string, Map map) {
        super(httpServletRequest, string, map);
        this.listServices(null);
    }

    public void listServices(Set set) {
        Set set2 = this.getHierarchy();
        Set set3 = this.getAvailableServices();
        Set set4 = Collections.EMPTY_SET;
        if (set3.isEmpty()) {
            this.hasServices = false;
            this.rowNodes = Collections.EMPTY_LIST;
        } else {
            try {
                set4 = this.dpStoreConn.getServiceNames();
                set3 = this.fixedCaseInServiceNames(set3, set4);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMServiceRegModelImpl.listServices, ", (Throwable)aMException);
            }
            if (!set4.isEmpty()) {
                if (!set3.isEmpty() && set != null && !set.isEmpty()) {
                    set3.removeAll(set);
                }
                if (!set3.isEmpty()) {
                    this.hasServices = true;
                    Map map = this.buildLocalizedLookup(set2, set4);
                    this.process(set2, set3, map);
                } else {
                    this.hasServices = false;
                    this.rowNodes = Collections.EMPTY_LIST;
                }
            }
        }
    }

    private Set fixedCaseInServiceNames(Set set, Set set2) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>(set.size() * 2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(set2.size() * 2);
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            hashMap.put(((String)object).toLowerCase(), object);
        }
        object = set.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            String string2 = (String)hashMap.get(string.toLowerCase());
            if (string2 == null) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    private Set getAvailableServices() {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        try {
            Set set = this.getServiceList(this.locationDN);
            AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.dpStoreConn);
            Set set2 = aMServiceDisplayModelImpl.getDeniedServices(this.dpUser);
            set.removeAll(set2);
            hashSet = new HashSet<String>(set.size());
            if (this.locationType == 6 || this.locationType == 7 || this.locationType == 8) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
                    if (serviceSchemaManager == null) continue;
                    try {
                        Set set3 = serviceSchemaManager.getSchemaTypes();
                        Iterator iterator2 = set3.iterator();
                        while (iterator2.hasNext()) {
                            SchemaType schemaType = (SchemaType)iterator2.next();
                            if (!schemaType.equals((Object)SchemaType.DYNAMIC)) continue;
                            hashSet.add(string);
                        }
                    }
                    catch (SMSException sMSException) {
                        AMModelBase.debug.error("UMServiceNavModelImpl.getAvailableServices", (Throwable)sMSException);
                    }
                }
            } else {
                hashSet.addAll(set);
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMServiceNavModelImpl:getAvailableServices ", (Throwable)sMSException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMServiceNavModelImpl:getAvailableServices ", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMServiceNavModelImpl:getAvailableServices ", (Throwable)sSOException);
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("UMServiceNavModelImpl:getAvailableServices " + hashSet);
        }
        return hashSet;
    }

    public boolean hasServices() {
        return this.hasServices;
    }

    public String getSelectedOption() {
        return "services";
    }

    public List getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorTitle() {
        return this.getLocalizedString("warningMessage.title");
    }

    public boolean isEditService() {
        return this.locationType == 2 || this.locationType == 3;
    }

    public boolean unRegisterServices(Set set) {
        AMModelBase.debug.message("UMServiceNavModelImpl.unRegisterServices");
        boolean bl = true;
        if (set != null) {
            this.errorMessage = new ArrayList(set.size());
            AMOrganization aMOrganization = null;
            AMOrganizationalUnit aMOrganizationalUnit = null;
            try {
                if (this.locationType == 2) {
                    aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                } else if (this.locationType == 3) {
                    aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMServiceNavModelImpl:unRegisterServicesfailed to get organization", (Throwable)sSOException);
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    if (this.locationType == 2) {
                        aMOrganization.unregisterService(string);
                    } else {
                        aMOrganizationalUnit.unregisterService(string);
                    }
                    this.writeFormatLog("service.unregistered", string, this.locationDN);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning(aMException.getMessage());
                    if (this.errorMessage.isEmpty()) {
                        bl = false;
                        this.errorMessage.add(this.getLocalizedString("unregisterfailed.message"));
                    }
                    this.errorMessage.add(this.getErrorString((Exception)((Object)aMException)));
                    iterator.remove();
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning(sSOException.getMessage());
                    if (this.errorMessage.isEmpty()) {
                        bl = false;
                        this.errorMessage.add(this.getLocalizedString("unregisterfailed.message"));
                    }
                    this.errorMessage.add(this.getErrorString((Exception)((Object)sSOException)));
                    iterator.remove();
                }
            }
        } else {
            this.errorMessage.add(this.getLocalizedString("unregisterfailed.message"));
            bl = false;
        }
        this.listServices(set);
        return bl;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("services.label");
    }

    public String getNoEntrySelectedForDeregTitle() {
        return this.getLocalizedString("noSvcSelectForDeregistration.title");
    }

    public String getNoEntrySelectedForDeregMessage() {
        return this.getLocalizedString("noSvcSelectForDeregistration.message");
    }

    public boolean isLocationValid() {
        try {
            return this.isCurrentLocationTypeValid() && this.dpStoreConn.isValidEntry(this.locationDN);
        }
        catch (SSOException sSOException) {
            block2: {
                if (!AMModelBase.debug.warningEnabled()) break block2;
                AMModelBase.debug.warning("UMServiceNavModelImpl.isLocationValid, location=" + this.locationDN, (Throwable)sSOException);
            }
            return false;
        }
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMServiceNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }
}

