/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMServiceDisplayModelImpl;
import com.iplanet.am.console.user.model.UMRoleServiceModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMRoleServiceModelImpl
extends AMProfileModelBase
implements UMRoleServiceModel {
    private String roleDN = null;
    private Map roleDisplayOptions = null;
    private String errorMsg = null;

    public UMRoleServiceModelImpl(HttpServletRequest httpServletRequest, Map map, String string) {
        super(httpServletRequest, map);
        this.roleDN = string;
    }

    public void initRoleServiceOptions() {
        if (this.roleDN != null) {
            try {
                AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.dpStoreConn);
                AMRole aMRole = this.dpStoreConn.getRole(this.roleDN);
                this.roleDisplayOptions = aMServiceDisplayModelImpl.getRoleOptions(aMRole, this.getAvailableServices(aMRole));
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("Couldn't get role display options", (Throwable)aMException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("Couldn't get role display options", (Throwable)sMSException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("Couldn't get role display options", (Throwable)sSOException);
            }
        }
        if (this.roleDisplayOptions == null) {
            this.roleDisplayOptions = new HashMap(1);
        }
    }

    public boolean storeDisplayOptions(Map map) {
        boolean bl;
        block3: {
            bl = true;
            if (this.roleDN == null) break block3;
            try {
                AMRole aMRole = this.dpStoreConn.getRole(this.roleDN);
                AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.dpStoreConn);
                aMServiceDisplayModelImpl.setRoleOptions(aMRole, map);
                this.roleDisplayOptions.clear();
                this.roleDisplayOptions.putAll(map);
                this.logger.doLog("roleServicesModified.message", aMRole.getDN());
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("Couldn't store role display options", (Throwable)aMException);
                this.errorMsg = this.getErrorString((Exception)((Object)aMException));
                bl = false;
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("Couldn't store role display options", (Throwable)sSOException);
                this.errorMsg = this.getErrorString((Exception)((Object)sSOException));
                bl = false;
            }
        }
        return bl;
    }

    public String getCloseButtonLabel() {
        return this.getLocalizedString("close.button");
    }

    public String getDisplayAttrLabel() {
        return this.getLocalizedString("display.label");
    }

    public String getReadOnlyAttrLabel() {
        return this.getLocalizedString("readOnly.label");
    }

    public Set getServiceNames() {
        Set set = Collections.EMPTY_SET;
        if (this.roleDN != null) {
            try {
                AMRole aMRole = this.dpStoreConn.getRole(this.roleDN);
                set = this.getAvailableServices(aMRole);
                if (set != null) {
                    set.remove("iPlanetAMWebAgentService");
                }
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("Couldn't get role ", (Throwable)aMException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.warning("Couldn't get role ", (Throwable)sMSException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("Couldn't get role ", (Throwable)sSOException);
            }
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("UMRoleServiceModelImpl.getServiceNames: " + set);
        }
        return set;
    }

    public boolean isDisplay(String string) {
        Set set = this.getDisplayOptions(string);
        if (set.isEmpty()) {
            return false;
        }
        return set.contains("display");
    }

    public boolean isReadOnly(String string) {
        Set set = this.getDisplayOptions(string);
        if (set.isEmpty()) {
            return false;
        }
        return set.contains("readOnly");
    }

    public String getRoleName() {
        return AMFormatUtils.DNToName(this, this.roleDN, true);
    }

    public String getErrorTitle() {
        return this.getLocalizedString("errorMessage.title");
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    private Set getDisplayOptions(String string) {
        if (this.roleDisplayOptions == null) {
            return Collections.EMPTY_SET;
        }
        Set set = (Set)this.roleDisplayOptions.get(string);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateServiceDisplay.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("roleServiceData.help");
        if (string.equals("roleServiceData.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

