/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMDataModelImpl;
import com.iplanet.am.console.user.model.UMRoleProfileModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class UMRoleProfileModelImpl
extends UMDataModelImpl
implements UMRoleProfileModel {
    private AMRole role = null;
    private static final String ACI_SEPARATOR = "##";
    private String roleDN = null;

    public UMRoleProfileModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public boolean modify(Map map) {
        boolean bl;
        block7: {
            if (map == null || map.isEmpty()) {
                AMModelBase.debug.warning("modify called with empty data set");
                return true;
            }
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("modifying role : " + map);
            }
            AMRole aMRole = null;
            try {
                aMRole = this.dpStoreConn.getRole(this.profileDN);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMRoleProfileModelImpl.modify", (Throwable)sSOException);
                return false;
            }
            bl = true;
            try {
                if (aMRole.isExists()) {
                    bl = this.setAttributes((AMObject)aMRole, map, "attribute.change");
                    break block7;
                }
                bl = false;
                this.errorMessage = this.getLocalizedString("norole.message");
            }
            catch (SSOException sSOException) {
                bl = false;
                AMModelBase.debug.warning("UMRoleProfileModelImpl.modify", (Throwable)sSOException);
            }
        }
        return bl;
    }

    public boolean setACIValue(String string) {
        Object object;
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ACI_SEPARATOR);
        HashSet<Object> hashSet = new HashSet<Object>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (object == null || ((String)object).length() == 0) continue;
            hashSet.add(object);
        }
        object = new HashMap(1);
        object.put("iplanet-am-role-aci-list", hashSet);
        this.createRoleHandle();
        try {
            this.setModifiedMessage("roleChanged.message");
            this.writeProfile((AMObject)this.role, (Map)object);
        }
        catch (AMConsoleException aMConsoleException) {
            bl = false;
            this.errorMessage = this.getErrorString(aMConsoleException);
        }
        catch (SSOException sSOException) {
            bl = false;
            this.errorMessage = this.getErrorString((Exception)((Object)sSOException));
        }
        return bl;
    }

    public String getPageTitle() {
        return this.profileDN == null ? "" : AMFormatUtils.DNToName(this, this.profileDN, true);
    }

    public String getDescriptionLabel() {
        return this.getLocalizedString("roleDescription.label");
    }

    public String getDescriptionValue() {
        String string = null;
        this.createRoleHandle();
        try {
            String string2;
            String string3;
            string = this.role.getStringAttribute("iplanet-am-role-description");
            if (string != null && string.length() > 0 && !(string3 = this.getLocalizedString(string2 = string.trim().replace(' ', '-'))).equals(string2)) {
                string = string3;
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("couldn't get role description", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("couldn't get role description", (Throwable)sSOException);
        }
        return string == null ? "" : string;
    }

    public String getPermissionLabel() {
        return this.getLocalizedString("aciDescription.label");
    }

    public String getPermissionValue() {
        this.createRoleHandle();
        String string = null;
        try {
            String string2;
            String string3;
            string = this.role.getStringAttribute("iplanet-am-role-aci-description");
            if (string != null && string.length() > 0 && !(string3 = this.getLocalizedString(string2 = string.trim().replace(' ', '-'))).equals(string2)) {
                string = string3;
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("couldn't get role aci description");
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("couldn't get role aci description");
        }
        return string == null ? "" : string;
    }

    public String getShowACIButton() {
        return this.getLocalizedString("showAdvanced.button");
    }

    public String getHideACIButton() {
        return this.getLocalizedString("hideAdvanced.button");
    }

    private void createRoleHandle() {
        block3: {
            if (this.role != null) break block3;
            AMModelBase.debug.message("getting handle to role");
            try {
                AMStoreConnection aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return AMAdminUtils.getStoreConnAsAdmin();
                        }
                        catch (AMConsoleException aMConsoleException) {
                            AMModelBase.debug.error("UMRoleProfileModelImpl.createRoleHandle", (Throwable)aMConsoleException);
                            return null;
                        }
                    }
                });
                if (aMStoreConnection != null) {
                    this.role = aMStoreConnection.getRole(this.profileDN);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("error getting role for " + this.profileDN, (Throwable)sSOException);
            }
        }
    }

    public String getAccessPermissionLabel() {
        return this.getLocalizedString("accessPermission.label");
    }

    public String getAccessPermissionValue() {
        this.createRoleHandle();
        Set set = null;
        try {
            set = this.role.getAttribute("iplanet-am-role-aci-list");
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMRoleProfileModelImpl.getAccessPermissionValue", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMRoleProfileModelImpl.getAccessPermissionValue", (Throwable)sSOException);
        }
        StringBuffer stringBuffer = new StringBuffer(250);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(ACI_SEPARATOR);
            }
        }
        return stringBuffer.toString();
    }

    public void setRoleDN(String string) {
        this.roleDN = string;
    }

    public List getShowMenuOptions() {
        if (this.roleDN != null && this.roleDN.length() > 0) {
            return this.getRoleMenu();
        }
        return super.getShowMenuOptions();
    }

    public String getDefaultSubView() {
        String string = null;
        String string2 = null;
        Set set = this.getUserSettings(Setting.DEFAULT_ROLE_PROFILE_VIEW);
        if (set != null && !set.isEmpty()) {
            string2 = (String)set.iterator().next();
            string = string2.toLowerCase();
        }
        if (string == null) {
            string = "users";
        }
        return string;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("roleProfile.help");
        if (string.equals("roleProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getCloseButtonLabel() {
        return this.getLocalizedString("close.button");
    }

    public boolean isRoleExists() {
        return this.getLocationType(this.profileDN) != -1;
    }

    public String getInvalidRoleMessage() {
        return this.getLocalizedString("invalidRoleProfile.message");
    }
}

