/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMNavModelImpl;
import com.iplanet.am.console.user.model.UMRoleNavModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMRoleNavModelImpl
extends UMNavModelImpl
implements UMRoleNavModel {
    private final String CONTAINER_DEFAULT_TEMPLATE_ROLE = "cn=ContainerDefaultTemplateRole,";
    private Set roles = null;

    public UMRoleNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getSelectedOption() {
        return "roles";
    }

    public Set getRoles(String string) {
        if (this.roles == null) {
            AMSearchResults aMSearchResults = null;
            AMSearchControl aMSearchControl = new AMSearchControl();
            aMSearchControl.setSearchScope(1);
            String[] stringArray = new String[]{AdminInterfaceUtils.getNamingAttribute((int)6, (Debug)AMModelBase.debug)};
            aMSearchControl.setSortKeys(stringArray);
            try {
                switch (this.locationType) {
                    case 2: {
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                        aMSearchResults = aMOrganization.searchAllRoles(string, aMSearchControl);
                        break;
                    }
                    case 3: {
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                        aMSearchResults = aMOrganizationalUnit.searchAllRoles(string, aMSearchControl);
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMRoleNavModelImpl.getRoles invalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMRoleNavModelImpl.getRoles", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMRoleNavModelImpl.getRoles", (Throwable)aMException);
                this.searchErrorMsg = this.getErrorString((Exception)((Object)aMException));
            }
            this.roles = this.getSearchResultsSet(aMSearchResults);
        }
        if (this.roles == null) {
            this.roles = Collections.EMPTY_SET;
        } else {
            this.roles.remove("cn=ContainerDefaultTemplateRole," + this.getLocationDN());
        }
        return this.roles;
    }

    public boolean deleteRoles(Set set) {
        boolean bl = false;
        if (set != null && (this.locationType == 2 || this.locationType == 3)) {
            try {
                Map map = this.deleteUMObject(6, set, "roleDeleted.message");
                if (!map.isEmpty()) {
                    Iterator iterator = map.keySet().iterator();
                    this.setErrorMessage(this.getLocalizedString("deleteRoleFailed.message"));
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = AMFormatUtils.DNToName(this, string, true);
                        String string3 = (String)map.get(string);
                        this.setErrorMessage(string2 + " - " + string3);
                    }
                } else {
                    bl = true;
                }
            }
            catch (AMConsoleException aMConsoleException) {
                this.setErrorMessage(this.getErrorString(aMConsoleException));
            }
        } else {
            this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
        }
        return bl;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("roles.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noRoleSelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noRoleSelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.roles;
    }

    public void setAttrList(Set set) {
        this.roles = set;
    }

    public String getRolesDisplayOffMessage() {
        return this.getLocalizedString("rolesDisplayOff.message");
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMRoleNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }
}

